dnl #
dnl #  aclocal.m4 -- Local M4 functions for GNU autoconf 2.x
dnl #  Copyright (c) Ralf S. Engelschall, <rse@en.engelschall.com>
dnl #
dnl #  NOTICE:
dnl #      all defined macros are named AC_*
dnl #      all defined and used variables are named acl-*
dnl #
dnl
dnl ##########################################################
dnl ##
dnl ##  check for Perl 5 module
dnl ##
dnl ##########################################################
dnl
define(AC_CHECK_PERL_MODULE,[dnl
AC_MSG_CHECKING([for Perl module $1 ($2)])
TMPFILE=/tmp/ac.$$
rm -f $TMPFILE 2>&1 >/dev/null
cat >$TMPFILE <<'EOT'
eval {
    require $1;
    if ('$2' ne 'ANY') {
        $1->require_version('$2');
    }
};
if ([$]@) {
    print "failed";
} else {
    print "ok";
}
EOT
rc=`$PATH_PERL $TMPFILE`; 
rm -f $TMPFILE 2>&1 >/dev/null
if test ".$have_$3" = .0; then
    AC_MSG_RESULT([forced: closed world])
else
    if test ".$rc" = .ok; then
	    have_$3=1
        AC_MSG_RESULT([found])
    else
        have_$3=0
        AC_MSG_RESULT([not found])
    fi
fi
AC_SUBST(have_$3)
])dnl
dnl
dnl
dnl ##########################################################
dnl ##
dnl ##  check for latest Perl interpreter
dnl ##
dnl ##########################################################
dnl
dnl
define(AC_CHECK_PERL_INTERPRETER,[dnl
AC_MSG_CHECKING([for Perl interpreter])
AC_ARG_WITH(perl,dnl
[  --with-perl             force the usage of a specific installed Perl],
ac_perlprog=$with_perl
ac_perlvers=`$perlprog -v | grep version | sed -e 's/.* version //' -e 's/ built.*//' -e 's/ with.*//'`
,
TMPFILE=/tmp/ac.$$
rm -f $TMPFILE
touch $TMPFILE
c=0
for dir in `echo $PATH | sed -e 's/:/ /g'` /tmp; do
    for perl in perl5 perl miniperl; do
         if test -f "$dir/$perl"; then
             if test -x "$dir/$perl"; then
                 perl="$dir/$perl"
                 version=`$perl -v | grep version | sed -e 's/.* version //' -e 's/ built.*//' -e 's/ with.*//'`
                 versionnum="`echo $version | sed -e 's/\.//g' -e 's/_//g'`"
                 versionnum=`expr $versionnum - $c`
                 echo "$versionnum $version $perl" >>$TMPFILE
             fi
         fi
    done
    c=`expr $c + 1`
done
ac_perlprog="`cat $TMPFILE | sort -u | tail -1 | cut '-d ' -f3`"
ac_perlvers="`cat $TMPFILE | sort -u | tail -1 | cut '-d ' -f2`"
rm -f $TMPFILE
)dnl
AC_MSG_RESULT([$ac_perlprog v$ac_perlvers])
if test -f $ac_perlprog; then
    :
else
    AC_ERROR([required program ``perl'' not found])
fi
AC_SUBST(ac_perlprog)
AC_SUBST(ac_perlvers)
PATH_PERL=$ac_perlprog
AC_SUBST(PATH_PERL)
])dnl
dnl
dnl ##########################################################
dnl ##
dnl ##  check for MakeMaker install paths
dnl ##
dnl ##########################################################
dnl
define(AC_CHECK_PERL_MM_PATHS,[dnl
AC_MSG_CHECKING([for MakeMaker's private install paths])
TMPDIR=/tmp/ac.$$
rm -rf $TMPDIR 2>/dev/null
mkdir $TMPDIR
cat >$TMPDIR/Makefile.PL <<'EOT'
use ExtUtils::MakeMaker;
WriteMakefile(
    'NAME'		=> 'Dummy::Dummy',
    'VERSION'	=> '0.0',
);
sub MY::postamble {
	'
dummy:
	@echo INSTALLPRIVLIB=$(INSTALLPRIVLIB)
	@echo INSTALLARCHLIB=$(INSTALLARCHLIB)
	@echo INSTALLSITELIB=$(INSTALLSITELIB)
	@echo INSTALLSITEARCH=$(INSTALLSITEARCH)
';
}
EOT
test "x$prefix" = xNONE && prefix=$ac_default_prefix
test "x$exec_prefix" = xNONE && exec_prefix='${prefix}'
eval "dir=$libdir"
( cd $TMPDIR; eval "$PATH_PERL Makefile.PL PREFIX=$dir/perl >/dev/null 2>/dev/null" )
for line in `make -f $TMPDIR/Makefile dummy | grep '^INSTALL'`; do
	eval "$line"
done
rm -rf $TMPDIR 2>/dev/null
AC_MSG_RESULT([ok])
AC_SUBST(INSTALLPRIVLIB)
AC_SUBST(INSTALLARCHLIB)
AC_SUBST(INSTALLSITELIB)
AC_SUBST(INSTALLSITEARCH)
])dnl
dnl
