#!@SH@
##
##  Shiela - CVS Access Control and Logging Facility
##  Copyright (c) 2000 Ralf S. Engelschall <rse@engelschall.com>
##
##  This file is part of Shiela, an access control and logging
##  facility for Concurrent Versions System (CVS) repositories
##  which can be found at http://www.ossp.org/pkg/shiela/.
##
##  This program is free software; you can redistribute it and/or
##  modify it under the terms of the GNU General Public  License 
##  as published by the Free Software Foundation; either version 
##  2.0 of the License, or (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
##  General Public License for more details.
##
##  You should have received a copy of the GNU General Public License 
##  along with this file; if not, write to the Free Software
##  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
##  USA, or contact Ralf S. Engelschall <rse@engelschall.com>.
##
##  shiela-install: Shiela repository install program (syntax: Bourne-Shell)
##

version="0.9.1"

prefix="@prefix@"
bindir="@bindir@"

if [ ".$TMPDIR" != . ]; then
    tmpdir=$TMPDIR
elif [ ".$TEMPDIR" != . ]; then
    tmpdir=$TEMPDIR
else
    tmpdir=/tmp
fi
tmpfile="$tmpdir/shiela-install.$$.tmp"

#   determine terminal bold sequence
term_bold='' 
term_norm=''
case $TERM in
    #   for the most important terminal types we directly know the sequences
    xterm|xterm*|vt220|vt220*)
        term_bold=`awk 'BEGIN { printf("%c%c%c%c", 27, 91, 49, 109); }' </dev/null 2>/dev/null`
        term_norm=`awk 'BEGIN { printf("%c%c%c", 27, 91, 109); }' </dev/null 2>/dev/null`
        ;;
    vt100|vt100*)
        term_bold=`awk 'BEGIN { printf("%c%c%c%c%c%c", 27, 91, 49, 109, 0, 0); }' </dev/null 2>/dev/null`
        term_norm=`awk 'BEGIN { printf("%c%c%c%c%c", 27, 91, 109, 0, 0); }' </dev/null 2>/dev/null`
        ;;
    #   for all others, we try to use a possibly existing `tput' or `tcout' utility
    * )
        paths=`echo $PATH | sed -e 's/:/ /g'`
        for tool in tput tcout; do
            for dir in $paths; do
                if [ -r "$dir/$tool" ]; then
                    for seq in bold md smso; do # 'smso' is last
                        bold="`$dir/$tool $seq 2>/dev/null`"
                        if [ ".$bold" != . ]; then
                            term_bold="$bold"
                            break
                        fi
                    done
                    if [ ".$term_bold" != . ]; then
                        for seq in sgr0 me rmso reset; do # 'reset' is last
                            norm="`$dir/$tool $seq 2>/dev/null`"
                            if [ ".$norm" != . ]; then
                                term_norm="$norm"
                                break
                            fi
                        done
                    fi
                    break
                fi
            done
            if [ ".$term_bold" != . -a ".$term_norm" != . ]; then
                break;
            fi
        done
        ;;
esac

echo "This is ${term_bold}Shiela Setup${term_norm}, Version ${term_bold}${version}${term_norm}"
echo "Copyright (c) 2000 Ralf S. Engelschall <rse@engelschall.com>"
echo ""

echo "${term_bold}PARAMETER DETERMINATION${term_norm}"
cat <<EOT

This utility helps you to initially setup Shiela for a particular CVS
repository. It asks you a few questions in order to establish an initial
Shiela configuration. This can be adjusted later without problems. Only
the questions marked with (U) ask for details which are actually used
immediately and so have to be correctly entered already now. All other
questions ask just for informational (I) details which do not harm if
not immediately correct.

EOT

for arg; do
    eval `echo $arg | sed -e 's/^\([^=]*\)=\(.*\)$/V_\1="\2"/`
done

query () {
    vartype=$1
    varname=$2
    echo $varname | awk '{ printf("%-16s", $0); }'
    eval "text=\"($vartype) [\$V_$varname]: \""
    echo dummy | awk '{ printf("%s", TEXT); }' TEXT="$text"
    if [ ".$V_batch" = .yes ]; then
        echo ""
    else
        read answer
        if [ ".$answer" != . ]; then
            eval "V_${varname}=\"\$answer\""
        fi
    fi
}

domainname=''
hostname="`(uname -n) 2>/dev/null |\
           awk '{ printf("%s", $1); }'`"
if [ ".$hostname" = . ]; then
    hostname="`(hostname) 2>/dev/null |\
               awk '{ printf("%s", $1); }'`"
    if [ ".$hostname" = . ]; then
        hostname='unknown'
    fi
fi
case $hostname in
    *.* )
        domainname="`echo $hostname | cut -d. -f2-`"
        hostname="`echo $hostname | cut -d. -f1`"
        ;;
esac
if [ ".$domainname" = . ]; then
    if [ -f /etc/resolv.conf ]; then
        domainname="`egrep '^[ 	]*domain' /etc/resolv.conf | head -1 |\
                     sed -e 's/.*domain//' \
                         -e 's/^[ 	]*//' -e 's/^ *//' -e 's/^	*//' \
                         -e 's/^\.//' |\
                     awk '{ printf("%s", $1); }'`"
        if [ ".$domainname" = . ]; then
            domainname="`egrep '^[ 	]*search' /etc/resolv.conf | head -1 |\
                         sed -e 's/.*search//' \
                             -e 's/^[ 	]*//' -e 's/^ *//' -e 's/^	*//' \
                             -e 's/ .*//' -e 's/	.*//' \
                             -e 's/^\.//' |\
                         awk '{ printf("%s", $1); }'`"
        fi
    fi
fi
if [ ".$V_host_name" = . ]; then
    V_host_name=$hostname
fi
query I host_name
if [ ".$V_domain_name" = . ]; then
    V_domain_name=$domainname
fi
query U domain_name

if [ ".$V_user_name" = . ]; then
    V_user_name="$LOGNAME"
    if [ ".$V_user_name" = . ]; then
        V_user_name="$USER"
        if [ ".$V_user_name" = . ]; then
            V_user_name="`(whoami) 2>/dev/null |\
                          awk '{ printf("%s", $1); }'`"
            if [ ".$V_user_name" = . ]; then
                V_user_name="`(who am i) 2>/dev/null |\
                              awk '{ printf("%s", $1); }'`"
                if [ ".$V_user_name" = . ]; then
                    V_user_name='unknown'
                fi
            fi
        fi
    fi
fi
query U user_name

if [ ".$V_user_realname" = . ]; then
    V_user_realname=`(cat /etc/passwd; (ypcat passwd) 2>/dev/null) |\
                     egrep "^$V_user_name:" 2>/dev/null | \
                     sed -e 's/[^:]*:[^:]*:[^:]*:[^:]*://' -e 's/:.*$//'`
fi
query I user_realname

if [ ".$V_user_email" = . ]; then
    V_user_email="${V_user_name}@${V_domain_name}"
fi
query U user_email

if [ ".$V_project_tag" = . ]; then
    V_project_tag="`echo ${V_user_name} |\
                    tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`"
fi
query I project_tag

if [ ".$V_project_name" = . ]; then
    V_project_name="${V_user_realname}'s CVS Test Project"
fi
query I project_name

if [ ".$V_project_home" = . ]; then
    V_project_home="http://${V_host_name}.${V_domain_name}/~${V_user_name}/"
fi
query I project_home

if [ ".$V_project_contact" = . ]; then
    V_project_contact=${V_user_email}
fi
query I project_contact

if [ ".$V_repos_tag" = . ]; then
    V_repos_tag="CVS-`echo ${V_user_name} |\
                 tr 'abcdefghijklmnopqrstuvwxyz' 'ABCDEFGHIJKLMNOPQRSTUVWXYZ'`"
fi
query I repos_tag

if [ ".$V_repos_name" = . ]; then
    V_repos_name="${V_user_realname}'s CVS Test Repository"
fi
query I repos_name

if [ ".$V_repos_contact" = . ]; then
    V_repos_contact=${V_project_contact}
fi
query I repos_contact

if [ ".$V_repos_home" = . ]; then
    V_repos_home=${V_project_home}
fi
query I repos_home

if [ ".$V_repos_host" = . ]; then
    V_repos_host="${V_host_name}.${V_domain_name}"
fi
query U repos_host

if [ ".$V_repos_path" = . ]; then
    V_repos_path="${CVSROOT-/tmp}"
fi
query U repos_path
if [ ! -d "$V_repos_path/CVSROOT" ]; then
    echo "shiela-install:Error: \`$V_repos_path' does not look like a CVS repository" 1>&2
    exit 1
fi

if [ ".$V_repos_history" = . ]; then
    V_repos_history="CVSROOT/shiela.log"
fi
query U repos_history

#   check whether the test command supports the -x option
if [ -x /bin/sh ] 2>/dev/null; then
    minusx="-x"
else
    minusx="-r"
fi
#   split path string
paths="`echo $PATH |\
        sed -e 's/^:/.:/' \
            -e 's/::/:.:/g' \
            -e 's/:$/:./' \
            -e 's/:/ /g'`"

if [ ".$V_tool_perl" = . ]; then
    V_tool_perl="perl"
    rm -f $tmpfile
    touch $tmpfile
    c=0
    found=0
    for dir in $paths; do
        dir=`echo $dir | sed -e 's;/*$;;'`
        for perl in perl5 perl miniperl; do
             if [ $minusx "$dir/$perl" ] && [ ! -d "$dir/$perl" ]; then
                 perl="$dir/$perl"
                 version=`$perl -v | grep version |\
                          sed -e 's/.* version //' -e 's/ built.*//' -e 's/ with.*//'`
                 versionnum="`echo $version | sed -e 's/\.//g' -e 's/_//g'`"
                 versionnum=`expr $versionnum - $c`
                 echo "$versionnum $perl" >>$tmpfile
                 found=1
             fi
        done
        c=`expr $c + 1`
    done
    if [ $found = 1 ]; then
        V_tool_perl="`cat $tmpfile | sort -u | tail -1 | cut '-d ' -f2`"
    fi
    rm -f $tmpfile
fi
query U tool_perl

if [ ".$V_tool_cvs" = . ]; then
    V_tool_cvs="cvs"
    for path in $paths; do
        path=`echo $path | sed -e 's;/*$;;'`
        if [ $minusx "$path/cvs" ] && [ ! -d "$path/cvs" ]; then
            V_tool_cvs="$path/cvs"
            break
        fi
    done
fi
query U tool_cvs

if [ ".$V_tool_sendmail" = . ]; then
    V_tool_sendmail="sendmail"
    for path in $paths; do
        path=`echo $path | sed -e 's;/*$;;'`
        if [ $minusx "$path/sendmail" ] && [ ! -d "$path/sendmail" ]; then
            V_tool_sendmail="$path/sendmail"
            break
        fi
    done
fi
query U tool_sendmail

CVS_VERSION=`$V_tool_cvs --version |\
             grep "Concurrent Versions System (CVS)" |\
             sed -e 's;^.*(CVS) ;;' -e 's; .*$;;'`
if [ ".`$V_tool_cvs --version | grep OSSP`" != . ]; then
    CVS_VENDOR=OSSP
else
    CVS_VENDOR=OpenAvenue
fi
case $CVS_VERSION in
   1.10.[789]* | 1.10.1[0123456789]* | 1.11.* ) 
       ;;
   * ) 
       echo "ERROR: CVS has to be at least version 1.10.7"
       exit 1 
       ;;
esac
case $CVS_VENDOR in
    OSSP ) 
       ;;
    * ) 
       echo "WARNING: You are using a stock CVS version from $CVS_VENDOR!"
       echo "         This means that not all Shiela functionality is available".
       echo "         for you. Please consider upgrading to the OSSP CVS version.".
       echo ""
       ;;
esac

if [ ".$V_tool_shiela" = . ]; then
    V_tool_shiela="$bindir/shiela"
    for path in $paths; do
        path=`echo $path | sed -e 's;/*$;;'`
        if [ $minusx "$path/shiela" ] && [ ! -d "$path/shiela" ]; then
            V_tool_shiela="$path/shiela"
            break
        fi
    done
fi
query U tool_shiela

if [ ".$V_shiela_local" = . ]; then
    V_shiela_local=yes
fi
query U shiela_local

cat >$tmpdir/shiela.cfg <<EOT
##
##  Shiela - CVS Access Control and Logging Facility
##  Copyright (c) 2000 Ralf S. Engelschall <rse@engelschall.com>
##
##  This file is part of Shiela, an access control and logging
##  facility for Concurrent Versions System (CVS) repositories 
##  which can be found at http://www.ossp.org/pkg/shiela/.
##
##  This program is free software; you can redistribute it and/or
##  modify it under the terms of the GNU General Public  License 
##  as published by the Free Software Foundation; either version 
##  2.0 of the License, or (at your option) any later version.
##
##  This program is distributed in the hope that it will be useful,
##  but WITHOUT ANY WARRANTY; without even the implied warranty of
##  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
##  General Public License for more details.
##
##  You should have received a copy of the GNU General Public License 
##  along with this file; if not, write to the Free Software
##  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
##  USA, or contact Ralf S. Engelschall <rse@engelschall.com>.
##
##  shiela.cfg: Shiela configuration (syntax: Shiela C-style)
##

Project {
    Tag     ${V_project_tag};
    Name    "${V_project_name}";
    Contact ${V_project_contact};
    Home    ${V_project_home};
    Users {
        User ${V_user_name} "${V_user_realname}" ${V_user_email};
    };
    Groups {
        Group users "Repository Users" { ${V_user_name} };
    };
};

Environment {
    CVS      ${V_tool_cvs};
    Sendmail ${V_tool_sendmail};
};

Repository {
    Tag     ${V_repos_tag};
    Name    "${V_repos_name}"; 
    Contact ${V_repos_contact};
    Home    ${V_repos_home};
    Host    ${V_repos_host};
    Path    ${V_repos_path};
    History ${V_repos_history};
    Modules {
        Module CVSROOT "CVS Administrative Files" {
            Acl * *:users;
            Log passwd none;
            Log * mail:${V_user_email};
        };
    };
};

Logging {
    Reports {
        Report mail {
            Content title rule header files log summary details;
            Details diff:mime;
        };
    };
};

EOT

cat >$tmpdir/shiela.msg <<EOT

PR:
Submitted by:
Reviewed by:
Approved by:
Obtained from:
CVS: ----------------------------------------------------------------------
CVS: PR:            Fill this in if a problem report is affected
CVS: Submitted by:  Fill this in if someone else sent you the change
CVS: Reviewed by:   Fill this in if someone else reviewed your modification
CVS: Approved by:   Fill this in if you needed approval for this commit
CVS: Obtained from: Fill this in if the change is from third party software
CVS: ----------------------------------------------------------------------
EOT

echo ""
echo "${term_bold}SHIELA CONFIGURATION${term_norm}"
cat <<EOT

Initial "shiela.cfg" and "shiela.msg" files were generated for you. 
Before Shiela is installed and activated with these configuration files, 
you have the chance to adjust them in your editor.

EOT
text="Edit \"shiela.cfg\" now with \"${EDITOR-vi}\" [y/N]: "
echo dummy | awk '{ printf("%s", TEXT); }' TEXT="$text"
if [ ".$V_batch" = .yes ]; then
    echo ""
else
    read answer
    if [ ".$answer" = .y ]; then
        cd $tmpdir && ${EDITOR-vi} shiela.cfg
    fi
fi
text="Edit \"shiela.msg\" now with \"${EDITOR-vi}\" [y/N]: "
echo dummy | awk '{ printf("%s", TEXT); }' TEXT="$text"
if [ ".$V_batch" = .yes ]; then
    echo ""
else
    read answer
    if [ ".$answer" = .y ]; then
        cd $tmpdir && ${EDITOR-vi} shiela.msg
    fi
fi
echo ""

echo "${term_bold}CVSROOT MODIFICATION${term_norm}"
cat <<EOT

Ok, we are now prepared to modify ${V_repos_path}/CVSROOT/. We will
first checkout CVSROOT and modify it. Then you have a last chance to
stop processing before we finally commit the modifications.

EOT

run () {
    echo "\$ $*" 1>&2
    eval $* || exit 1
}

cvs_file () {
    op=$1
    file=$2;
    name=`echo $file | sed -e 's;\.;_;g'`
    if [ ".$op" = .tst ]; then
        if [ -f $file ]; then
            eval "cvs_file_add_${name}=no"
        else
            eval "cvs_file_add_${name}=yes"
        fi
    elif [ ".$op" = .add ]; then
        eval "add=\$cvs_file_add_${name}"
        if [ ".$add" = .yes ]; then
            run $V_tool_cvs -q add $file
        fi
    fi
}

run rm -rf CVSROOT
run cvs -Q -q -d${V_repos_path} co CVSROOT 
run cd CVSROOT

if [ ".$V_shiela_local" = .yes ]; then
    cvs_file tst shiela
    run "cp $V_tool_shiela ."
    run chmod 755 shiela 
    cvs_file add shiela
    V_tool_shiela="\$CVSROOT/CVSROOT/shiela"
fi

cvs_file tst shiela.cfg
run cp $tmpdir/shiela.cfg .
run chmod 644 shiela.cfg
cvs_file add shiela.cfg

cvs_file tst shiela.msg
run cp $tmpdir/shiela.msg .
run chmod 644 shiela.msg
cvs_file add shiela.msg

cvs_file tst checkoutlist
run "echo 'shiela.cfg' >>checkoutlist"
run "echo 'shiela' >>checkoutlist"
run "echo 'shiela.msg' >>checkoutlist"
cvs_file add checkoutlist

cvs_file tst rcsinfo
run "(echo ''; echo 'ALL \$CVSROOT/CVSROOT/shiela.msg'; echo '') >>rcsinfo"
cvs_file add rcsinfo

cvs_file tst taginfo
run "(echo ''; echo 'ALL $V_tool_shiela --hook=taginfo'; echo '') >>taginfo"
cvs_file add taginfo

if [ ".$CVS_VENDOR" = .OSSP ]; then
    cvs_file tst importinfo
    run "(echo ''; echo 'ALL $V_tool_shiela --hook=importinfo'; echo '') >>importinfo"
    cvs_file add importinfo

    cvs_file tst admininfo
    run "(echo ''; echo 'ALL $V_tool_shiela --hook=admininfo'; echo '') >>admininfo"
    cvs_file add admininfo
fi

cvs_file tst commitinfo
run "(echo ''; echo 'ALL $V_tool_shiela --hook=commitinfo'; echo '') >>commitinfo"
cvs_file add commitinfo

cvs_file tst verifymsg
run "(echo ''; echo 'DEFAULT $V_tool_shiela --hook=verifymsg'; echo '') >>verifymsg"
cvs_file add verifymsg

if [ ".$CVS_VENDOR" = .OSSP ]; then
    flags="sVvto"
else
    flags="sVv"
fi
cvs_file tst loginfo
run "(echo ''; echo 'ALL $V_tool_shiela --hook=loginfo %{${flags}}'; echo '') >>loginfo"
cvs_file add loginfo

run $V_tool_cvs update

echo ""
echo "${term_bold}The above modifications were made to CVSROOT.${term_norm}"
text="${term_bold}Are you sure to finally commit these modifications [y/N]: ${term_norm}"
echo dummy | awk '{ printf("%s", TEXT); }' TEXT="$text"
if [ ".$V_batch" = .yes ]; then
    echo ""
else
    read answer
    if [ ".$answer" = . -o ".$answer" = .n ]; then
        cd ..
        rm -rf CVSROOT
        echo ""
        echo "**Break: nothing touched."
        echo ""
        exit 0
    fi
fi
echo ""
run "$V_tool_cvs commit -m 'Add Shiela -- CVS Access Control and Logging Facility' ."
run cd ..
run rm -rf CVSROOT

cat <<EOT

Ok, your $V_repos_path/CVSROOT/ area was modified to now use Shiela for
access control and logging. You can try it out by checking out CVSROOT
yourself and modify some files. You should receive an Email for every
modification. Then especially adjust "shiela.cfg" for your particular
repository layout.

EOT

rm -f $tmpfile
rm -f $tmpdir/shiela.cfg
rm -f $tmpdir/shiela.msg

