/*
    ifnotps -- run stdin through the named filter if not already
               in postscript format
    Copyright (c) 1992 Ralf S. Engelschall, sd&m

    Compile with: cc -o ifnotps ifnotps.c
    Usage: ifnotps a2ps [<infile] [>outfile]
								*/
#include <stdio.h>

#define POSTSCRIPT_KEY "%!"    /* key for PostScript format */
#define BUFSIZE 256
#define FALSE 0
#define TRUE ~FALSE 

main(argc, argv)
int argc;
char *argv[];
{
    FILE *fpOut;
    int filtered;
    char caBuf[BUFSIZE];
    char *cpBuf;
    int nBuf;
    int i;

    if (argc != 2) {
        printf("%s: Usage: %s filter [<infile] [>outfile]\n",
            argv[0], argv[0]);
        exit(1);
    }

    /* read in the first 512 bytes */
    nBuf = fread(caBuf, 1, BUFSIZE, stdin);
    
    /* check for Postscript key */
    filtered = TRUE;
    for (cpBuf=caBuf, i=0; i <= nBuf-strlen(POSTSCRIPT_KEY); cpBuf++, i++) {
        if (strncmp(cpBuf, POSTSCRIPT_KEY, strlen(POSTSCRIPT_KEY)) == 0) {
            filtered = FALSE;
            break;
        }
    }

    /* open pipe to filter */
    if (filtered) {
        if ((fpOut = popen(argv[1], "w")) == NULL) {
            printf("Error opening Pipe!\n");
            exit(2);
        }
    }
    else {
        fpOut = stdout;
    }

    /* write out the data */
    do {
        fwrite(caBuf, 1, nBuf, fpOut);
    } while ((nBuf = fread(caBuf, 1, BUFSIZE, stdin)) != 0); 

    /* close pipe */
    if (filtered)
        pclose(fpOut);

    exit(0);
}

