#ifndef __L2_SPEC_H__
#define __L2_SPEC_H__

#include "l2.h"

/* internal specification scanner/parser context */
typedef struct {
    const char   *inputptr;  /* input buffer: current reading pointer */
    const char   *inputbuf;  /* input buffer: begin of buffer */
    size_t        inputlen;  /* input buffer: size  of buffer */
    l2_env_t     *env;       /* environment for channel create & error remember */
    l2_channel_t *ch;        /* top-level/root/result channel */
    l2_channel_t *chTmp;     /* temporary channel needed in the parser */
    l2_result_t   rv;        /* return value */
    void         *yyscan;    /* Flex scanner context */
} l2_spec_ctx_t;

/* internal scanner/parser token location */
typedef struct {
    int first;
    int last;
} l2_spec_loc_t;
#define YYLTYPE l2_spec_loc_t

/* support for automatic location tracking by Bison */
#define first_line   first
#define first_column first
#define last_line    last
#define last_column  last

/* error reporting function */
extern void l2_spec_error(l2_spec_ctx_t *ctx, l2_result_t rv, YYLTYPE *loc, const char *fmt, ...);

#endif /* __L2_SPEC_H__ */
