/*
**  L2 - OSSP Logging Library
**  Copyright (c) 2001 The OSSP Project (http://www.ossp.org/)
**  Copyright (c) 2001 Cable & Wireless Deutschland (http://www.cw.com/de/)
**
**  This file is part of OSSP L2, a flexible logging library which
**  can be found at http://www.ossp.org/pkg/l2/.
**
**  Permission to use, copy, modify, and distribute this software for
**  any purpose with or without fee is hereby granted, provided that
**  the above copyright notice and this permission notice appear in all
**  copies.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
**  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
**  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
**  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
**  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
**  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
**  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
**  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
**  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
**  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
**  SUCH DAMAGE.
**
**  l2_ut_param.c: parameter parsing support
*/

#include "l2.h"
#include "l2_p.h"

#include <string.h>

l2_result_t l2_util_setparams(l2_param_t pa[], const char *fmt, va_list ap)
{
    const char *cpB, *cpE;
    const char *cpC, *cpG;
    int ok;
    int i; 

    if (pa == NULL || fmt == NULL || ap == NULL)
        return L2_ERR_ARG;
    cpE = fmt;
    while (*cpE != '\0') {
        /* determine begin of parameter name */
        cpB = cpE;
        while (*cpB == ',')
            cpB++;

        /* determine end of parameter name */
        cpE = cpB;
        while (*cpE != ',' && *cpE != '\0')
            cpE++;

        /* try to match with configured parameters */
        ok = FALSE;
        for (i = 0; pa[i].name != NULL; i++) {
            cpC = pa[i].name;
            cpG = cpB;
            while (*cpC != '\0' && cpG < cpE) {
                if (*cpC != *cpG)
                    break;
                cpC++;
                cpG++;
            }
            if (*cpC == '\0' && cpG == cpE) {
                /* parameter matched, so store value */
                switch (pa[i].type) {
                    case L2_TYPE_CHAR:
                        *(char *)(pa[i].store) = va_get(ap, char); 
                        break;
                    case L2_TYPE_SHORT:
                        *(short *)(pa[i].store) = va_get(ap, short); 
                        break;
                    case L2_TYPE_INT:
                        *(int *)(pa[i].store) = va_get(ap, int); 
                        break;
                    case L2_TYPE_LONG:
                        *(long *)(pa[i].store) = va_get(ap, long); 
                        break;
                    case L2_TYPE_FLOAT:
                        *(float *)(pa[i].store) = va_get(ap, float); 
                        break;
                    case L2_TYPE_DOUBLE:
                        *(double *)(pa[i].store) = va_get(ap, double); 
                        break;
                    case L2_TYPE_STRING:
                        if (*(char **)(pa[i].store) != NULL) 
                            free(*(char **)(pa[i].store));
                        *(char **)(pa[i].store) = va_get(ap, charptr);
                        if (*(char **)(pa[i].store) != NULL)
                            *(char **)(pa[i].store) = strdup(*(char **)(pa[i].store));
                        break;
                    case L2_TYPE_CHARPTR:
                        *(char **)(pa[i].store) = va_get(ap, charptr); 
                        break;
                    case L2_TYPE_VOIDPTR:
                        *(void **)(pa[i].store) = va_get(ap, voidptr); 
                        break;
                }
                ok = TRUE;
                break;
            }
        }
        if (!ok)
            return L2_ERR_USE;
    }
    return L2_OK;
}

