/*
**  TS - OSSP Test Suite Library
**  Copyright (c) 2001 Ralf S. Engelschall <rse@engelschall.com>
**  Copyright (c) 2001 The OSSP Project <http://www.ossp.org/>
**  Copyright (c) 2001 Cable & Wireless Deutschland <http://www.cw.com/de/>
**
**  This file is part of OSSP TS, a test suite library which
**  can be found at http://www.ossp.org/pkg/ts/.
**
**  Permission to use, copy, modify, and distribute this software for
**  any purpose with or without fee is hereby granted, provided that
**  the above copyright notice and this permission notice appear in all
**  copies.
**
**  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
**  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
**  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
**  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
**  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
**  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
**  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
**  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
**  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
**  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
**  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
**  SUCH DAMAGE.
**
**  ts.h: test suite library API
*/

#ifndef _TS_H_
#define _TS_H_

struct ts_st;
typedef struct ts_st ts_t;

struct tst_st;
typedef struct tst_st tst_t;

typedef void (*tst_func_t)(tst_t *);

#define TST_FUNC(name) \
    static void name(tst_t *tst)

#define TST_CTX(tst) \
    tst_ctx(tst, __FILE__, __LINE__)

#define TST \
    TST_CTX(tst)

ts_t   *ts_new    (const char *fmt, ...);
void    ts_test   (ts_t *ts, tst_func_t func, const char *fmt, ...);
int     ts_run    (ts_t *ts);
void    ts_free   (ts_t *ts);

tst_t  *tst_ctx   (tst_t *tst, const char *file, int line);
void    tst_check (tst_t *tst, const char *fmt, ...);
void    tst_fail  (tst_t *tst, const char *fmt, ...);
void    tst_log   (tst_t *tst, const char *fmt, ...);

#endif /* _TS_H_ */

