/*
**  Copyright (c) 2001 The OSSP Project <http://www.ossp.org/>
**  Copyright (c) 2001 Cable & Wireless Deutschland <http://www.cw.com/de/>
**
**  This file is part of OSSP lmtp2nntp, an LMTP speaking local
**  mailer which forwards mails as Usenet news articles via NNTP.
**  It can be found at http://www.ossp.org/pkg/lmtp2nntp/.
**
**  This program is free software; you can redistribute it and/or
**  modify it under the terms of the GNU General Public  License
**  as published by the Free Software Foundation; either version
**  2.0 of the License, or (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
**  General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this file; if not, write to the Free Software
**  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
**  USA, or contact the OSSP project <ossp@ossp.org>.
**
**  nntp.h: Network News Transfer Protocol (NNTP) client library (API)
*/

#ifndef __NNTP_H__
#define __NNTP_H__

#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <fcntl.h>
#include "msg.h"

struct nntp_st;
typedef struct nntp_st nntp_t;

typedef struct {
    void    *ctx;
    int     (*select)(void *, int, fd_set *, fd_set *, fd_set *, struct timeval *);
    ssize_t (*read)(void *, int, void *, size_t);
    ssize_t (*write)(void *, int, const void *, size_t);
} nntp_io_t;

typedef enum {
    NNTP_OK,
    NNTP_EOF,
    NNTP_TIMEOUT,
    NNTP_DEFER,
    NNTP_FAKE,
    NNTP_ERR_SYSTEM,
    NNTP_ERR_ARG,
    NNTP_ERR_OVERFLOW,
    NNTP_ERR_DELIVERY,
    NNTP_ERR_INIT,
    NNTP_ERR_UNKNOWN
} nntp_rc_t;

nntp_t     *nntp_create   (int, int, nntp_io_t *);
nntp_rc_t   nntp_timeout  (nntp_t *nntp, long);
nntp_rc_t   nntp_init     (nntp_t *);
void        nntp_destroy  (nntp_t *);
nntp_rc_t   nntp_readline (nntp_t *, char *, size_t);
nntp_rc_t   nntp_writeline(nntp_t *, char *);
nntp_rc_t   nntp_post     (nntp_t *, msg_t *msg);
nntp_rc_t   nntp_feed     (nntp_t *, msg_t *msg);
char       *nntp_error    (nntp_rc_t);

#endif /* __NNTP_H__ */

