/*
 *  nntp.h: NNTP library (API definition)
 *
 *  Copyright (c) 2001 The OSSP Project (http://www.ossp.org/)
 *  Copyright (c) 2001 Cable & Wireless Deutschland (http://www.cw.com/de/)
 *
 *  This file is part of OSSP nntp2nntp, an NNTP speaking local
 *  mailer which forwards mails as Usenet news articles via NNTP.
 *  It can be found at http://www.ossp.com/pkg/nntp2nntp/.
 *
 *  Permission to use, copy, modify, and distribute this software for
 *  any purpose with or without fee is hereby granted, provided that
 *  the above copyright notice and this permission notice appear in all
 *  copies.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 *  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 *  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 */

#ifndef __NNTP_H__
#define __NNTP_H__

#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <fcntl.h>
#include "msg.h"

struct nntp_st;
typedef struct nntp_st nntp_t;

typedef struct {
    int     (*select)(int, fd_set *, fd_set *, fd_set *, struct timeval *);
    ssize_t (*read)(int, void *, size_t);
    ssize_t (*write)(int, const void *, size_t);
} nntp_io_t;

typedef enum {
    NNTP_OK,
    NNTP_EOF,
    NNTP_TIMEOUT,
    NNTP_DEFER,
    NNTP_ERR_SYSTEM,
    NNTP_ERR_ARG,
    NNTP_ERR_OVERFLOW,
    NNTP_ERR_POST,
    NNTP_ERR_INIT,
    NNTP_ERR_UNKNOWN
} nntp_rc_t;

nntp_t     *nntp_create   (int, int, nntp_io_t *);
nntp_rc_t   nntp_timeout  (nntp_t *nntp, long);
nntp_rc_t   nntp_init     (nntp_t *);
void        nntp_destroy  (nntp_t *);
nntp_rc_t   nntp_readline (nntp_t *, char *, size_t);
nntp_rc_t   nntp_writeline(nntp_t *, char *);
nntp_rc_t   nntp_post     (nntp_t *, msg_t *msg);
nntp_rc_t   nntp_feed     (nntp_t *, msg_t *msg);
char       *nntp_error    (nntp_rc_t);

#endif /* __NNTP_H__ */

