
#include <errno.h>
#include <limits.h>

#include "trace.h"

#ifndef _POSIX_PATH_MAX
#if defined(PATH_MAX)
#define _POSIX_PATH_MAX PATH_MAX
#elif defined(MAX_PATH)
#define _POSIX_PATH_MAX MAX_PATH
#else
#error "unable to determime maximum path limit"
#endif
#endif

/*
 * tracing
 */

ssize_t trace_read(int d, void *buf, size_t nbytes)
{
    ssize_t rc;
    int tf;
    static char tfn[_POSIX_PATH_MAX] = "/tmp/trace";

    if ((d == -1) && (buf != NULL) && (nbytes == 0)) {
        strncpy(tfn, buf, _POSIX_PATH_MAX-1);
    }
    rc = read(d, buf, nbytes);
    if ((tf = open(tfn, O_CREAT|O_WRONLY|O_APPEND, 0664)) != -1) {
        write(tf, buf, rc);
        close(tf);
    }
    return rc;
}

ssize_t trace_write(int d, const void *buf, size_t nbytes)
{
    ssize_t rc;
    int tf;
    static char tfn[_POSIX_PATH_MAX] = "/tmp/trace";

    if ((d == -1) && (buf != NULL) && (nbytes == 0)) {
        strncpy(tfn, buf, _POSIX_PATH_MAX-1);
    }

    rc = write(d, buf, nbytes);
    if ((tf = open(tfn, O_CREAT|O_WRONLY|O_APPEND, 0664)) != -1) {
        write(tf, buf, rc);
        close(tf);
    }
    return rc;
}

