/*
**
**  shpat_match.h -- MAX POSIX-compliant fnmatch library
**
*/

/*-
 * Copyright (c) 1992, 1993
 *      The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. All advertising materials mentioning features or use of this software
 *    must display the following acknowledgement:
 *      This product includes software developed by the University of
 *      California, Berkeley and its contributors.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _SHPAT_MATCH_H_
#define _SHPAT_MATCH_H_

#define SHPAT_M_NOMATCH     1       /* Match failed. */

#define SHPAT_M_NOESCAPE    0x01    /* Disable backslash escaping. */
#define SHPAT_M_PATHNAME    0x02    /* Slash must be matched by slash. */
#define SHPAT_M_PERIOD      0x04    /* Period must be matched by period. */
#define SHPAT_M_LEADING_DIR 0x08    /* Ignore /<tail> after Imatch. */
#define SHPAT_M_CASEFOLD    0x10    /* Case insensitive search. */
#define SHPAT_M_IGNORECASE  FNM_CASEFOLD

#if defined(__cplusplus)
extern "C" {
#endif

int shpat_match(const char *, const char *, int);
int shpat_match_hasglobchar(const char *);

#if defined(__cplusplus)
}
#endif

#endif /* !_SHPAT_MATCH_H_ */
