/*
 *  lmtp.h: LMTP library (API definition)
 *
 *  Copyright (c) 2001 The OSSP Project (http://www.ossp.org/)
 *  Copyright (c) 2001 Cable & Wireless Deutschland (http://www.cw.com/de/)
 *
 *  This file is part of OSSP lmtp2nntp, an LMTP speaking local
 *  mailer which forwards mails as Usenet news articles via NNTP.
 *  It can be found at http://www.ossp.com/pkg/lmtp2nntp/.
 *
 *  Permission to use, copy, modify, and distribute this software for
 *  any purpose with or without fee is hereby granted, provided that
 *  the above copyright notice and this permission notice appear in all
 *  copies.
 *
 *  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 *  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 *  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
 *  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
 *  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 *  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 *  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 *  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 *  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 *  SUCH DAMAGE.
 */

#ifndef __LMTP_H__
#define __LMTP_H__

#include <sys/types.h>
#include <sys/uio.h>
#include <unistd.h>
#include <fcntl.h>

struct lmtp_st;
typedef struct lmtp_st lmtp_t;

typedef struct {
    int     (*select)(int, fd_set *, fd_set *, fd_set *, struct timeval *);
    ssize_t (*read)(int, void *, size_t);
    ssize_t (*write)(int, const void *, size_t);
} lmtp_io_t;

typedef struct {
    char *verb;
    char *msg;
} lmtp_req_t;

typedef struct {
    char *statuscode;
    char *dsncode;
    char *statusmsg;
} lmtp_res_t;

typedef enum {
    LMTP_OK,
    LMTP_EOF,
    LMTP_ERR_SYSTEM,
    LMTP_ERR_MEM,
    LMTP_ERR_OVERFLOW,
    LMTP_ERR_ARG,
    LMTP_ERR_UNKNOWN
} lmtp_rc_t;

typedef lmtp_rc_t (*lmtp_cb_t)(lmtp_t *, lmtp_io_t *, lmtp_req_t *, void *);

lmtp_t     *lmtp_create  (int, int, lmtp_io_t *);
void        lmtp_destroy (lmtp_t *);
lmtp_rc_t   lmtp_readline(lmtp_t *, char *, size_t);
lmtp_rc_t   lmtp_readmsg (lmtp_t *, char **, size_t);
lmtp_rc_t   lmtp_request (lmtp_t *, lmtp_req_t *);
lmtp_rc_t   lmtp_response(lmtp_t *, lmtp_res_t *);
char       *lmtp_error   (lmtp_rc_t);
lmtp_rc_t   lmtp_register(lmtp_t *, char *, lmtp_cb_t, void *, lmtp_cb_t *, void **);
lmtp_rc_t   lmtp_loop    (lmtp_t *);

#endif /* __LMTP_H__ */

