//
//  OSSP asgui - Accounting system graphical user interface
//  Copyright (c) 2002-2003 The OSSP Project (http://www.ossp.org/)
//  Copyright (c) 2002-2003 Cable & Wireless Deutschland (http://www.cw.com/de/)
//  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
//  Copyright (c) 2002-2003 Michael Schloh von Bennewitz <michael@schloh.com>
//
//  This file is part of OSSP asgui, an accounting system graphical user
//  interface which can be found at http://www.ossp.org/pkg/tool/asgui/.
//
//  Permission to use, copy, modify, and distribute this software for
//  any purpose with or without fee is hereby granted, provided that
//  the above copyright notice and this permission notice appear in all
//  copies.
//
//  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
//  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
//  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
//  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
//  SUCH DAMAGE.
//
//  as_reportpanel.h: ISO C++ interface
//

#ifndef REPORTPANEL_H
#define REPORTPANEL_H

#include <qvariant.h>
#include <qdialog.h>
#include <qdatetime.h>


class TiTable;
class Preferences;
class QVBoxLayout;
class QHBoxLayout;
class QGridLayout;
class QGroupBox;
class QPushButton;
class QTextEdit;
class QToolButton;

class Reportpanel : public QDialog
{
    Q_OBJECT

public:
    Reportpanel(TiTable *pTable, Preferences *pPreferences,
                QWidget *pParent = 0, const char *kszName = 0,
                bool bModal = true, WFlags Flags = 0);
//    ~Reportpanel(void); // No need to destroy widgets, because qt does it for us

public:
    QGroupBox    *m_pGroupbox;
    QToolButton  *m_pWeeklybutt;
    QToolButton  *m_pMonthlybutt;
    QToolButton  *m_pBothbutt;
    QTextEdit    *m_pBrowser;
    QPushButton  *m_pSavebutt;
    QPushButton  *m_pDismissbutt;

protected:
    QVBoxLayout *m_pFormlay;
    QVBoxLayout *m_pGrouplay;
    QHBoxLayout *m_pToolay;
    QHBoxLayout *m_pPushlay;

private:
    TiTable     *m_pReptable;
    Preferences *m_pReprefs;

protected slots:
    virtual void saveReport(void);
    virtual void textChange(void);
    virtual void reportWeeks(int nWeeks = 1);
    virtual void reportMonths(int nMonths = 1);

private:
    void writeHeader(void);
    QString getWeek(QDate Refer = QDate::currentDate());
    QString getMonth(QDate Refer = QDate::currentDate());
};

#endif // REPORTPANEL_H
