//
//  OSSP asgui - Accounting system graphical user interface
//  Copyright (c) 2002-2003 The OSSP Project (http://www.ossp.org/)
//  Copyright (c) 2002-2003 Cable & Wireless Deutschland (http://www.cw.com/de/)
//  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
//  Copyright (c) 2002-2003 Michael Schloh von Bennewitz <michael@schloh.com>
//
//  This file is part of OSSP asgui, an accounting system graphical user
//  interface which can be found at http://www.ossp.org/pkg/tool/asgui/.
//
//  Permission to use, copy, modify, and distribute this software for
//  any purpose with or without fee is hereby granted, provided that
//  the above copyright notice and this permission notice appear in all
//  copies.
//
//  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
//  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
//  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
//  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
//  SUCH DAMAGE.
//
//  as_panel.cpp: ISO C++ implementation
//

#include <vector>

#include "as_panel.h"
#include "as_generic.h"
#include "as_const.h"


//
// Constructs a Prefpanel as a child of 'pParent', with the 
// name 'kszName' and widget flags set to 'Flags'.
//
// The dialog will by default be modeless, unless you set 'bModal' to
// true to construct a modal dialog.
//
Prefpanel::Prefpanel(QWidget *pParent, const char *kszName, bool bModal, WFlags Flags)
    : QDialog(pParent, kszName, bModal, Flags)
{
    if (!kszName)
        this->setName("Prefpanel");

    setSizeGripEnabled(false);
    setSizePolicy(QSizePolicy((QSizePolicy::SizeType)5,
        (QSizePolicy::SizeType)5, 0, 0, sizePolicy().hasHeightForWidth()));

    m_pVlayout = new QVBoxLayout(this, 11, 6, "Formlayout");
    m_pTabselect = new QTabWidget(this, "Tabselector");

    // Start of style chooser UI pieces
    m_pBoolpage = new QWidget(m_pTabselect, "Tabpage");
    m_pBoolayout = new QHBoxLayout(m_pBoolpage, 11, 6, "Genlayout"); 
    m_pStylegroup = new QButtonGroup(m_pBoolpage, "Stylebuttongroup");
    m_pStylegroup->setColumnLayout(0, Qt::Vertical);
    m_pStylegroup->layout()->setSpacing(6);
    m_pStylegroup->layout()->setMargin(11);
    m_pStylegroup->setExclusive(true);
    m_pBoolayout->addWidget(m_pStylegroup);

    m_pStylelay = new QVBoxLayout(m_pStylegroup->layout());
    m_pStylelay->setAlignment(Qt::AlignTop);

    // Block to handle a vector of radio buttons
    int nIter = 0;
    QStringList Styles = QStyleFactory::keys();
    std::vector<QRadioButton *> Stylevector(Styles.size());

    // Discover which interface styles are available, and
    // dynamically construct new radio buttons to represent them
    for (QStringList::Iterator Stylename = Styles.begin();
        Stylename != Styles.end(); Stylename++) {
        Stylevector[nIter] = new QRadioButton(m_pStylegroup, *Stylename + "_button");
        Stylevector[nIter]->setText(tr(*Stylename, "Comment for " + *Stylename));
        Stylevector[nIter]->setSizePolicy(QSizePolicy::Minimum, QSizePolicy::Expanding,
            Stylevector[nIter]->sizePolicy().hasHeightForWidth());
        QToolTip::add(Stylevector[nIter], tr("The " + *Stylename + " style",
            "Comment for toolTip " + *Stylename));
        QWhatsThis::add(Stylevector[nIter], tr("Click this button to enjoy the style of the "
            + *Stylename + " user interface", "Comment whatsThis for " + *Stylename));
        m_pStylelay->addWidget(Stylevector[nIter]);
        nIter++;
    }

    // Start of binary option UI pieces (like make backups, yes or no)
    m_pSwitchgroup = new QButtonGroup(m_pBoolpage, "Switchbuttongroup");
    m_pSwitchgroup->setColumnLayout(0, Qt::Vertical);
    m_pSwitchgroup->layout()->setSpacing(6);
    m_pSwitchgroup->layout()->setMargin(11);
    m_pSwitchgroup->setExclusive(false);
    m_pSwitchlay = new QVBoxLayout(m_pSwitchgroup->layout());
    m_pSwitchlay->setAlignment(Qt::AlignTop);

    // Optional file backups with hard coded extension .bak
    m_pBackupcheck = new QCheckBox(m_pSwitchgroup, "Backupbutton");
    m_pBackupcheck->setText(tr("Leave a .bak file", "Comment for Backupcheck"));
    QToolTip::add(m_pBackupcheck, tr("Will make a .bak file when saving", "Comment for toolTip Backupcheck"));
    QWhatsThis::add(m_pBackupcheck, tr("Check this box to enable automatic file backups when overwriting an existing file", "Comment whatsThis for Backupcheck"));
    m_pSwitchlay->addWidget(m_pBackupcheck);

    // Optional easy filename appending with hard coded extension .as
    m_pExtendcheck = new QCheckBox(m_pSwitchgroup, "Extensionbutton");
    m_pExtendcheck->setText(tr("Append .as extension", "Comment for Extensioncheck"));
    QToolTip::add(m_pExtendcheck, tr("Use the .as file extension", "Comment for toolTip Extensioncheck"));
    QWhatsThis::add(m_pExtendcheck, tr("Check this box to automatically append '.as' to new filenames when saving", "Comment whatsThis for Extensioncheck"));
    m_pSwitchlay->addWidget(m_pExtendcheck);

    m_pBoolayout->addWidget(m_pSwitchgroup);
    m_pTabselect->insertTab(m_pBoolpage, "");

    // Start of paths page UI pieces
    m_pGeneralpage = new QWidget(m_pTabselect, "Generalpage");
    m_pGenlayout = new QHBoxLayout(m_pGeneralpage, 11, 6, "Genlayout");
    m_pGenbox = new QGroupBox(m_pGeneralpage, "Groupboxlayout");

    m_pGenbox->setColumnLayout(0, Qt::Vertical);
    m_pGenbox->layout()->setSpacing(6);
    m_pGenbox->layout()->setMargin(11);
    m_pGenboxlay = new QHBoxLayout(m_pGenbox->layout());
    m_pGenboxlay->setAlignment(Qt::AlignTop);

    // Start of path text entry preferences UI pieces
    m_pGeninner = new QGridLayout(0, 4, 2, 0, 16, "Innergrid");
    m_pAcctlabel = new QLabel(m_pGenbox, "Accfilelabel");
    m_pGeninner->addWidget(m_pAcctlabel, 0, 0);
    m_pAcctline = new QLineEdit(m_pGenbox, "Accountline");
    m_pGeninner->addWidget(m_pAcctline, 0, 1);
    m_pEventlabel = new QLabel(m_pGenbox, "Evntfilelabel");
    m_pGeninner->addWidget(m_pEventlabel, 1, 0);
    m_pEventline = new QLineEdit(m_pGenbox, "Eventline");
    m_pGeninner->addWidget(m_pEventline, 1, 1);
    m_pUserlabel = new QLabel(m_pGenbox, "Userlabel");
    m_pGeninner->addWidget(m_pUserlabel, 2, 0);
    m_pUserline = new QLineEdit(m_pGenbox, "Userline");
    m_pGeninner->addWidget(m_pUserline, 2, 1);
    m_pHomelabel = new QLabel(m_pGenbox, "Homelabel");
    m_pGeninner->addWidget(m_pHomelabel, 3, 0);
    m_pHomeline = new QLineEdit(m_pGenbox, "Homeline");
    m_pGeninner->addWidget(m_pHomeline, 3, 1);
    m_pGenboxlay->addLayout(m_pGeninner);

    m_pGenlayout->addWidget(m_pGenbox);
    m_pTabselect->insertTab(m_pGeneralpage, "");

    // Start of remote page UI pieces
    m_pRemotepage = new QWidget(m_pTabselect, "Remotepage");
    m_pRemlayout = new QHBoxLayout(m_pRemotepage, 11, 6, "Remlayout");
    m_pRembox = new QGroupBox(m_pRemotepage, "Remoteboxlayout");

    m_pRembox->setColumnLayout(0, Qt::Vertical);
    m_pRembox->layout()->setSpacing(6);
    m_pRembox->layout()->setMargin(11);
    m_pRemboxlay = new QHBoxLayout(m_pRembox->layout());
    m_pRemboxlay->setAlignment(Qt::AlignTop);

    // Start of RPC preferences UI pieces
    m_pReminner = new QGridLayout(0, 5, 2, 0, 12, "Innergrid");
    m_pCorbalabel = new QLabel(m_pRembox, "Corbalabel");
    m_pReminner->addWidget(m_pCorbalabel, 0, 0);
    m_pCorbaline = new QLineEdit(m_pRembox, "Corbaline");
    m_pReminner->addWidget(m_pCorbaline, 0, 1);
    m_pCorbacheck = new QCheckBox(m_pRembox, "Corbacheckbox");
    m_pReminner->addWidget(m_pCorbacheck, 1, 1);
    QSpacerItem *Spacey = new QSpacerItem(6, 12, QSizePolicy::Minimum, QSizePolicy::Minimum);
    m_pReminner->addItem(Spacey, 2, 0);
    m_pSoaplabel = new QLabel(m_pRembox, "Soaplabel");
    m_pReminner->addWidget(m_pSoaplabel, 3, 0);
    m_pSoapline = new QLineEdit(m_pRembox, "Soapline");
    m_pReminner->addWidget(m_pSoapline, 3, 1);
    m_pSoapcheck = new QCheckBox(m_pRembox, "Corbacheckbox");
    m_pReminner->addWidget(m_pSoapcheck, 4, 1);
    m_pRemboxlay->addLayout(m_pReminner);

    m_pRemlayout->addWidget(m_pRembox);
    m_pTabselect->insertTab(m_pRemotepage, "");

    // Finally add the damn pages to the tab selector widget!
    m_pVlayout->addWidget(m_pTabselect);

    // Start of bottom buttons for aknowlegement and commital of changes
    m_pButtlay = new QHBoxLayout(0, 0, 12, "Buttonlayout");
    m_pOkaybutton = new QPushButton(this, "Okaybutton");
    m_pOkaybutton->setMinimumWidth(120);
    m_pOkaybutton->setPaletteBackgroundColor(QColor(202, 194, 182));
    m_pOkaybutton->setCursor(QCursor(13));
    m_pButtlay->addWidget(m_pOkaybutton);
    m_pApplybutton = new QPushButton(this, "Applybutton");
    m_pApplybutton->setMinimumWidth(120);
    m_pApplybutton->setPaletteBackgroundColor(QColor(198, 196, 186));
    m_pApplybutton->setCursor(QCursor(13));
    m_pButtlay->addWidget(m_pApplybutton);
//    QSpacerItem *Spacey = new QSpacerItem(20, 20, QSizePolicy::Expanding, QSizePolicy::Minimum);
//    m_pButtlay->addItem(Spacey);
    m_pCancelbutton = new QPushButton(this, "Cancelbutton");
    m_pCancelbutton->setMinimumWidth(120);
    m_pCancelbutton->setPaletteBackgroundColor(QColor(198, 196, 186));
    m_pCancelbutton->setCursor(QCursor(13));
    m_pButtlay->addWidget(m_pCancelbutton);
    m_pCancelbutton->setDefault(true);
    m_pVlayout->addLayout(m_pButtlay);

    // Connect our signals to slots, accept() and reject() are Qt implicit
    connect(m_pOkaybutton, SIGNAL(clicked()), this, SLOT(accept()));
    connect(m_pApplybutton, SIGNAL(clicked()), this, SLOT(apply()));
    connect(m_pCancelbutton, SIGNAL(clicked()), this, SLOT(reject()));
    connect(m_pCorbacheck, SIGNAL(toggled(bool)), this, SLOT(enableCorba(bool)));
    connect(m_pSoapcheck, SIGNAL(toggled(bool)), this, SLOT(enableSoap(bool)));
    this->textChange();
    this->resize(QSize(400, 264).expandedTo(minimumSizeHint()));
}

//
// Sets the strings of the subwidgets using the current language
//
void Prefpanel::textChange()
{
    this->setCaption(tr("AS Applicate Preferences", "Personal preferences are persistent across sessions"));

    m_pTabselect->changeTab(m_pBoolpage, tr("General"));
    m_pTabselect->changeTab(m_pGeneralpage, tr("Paths"));
    m_pTabselect->changeTab(m_pRemotepage, tr("Remote"));

    m_pOkaybutton->setText(tr("Okay", "Comment for Okaybutton"));
    QToolTip::add(m_pOkaybutton, tr("Applies and saves changes", "Comment for tooltip Okaybutton"));
    QWhatsThis::add(m_pOkaybutton, tr("The okay button applies and saves changes", "Comment for whatsThis Okaybutton"));

    m_pApplybutton->setText(tr("Apply", "Comment for Applybutton"));
    QToolTip::add(m_pApplybutton, tr("Apply changes immediately", "Comment for toolTip Applybutton"));
    QWhatsThis::add(m_pApplybutton, tr("The apply button applies changes immediately", "Comment for whatsThis Applybutton"));

    m_pCancelbutton->setText(tr("Cancel", "Comment for Cancelbutton"));
    QToolTip::add(m_pCancelbutton, tr("Cancel any changes", "Comment for toolTip Cancelbutton"));
    QWhatsThis::add(m_pCancelbutton, tr("The cancel button cancels any changes", "Comment for whatsThis Cancelbutton"));

    m_pGenbox->setTitle(tr("File and directory paths", "Comment for Genbox"));
    m_pAcctlabel->setText(tr("Accounts path", "Comment for Acctlabel"));
    m_pEventlabel->setText(tr("Events path", "Comment for Eventlabel"));
    m_pUserlabel->setText(tr("User name", "Comment for Userlabel"));
    m_pHomelabel->setText(tr("Home directory", "Comment for Homelabel"));
    QToolTip::add(m_pAcctline, tr("The accounts file pathname", "Comment for toolTip Acctline"));
    QToolTip::add(m_pEventline, tr("The events file pathname", "Comment for toolTip Eventline"));
    QToolTip::add(m_pUserline, tr("The user name", "Comment for toolTip Userline"));
    QToolTip::add(m_pHomeline, tr("The home directory", "Comment for toolTip Homeline"));

    m_pRembox->setTitle(tr("Remote host names", "Comment for Genbox"));
    m_pCorbalabel->setText(tr("CORBA host", "Comment for Corbalabel"));
    m_pSoaplabel->setText(tr("SOAP host", "Comment for Soaplabel"));
    QToolTip::add(m_pCorbaline, tr("The CORBA host name", "Comment for toolTip Corbaline"));
    QToolTip::add(m_pSoapline, tr("The SOAP host name", "Comment for toolTip Soapline"));

    m_pCorbacheck->setText(tr("Enable IIOP transmission", "Comment for Corbacheck"));
    QToolTip::add(m_pCorbacheck, tr("Will enable transmission over IIOP", "Comment for toolTip Corbacheck"));
    QWhatsThis::add(m_pCorbacheck, tr("Check this box to enable transmission to a CORBA host", "Comment whatsThis for Corbacheck"));

    m_pSoapcheck->setText(tr("Enable SOAP transmission", "Comment for Soapcheck"));
    QToolTip::add(m_pSoapcheck, tr("Will enable transmission over SOAP", "Comment for toolTip Soapcheck"));
    QWhatsThis::add(m_pSoapcheck, tr("Check this box to enable transmission over to a SOAP host", "Comment whatsThis for Soapcheck"));

    m_pStylegroup->setTitle(tr("Available styles", "Comment for Stylebuttons"));
//    QToolTip::add(m_pStylegroup, tr("Tooltip for Stylebutton", "Comment for toolTip Stylebutton"));
//    QWhatsThis::add(m_pStylegroup, tr("Whatsthis for Stylebutton", "Comment for whatsThis Stylebuttons"));

    m_pSwitchgroup->setTitle(tr("Other options", "Comment for Switchbox"));
//    QToolTip::add(m_pSwitchgroup, tr("Tooltip for Switchbox", "Comment for toolTip Switchbox"));
//    QWhatsThis::add(m_pSwitchgroup, tr("Whatsthis for Switchbutton", "Comment for whatsThis Switchbox"));
}

//
// Applies changes user selected from this class
//
void Prefpanel::apply(void)
{
    Prototype Unimp;
    Unimp.doMbox();
}
