//
//  OSSP asgui - Accounting system graphical user interface
//  Copyright (c) 2002-2003 The OSSP Project (http://www.ossp.org/)
//  Copyright (c) 2002-2003 Cable & Wireless Deutschland (http://www.cw.com/de/)
//  Copyright (c) 2002-2003 Ralf S. Engelschall <rse@engelschall.com>
//  Copyright (c) 2002-2003 Michael Schloh von Bennewitz <michael@schloh.com>
//
//  This file is part of OSSP asgui, an accounting system graphical user
//  interface which can be found at http://www.ossp.org/pkg/tool/asgui/.
//
//  Permission to use, copy, modify, and distribute this software for
//  any purpose with or without fee is hereby granted, provided that
//  the above copyright notice and this permission notice appear in all
//  copies.
//
//  THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
//  WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
//  MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
//  IN NO EVENT SHALL THE AUTHORS AND COPYRIGHT HOLDERS AND THEIR
//  CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
//  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
//  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
//  USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
//  ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
//  OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
//  OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
//  SUCH DAMAGE.
//
//  titconst.h: ISO C++ interface
//

#ifndef TITCONST_H
#define TITCONST_H


// General preferences
#define TITRAQ_PREFNAME         ".asgui"
#define TITRAQ_APPTITLE         "AS Gui"
#define TITRAQ_STR_ID           "OSSPASGUI"                         /* APPID */
#define TITRAQ_UID_ID           0x84fae747e1a64016bf049e98bbc4bd96  /* UUID */
#define TITRAQ_PREFVER          "0.5"
#define TITRAQ_PREFHOME         "homedir"
#define TITRAQ_DEFHOME          "."
#define TITRAQ_PREFUSER         "user"
#define TITRAQ_DEFUSER          "username"
#define TITRAQ_PREFASFILE       "asfile"
#define TITRAQ_DEFASFILE        "/e/dev/as"
#define TITRAQ_PREFACCOUNTS     "accounts"
#define TITRAQ_DEFACCOUNTS      "/e/dev/as/accounts.txt"
#define TITRAQ_PREFSTYLE        "uistyle"
#define TITRAQ_PREFVIEW         "view"
#define TITRAQ_DEFVIEW          "normal"
#define TITRAQ_PREFREMOTELOG    "logremote"
#define TITRAQ_DEFREMOTELOG     "no"
#define TITRAQ_PREFLOCALLOG     "loglocal"
#define TITRAQ_DEFLOCALLOG      "no"

// Column show preferences
#define TITRAQ_PREFSTATCOLON    "statcolshow"
#define TITRAQ_DEFSTATCOLON     true
#define TITRAQ_PREFLCOLON       "linecolshow"
#define TITRAQ_DEFLCOLON        false
#define TITRAQ_PREFUCOLON       "usercolshow"
#define TITRAQ_DEFUCOLON        false
#define TITRAQ_PREFGCOLON       "guidcolshow"
#define TITRAQ_DEFGCOLON        false
#define TITRAQ_PREFCCOLON       "crccolshow"
#define TITRAQ_DEFCCOLON        false
#define TITRAQ_PREFREVCOLON     "revcolshow"
#define TITRAQ_DEFREVCOLON      false
#define TITRAQ_PREFDCOLON       "datecolshow"
#define TITRAQ_DEFDCOLON        true
#define TITRAQ_PREFSTARTCOLON   "startcolshow"
#define TITRAQ_DEFSTARTCOLON    false
#define TITRAQ_PREFFCOLON       "finishcolshow"
#define TITRAQ_DEFFCOLON        false
#define TITRAQ_PREFACOLON       "amountcolshow"
#define TITRAQ_DEFACOLON        true
#define TITRAQ_PREFTCOLON       "taskcolshow"
#define TITRAQ_DEFTCOLON        true
#define TITRAQ_PREFREMCOLON     "remarkcolshow"
#define TITRAQ_DEFREMCOLON      true

// Frame geometry preferences
#define TITRAQ_PREFFRAMELAY     "framelayout"
#define TITRAQ_PREFFRAMEWIDTH   "framewidth"
#define TITRAQ_DEFFRAMEWIDTH    640
#define TITRAQ_PREFFRAMEHEIGHT  "frameheight"
#define TITRAQ_DEFFRAMEHEIGHT   400

// Column width preferences
#define TITRAQ_PREFSTATCOLWIDTH   "statcolwidth"
#define TITRAQ_DEFSTATCOLWIDTH    24
#define TITRAQ_PREFLCOLWIDTH      "linecolwidth"
#define TITRAQ_DEFLCOLWIDTH       32
#define TITRAQ_PREFUCOLWIDTH      "usercolwidth"
#define TITRAQ_DEFUCOLWIDTH       32
#define TITRAQ_PREFGCOLWIDTH      "guidcolwidth"
#define TITRAQ_DEFGCOLWIDTH       36
#define TITRAQ_PREFCCOLWIDTH      "crccolwidth"
#define TITRAQ_DEFCCOLWIDTH       32
#define TITRAQ_PREFREVCOLWIDTH    "revcolwidth"
#define TITRAQ_DEFREVCOLWIDTH     32
#define TITRAQ_PREFDCOLWIDTH      "datecolwidth"
#define TITRAQ_DEFDCOLWIDTH       94
#define TITRAQ_PREFSTARTCOLWIDTH  "startcolwidth"
#define TITRAQ_DEFSTARTCOLWIDTH   80
#define TITRAQ_PREFFCOLWIDTH      "finishcolwidth"
#define TITRAQ_DEFFCOLWIDTH       80
#define TITRAQ_PREFACOLWIDTH      "amountcolwidth"
#define TITRAQ_DEFACOLWIDTH       98
#define TITRAQ_PREFTCOLWIDTH      "taskcolwidth"
#define TITRAQ_DEFTCOLWIDTH       96
#define TITRAQ_PREFREMCOLWIDTH    "remarkcolwidth"
#define TITRAQ_DEFREMCOLWIDTH     120

// Column appearance preferences
#define TITRAQ_PREFFILEBAR      "filetoolbar"
#define TITRAQ_DEFFILEBAR       true
#define TITRAQ_PREFEDITBAR      "edittoolbar"
#define TITRAQ_DEFEDITBAR       true
#define TITRAQ_PREFVIEWBAR      "viewtoolbar"
#define TITRAQ_DEFVIEWBAR       true
#define TITRAQ_PREFWHATBAR      "whattoolbar"
#define TITRAQ_DEFWHATBAR       true

// Other value preferences
#define TITRAQ_PREFSORTCOL      "sortordering"
#define TITRAQ_DEFSORTCOL       TITRAQ_IDXDATE
#define TITRAQ_PREFSORTDIR      "sortascending"
#define TITRAQ_DEFSORTDIR       true

// Other string constants
#define TITRAQ_DATEZERO         "0000-00-00"
#define TITRAQ_SEPARATORTOK     " "
#define TITRAQ_SAVEFIRST        "The timesheet contains unsaved changes\nDo you want to save the changes or discard them?"
#define TITRAQ_OVERWRITE        "A file already exists with the chosen name\nDo you want to overwrite it with new data?"

// Indexes of table columns
#define TITRAQ_IDXALLCTRLS     -1
#define TITRAQ_IDXSTATUS        0
#define TITRAQ_IDXLINE          1
#define TITRAQ_IDXUSER          2
#define TITRAQ_IDXGUID          3
#define TITRAQ_IDXCRC           4
#define TITRAQ_IDXREV           5
#define TITRAQ_IDXDATE          6
#define TITRAQ_IDXSTART         7
#define TITRAQ_IDXFINISH        8
#define TITRAQ_IDXAMOUNT        9
#define TITRAQ_IDXTASK          10
#define TITRAQ_IDXREMARK        11
#define TITRAQ_IDXTAIL          12

// Indexes of col popup menu items
#define TITRAQ_IDXSTATCOL       1
#define TITRAQ_IDXLCOL          2
#define TITRAQ_IDXUCOL          3
#define TITRAQ_IDXGCOL          4
#define TITRAQ_IDXCCOL          5
#define TITRAQ_IDXREVCOL        6
#define TITRAQ_IDXDCOL          7
#define TITRAQ_IDXSTARTCOL      8
#define TITRAQ_IDXFCOL          9
#define TITRAQ_IDXACOL          10
#define TITRAQ_IDXTCOL          11
#define TITRAQ_IDXREMCOL        12

// Indexes of popup menu submenus
#define TITRAQ_IDXFILEBAR       1
#define TITRAQ_IDXEDITBAR       2
#define TITRAQ_IDXVIEWBAR       3
#define TITRAQ_IDXWHATBAR       4

// Indexes of character tokens in strings
#define TITRAQ_IDXSTATERROR     0
#define TITRAQ_IDXSTATCOLOR     1

// Values
#define TITRAQ_MARGIN           10          // Default layout margin
#define TITRAQ_SPACING          6           // Default layout spacing
#define TITRAQ_NUMBLOCKS        32          // Block size of a timesheet
#define TITRAQ_MAXAMOUNT        960         // Maximum valid amount
#define TITRAQ_MINAMOUNT        0           // Minimum valid amount
#define TITRAQ_STEPAMOUNT       15          // Line step interval
#define TITRAQ_MINSINHOUR       60          // Only idiots don't know this
#define TITRAQ_BRIGHT           'H'         // For coloring rows
#define TITRAQ_DARK             'D'         // For coloring rows

#endif // TITCONST_H
