/*
 * as_uuidgen.h -- public header file for uuids
 * 
 * Copyright (C) 1996, 1997 Theodore Ts'o.
 *
 * %Begin-Header%
 * This file may be redistributed under the terms of the GNU 
 * Library General Public License.
 * %End-Header%
 */

#ifndef AS_UUIDGEN_H
#define AS_UUIDGEN_H

/* Include whatever autoconf found */
#ifdef HAVE_CONFIG_H
#include "ac_config.h"
#endif

#ifdef TIME_WITH_SYS_TIME
    #include <sys/time.h>
    #include <time.h>
#else
    #if HAVE_SYS_TIME_H
        #include <sys/time.h>
    #else
        #include <time.h>
    #endif /* HAVE_SYS_TIME_H */
#endif /* TIME_WITH_SYS_TIME */


/* For fixed length UUID fields */
#if (4 == 2)
typedef unsigned int    __u16;
#elif (2 == 2)
typedef unsigned short  __u16;
#else
  ?==error: undefined 16 bit type
#endif

#if (4 == 4)
typedef unsigned int    __u32;
#elif (4 == 4)
typedef unsigned long   __u32;
#elif (2 == 4)
typedef unsigned short  __u32;
#else
 ?== error: undefined 32 bit type
#endif

typedef unsigned char __u8;
typedef unsigned char uuid_t[16];

/* Our atomic type */
struct uuid {
    __u32    time_low;
    __u16    time_mid;
    __u16    time_hi_and_version;
    __u16    clock_seq;
    __u8     node[6];
};

/* UUID Variant definitions */
#define UUID_VARIANT_NCS        0
#define UUID_VARIANT_DCE        1
#define UUID_VARIANT_MICROSOFT  2
#define UUID_VARIANT_OTHER      3

/* Offset between 15-Oct-1582 and 1-Jan-70 */
#define TIME_OFFSET_HIGH 0x01B21DD2
#define TIME_OFFSET_LOW  0x13814000

#ifdef __cplusplus
extern "C" {
#endif

/* Public interface */
void   uuid_generate(uuid_t out);                           /* uuid_gen.c   */
void   uuid_generate_random(uuid_t out);                    /* uuid_gen.c   */
void   uuid_generate_time(uuid_t out);                      /* uuid_gen.c   */
time_t uuid_time(const uuid_t uu, struct timeval *ret_tv);  /* uuid_time.c  */
int    uuid_type(const uuid_t uu);                          /* uuid_time.c  */
int    uuid_variant(const uuid_t uu);                       /* uuid_time.c  */
int    uuid_parse(const char *in, uuid_t uu);               /* uuid_proc.c  */
void   uuid_unparse(const uuid_t uu, char *out);            /* uuid_proc.c  */

/* Private interface */
void   uuid_pack(const struct uuid *uu, uuid_t ptr);        /* uuid_proc.c  */
void   uuid_unpack(const uuid_t in, struct uuid *uu);       /* uuid_proc.c  */

#ifdef __cplusplus
}
#endif

#endif /* AS_UUIDGEN_H */
