/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.utilities;

import org.openide.ErrorManager;
import org.openide.util.RequestProcessor;

public final class ProfilerUtils {
    private static RequestProcessor profilerRequestProcessor;
    private static ErrorManager profilerErrorManager;

    public static synchronized RequestProcessor getProfilerRequestProcessor() {
        if (profilerRequestProcessor == null) {
            profilerRequestProcessor = new RequestProcessor("Profiler Request Processor", 1);
        }
        return profilerRequestProcessor;
    }

    public static synchronized ErrorManager getProfilerErrorManager() {
        if (profilerErrorManager == null) {
            profilerErrorManager = ErrorManager.getDefault().getInstance("org.graalvm.visualvm.lib.profiler");
        }
        return profilerErrorManager;
    }

    public static void runInProfilerRequestProcessor(Runnable r) {
        ProfilerUtils.getProfilerRequestProcessor().post(r);
    }

    public static void runInProfilerRequestProcessor(Runnable r, int delay) {
        ProfilerUtils.getProfilerRequestProcessor().post(r, delay);
    }
}

