/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.gui;

import java.util.ArrayList;
import java.util.List;
import org.pentaho.di.job.JobEntryResult;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entry.JobEntryCopy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobTracker {
    private List<JobTracker> jobTrackers;
    private JobEntryResult result;
    private JobTracker parentJobTracker;
    private String jobName;
    private String jobFilename;

    public JobTracker(JobMeta jobMeta) {
        this.jobName = jobMeta.getName();
        this.jobFilename = jobMeta.getFilename();
        this.jobTrackers = new ArrayList<JobTracker>();
    }

    public JobTracker(JobMeta jobMeta, JobEntryResult result) {
        this(jobMeta);
        this.result = result;
    }

    public void addJobTracker(JobTracker jobTracker) {
        this.jobTrackers.add(jobTracker);
    }

    public JobTracker getJobTracker(int i) {
        return this.jobTrackers.get(i);
    }

    public int nrJobTrackers() {
        return this.jobTrackers.size();
    }

    public List<JobTracker> getJobTrackers() {
        return this.jobTrackers;
    }

    public void setJobTrackers(List<JobTracker> jobTrackers) {
        this.jobTrackers = jobTrackers;
    }

    public JobEntryResult getJobEntryResult() {
        return this.result;
    }

    public void setJobEntryResult(JobEntryResult result) {
        this.result = result;
    }

    public void clear() {
        this.jobTrackers.clear();
        this.result = null;
    }

    public JobTracker findJobTracker(JobEntryCopy jobEntryCopy) {
        for (int i = 0; i < this.jobTrackers.size(); ++i) {
            JobEntryCopy jobEntry;
            JobTracker tracker = this.getJobTracker(i);
            JobEntryResult result = tracker.getJobEntryResult();
            if (result == null || (jobEntry = result.getJobEntry()) == null || !jobEntry.equals(jobEntryCopy)) continue;
            return tracker;
        }
        return null;
    }

    public JobTracker getParentJobTracker() {
        return this.parentJobTracker;
    }

    public void setParentJobTracker(JobTracker parentJobTracker) {
        this.parentJobTracker = parentJobTracker;
    }

    public int getTotalNumberOfItems() {
        int total = 1;
        for (int i = 0; i < this.nrJobTrackers(); ++i) {
            total += this.getJobTracker(i).getTotalNumberOfItems();
        }
        return total;
    }

    public String getJobFilename() {
        return this.jobFilename;
    }

    public void setJobFilename(String jobFilename) {
        this.jobFilename = jobFilename;
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }
}

