# Generated by ffi_gen. Please do not change this file by hand.

require 'ffi'

module RLTK::CG::Bindings
  extend FFI::Library
  ffi_lib 'LLVM-3.4'

  def self.attach_function(name, *_)
    begin; super; rescue FFI::NotFoundError => e
      (class << self; self; end).class_eval { define_method(name) { |*_| raise e } }
    end
  end

  DISASSEMBLER_VARIANT_KIND_NONE = 0

  DISASSEMBLER_VARIANT_KIND_ARM_HI16 = 1

  DISASSEMBLER_VARIANT_KIND_ARM_LO16 = 2

  DISASSEMBLER_REFERENCE_TYPE_IN_OUT_NONE = 0

  DISASSEMBLER_REFERENCE_TYPE_IN_BRANCH = 1

  DISASSEMBLER_REFERENCE_TYPE_IN_P_CREL_LOAD = 2

  DISASSEMBLER_REFERENCE_TYPE_OUT_SYMBOL_STUB = 1

  DISASSEMBLER_REFERENCE_TYPE_OUT_LIT_POOL_SYM_ADDR = 2

  DISASSEMBLER_REFERENCE_TYPE_OUT_LIT_POOL_CSTR_ADDR = 3

  DISASSEMBLER_REFERENCE_TYPE_OUT_OBJC_CF_STRING_REF = 4

  DISASSEMBLER_REFERENCE_TYPE_OUT_OBJC_MESSAGE = 5

  DISASSEMBLER_REFERENCE_TYPE_OUT_OBJC_MESSAGE_REF = 6

  DISASSEMBLER_REFERENCE_TYPE_OUT_OBJC_SELECTOR_REF = 7

  DISASSEMBLER_REFERENCE_TYPE_OUT_OBJC_CLASS_REF = 8

  DISASSEMBLER_OPTION_USE_MARKUP = 1

  DISASSEMBLER_OPTION_PRINT_IMM_HEX = 2

  DISASSEMBLER_OPTION_ASM_PRINTER_VARIANT = 4

  DISASSEMBLER_OPTION_SET_INSTR_COMMENTS = 8

  DISASSEMBLER_OPTION_PRINT_LATENCY = 16

  # The top-level container for all LLVM global data. See the LLVMContext class.
  class OpaqueContext < FFI::Struct
    layout :dummy, :char
  end

  # The top-level container for all other LLVM Intermediate Representation (IR)
  # objects.
  #
  # @see llvm::Module
  class OpaqueModule < FFI::Struct
    layout :dummy, :char
  end

  # Each value in the LLVM IR has a type, an LLVMTypeRef.
  #
  # @see llvm::Type
  class OpaqueType < FFI::Struct
    layout :dummy, :char
  end

  # Represents an individual value in LLVM IR.
  #
  # This models llvm::Value.
  class OpaqueValue < FFI::Struct
    layout :dummy, :char
  end

  # Represents a basic block of instructions in LLVM IR.
  #
  # This models llvm::BasicBlock.
  class OpaqueBasicBlock < FFI::Struct
    layout :dummy, :char
  end

  # Represents an LLVM basic block builder.
  #
  # This models llvm::IRBuilder.
  class OpaqueBuilder < FFI::Struct
    layout :dummy, :char
  end

  # Interface used to provide a module to JIT or interpreter.
  # This is now just a synonym for llvm::Module, but we have to keep using the
  # different type to keep binary compatibility.
  class OpaqueModuleProvider < FFI::Struct
    layout :dummy, :char
  end

  # Used to provide a module to JIT or interpreter.
  #
  # @see llvm::MemoryBuffer
  class OpaqueMemoryBuffer < FFI::Struct
    layout :dummy, :char
  end

  # @see llvm::PassManagerBase
  class OpaquePassManager < FFI::Struct
    layout :dummy, :char
  end

  # @see llvm::PassRegistry
  class OpaquePassRegistry < FFI::Struct
    layout :dummy, :char
  end

  # Used to get the users and usees of a Value.
  #
  # @see llvm::Use
  class OpaqueUse < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:attribute).</em>
  #
  # === Options:
  # :z_ext_attribute ::
  #
  # :s_ext_attribute ::
  #
  # :no_return_attribute ::
  #
  # :in_reg_attribute ::
  #
  # :struct_ret_attribute ::
  #
  # :no_unwind_attribute ::
  #
  # :no_alias_attribute ::
  #
  # :by_val_attribute ::
  #
  # :nest_attribute ::
  #
  # :read_none_attribute ::
  #
  # :read_only_attribute ::
  #
  # :no_inline_attribute ::
  #
  # :always_inline_attribute ::
  #
  # :optimize_for_size_attribute ::
  #
  # :stack_protect_attribute ::
  #
  # :stack_protect_req_attribute ::
  #
  # :alignment ::
  #
  # :no_capture_attribute ::
  #
  # :no_red_zone_attribute ::
  #
  # :no_implicit_float_attribute ::
  #
  # :naked_attribute ::
  #
  # :inline_hint_attribute ::
  #
  # :stack_alignment ::
  #
  # :returns_twice ::
  #
  # :uw_table ::
  #
  #
  # @method _enum_attribute_
  # @return [Symbol]
  # @scope class
  enum :attribute, [
    :z_ext_attribute, 1,
    :s_ext_attribute, 2,
    :no_return_attribute, 4,
    :in_reg_attribute, 8,
    :struct_ret_attribute, 16,
    :no_unwind_attribute, 32,
    :no_alias_attribute, 64,
    :by_val_attribute, 128,
    :nest_attribute, 256,
    :read_none_attribute, 512,
    :read_only_attribute, 1024,
    :no_inline_attribute, 2048,
    :always_inline_attribute, 4096,
    :optimize_for_size_attribute, 8192,
    :stack_protect_attribute, 16384,
    :stack_protect_req_attribute, 32768,
    :alignment, 2031616,
    :no_capture_attribute, 2097152,
    :no_red_zone_attribute, 4194304,
    :no_implicit_float_attribute, 8388608,
    :naked_attribute, 16777216,
    :inline_hint_attribute, 33554432,
    :stack_alignment, 469762048,
    :returns_twice, 536870912,
    :uw_table, 1073741824
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:opcode).</em>
  #
  # === Options:
  # :ret ::
  #   Terminator Instructions
  # :br ::
  #
  # :switch ::
  #
  # :indirect_br ::
  #
  # :invoke ::
  #
  # :unreachable ::
  #   removed 6 due to API changes
  # :add ::
  #   Standard Binary Operators
  # :f_add ::
  #
  # :sub ::
  #
  # :f_sub ::
  #
  # :mul ::
  #
  # :f_mul ::
  #
  # :u_div ::
  #
  # :s_div ::
  #
  # :f_div ::
  #
  # :u_rem ::
  #
  # :s_rem ::
  #
  # :f_rem ::
  #
  # :shl ::
  #   Logical Operators
  # :l_shr ::
  #
  # :a_shr ::
  #
  # :and_ ::
  #
  # :or_ ::
  #
  # :xor ::
  #
  # :alloca ::
  #   Memory Operators
  # :load ::
  #
  # :store ::
  #
  # :get_element_ptr ::
  #
  # :trunc ::
  #   Cast Operators
  # :z_ext ::
  #
  # :s_ext ::
  #
  # :fp_to_ui ::
  #
  # :fp_to_si ::
  #
  # :ui_to_fp ::
  #
  # :si_to_fp ::
  #
  # :fp_trunc ::
  #
  # :fp_ext ::
  #
  # :ptr_to_int ::
  #
  # :int_to_ptr ::
  #
  # :bit_cast ::
  #
  # :addr_space_cast ::
  #
  # :i_cmp ::
  #   Other Operators
  # :f_cmp ::
  #
  # :phi ::
  #
  # :call ::
  #
  # :select ::
  #
  # :user_op1 ::
  #
  # :user_op2 ::
  #
  # :va_arg ::
  #
  # :extract_element ::
  #
  # :insert_element ::
  #
  # :shuffle_vector ::
  #
  # :extract_value ::
  #
  # :insert_value ::
  #
  # :fence ::
  #   Atomic operators
  # :atomic_cmp_xchg ::
  #
  # :atomic_rmw ::
  #
  # :resume ::
  #   Exception Handling Operators
  # :landing_pad ::
  #
  #
  # @method _enum_opcode_
  # @return [Symbol]
  # @scope class
  enum :opcode, [
    :ret, 1,
    :br, 2,
    :switch, 3,
    :indirect_br, 4,
    :invoke, 5,
    :unreachable, 7,
    :add, 8,
    :f_add, 9,
    :sub, 10,
    :f_sub, 11,
    :mul, 12,
    :f_mul, 13,
    :u_div, 14,
    :s_div, 15,
    :f_div, 16,
    :u_rem, 17,
    :s_rem, 18,
    :f_rem, 19,
    :shl, 20,
    :l_shr, 21,
    :a_shr, 22,
    :and_, 23,
    :or_, 24,
    :xor, 25,
    :alloca, 26,
    :load, 27,
    :store, 28,
    :get_element_ptr, 29,
    :trunc, 30,
    :z_ext, 31,
    :s_ext, 32,
    :fp_to_ui, 33,
    :fp_to_si, 34,
    :ui_to_fp, 35,
    :si_to_fp, 36,
    :fp_trunc, 37,
    :fp_ext, 38,
    :ptr_to_int, 39,
    :int_to_ptr, 40,
    :bit_cast, 41,
    :addr_space_cast, 60,
    :i_cmp, 42,
    :f_cmp, 43,
    :phi, 44,
    :call, 45,
    :select, 46,
    :user_op1, 47,
    :user_op2, 48,
    :va_arg, 49,
    :extract_element, 50,
    :insert_element, 51,
    :shuffle_vector, 52,
    :extract_value, 53,
    :insert_value, 54,
    :fence, 55,
    :atomic_cmp_xchg, 56,
    :atomic_rmw, 57,
    :resume, 58,
    :landing_pad, 59
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:type_kind).</em>
  #
  # === Options:
  # :void ::
  #
  # :half ::
  #   < type with no size
  # :float ::
  #   < 16 bit floating point type
  # :double ::
  #   < 32 bit floating point type
  # :x86_fp80 ::
  #   < 64 bit floating point type
  # :fp128 ::
  #   < 80 bit floating point type (X87)
  # :ppc_fp128 ::
  #   < 128 bit floating point type (112-bit mantissa)
  # :label ::
  #   < 128 bit floating point type (two 64-bits)
  # :integer ::
  #   < Labels
  # :function ::
  #   < Arbitrary bit width integers
  # :struct ::
  #   < Functions
  # :array ::
  #   < Structures
  # :pointer ::
  #   < Arrays
  # :vector ::
  #   < Pointers
  # :metadata ::
  #   < SIMD 'packed' format, or other vector type
  # :x86_mmx ::
  #   < Metadata
  #
  # @method _enum_type_kind_
  # @return [Symbol]
  # @scope class
  enum :type_kind, [
    :void, 0,
    :half, 1,
    :float, 2,
    :double, 3,
    :x86_fp80, 4,
    :fp128, 5,
    :ppc_fp128, 6,
    :label, 7,
    :integer, 8,
    :function, 9,
    :struct, 10,
    :array, 11,
    :pointer, 12,
    :vector, 13,
    :metadata, 14,
    :x86_mmx, 15
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:linkage).</em>
  #
  # === Options:
  # :external ::
  #
  # :available_externally ::
  #   < Externally visible function
  # :link_once_any ::
  #
  # :link_once_odr ::
  #   < Keep one copy of function when linking (inline)
  # :link_once_odr_auto_hide ::
  #   < Same, but only replaced by something
  #                               equivalent.
  # :weak_any ::
  #   < Obsolete
  # :weak_odr ::
  #   < Keep one copy of function when linking (weak)
  # :appending ::
  #   < Same, but only replaced by something
  #                               equivalent.
  # :internal ::
  #   < Special purpose, only applies to global arrays
  # :private ::
  #   < Rename collisions when linking (static
  #                                  functions)
  # :dll_import ::
  #   < Like Internal, but omit from symbol table
  # :dll_export ::
  #   < Function to be imported from DLL
  # :external_weak ::
  #   < Function to be accessible from DLL
  # :ghost ::
  #   < ExternalWeak linkage description
  # :common ::
  #   < Obsolete
  # :linker_private ::
  #   < Tentative definitions
  # :linker_private_weak ::
  #   < Like Private, but linker removes.
  #
  # @method _enum_linkage_
  # @return [Symbol]
  # @scope class
  enum :linkage, [
    :external, 0,
    :available_externally, 1,
    :link_once_any, 2,
    :link_once_odr, 3,
    :link_once_odr_auto_hide, 4,
    :weak_any, 5,
    :weak_odr, 6,
    :appending, 7,
    :internal, 8,
    :private, 9,
    :dll_import, 10,
    :dll_export, 11,
    :external_weak, 12,
    :ghost, 13,
    :common, 14,
    :linker_private, 15,
    :linker_private_weak, 16
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:visibility).</em>
  #
  # === Options:
  # :default ::
  #
  # :hidden ::
  #   < The GV is visible
  # :protected ::
  #   < The GV is hidden
  #
  # @method _enum_visibility_
  # @return [Symbol]
  # @scope class
  enum :visibility, [
    :default, 0,
    :hidden, 1,
    :protected, 2
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:call_conv).</em>
  #
  # === Options:
  # :c ::
  #
  # :fast ::
  #
  # :cold ::
  #
  # :web_kit_js ::
  #
  # :any_reg ::
  #
  # :x86_stdcall ::
  #
  # :x86_fastcall ::
  #
  #
  # @method _enum_call_conv_
  # @return [Symbol]
  # @scope class
  enum :call_conv, [
    :c, 0,
    :fast, 8,
    :cold, 9,
    :web_kit_js, 12,
    :any_reg, 13,
    :x86_stdcall, 64,
    :x86_fastcall, 65
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:int_predicate).</em>
  #
  # === Options:
  # :eq ::
  #
  # :ne ::
  #   < equal
  # :ugt ::
  #   < not equal
  # :uge ::
  #   < unsigned greater than
  # :ult ::
  #   < unsigned greater or equal
  # :ule ::
  #   < unsigned less than
  # :sgt ::
  #   < unsigned less or equal
  # :sge ::
  #   < signed greater than
  # :slt ::
  #   < signed greater or equal
  # :sle ::
  #   < signed less than
  #
  # @method _enum_int_predicate_
  # @return [Symbol]
  # @scope class
  enum :int_predicate, [
    :eq, 32,
    :ne, 33,
    :ugt, 34,
    :uge, 35,
    :ult, 36,
    :ule, 37,
    :sgt, 38,
    :sge, 39,
    :slt, 40,
    :sle, 41
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:real_predicate).</em>
  #
  # === Options:
  # :predicate_false ::
  #
  # :oeq ::
  #   < Always false (always folded)
  # :ogt ::
  #   < True if ordered and equal
  # :oge ::
  #   < True if ordered and greater than
  # :olt ::
  #   < True if ordered and greater than or equal
  # :ole ::
  #   < True if ordered and less than
  # :one ::
  #   < True if ordered and less than or equal
  # :ord ::
  #   < True if ordered and operands are unequal
  # :uno ::
  #   < True if ordered (no nans)
  # :ueq ::
  #   < True if unordered: isnan(X) | isnan(Y)
  # :ugt ::
  #   < True if unordered or equal
  # :uge ::
  #   < True if unordered or greater than
  # :ult ::
  #   < True if unordered, greater than, or equal
  # :ule ::
  #   < True if unordered or less than
  # :une ::
  #   < True if unordered, less than, or equal
  # :predicate_true ::
  #   < True if unordered or not equal
  #
  # @method _enum_real_predicate_
  # @return [Symbol]
  # @scope class
  enum :real_predicate, [
    :predicate_false, 0,
    :oeq, 1,
    :ogt, 2,
    :oge, 3,
    :olt, 4,
    :ole, 5,
    :one, 6,
    :ord, 7,
    :uno, 8,
    :ueq, 9,
    :ugt, 10,
    :uge, 11,
    :ult, 12,
    :ule, 13,
    :une, 14,
    :predicate_true, 15
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:landing_pad_clause_ty).</em>
  #
  # === Options:
  # :catch ::
  #
  # :filter ::
  #   < A catch clause
  #
  # @method _enum_landing_pad_clause_ty_
  # @return [Symbol]
  # @scope class
  enum :landing_pad_clause_ty, [
    :catch, 0,
    :filter, 1
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:thread_local_mode).</em>
  #
  # === Options:
  # :not_thread_local ::
  #
  # :general_dynamic_tls_model ::
  #
  # :local_dynamic_tls_model ::
  #
  # :initial_exec_tls_model ::
  #
  # :local_exec_tls_model ::
  #
  #
  # @method _enum_thread_local_mode_
  # @return [Symbol]
  # @scope class
  enum :thread_local_mode, [
    :not_thread_local, 0,
    :general_dynamic_tls_model, 1,
    :local_dynamic_tls_model, 2,
    :initial_exec_tls_model, 3,
    :local_exec_tls_model, 4
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:atomic_ordering).</em>
  #
  # === Options:
  # :not_atomic ::
  #
  # :unordered ::
  #   < A load or store which is not atomic
  # :monotonic ::
  #   < Lowest level of atomicity, guarantees
  #                                        somewhat sane results, lock free.
  # :acquire ::
  #   < guarantees that if you take all the
  #                                        operations affecting a specific address,
  #                                        a consistent ordering exists
  # :release ::
  #   < Acquire provides a barrier of the sort
  #                                      necessary to acquire a lock to access other
  #                                      memory with normal loads and stores.
  # :acquire_release ::
  #   < Release is similar to Acquire, but with
  #                                      a barrier of the sort necessary to release
  #                                      a lock.
  #
  # @method _enum_atomic_ordering_
  # @return [Symbol]
  # @scope class
  enum :atomic_ordering, [
    :not_atomic, 0,
    :unordered, 1,
    :monotonic, 2,
    :acquire, 4,
    :release, 5,
    :acquire_release, 6
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:atomic_rmw_bin_op).</em>
  #
  # === Options:
  # :xchg ::
  #
  # :add ::
  #   < Set the new value and return the one old
  # :sub ::
  #   < Add a value and return the old one
  # :and_ ::
  #   < Subtract a value and return the old one
  # :nand ::
  #   < And a value and return the old one
  # :or_ ::
  #   < Not-And a value and return the old one
  # :xor ::
  #   < OR a value and return the old one
  # :max ::
  #   < Xor a value and return the old one
  # :min ::
  #   < Sets the value if it's greater than the
  #                                original using a signed comparison and return
  #                                the old one
  # :u_max ::
  #   < Sets the value if it's Smaller than the
  #                                original using a signed comparison and return
  #                                the old one
  # :u_min ::
  #   < Sets the value if it's greater than the
  #                                original using an unsigned comparison and return
  #                                the old one
  #
  # @method _enum_atomic_rmw_bin_op_
  # @return [Symbol]
  # @scope class
  enum :atomic_rmw_bin_op, [
    :xchg, 0,
    :add, 1,
    :sub, 2,
    :and_, 3,
    :nand, 4,
    :or_, 5,
    :xor, 6,
    :max, 7,
    :min, 8,
    :u_max, 9,
    :u_min, 10
  ]

  # @}
  #
  # @method initialize_core(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_core, :LLVMInitializeCore, [OpaquePassRegistry], :void

  # Deallocate and destroy all ManagedStatic variables.
  #     @see llvm::llvm_shutdown
  #     @see ManagedStatic
  #
  # @method shutdown()
  # @return [nil]
  # @scope class
  attach_function :shutdown, :LLVMShutdown, [], :void

  # ===-- Error handling ----------------------------------------------------===
  #
  # @method create_message(message)
  # @param [String] message
  # @return [String]
  # @scope class
  attach_function :create_message, :LLVMCreateMessage, [:string], :string

  # (Not documented)
  #
  # @method dispose_message(message)
  # @param [String] message
  # @return [nil]
  # @scope class
  attach_function :dispose_message, :LLVMDisposeMessage, [:string], :void

  # Install a fatal error handler. By default, if LLVM detects a fatal error, it
  # will call exit(1). This may not be appropriate in many contexts. For example,
  # doing exit(1) will bypass many crash reporting/tracing system tools. This
  # function allows you to install a callback that will be invoked prior to the
  # call to exit(1).
  #
  # @method install_fatal_error_handler(handler)
  # @param [FFI::Pointer(FatalErrorHandler)] handler
  # @return [nil]
  # @scope class
  attach_function :install_fatal_error_handler, :LLVMInstallFatalErrorHandler, [:pointer], :void

  # Reset the fatal error handler. This resets LLVM's fatal error handling
  # behavior to the default.
  #
  # @method reset_fatal_error_handler()
  # @return [nil]
  # @scope class
  attach_function :reset_fatal_error_handler, :LLVMResetFatalErrorHandler, [], :void

  # Enable LLVM's built-in stack trace code. This intercepts the OS's crash
  # signals and prints which component of LLVM you were in at the time if the
  # crash.
  #
  # @method enable_pretty_stack_trace()
  # @return [nil]
  # @scope class
  attach_function :enable_pretty_stack_trace, :LLVMEnablePrettyStackTrace, [], :void

  # Create a new context.
  #
  # Every call to this function should be paired with a call to
  # LLVMContextDispose() or the context will leak memory.
  #
  # @method context_create()
  # @return [OpaqueContext]
  # @scope class
  attach_function :context_create, :LLVMContextCreate, [], OpaqueContext

  # Obtain the global context instance.
  #
  # @method get_global_context()
  # @return [OpaqueContext]
  # @scope class
  attach_function :get_global_context, :LLVMGetGlobalContext, [], OpaqueContext

  # Destroy a context instance.
  #
  # This should be called for every call to LLVMContextCreate() or memory
  # will be leaked.
  #
  # @method context_dispose(c)
  # @param [OpaqueContext] c
  # @return [nil]
  # @scope class
  attach_function :context_dispose, :LLVMContextDispose, [OpaqueContext], :void

  # (Not documented)
  #
  # @method get_md_kind_id_in_context(c, name, s_len)
  # @param [OpaqueContext] c
  # @param [String] name
  # @param [Integer] s_len
  # @return [Integer]
  # @scope class
  attach_function :get_md_kind_id_in_context, :LLVMGetMDKindIDInContext, [OpaqueContext, :string, :uint], :uint

  # (Not documented)
  #
  # @method get_md_kind_id(name, s_len)
  # @param [String] name
  # @param [Integer] s_len
  # @return [Integer]
  # @scope class
  attach_function :get_md_kind_id, :LLVMGetMDKindID, [:string, :uint], :uint

  # Create a new, empty module in the global context.
  #
  # This is equivalent to calling LLVMModuleCreateWithNameInContext with
  # LLVMGetGlobalContext() as the context parameter.
  #
  # Every invocation should be paired with LLVMDisposeModule() or memory
  # will be leaked.
  #
  # @method module_create_with_name(module_id)
  # @param [String] module_id
  # @return [OpaqueModule]
  # @scope class
  attach_function :module_create_with_name, :LLVMModuleCreateWithName, [:string], OpaqueModule

  # Create a new, empty module in a specific context.
  #
  # Every invocation should be paired with LLVMDisposeModule() or memory
  # will be leaked.
  #
  # @method module_create_with_name_in_context(module_id, c)
  # @param [String] module_id
  # @param [OpaqueContext] c
  # @return [OpaqueModule]
  # @scope class
  attach_function :module_create_with_name_in_context, :LLVMModuleCreateWithNameInContext, [:string, OpaqueContext], OpaqueModule

  # Destroy a module instance.
  #
  # This must be called for every created module or memory will be
  # leaked.
  #
  # @method dispose_module(m)
  # @param [OpaqueModule] m
  # @return [nil]
  # @scope class
  attach_function :dispose_module, :LLVMDisposeModule, [OpaqueModule], :void

  # Obtain the data layout for a module.
  #
  # @see Module::getDataLayout()
  #
  # @method get_data_layout(m)
  # @param [OpaqueModule] m
  # @return [String]
  # @scope class
  attach_function :get_data_layout, :LLVMGetDataLayout, [OpaqueModule], :string

  # Set the data layout for a module.
  #
  # @see Module::setDataLayout()
  #
  # @method set_data_layout(m, triple)
  # @param [OpaqueModule] m
  # @param [String] triple
  # @return [nil]
  # @scope class
  attach_function :set_data_layout, :LLVMSetDataLayout, [OpaqueModule, :string], :void

  # Obtain the target triple for a module.
  #
  # @see Module::getTargetTriple()
  #
  # @method get_target(m)
  # @param [OpaqueModule] m
  # @return [String]
  # @scope class
  attach_function :get_target, :LLVMGetTarget, [OpaqueModule], :string

  # Set the target triple for a module.
  #
  # @see Module::setTargetTriple()
  #
  # @method set_target(m, triple)
  # @param [OpaqueModule] m
  # @param [String] triple
  # @return [nil]
  # @scope class
  attach_function :set_target, :LLVMSetTarget, [OpaqueModule, :string], :void

  # Dump a representation of a module to stderr.
  #
  # @see Module::dump()
  #
  # @method dump_module(m)
  # @param [OpaqueModule] m
  # @return [nil]
  # @scope class
  attach_function :dump_module, :LLVMDumpModule, [OpaqueModule], :void

  # Print a representation of a module to a file. The ErrorMessage needs to be
  # disposed with LLVMDisposeMessage. Returns 0 on success, 1 otherwise.
  #
  # @see Module::print()
  #
  # @method print_module_to_file(m, filename, error_message)
  # @param [OpaqueModule] m
  # @param [String] filename
  # @param [FFI::Pointer(**CharS)] error_message
  # @return [Integer]
  # @scope class
  attach_function :print_module_to_file, :LLVMPrintModuleToFile, [OpaqueModule, :string, :pointer], :int

  # Return a string representation of the module. Use
  # LLVMDisposeMessage to free the string.
  #
  # @see Module::print()
  #
  # @method print_module_to_string(m)
  # @param [OpaqueModule] m
  # @return [String]
  # @scope class
  attach_function :print_module_to_string, :LLVMPrintModuleToString, [OpaqueModule], :string

  # Set inline assembly for a module.
  #
  # @see Module::setModuleInlineAsm()
  #
  # @method set_module_inline_asm(m, asm)
  # @param [OpaqueModule] m
  # @param [String] asm
  # @return [nil]
  # @scope class
  attach_function :set_module_inline_asm, :LLVMSetModuleInlineAsm, [OpaqueModule, :string], :void

  # Obtain the context to which this module is associated.
  #
  # @see Module::getContext()
  #
  # @method get_module_context(m)
  # @param [OpaqueModule] m
  # @return [OpaqueContext]
  # @scope class
  attach_function :get_module_context, :LLVMGetModuleContext, [OpaqueModule], OpaqueContext

  # Obtain a Type from a module by its registered name.
  #
  # @method get_type_by_name(m, name)
  # @param [OpaqueModule] m
  # @param [String] name
  # @return [OpaqueType]
  # @scope class
  attach_function :get_type_by_name, :LLVMGetTypeByName, [OpaqueModule, :string], OpaqueType

  # Obtain the number of operands for named metadata in a module.
  #
  # @see llvm::Module::getNamedMetadata()
  #
  # @method get_named_metadata_num_operands(m, name)
  # @param [OpaqueModule] m
  # @param [String] name
  # @return [Integer]
  # @scope class
  attach_function :get_named_metadata_num_operands, :LLVMGetNamedMetadataNumOperands, [OpaqueModule, :string], :uint

  # Obtain the named metadata operands for a module.
  #
  # The passed LLVMValueRef pointer should refer to an array of
  # LLVMValueRef at least LLVMGetNamedMetadataNumOperands long. This
  # array will be populated with the LLVMValueRef instances. Each
  # instance corresponds to a llvm::MDNode.
  #
  # @see llvm::Module::getNamedMetadata()
  # @see llvm::MDNode::getOperand()
  #
  # @method get_named_metadata_operands(m, name, dest)
  # @param [OpaqueModule] m
  # @param [String] name
  # @param [FFI::Pointer(*ValueRef)] dest
  # @return [nil]
  # @scope class
  attach_function :get_named_metadata_operands, :LLVMGetNamedMetadataOperands, [OpaqueModule, :string, :pointer], :void

  # Add an operand to named metadata.
  #
  # @see llvm::Module::getNamedMetadata()
  # @see llvm::MDNode::addOperand()
  #
  # @method add_named_metadata_operand(m, name, val)
  # @param [OpaqueModule] m
  # @param [String] name
  # @param [OpaqueValue] val
  # @return [nil]
  # @scope class
  attach_function :add_named_metadata_operand, :LLVMAddNamedMetadataOperand, [OpaqueModule, :string, OpaqueValue], :void

  # Add a function to a module under a specified name.
  #
  # @see llvm::Function::Create()
  #
  # @method add_function(m, name, function_ty)
  # @param [OpaqueModule] m
  # @param [String] name
  # @param [OpaqueType] function_ty
  # @return [OpaqueValue]
  # @scope class
  attach_function :add_function, :LLVMAddFunction, [OpaqueModule, :string, OpaqueType], OpaqueValue

  # Obtain a Function value from a Module by its name.
  #
  # The returned value corresponds to a llvm::Function value.
  #
  # @see llvm::Module::getFunction()
  #
  # @method get_named_function(m, name)
  # @param [OpaqueModule] m
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_named_function, :LLVMGetNamedFunction, [OpaqueModule, :string], OpaqueValue

  # Obtain an iterator to the first Function in a Module.
  #
  # @see llvm::Module::begin()
  #
  # @method get_first_function(m)
  # @param [OpaqueModule] m
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_first_function, :LLVMGetFirstFunction, [OpaqueModule], OpaqueValue

  # Obtain an iterator to the last Function in a Module.
  #
  # @see llvm::Module::end()
  #
  # @method get_last_function(m)
  # @param [OpaqueModule] m
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_last_function, :LLVMGetLastFunction, [OpaqueModule], OpaqueValue

  # Advance a Function iterator to the next Function.
  #
  # Returns NULL if the iterator was already at the end and there are no more
  # functions.
  #
  # @method get_next_function(fn)
  # @param [OpaqueValue] fn
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_next_function, :LLVMGetNextFunction, [OpaqueValue], OpaqueValue

  # Decrement a Function iterator to the previous Function.
  #
  # Returns NULL if the iterator was already at the beginning and there are
  # no previous functions.
  #
  # @method get_previous_function(fn)
  # @param [OpaqueValue] fn
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_previous_function, :LLVMGetPreviousFunction, [OpaqueValue], OpaqueValue

  # Obtain the enumerated type of a Type instance.
  #
  # @see llvm::Type:getTypeID()
  #
  # @method get_type_kind(ty)
  # @param [OpaqueType] ty
  # @return [Symbol from _enum_type_kind_]
  # @scope class
  attach_function :get_type_kind, :LLVMGetTypeKind, [OpaqueType], :type_kind

  # Whether the type has a known size.
  #
  # Things that don't have a size are abstract types, labels, and void.a
  #
  # @see llvm::Type::isSized()
  #
  # @method type_is_sized(ty)
  # @param [OpaqueType] ty
  # @return [Integer]
  # @scope class
  attach_function :type_is_sized, :LLVMTypeIsSized, [OpaqueType], :int

  # Obtain the context to which this type instance is associated.
  #
  # @see llvm::Type::getContext()
  #
  # @method get_type_context(ty)
  # @param [OpaqueType] ty
  # @return [OpaqueContext]
  # @scope class
  attach_function :get_type_context, :LLVMGetTypeContext, [OpaqueType], OpaqueContext

  # Dump a representation of a type to stderr.
  #
  # @see llvm::Type::dump()
  #
  # @method dump_type(val)
  # @param [OpaqueType] val
  # @return [nil]
  # @scope class
  attach_function :dump_type, :LLVMDumpType, [OpaqueType], :void

  # Return a string representation of the type. Use
  # LLVMDisposeMessage to free the string.
  #
  # @see llvm::Type::print()
  #
  # @method print_type_to_string(val)
  # @param [OpaqueType] val
  # @return [String]
  # @scope class
  attach_function :print_type_to_string, :LLVMPrintTypeToString, [OpaqueType], :string

  # Obtain an integer type from a context with specified bit width.
  #
  # @method int1_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :int1_type_in_context, :LLVMInt1TypeInContext, [OpaqueContext], OpaqueType

  # (Not documented)
  #
  # @method int8_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :int8_type_in_context, :LLVMInt8TypeInContext, [OpaqueContext], OpaqueType

  # (Not documented)
  #
  # @method int16_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :int16_type_in_context, :LLVMInt16TypeInContext, [OpaqueContext], OpaqueType

  # (Not documented)
  #
  # @method int32_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :int32_type_in_context, :LLVMInt32TypeInContext, [OpaqueContext], OpaqueType

  # (Not documented)
  #
  # @method int64_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :int64_type_in_context, :LLVMInt64TypeInContext, [OpaqueContext], OpaqueType

  # (Not documented)
  #
  # @method int_type_in_context(c, num_bits)
  # @param [OpaqueContext] c
  # @param [Integer] num_bits
  # @return [OpaqueType]
  # @scope class
  attach_function :int_type_in_context, :LLVMIntTypeInContext, [OpaqueContext, :uint], OpaqueType

  # Obtain an integer type from the global context with a specified bit
  # width.
  #
  # @method int1_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :int1_type, :LLVMInt1Type, [], OpaqueType

  # (Not documented)
  #
  # @method int8_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :int8_type, :LLVMInt8Type, [], OpaqueType

  # (Not documented)
  #
  # @method int16_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :int16_type, :LLVMInt16Type, [], OpaqueType

  # (Not documented)
  #
  # @method int32_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :int32_type, :LLVMInt32Type, [], OpaqueType

  # (Not documented)
  #
  # @method int64_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :int64_type, :LLVMInt64Type, [], OpaqueType

  # (Not documented)
  #
  # @method int_type(num_bits)
  # @param [Integer] num_bits
  # @return [OpaqueType]
  # @scope class
  attach_function :int_type, :LLVMIntType, [:uint], OpaqueType

  # (Not documented)
  #
  # @method get_int_type_width(integer_ty)
  # @param [OpaqueType] integer_ty
  # @return [Integer]
  # @scope class
  attach_function :get_int_type_width, :LLVMGetIntTypeWidth, [OpaqueType], :uint

  # Obtain a 16-bit floating point type from a context.
  #
  # @method half_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :half_type_in_context, :LLVMHalfTypeInContext, [OpaqueContext], OpaqueType

  # Obtain a 32-bit floating point type from a context.
  #
  # @method float_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :float_type_in_context, :LLVMFloatTypeInContext, [OpaqueContext], OpaqueType

  # Obtain a 64-bit floating point type from a context.
  #
  # @method double_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :double_type_in_context, :LLVMDoubleTypeInContext, [OpaqueContext], OpaqueType

  # Obtain a 80-bit floating point type (X87) from a context.
  #
  # @method x86fp80_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :x86fp80_type_in_context, :LLVMX86FP80TypeInContext, [OpaqueContext], OpaqueType

  # Obtain a 128-bit floating point type (112-bit mantissa) from a
  # context.
  #
  # @method fp128_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :fp128_type_in_context, :LLVMFP128TypeInContext, [OpaqueContext], OpaqueType

  # Obtain a 128-bit floating point type (two 64-bits) from a context.
  #
  # @method ppcfp128_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :ppcfp128_type_in_context, :LLVMPPCFP128TypeInContext, [OpaqueContext], OpaqueType

  # Obtain a floating point type from the global context.
  #
  # These map to the functions in this group of the same name.
  #
  # @method half_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :half_type, :LLVMHalfType, [], OpaqueType

  # (Not documented)
  #
  # @method float_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :float_type, :LLVMFloatType, [], OpaqueType

  # (Not documented)
  #
  # @method double_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :double_type, :LLVMDoubleType, [], OpaqueType

  # (Not documented)
  #
  # @method x86fp80_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :x86fp80_type, :LLVMX86FP80Type, [], OpaqueType

  # (Not documented)
  #
  # @method fp128_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :fp128_type, :LLVMFP128Type, [], OpaqueType

  # (Not documented)
  #
  # @method ppcfp128_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :ppcfp128_type, :LLVMPPCFP128Type, [], OpaqueType

  # Obtain a function type consisting of a specified signature.
  #
  # The function is defined as a tuple of a return Type, a list of
  # parameter types, and whether the function is variadic.
  #
  # @method function_type(return_type, param_types, param_count, is_var_arg)
  # @param [OpaqueType] return_type
  # @param [FFI::Pointer(*TypeRef)] param_types
  # @param [Integer] param_count
  # @param [Integer] is_var_arg
  # @return [OpaqueType]
  # @scope class
  attach_function :function_type, :LLVMFunctionType, [OpaqueType, :pointer, :uint, :int], OpaqueType

  # Returns whether a function type is variadic.
  #
  # @method is_function_var_arg(function_ty)
  # @param [OpaqueType] function_ty
  # @return [Integer]
  # @scope class
  attach_function :is_function_var_arg, :LLVMIsFunctionVarArg, [OpaqueType], :int

  # Obtain the Type this function Type returns.
  #
  # @method get_return_type(function_ty)
  # @param [OpaqueType] function_ty
  # @return [OpaqueType]
  # @scope class
  attach_function :get_return_type, :LLVMGetReturnType, [OpaqueType], OpaqueType

  # Obtain the number of parameters this function accepts.
  #
  # @method count_param_types(function_ty)
  # @param [OpaqueType] function_ty
  # @return [Integer]
  # @scope class
  attach_function :count_param_types, :LLVMCountParamTypes, [OpaqueType], :uint

  # Obtain the types of a function's parameters.
  #
  # The Dest parameter should point to a pre-allocated array of
  # LLVMTypeRef at least LLVMCountParamTypes() large. On return, the
  # first LLVMCountParamTypes() entries in the array will be populated
  # with LLVMTypeRef instances.
  #
  # @param FunctionTy The function type to operate on.
  # @param Dest Memory address of an array to be filled with result.
  #
  # @method get_param_types(function_ty, dest)
  # @param [OpaqueType] function_ty
  # @param [FFI::Pointer(*TypeRef)] dest
  # @return [nil]
  # @scope class
  attach_function :get_param_types, :LLVMGetParamTypes, [OpaqueType, :pointer], :void

  # Create a new structure type in a context.
  #
  # A structure is specified by a list of inner elements/types and
  # whether these can be packed together.
  #
  # @see llvm::StructType::create()
  #
  # @method struct_type_in_context(c, element_types, element_count, packed)
  # @param [OpaqueContext] c
  # @param [FFI::Pointer(*TypeRef)] element_types
  # @param [Integer] element_count
  # @param [Integer] packed
  # @return [OpaqueType]
  # @scope class
  attach_function :struct_type_in_context, :LLVMStructTypeInContext, [OpaqueContext, :pointer, :uint, :int], OpaqueType

  # Create a new structure type in the global context.
  #
  # @see llvm::StructType::create()
  #
  # @method struct_type(element_types, element_count, packed)
  # @param [FFI::Pointer(*TypeRef)] element_types
  # @param [Integer] element_count
  # @param [Integer] packed
  # @return [OpaqueType]
  # @scope class
  attach_function :struct_type, :LLVMStructType, [:pointer, :uint, :int], OpaqueType

  # Create an empty structure in a context having a specified name.
  #
  # @see llvm::StructType::create()
  #
  # @method struct_create_named(c, name)
  # @param [OpaqueContext] c
  # @param [String] name
  # @return [OpaqueType]
  # @scope class
  attach_function :struct_create_named, :LLVMStructCreateNamed, [OpaqueContext, :string], OpaqueType

  # Obtain the name of a structure.
  #
  # @see llvm::StructType::getName()
  #
  # @method get_struct_name(ty)
  # @param [OpaqueType] ty
  # @return [String]
  # @scope class
  attach_function :get_struct_name, :LLVMGetStructName, [OpaqueType], :string

  # Set the contents of a structure type.
  #
  # @see llvm::StructType::setBody()
  #
  # @method struct_set_body(struct_ty, element_types, element_count, packed)
  # @param [OpaqueType] struct_ty
  # @param [FFI::Pointer(*TypeRef)] element_types
  # @param [Integer] element_count
  # @param [Integer] packed
  # @return [nil]
  # @scope class
  attach_function :struct_set_body, :LLVMStructSetBody, [OpaqueType, :pointer, :uint, :int], :void

  # Get the number of elements defined inside the structure.
  #
  # @see llvm::StructType::getNumElements()
  #
  # @method count_struct_element_types(struct_ty)
  # @param [OpaqueType] struct_ty
  # @return [Integer]
  # @scope class
  attach_function :count_struct_element_types, :LLVMCountStructElementTypes, [OpaqueType], :uint

  # Get the elements within a structure.
  #
  # The function is passed the address of a pre-allocated array of
  # LLVMTypeRef at least LLVMCountStructElementTypes() long. After
  # invocation, this array will be populated with the structure's
  # elements. The objects in the destination array will have a lifetime
  # of the structure type itself, which is the lifetime of the context it
  # is contained in.
  #
  # @method get_struct_element_types(struct_ty, dest)
  # @param [OpaqueType] struct_ty
  # @param [FFI::Pointer(*TypeRef)] dest
  # @return [nil]
  # @scope class
  attach_function :get_struct_element_types, :LLVMGetStructElementTypes, [OpaqueType, :pointer], :void

  # Determine whether a structure is packed.
  #
  # @see llvm::StructType::isPacked()
  #
  # @method is_packed_struct(struct_ty)
  # @param [OpaqueType] struct_ty
  # @return [Integer]
  # @scope class
  attach_function :is_packed_struct, :LLVMIsPackedStruct, [OpaqueType], :int

  # Determine whether a structure is opaque.
  #
  # @see llvm::StructType::isOpaque()
  #
  # @method is_opaque_struct(struct_ty)
  # @param [OpaqueType] struct_ty
  # @return [Integer]
  # @scope class
  attach_function :is_opaque_struct, :LLVMIsOpaqueStruct, [OpaqueType], :int

  # Obtain the type of elements within a sequential type.
  #
  # This works on array, vector, and pointer types.
  #
  # @see llvm::SequentialType::getElementType()
  #
  # @method get_element_type(ty)
  # @param [OpaqueType] ty
  # @return [OpaqueType]
  # @scope class
  attach_function :get_element_type, :LLVMGetElementType, [OpaqueType], OpaqueType

  # Create a fixed size array type that refers to a specific type.
  #
  # The created type will exist in the context that its element type
  # exists in.
  #
  # @see llvm::ArrayType::get()
  #
  # @method array_type(element_type, element_count)
  # @param [OpaqueType] element_type
  # @param [Integer] element_count
  # @return [OpaqueType]
  # @scope class
  attach_function :array_type, :LLVMArrayType, [OpaqueType, :uint], OpaqueType

  # Obtain the length of an array type.
  #
  # This only works on types that represent arrays.
  #
  # @see llvm::ArrayType::getNumElements()
  #
  # @method get_array_length(array_ty)
  # @param [OpaqueType] array_ty
  # @return [Integer]
  # @scope class
  attach_function :get_array_length, :LLVMGetArrayLength, [OpaqueType], :uint

  # Create a pointer type that points to a defined type.
  #
  # The created type will exist in the context that its pointee type
  # exists in.
  #
  # @see llvm::PointerType::get()
  #
  # @method pointer_type(element_type, address_space)
  # @param [OpaqueType] element_type
  # @param [Integer] address_space
  # @return [OpaqueType]
  # @scope class
  attach_function :pointer_type, :LLVMPointerType, [OpaqueType, :uint], OpaqueType

  # Obtain the address space of a pointer type.
  #
  # This only works on types that represent pointers.
  #
  # @see llvm::PointerType::getAddressSpace()
  #
  # @method get_pointer_address_space(pointer_ty)
  # @param [OpaqueType] pointer_ty
  # @return [Integer]
  # @scope class
  attach_function :get_pointer_address_space, :LLVMGetPointerAddressSpace, [OpaqueType], :uint

  # Create a vector type that contains a defined type and has a specific
  # number of elements.
  #
  # The created type will exist in the context thats its element type
  # exists in.
  #
  # @see llvm::VectorType::get()
  #
  # @method vector_type(element_type, element_count)
  # @param [OpaqueType] element_type
  # @param [Integer] element_count
  # @return [OpaqueType]
  # @scope class
  attach_function :vector_type, :LLVMVectorType, [OpaqueType, :uint], OpaqueType

  # Obtain the number of elements in a vector type.
  #
  # This only works on types that represent vectors.
  #
  # @see llvm::VectorType::getNumElements()
  #
  # @method get_vector_size(vector_ty)
  # @param [OpaqueType] vector_ty
  # @return [Integer]
  # @scope class
  attach_function :get_vector_size, :LLVMGetVectorSize, [OpaqueType], :uint

  # Create a void type in a context.
  #
  # @method void_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :void_type_in_context, :LLVMVoidTypeInContext, [OpaqueContext], OpaqueType

  # Create a label type in a context.
  #
  # @method label_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :label_type_in_context, :LLVMLabelTypeInContext, [OpaqueContext], OpaqueType

  # Create a X86 MMX type in a context.
  #
  # @method x86mmx_type_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueType]
  # @scope class
  attach_function :x86mmx_type_in_context, :LLVMX86MMXTypeInContext, [OpaqueContext], OpaqueType

  # These are similar to the above functions except they operate on the
  # global context.
  #
  # @method void_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :void_type, :LLVMVoidType, [], OpaqueType

  # (Not documented)
  #
  # @method label_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :label_type, :LLVMLabelType, [], OpaqueType

  # (Not documented)
  #
  # @method x86mmx_type()
  # @return [OpaqueType]
  # @scope class
  attach_function :x86mmx_type, :LLVMX86MMXType, [], OpaqueType

  # Obtain the type of a value.
  #
  # @see llvm::Value::getType()
  #
  # @method type_of(val)
  # @param [OpaqueValue] val
  # @return [OpaqueType]
  # @scope class
  attach_function :type_of, :LLVMTypeOf, [OpaqueValue], OpaqueType

  # Obtain the string name of a value.
  #
  # @see llvm::Value::getName()
  #
  # @method get_value_name(val)
  # @param [OpaqueValue] val
  # @return [String]
  # @scope class
  attach_function :get_value_name, :LLVMGetValueName, [OpaqueValue], :string

  # Set the string name of a value.
  #
  # @see llvm::Value::setName()
  #
  # @method set_value_name(val, name)
  # @param [OpaqueValue] val
  # @param [String] name
  # @return [nil]
  # @scope class
  attach_function :set_value_name, :LLVMSetValueName, [OpaqueValue, :string], :void

  # Dump a representation of a value to stderr.
  #
  # @see llvm::Value::dump()
  #
  # @method dump_value(val)
  # @param [OpaqueValue] val
  # @return [nil]
  # @scope class
  attach_function :dump_value, :LLVMDumpValue, [OpaqueValue], :void

  # Return a string representation of the value. Use
  # LLVMDisposeMessage to free the string.
  #
  # @see llvm::Value::print()
  #
  # @method print_value_to_string(val)
  # @param [OpaqueValue] val
  # @return [String]
  # @scope class
  attach_function :print_value_to_string, :LLVMPrintValueToString, [OpaqueValue], :string

  # Replace all uses of a value with another one.
  #
  # @see llvm::Value::replaceAllUsesWith()
  #
  # @method replace_all_uses_with(old_val, new_val)
  # @param [OpaqueValue] old_val
  # @param [OpaqueValue] new_val
  # @return [nil]
  # @scope class
  attach_function :replace_all_uses_with, :LLVMReplaceAllUsesWith, [OpaqueValue, OpaqueValue], :void

  # Determine whether the specified constant instance is constant.
  #
  # @method is_constant(val)
  # @param [OpaqueValue] val
  # @return [Integer]
  # @scope class
  attach_function :is_constant, :LLVMIsConstant, [OpaqueValue], :int

  # Determine whether a value instance is undefined.
  #
  # @method is_undef(val)
  # @param [OpaqueValue] val
  # @return [Integer]
  # @scope class
  attach_function :is_undef, :LLVMIsUndef, [OpaqueValue], :int

  # Convert value instances between types.
  #
  # Internally, an LLVMValueRef is "pinned" to a specific type. This
  # series of functions allows you to cast an instance to a specific
  # type.
  #
  # If the cast is not valid for the specified type, NULL is returned.
  #
  # @see llvm::dyn_cast_or_null<>
  #
  # @method is_a_argument(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_argument, :LLVMIsAArgument, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_basic_block(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_basic_block, :LLVMIsABasicBlock, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_inline_asm(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_inline_asm, :LLVMIsAInlineAsm, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_amd_node(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_amd_node, :LLVMIsAMDNode, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_amd_string(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_amd_string, :LLVMIsAMDString, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_user(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_user, :LLVMIsAUser, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant, :LLVMIsAConstant, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_block_address(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_block_address, :LLVMIsABlockAddress, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant_aggregate_zero(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant_aggregate_zero, :LLVMIsAConstantAggregateZero, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant_array(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant_array, :LLVMIsAConstantArray, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant_data_sequential(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant_data_sequential, :LLVMIsAConstantDataSequential, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant_data_array(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant_data_array, :LLVMIsAConstantDataArray, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant_data_vector(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant_data_vector, :LLVMIsAConstantDataVector, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant_expr(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant_expr, :LLVMIsAConstantExpr, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant_fp(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant_fp, :LLVMIsAConstantFP, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant_int(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant_int, :LLVMIsAConstantInt, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant_pointer_null(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant_pointer_null, :LLVMIsAConstantPointerNull, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant_struct(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant_struct, :LLVMIsAConstantStruct, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_constant_vector(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_constant_vector, :LLVMIsAConstantVector, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_global_value(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_global_value, :LLVMIsAGlobalValue, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_function(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_function, :LLVMIsAFunction, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_global_alias(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_global_alias, :LLVMIsAGlobalAlias, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_global_variable(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_global_variable, :LLVMIsAGlobalVariable, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_undef_value(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_undef_value, :LLVMIsAUndefValue, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_instruction(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_instruction, :LLVMIsAInstruction, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_binary_operator(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_binary_operator, :LLVMIsABinaryOperator, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_call_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_call_inst, :LLVMIsACallInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_intrinsic_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_intrinsic_inst, :LLVMIsAIntrinsicInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_dbg_info_intrinsic(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_dbg_info_intrinsic, :LLVMIsADbgInfoIntrinsic, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_dbg_declare_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_dbg_declare_inst, :LLVMIsADbgDeclareInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_mem_intrinsic(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_mem_intrinsic, :LLVMIsAMemIntrinsic, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_mem_cpy_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_mem_cpy_inst, :LLVMIsAMemCpyInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_mem_move_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_mem_move_inst, :LLVMIsAMemMoveInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_mem_set_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_mem_set_inst, :LLVMIsAMemSetInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_cmp_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_cmp_inst, :LLVMIsACmpInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_af_cmp_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_af_cmp_inst, :LLVMIsAFCmpInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_ai_cmp_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_ai_cmp_inst, :LLVMIsAICmpInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_extract_element_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_extract_element_inst, :LLVMIsAExtractElementInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_get_element_ptr_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_get_element_ptr_inst, :LLVMIsAGetElementPtrInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_insert_element_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_insert_element_inst, :LLVMIsAInsertElementInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_insert_value_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_insert_value_inst, :LLVMIsAInsertValueInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_landing_pad_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_landing_pad_inst, :LLVMIsALandingPadInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_aphi_node(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_aphi_node, :LLVMIsAPHINode, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_select_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_select_inst, :LLVMIsASelectInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_shuffle_vector_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_shuffle_vector_inst, :LLVMIsAShuffleVectorInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_store_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_store_inst, :LLVMIsAStoreInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_terminator_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_terminator_inst, :LLVMIsATerminatorInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_branch_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_branch_inst, :LLVMIsABranchInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_indirect_br_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_indirect_br_inst, :LLVMIsAIndirectBrInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_invoke_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_invoke_inst, :LLVMIsAInvokeInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_return_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_return_inst, :LLVMIsAReturnInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_switch_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_switch_inst, :LLVMIsASwitchInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_unreachable_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_unreachable_inst, :LLVMIsAUnreachableInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_resume_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_resume_inst, :LLVMIsAResumeInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_unary_instruction(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_unary_instruction, :LLVMIsAUnaryInstruction, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_alloca_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_alloca_inst, :LLVMIsAAllocaInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_cast_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_cast_inst, :LLVMIsACastInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_addr_space_cast_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_addr_space_cast_inst, :LLVMIsAAddrSpaceCastInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_bit_cast_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_bit_cast_inst, :LLVMIsABitCastInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_afp_ext_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_afp_ext_inst, :LLVMIsAFPExtInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_afp_to_si_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_afp_to_si_inst, :LLVMIsAFPToSIInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_afp_to_ui_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_afp_to_ui_inst, :LLVMIsAFPToUIInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_afp_trunc_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_afp_trunc_inst, :LLVMIsAFPTruncInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_int_to_ptr_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_int_to_ptr_inst, :LLVMIsAIntToPtrInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_ptr_to_int_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_ptr_to_int_inst, :LLVMIsAPtrToIntInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_as_ext_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_as_ext_inst, :LLVMIsASExtInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_asi_to_fp_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_asi_to_fp_inst, :LLVMIsASIToFPInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_trunc_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_trunc_inst, :LLVMIsATruncInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_aui_to_fp_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_aui_to_fp_inst, :LLVMIsAUIToFPInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_az_ext_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_az_ext_inst, :LLVMIsAZExtInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_extract_value_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_extract_value_inst, :LLVMIsAExtractValueInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_a_load_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_a_load_inst, :LLVMIsALoadInst, [OpaqueValue], OpaqueValue

  # @}
  #
  # @method is_ava_arg_inst(val)
  # @param [OpaqueValue] val
  # @return [OpaqueValue]
  # @scope class
  attach_function :is_ava_arg_inst, :LLVMIsAVAArgInst, [OpaqueValue], OpaqueValue

  # Obtain the first use of a value.
  #
  # Uses are obtained in an iterator fashion. First, call this function
  # to obtain a reference to the first use. Then, call LLVMGetNextUse()
  # on that instance and all subsequently obtained instances until
  # LLVMGetNextUse() returns NULL.
  #
  # @see llvm::Value::use_begin()
  #
  # @method get_first_use(val)
  # @param [OpaqueValue] val
  # @return [OpaqueUse]
  # @scope class
  attach_function :get_first_use, :LLVMGetFirstUse, [OpaqueValue], OpaqueUse

  # Obtain the next use of a value.
  #
  # This effectively advances the iterator. It returns NULL if you are on
  # the final use and no more are available.
  #
  # @method get_next_use(u)
  # @param [OpaqueUse] u
  # @return [OpaqueUse]
  # @scope class
  attach_function :get_next_use, :LLVMGetNextUse, [OpaqueUse], OpaqueUse

  # Obtain the user value for a user.
  #
  # The returned value corresponds to a llvm::User type.
  #
  # @see llvm::Use::getUser()
  #
  # @method get_user(u)
  # @param [OpaqueUse] u
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_user, :LLVMGetUser, [OpaqueUse], OpaqueValue

  # Obtain the value this use corresponds to.
  #
  # @see llvm::Use::get().
  #
  # @method get_used_value(u)
  # @param [OpaqueUse] u
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_used_value, :LLVMGetUsedValue, [OpaqueUse], OpaqueValue

  # Obtain an operand at a specific index in a llvm::User value.
  #
  # @see llvm::User::getOperand()
  #
  # @method get_operand(val, index)
  # @param [OpaqueValue] val
  # @param [Integer] index
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_operand, :LLVMGetOperand, [OpaqueValue, :uint], OpaqueValue

  # Set an operand at a specific index in a llvm::User value.
  #
  # @see llvm::User::setOperand()
  #
  # @method set_operand(user, index, val)
  # @param [OpaqueValue] user
  # @param [Integer] index
  # @param [OpaqueValue] val
  # @return [nil]
  # @scope class
  attach_function :set_operand, :LLVMSetOperand, [OpaqueValue, :uint, OpaqueValue], :void

  # Obtain the number of operands in a llvm::User value.
  #
  # @see llvm::User::getNumOperands()
  #
  # @method get_num_operands(val)
  # @param [OpaqueValue] val
  # @return [Integer]
  # @scope class
  attach_function :get_num_operands, :LLVMGetNumOperands, [OpaqueValue], :int

  # Obtain a constant value referring to the null instance of a type.
  #
  # @see llvm::Constant::getNullValue()
  #
  # @method const_null(ty)
  # @param [OpaqueType] ty
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_null, :LLVMConstNull, [OpaqueType], OpaqueValue

  # Obtain a constant value referring to the instance of a type
  # consisting of all ones.
  #
  # This is only valid for integer types.
  #
  # @see llvm::Constant::getAllOnesValue()
  #
  # @method const_all_ones(ty)
  # @param [OpaqueType] ty
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_all_ones, :LLVMConstAllOnes, [OpaqueType], OpaqueValue

  # Obtain a constant value referring to an undefined value of a type.
  #
  # @see llvm::UndefValue::get()
  #
  # @method get_undef(ty)
  # @param [OpaqueType] ty
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_undef, :LLVMGetUndef, [OpaqueType], OpaqueValue

  # Determine whether a value instance is null.
  #
  # @see llvm::Constant::isNullValue()
  #
  # @method is_null(val)
  # @param [OpaqueValue] val
  # @return [Integer]
  # @scope class
  attach_function :is_null, :LLVMIsNull, [OpaqueValue], :int

  # Obtain a constant that is a constant pointer pointing to NULL for a
  # specified type.
  #
  # @method const_pointer_null(ty)
  # @param [OpaqueType] ty
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_pointer_null, :LLVMConstPointerNull, [OpaqueType], OpaqueValue

  # Obtain a constant value for an integer type.
  #
  # The returned value corresponds to a llvm::ConstantInt.
  #
  # @see llvm::ConstantInt::get()
  #
  # @param IntTy Integer type to obtain value of.
  # @param N The value the returned instance should refer to.
  # @param SignExtend Whether to sign extend the produced value.
  #
  # @method const_int(int_ty, n, sign_extend)
  # @param [OpaqueType] int_ty
  # @param [Integer] n
  # @param [Integer] sign_extend
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_int, :LLVMConstInt, [OpaqueType, :ulong_long, :int], OpaqueValue

  # Obtain a constant value for an integer of arbitrary precision.
  #
  # @see llvm::ConstantInt::get()
  #
  # @method const_int_of_arbitrary_precision(int_ty, num_words, words)
  # @param [OpaqueType] int_ty
  # @param [Integer] num_words
  # @param [unexposed] words
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_int_of_arbitrary_precision, :LLVMConstIntOfArbitraryPrecision, [OpaqueType, :uint, :char], OpaqueValue

  # Obtain a constant value for an integer parsed from a string.
  #
  # A similar API, LLVMConstIntOfStringAndSize is also available. If the
  # string's length is available, it is preferred to call that function
  # instead.
  #
  # @see llvm::ConstantInt::get()
  #
  # @method const_int_of_string(int_ty, text, radix)
  # @param [OpaqueType] int_ty
  # @param [String] text
  # @param [Integer] radix
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_int_of_string, :LLVMConstIntOfString, [OpaqueType, :string, :uchar], OpaqueValue

  # Obtain a constant value for an integer parsed from a string with
  # specified length.
  #
  # @see llvm::ConstantInt::get()
  #
  # @method const_int_of_string_and_size(int_ty, text, s_len, radix)
  # @param [OpaqueType] int_ty
  # @param [String] text
  # @param [Integer] s_len
  # @param [Integer] radix
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_int_of_string_and_size, :LLVMConstIntOfStringAndSize, [OpaqueType, :string, :uint, :uchar], OpaqueValue

  # Obtain a constant value referring to a double floating point value.
  #
  # @method const_real(real_ty, n)
  # @param [OpaqueType] real_ty
  # @param [Float] n
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_real, :LLVMConstReal, [OpaqueType, :double], OpaqueValue

  # Obtain a constant for a floating point value parsed from a string.
  #
  # A similar API, LLVMConstRealOfStringAndSize is also available. It
  # should be used if the input string's length is known.
  #
  # @method const_real_of_string(real_ty, text)
  # @param [OpaqueType] real_ty
  # @param [String] text
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_real_of_string, :LLVMConstRealOfString, [OpaqueType, :string], OpaqueValue

  # Obtain a constant for a floating point value parsed from a string.
  #
  # @method const_real_of_string_and_size(real_ty, text, s_len)
  # @param [OpaqueType] real_ty
  # @param [String] text
  # @param [Integer] s_len
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_real_of_string_and_size, :LLVMConstRealOfStringAndSize, [OpaqueType, :string, :uint], OpaqueValue

  # Obtain the zero extended value for an integer constant value.
  #
  # @see llvm::ConstantInt::getZExtValue()
  #
  # @method const_int_get_z_ext_value(constant_val)
  # @param [OpaqueValue] constant_val
  # @return [Integer]
  # @scope class
  attach_function :const_int_get_z_ext_value, :LLVMConstIntGetZExtValue, [OpaqueValue], :ulong_long

  # Obtain the sign extended value for an integer constant value.
  #
  # @see llvm::ConstantInt::getSExtValue()
  #
  # @method const_int_get_s_ext_value(constant_val)
  # @param [OpaqueValue] constant_val
  # @return [Integer]
  # @scope class
  attach_function :const_int_get_s_ext_value, :LLVMConstIntGetSExtValue, [OpaqueValue], :long_long

  # Create a ConstantDataSequential and initialize it with a string.
  #
  # @see llvm::ConstantDataArray::getString()
  #
  # @method const_string_in_context(c, str, length, dont_null_terminate)
  # @param [OpaqueContext] c
  # @param [String] str
  # @param [Integer] length
  # @param [Integer] dont_null_terminate
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_string_in_context, :LLVMConstStringInContext, [OpaqueContext, :string, :uint, :int], OpaqueValue

  # Create a ConstantDataSequential with string content in the global context.
  #
  # This is the same as LLVMConstStringInContext except it operates on the
  # global context.
  #
  # @see LLVMConstStringInContext()
  # @see llvm::ConstantDataArray::getString()
  #
  # @method const_string(str, length, dont_null_terminate)
  # @param [String] str
  # @param [Integer] length
  # @param [Integer] dont_null_terminate
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_string, :LLVMConstString, [:string, :uint, :int], OpaqueValue

  # Create an anonymous ConstantStruct with the specified values.
  #
  # @see llvm::ConstantStruct::getAnon()
  #
  # @method const_struct_in_context(c, constant_vals, count, packed)
  # @param [OpaqueContext] c
  # @param [FFI::Pointer(*ValueRef)] constant_vals
  # @param [Integer] count
  # @param [Integer] packed
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_struct_in_context, :LLVMConstStructInContext, [OpaqueContext, :pointer, :uint, :int], OpaqueValue

  # Create a ConstantStruct in the global Context.
  #
  # This is the same as LLVMConstStructInContext except it operates on the
  # global Context.
  #
  # @see LLVMConstStructInContext()
  #
  # @method const_struct(constant_vals, count, packed)
  # @param [FFI::Pointer(*ValueRef)] constant_vals
  # @param [Integer] count
  # @param [Integer] packed
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_struct, :LLVMConstStruct, [:pointer, :uint, :int], OpaqueValue

  # Create a ConstantArray from values.
  #
  # @see llvm::ConstantArray::get()
  #
  # @method const_array(element_ty, constant_vals, length)
  # @param [OpaqueType] element_ty
  # @param [FFI::Pointer(*ValueRef)] constant_vals
  # @param [Integer] length
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_array, :LLVMConstArray, [OpaqueType, :pointer, :uint], OpaqueValue

  # Create a non-anonymous ConstantStruct from values.
  #
  # @see llvm::ConstantStruct::get()
  #
  # @method const_named_struct(struct_ty, constant_vals, count)
  # @param [OpaqueType] struct_ty
  # @param [FFI::Pointer(*ValueRef)] constant_vals
  # @param [Integer] count
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_named_struct, :LLVMConstNamedStruct, [OpaqueType, :pointer, :uint], OpaqueValue

  # Create a ConstantVector from values.
  #
  # @see llvm::ConstantVector::get()
  #
  # @method const_vector(scalar_constant_vals, size)
  # @param [FFI::Pointer(*ValueRef)] scalar_constant_vals
  # @param [Integer] size
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_vector, :LLVMConstVector, [:pointer, :uint], OpaqueValue

  # @defgroup LLVMCCoreValueConstantExpressions Constant Expressions
  #
  # Functions in this group correspond to APIs on llvm::ConstantExpr.
  #
  # @see llvm::ConstantExpr.
  #
  # @{
  #
  # @method get_const_opcode(constant_val)
  # @param [OpaqueValue] constant_val
  # @return [Symbol from _enum_opcode_]
  # @scope class
  attach_function :get_const_opcode, :LLVMGetConstOpcode, [OpaqueValue], :opcode

  # (Not documented)
  #
  # @method align_of(ty)
  # @param [OpaqueType] ty
  # @return [OpaqueValue]
  # @scope class
  attach_function :align_of, :LLVMAlignOf, [OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method size_of(ty)
  # @param [OpaqueType] ty
  # @return [OpaqueValue]
  # @scope class
  attach_function :size_of, :LLVMSizeOf, [OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_neg(constant_val)
  # @param [OpaqueValue] constant_val
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_neg, :LLVMConstNeg, [OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_nsw_neg(constant_val)
  # @param [OpaqueValue] constant_val
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_nsw_neg, :LLVMConstNSWNeg, [OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_nuw_neg(constant_val)
  # @param [OpaqueValue] constant_val
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_nuw_neg, :LLVMConstNUWNeg, [OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_f_neg(constant_val)
  # @param [OpaqueValue] constant_val
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_f_neg, :LLVMConstFNeg, [OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_not(constant_val)
  # @param [OpaqueValue] constant_val
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_not, :LLVMConstNot, [OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_add(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_add, :LLVMConstAdd, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_nsw_add(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_nsw_add, :LLVMConstNSWAdd, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_nuw_add(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_nuw_add, :LLVMConstNUWAdd, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_f_add(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_f_add, :LLVMConstFAdd, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_sub(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_sub, :LLVMConstSub, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_nsw_sub(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_nsw_sub, :LLVMConstNSWSub, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_nuw_sub(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_nuw_sub, :LLVMConstNUWSub, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_f_sub(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_f_sub, :LLVMConstFSub, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_mul(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_mul, :LLVMConstMul, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_nsw_mul(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_nsw_mul, :LLVMConstNSWMul, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_nuw_mul(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_nuw_mul, :LLVMConstNUWMul, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_f_mul(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_f_mul, :LLVMConstFMul, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_u_div(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_u_div, :LLVMConstUDiv, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_s_div(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_s_div, :LLVMConstSDiv, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_exact_s_div(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_exact_s_div, :LLVMConstExactSDiv, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_f_div(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_f_div, :LLVMConstFDiv, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_u_rem(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_u_rem, :LLVMConstURem, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_s_rem(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_s_rem, :LLVMConstSRem, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_f_rem(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_f_rem, :LLVMConstFRem, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_and(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_and, :LLVMConstAnd, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_or(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_or, :LLVMConstOr, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_xor(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_xor, :LLVMConstXor, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_i_cmp(predicate, lhs_constant, rhs_constant)
  # @param [Symbol from _enum_int_predicate_] predicate
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_i_cmp, :LLVMConstICmp, [:int_predicate, OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_f_cmp(predicate, lhs_constant, rhs_constant)
  # @param [Symbol from _enum_real_predicate_] predicate
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_f_cmp, :LLVMConstFCmp, [:real_predicate, OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_shl(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_shl, :LLVMConstShl, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_l_shr(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_l_shr, :LLVMConstLShr, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_a_shr(lhs_constant, rhs_constant)
  # @param [OpaqueValue] lhs_constant
  # @param [OpaqueValue] rhs_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_a_shr, :LLVMConstAShr, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_gep(constant_val, constant_indices, num_indices)
  # @param [OpaqueValue] constant_val
  # @param [FFI::Pointer(*ValueRef)] constant_indices
  # @param [Integer] num_indices
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_gep, :LLVMConstGEP, [OpaqueValue, :pointer, :uint], OpaqueValue

  # (Not documented)
  #
  # @method const_in_bounds_gep(constant_val, constant_indices, num_indices)
  # @param [OpaqueValue] constant_val
  # @param [FFI::Pointer(*ValueRef)] constant_indices
  # @param [Integer] num_indices
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_in_bounds_gep, :LLVMConstInBoundsGEP, [OpaqueValue, :pointer, :uint], OpaqueValue

  # (Not documented)
  #
  # @method const_trunc(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_trunc, :LLVMConstTrunc, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_s_ext(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_s_ext, :LLVMConstSExt, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_z_ext(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_z_ext, :LLVMConstZExt, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_fp_trunc(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_fp_trunc, :LLVMConstFPTrunc, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_fp_ext(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_fp_ext, :LLVMConstFPExt, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_ui_to_fp(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_ui_to_fp, :LLVMConstUIToFP, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_si_to_fp(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_si_to_fp, :LLVMConstSIToFP, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_fp_to_ui(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_fp_to_ui, :LLVMConstFPToUI, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_fp_to_si(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_fp_to_si, :LLVMConstFPToSI, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_ptr_to_int(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_ptr_to_int, :LLVMConstPtrToInt, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_int_to_ptr(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_int_to_ptr, :LLVMConstIntToPtr, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_bit_cast(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_bit_cast, :LLVMConstBitCast, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_addr_space_cast(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_addr_space_cast, :LLVMConstAddrSpaceCast, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_z_ext_or_bit_cast(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_z_ext_or_bit_cast, :LLVMConstZExtOrBitCast, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_s_ext_or_bit_cast(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_s_ext_or_bit_cast, :LLVMConstSExtOrBitCast, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_trunc_or_bit_cast(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_trunc_or_bit_cast, :LLVMConstTruncOrBitCast, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_pointer_cast(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_pointer_cast, :LLVMConstPointerCast, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_int_cast(constant_val, to_type, is_signed)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @param [Integer] is_signed
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_int_cast, :LLVMConstIntCast, [OpaqueValue, OpaqueType, :int], OpaqueValue

  # (Not documented)
  #
  # @method const_fp_cast(constant_val, to_type)
  # @param [OpaqueValue] constant_val
  # @param [OpaqueType] to_type
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_fp_cast, :LLVMConstFPCast, [OpaqueValue, OpaqueType], OpaqueValue

  # (Not documented)
  #
  # @method const_select(constant_condition, constant_if_true, constant_if_false)
  # @param [OpaqueValue] constant_condition
  # @param [OpaqueValue] constant_if_true
  # @param [OpaqueValue] constant_if_false
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_select, :LLVMConstSelect, [OpaqueValue, OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_extract_element(vector_constant, index_constant)
  # @param [OpaqueValue] vector_constant
  # @param [OpaqueValue] index_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_extract_element, :LLVMConstExtractElement, [OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_insert_element(vector_constant, element_value_constant, index_constant)
  # @param [OpaqueValue] vector_constant
  # @param [OpaqueValue] element_value_constant
  # @param [OpaqueValue] index_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_insert_element, :LLVMConstInsertElement, [OpaqueValue, OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_shuffle_vector(vector_a_constant, vector_b_constant, mask_constant)
  # @param [OpaqueValue] vector_a_constant
  # @param [OpaqueValue] vector_b_constant
  # @param [OpaqueValue] mask_constant
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_shuffle_vector, :LLVMConstShuffleVector, [OpaqueValue, OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method const_extract_value(agg_constant, idx_list, num_idx)
  # @param [OpaqueValue] agg_constant
  # @param [FFI::Pointer(*UInt)] idx_list
  # @param [Integer] num_idx
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_extract_value, :LLVMConstExtractValue, [OpaqueValue, :pointer, :uint], OpaqueValue

  # (Not documented)
  #
  # @method const_insert_value(agg_constant, element_value_constant, idx_list, num_idx)
  # @param [OpaqueValue] agg_constant
  # @param [OpaqueValue] element_value_constant
  # @param [FFI::Pointer(*UInt)] idx_list
  # @param [Integer] num_idx
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_insert_value, :LLVMConstInsertValue, [OpaqueValue, OpaqueValue, :pointer, :uint], OpaqueValue

  # (Not documented)
  #
  # @method const_inline_asm(ty, asm_string, constraints, has_side_effects, is_align_stack)
  # @param [OpaqueType] ty
  # @param [String] asm_string
  # @param [String] constraints
  # @param [Integer] has_side_effects
  # @param [Integer] is_align_stack
  # @return [OpaqueValue]
  # @scope class
  attach_function :const_inline_asm, :LLVMConstInlineAsm, [OpaqueType, :string, :string, :int, :int], OpaqueValue

  # (Not documented)
  #
  # @method block_address(f, bb)
  # @param [OpaqueValue] f
  # @param [OpaqueBasicBlock] bb
  # @return [OpaqueValue]
  # @scope class
  attach_function :block_address, :LLVMBlockAddress, [OpaqueValue, OpaqueBasicBlock], OpaqueValue

  # @defgroup LLVMCCoreValueConstantGlobals Global Values
  #
  # This group contains functions that operate on global values. Functions in
  # this group relate to functions in the llvm::GlobalValue class tree.
  #
  # @see llvm::GlobalValue
  #
  # @{
  #
  # @method get_global_parent(global)
  # @param [OpaqueValue] global
  # @return [OpaqueModule]
  # @scope class
  attach_function :get_global_parent, :LLVMGetGlobalParent, [OpaqueValue], OpaqueModule

  # (Not documented)
  #
  # @method is_declaration(global)
  # @param [OpaqueValue] global
  # @return [Integer]
  # @scope class
  attach_function :is_declaration, :LLVMIsDeclaration, [OpaqueValue], :int

  # (Not documented)
  #
  # @method get_linkage(global)
  # @param [OpaqueValue] global
  # @return [Symbol from _enum_linkage_]
  # @scope class
  attach_function :get_linkage, :LLVMGetLinkage, [OpaqueValue], :linkage

  # (Not documented)
  #
  # @method set_linkage(global, linkage)
  # @param [OpaqueValue] global
  # @param [Symbol from _enum_linkage_] linkage
  # @return [nil]
  # @scope class
  attach_function :set_linkage, :LLVMSetLinkage, [OpaqueValue, :linkage], :void

  # (Not documented)
  #
  # @method get_section(global)
  # @param [OpaqueValue] global
  # @return [String]
  # @scope class
  attach_function :get_section, :LLVMGetSection, [OpaqueValue], :string

  # (Not documented)
  #
  # @method set_section(global, section)
  # @param [OpaqueValue] global
  # @param [String] section
  # @return [nil]
  # @scope class
  attach_function :set_section, :LLVMSetSection, [OpaqueValue, :string], :void

  # (Not documented)
  #
  # @method get_visibility(global)
  # @param [OpaqueValue] global
  # @return [Symbol from _enum_visibility_]
  # @scope class
  attach_function :get_visibility, :LLVMGetVisibility, [OpaqueValue], :visibility

  # (Not documented)
  #
  # @method set_visibility(global, viz)
  # @param [OpaqueValue] global
  # @param [Symbol from _enum_visibility_] viz
  # @return [nil]
  # @scope class
  attach_function :set_visibility, :LLVMSetVisibility, [OpaqueValue, :visibility], :void

  # Obtain the preferred alignment of the value.
  # @see llvm::LoadInst::getAlignment()
  # @see llvm::StoreInst::getAlignment()
  # @see llvm::GlobalValue::getAlignment()
  #
  # @method get_alignment(v)
  # @param [OpaqueValue] v
  # @return [Integer]
  # @scope class
  attach_function :get_alignment, :LLVMGetAlignment, [OpaqueValue], :uint

  # Set the preferred alignment of the value.
  # @see llvm::LoadInst::setAlignment()
  # @see llvm::StoreInst::setAlignment()
  # @see llvm::GlobalValue::setAlignment()
  #
  # @method set_alignment(v, bytes)
  # @param [OpaqueValue] v
  # @param [Integer] bytes
  # @return [nil]
  # @scope class
  attach_function :set_alignment, :LLVMSetAlignment, [OpaqueValue, :uint], :void

  # @defgroup LLVMCoreValueConstantGlobalVariable Global Variables
  #
  # This group contains functions that operate on global variable values.
  #
  # @see llvm::GlobalVariable
  #
  # @{
  #
  # @method add_global(m, ty, name)
  # @param [OpaqueModule] m
  # @param [OpaqueType] ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :add_global, :LLVMAddGlobal, [OpaqueModule, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method add_global_in_address_space(m, ty, name, address_space)
  # @param [OpaqueModule] m
  # @param [OpaqueType] ty
  # @param [String] name
  # @param [Integer] address_space
  # @return [OpaqueValue]
  # @scope class
  attach_function :add_global_in_address_space, :LLVMAddGlobalInAddressSpace, [OpaqueModule, OpaqueType, :string, :uint], OpaqueValue

  # (Not documented)
  #
  # @method get_named_global(m, name)
  # @param [OpaqueModule] m
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_named_global, :LLVMGetNamedGlobal, [OpaqueModule, :string], OpaqueValue

  # (Not documented)
  #
  # @method get_first_global(m)
  # @param [OpaqueModule] m
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_first_global, :LLVMGetFirstGlobal, [OpaqueModule], OpaqueValue

  # (Not documented)
  #
  # @method get_last_global(m)
  # @param [OpaqueModule] m
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_last_global, :LLVMGetLastGlobal, [OpaqueModule], OpaqueValue

  # (Not documented)
  #
  # @method get_next_global(global_var)
  # @param [OpaqueValue] global_var
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_next_global, :LLVMGetNextGlobal, [OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method get_previous_global(global_var)
  # @param [OpaqueValue] global_var
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_previous_global, :LLVMGetPreviousGlobal, [OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method delete_global(global_var)
  # @param [OpaqueValue] global_var
  # @return [nil]
  # @scope class
  attach_function :delete_global, :LLVMDeleteGlobal, [OpaqueValue], :void

  # (Not documented)
  #
  # @method get_initializer(global_var)
  # @param [OpaqueValue] global_var
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_initializer, :LLVMGetInitializer, [OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method set_initializer(global_var, constant_val)
  # @param [OpaqueValue] global_var
  # @param [OpaqueValue] constant_val
  # @return [nil]
  # @scope class
  attach_function :set_initializer, :LLVMSetInitializer, [OpaqueValue, OpaqueValue], :void

  # (Not documented)
  #
  # @method is_thread_local(global_var)
  # @param [OpaqueValue] global_var
  # @return [Integer]
  # @scope class
  attach_function :is_thread_local, :LLVMIsThreadLocal, [OpaqueValue], :int

  # (Not documented)
  #
  # @method set_thread_local(global_var, is_thread_local)
  # @param [OpaqueValue] global_var
  # @param [Integer] is_thread_local
  # @return [nil]
  # @scope class
  attach_function :set_thread_local, :LLVMSetThreadLocal, [OpaqueValue, :int], :void

  # (Not documented)
  #
  # @method is_global_constant(global_var)
  # @param [OpaqueValue] global_var
  # @return [Integer]
  # @scope class
  attach_function :is_global_constant, :LLVMIsGlobalConstant, [OpaqueValue], :int

  # (Not documented)
  #
  # @method set_global_constant(global_var, is_constant)
  # @param [OpaqueValue] global_var
  # @param [Integer] is_constant
  # @return [nil]
  # @scope class
  attach_function :set_global_constant, :LLVMSetGlobalConstant, [OpaqueValue, :int], :void

  # (Not documented)
  #
  # @method get_thread_local_mode(global_var)
  # @param [OpaqueValue] global_var
  # @return [Symbol from _enum_thread_local_mode_]
  # @scope class
  attach_function :get_thread_local_mode, :LLVMGetThreadLocalMode, [OpaqueValue], :thread_local_mode

  # (Not documented)
  #
  # @method set_thread_local_mode(global_var, mode)
  # @param [OpaqueValue] global_var
  # @param [Symbol from _enum_thread_local_mode_] mode
  # @return [nil]
  # @scope class
  attach_function :set_thread_local_mode, :LLVMSetThreadLocalMode, [OpaqueValue, :thread_local_mode], :void

  # (Not documented)
  #
  # @method is_externally_initialized(global_var)
  # @param [OpaqueValue] global_var
  # @return [Integer]
  # @scope class
  attach_function :is_externally_initialized, :LLVMIsExternallyInitialized, [OpaqueValue], :int

  # (Not documented)
  #
  # @method set_externally_initialized(global_var, is_ext_init)
  # @param [OpaqueValue] global_var
  # @param [Integer] is_ext_init
  # @return [nil]
  # @scope class
  attach_function :set_externally_initialized, :LLVMSetExternallyInitialized, [OpaqueValue, :int], :void

  # @defgroup LLVMCoreValueConstantGlobalAlias Global Aliases
  #
  # This group contains function that operate on global alias values.
  #
  # @see llvm::GlobalAlias
  #
  # @{
  #
  # @method add_alias(m, ty, aliasee, name)
  # @param [OpaqueModule] m
  # @param [OpaqueType] ty
  # @param [OpaqueValue] aliasee
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :add_alias, :LLVMAddAlias, [OpaqueModule, OpaqueType, OpaqueValue, :string], OpaqueValue

  # Remove a function from its containing module and deletes it.
  #
  # @see llvm::Function::eraseFromParent()
  #
  # @method delete_function(fn)
  # @param [OpaqueValue] fn
  # @return [nil]
  # @scope class
  attach_function :delete_function, :LLVMDeleteFunction, [OpaqueValue], :void

  # Obtain the ID number from a function instance.
  #
  # @see llvm::Function::getIntrinsicID()
  #
  # @method get_intrinsic_id(fn)
  # @param [OpaqueValue] fn
  # @return [Integer]
  # @scope class
  attach_function :get_intrinsic_id, :LLVMGetIntrinsicID, [OpaqueValue], :uint

  # Obtain the calling function of a function.
  #
  # The returned value corresponds to the LLVMCallConv enumeration.
  #
  # @see llvm::Function::getCallingConv()
  #
  # @method get_function_call_conv(fn)
  # @param [OpaqueValue] fn
  # @return [Integer]
  # @scope class
  attach_function :get_function_call_conv, :LLVMGetFunctionCallConv, [OpaqueValue], :uint

  # Set the calling convention of a function.
  #
  # @see llvm::Function::setCallingConv()
  #
  # @param Fn Function to operate on
  # @param CC LLVMCallConv to set calling convention to
  #
  # @method set_function_call_conv(fn, cc)
  # @param [OpaqueValue] fn
  # @param [Integer] cc
  # @return [nil]
  # @scope class
  attach_function :set_function_call_conv, :LLVMSetFunctionCallConv, [OpaqueValue, :uint], :void

  # Obtain the name of the garbage collector to use during code
  # generation.
  #
  # @see llvm::Function::getGC()
  #
  # @method get_gc(fn)
  # @param [OpaqueValue] fn
  # @return [String]
  # @scope class
  attach_function :get_gc, :LLVMGetGC, [OpaqueValue], :string

  # Define the garbage collector to use during code generation.
  #
  # @see llvm::Function::setGC()
  #
  # @method set_gc(fn, name)
  # @param [OpaqueValue] fn
  # @param [String] name
  # @return [nil]
  # @scope class
  attach_function :set_gc, :LLVMSetGC, [OpaqueValue, :string], :void

  # Add an attribute to a function.
  #
  # @see llvm::Function::addAttribute()
  #
  # @method add_function_attr(fn, pa)
  # @param [OpaqueValue] fn
  # @param [Symbol from _enum_attribute_] pa
  # @return [nil]
  # @scope class
  attach_function :add_function_attr, :LLVMAddFunctionAttr, [OpaqueValue, :attribute], :void

  # Add a target-dependent attribute to a fuction
  # @see llvm::AttrBuilder::addAttribute()
  #
  # @method add_target_dependent_function_attr(fn, a, v)
  # @param [OpaqueValue] fn
  # @param [String] a
  # @param [String] v
  # @return [nil]
  # @scope class
  attach_function :add_target_dependent_function_attr, :LLVMAddTargetDependentFunctionAttr, [OpaqueValue, :string, :string], :void

  # Obtain an attribute from a function.
  #
  # @see llvm::Function::getAttributes()
  #
  # @method get_function_attr(fn)
  # @param [OpaqueValue] fn
  # @return [Symbol from _enum_attribute_]
  # @scope class
  attach_function :get_function_attr, :LLVMGetFunctionAttr, [OpaqueValue], :attribute

  # Remove an attribute from a function.
  #
  # @method remove_function_attr(fn, pa)
  # @param [OpaqueValue] fn
  # @param [Symbol from _enum_attribute_] pa
  # @return [nil]
  # @scope class
  attach_function :remove_function_attr, :LLVMRemoveFunctionAttr, [OpaqueValue, :attribute], :void

  # Obtain the number of parameters in a function.
  #
  # @see llvm::Function::arg_size()
  #
  # @method count_params(fn)
  # @param [OpaqueValue] fn
  # @return [Integer]
  # @scope class
  attach_function :count_params, :LLVMCountParams, [OpaqueValue], :uint

  # Obtain the parameters in a function.
  #
  # The takes a pointer to a pre-allocated array of LLVMValueRef that is
  # at least LLVMCountParams() long. This array will be filled with
  # LLVMValueRef instances which correspond to the parameters the
  # function receives. Each LLVMValueRef corresponds to a llvm::Argument
  # instance.
  #
  # @see llvm::Function::arg_begin()
  #
  # @method get_params(fn, params)
  # @param [OpaqueValue] fn
  # @param [FFI::Pointer(*ValueRef)] params
  # @return [nil]
  # @scope class
  attach_function :get_params, :LLVMGetParams, [OpaqueValue, :pointer], :void

  # Obtain the parameter at the specified index.
  #
  # Parameters are indexed from 0.
  #
  # @see llvm::Function::arg_begin()
  #
  # @method get_param(fn, index)
  # @param [OpaqueValue] fn
  # @param [Integer] index
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_param, :LLVMGetParam, [OpaqueValue, :uint], OpaqueValue

  # Obtain the function to which this argument belongs.
  #
  # Unlike other functions in this group, this one takes an LLVMValueRef
  # that corresponds to a llvm::Attribute.
  #
  # The returned LLVMValueRef is the llvm::Function to which this
  # argument belongs.
  #
  # @method get_param_parent(inst)
  # @param [OpaqueValue] inst
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_param_parent, :LLVMGetParamParent, [OpaqueValue], OpaqueValue

  # Obtain the first parameter to a function.
  #
  # @see llvm::Function::arg_begin()
  #
  # @method get_first_param(fn)
  # @param [OpaqueValue] fn
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_first_param, :LLVMGetFirstParam, [OpaqueValue], OpaqueValue

  # Obtain the last parameter to a function.
  #
  # @see llvm::Function::arg_end()
  #
  # @method get_last_param(fn)
  # @param [OpaqueValue] fn
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_last_param, :LLVMGetLastParam, [OpaqueValue], OpaqueValue

  # Obtain the next parameter to a function.
  #
  # This takes an LLVMValueRef obtained from LLVMGetFirstParam() (which is
  # actually a wrapped iterator) and obtains the next parameter from the
  # underlying iterator.
  #
  # @method get_next_param(arg)
  # @param [OpaqueValue] arg
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_next_param, :LLVMGetNextParam, [OpaqueValue], OpaqueValue

  # Obtain the previous parameter to a function.
  #
  # This is the opposite of LLVMGetNextParam().
  #
  # @method get_previous_param(arg)
  # @param [OpaqueValue] arg
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_previous_param, :LLVMGetPreviousParam, [OpaqueValue], OpaqueValue

  # Add an attribute to a function argument.
  #
  # @see llvm::Argument::addAttr()
  #
  # @method add_attribute(arg, pa)
  # @param [OpaqueValue] arg
  # @param [Symbol from _enum_attribute_] pa
  # @return [nil]
  # @scope class
  attach_function :add_attribute, :LLVMAddAttribute, [OpaqueValue, :attribute], :void

  # Remove an attribute from a function argument.
  #
  # @see llvm::Argument::removeAttr()
  #
  # @method remove_attribute(arg, pa)
  # @param [OpaqueValue] arg
  # @param [Symbol from _enum_attribute_] pa
  # @return [nil]
  # @scope class
  attach_function :remove_attribute, :LLVMRemoveAttribute, [OpaqueValue, :attribute], :void

  # Get an attribute from a function argument.
  #
  # @method get_attribute(arg)
  # @param [OpaqueValue] arg
  # @return [Symbol from _enum_attribute_]
  # @scope class
  attach_function :get_attribute, :LLVMGetAttribute, [OpaqueValue], :attribute

  # Set the alignment for a function parameter.
  #
  # @see llvm::Argument::addAttr()
  # @see llvm::AttrBuilder::addAlignmentAttr()
  #
  # @method set_param_alignment(arg, align)
  # @param [OpaqueValue] arg
  # @param [Integer] align
  # @return [nil]
  # @scope class
  attach_function :set_param_alignment, :LLVMSetParamAlignment, [OpaqueValue, :uint], :void

  # Obtain a MDString value from a context.
  #
  # The returned instance corresponds to the llvm::MDString class.
  #
  # The instance is specified by string data of a specified length. The
  # string content is copied, so the backing memory can be freed after
  # this function returns.
  #
  # @method md_string_in_context(c, str, s_len)
  # @param [OpaqueContext] c
  # @param [String] str
  # @param [Integer] s_len
  # @return [OpaqueValue]
  # @scope class
  attach_function :md_string_in_context, :LLVMMDStringInContext, [OpaqueContext, :string, :uint], OpaqueValue

  # Obtain a MDString value from the global context.
  #
  # @method md_string(str, s_len)
  # @param [String] str
  # @param [Integer] s_len
  # @return [OpaqueValue]
  # @scope class
  attach_function :md_string, :LLVMMDString, [:string, :uint], OpaqueValue

  # Obtain a MDNode value from a context.
  #
  # The returned value corresponds to the llvm::MDNode class.
  #
  # @method md_node_in_context(c, vals, count)
  # @param [OpaqueContext] c
  # @param [FFI::Pointer(*ValueRef)] vals
  # @param [Integer] count
  # @return [OpaqueValue]
  # @scope class
  attach_function :md_node_in_context, :LLVMMDNodeInContext, [OpaqueContext, :pointer, :uint], OpaqueValue

  # Obtain a MDNode value from the global context.
  #
  # @method md_node(vals, count)
  # @param [FFI::Pointer(*ValueRef)] vals
  # @param [Integer] count
  # @return [OpaqueValue]
  # @scope class
  attach_function :md_node, :LLVMMDNode, [:pointer, :uint], OpaqueValue

  # Obtain the underlying string from a MDString value.
  #
  # @param V Instance to obtain string from.
  # @param Len Memory address which will hold length of returned string.
  # @return String data in MDString.
  #
  # @method get_md_string(v, len)
  # @param [OpaqueValue] v
  # @param [FFI::Pointer(*UInt)] len
  # @return [String]
  # @scope class
  attach_function :get_md_string, :LLVMGetMDString, [OpaqueValue, :pointer], :string

  # Obtain the number of operands from an MDNode value.
  #
  # @param V MDNode to get number of operands from.
  # @return Number of operands of the MDNode.
  #
  # @method get_md_node_num_operands(v)
  # @param [OpaqueValue] v
  # @return [Integer]
  # @scope class
  attach_function :get_md_node_num_operands, :LLVMGetMDNodeNumOperands, [OpaqueValue], :uint

  # Obtain the given MDNode's operands.
  #
  # The passed LLVMValueRef pointer should point to enough memory to hold all of
  # the operands of the given MDNode (see LLVMGetMDNodeNumOperands) as
  # LLVMValueRefs. This memory will be populated with the LLVMValueRefs of the
  # MDNode's operands.
  #
  # @param V MDNode to get the operands from.
  # @param Dest Destination array for operands.
  #
  # @method get_md_node_operands(v, dest)
  # @param [OpaqueValue] v
  # @param [FFI::Pointer(*ValueRef)] dest
  # @return [nil]
  # @scope class
  attach_function :get_md_node_operands, :LLVMGetMDNodeOperands, [OpaqueValue, :pointer], :void

  # Convert a basic block instance to a value type.
  #
  # @method basic_block_as_value(bb)
  # @param [OpaqueBasicBlock] bb
  # @return [OpaqueValue]
  # @scope class
  attach_function :basic_block_as_value, :LLVMBasicBlockAsValue, [OpaqueBasicBlock], OpaqueValue

  # Determine whether an LLVMValueRef is itself a basic block.
  #
  # @method value_is_basic_block(val)
  # @param [OpaqueValue] val
  # @return [Integer]
  # @scope class
  attach_function :value_is_basic_block, :LLVMValueIsBasicBlock, [OpaqueValue], :int

  # Convert an LLVMValueRef to an LLVMBasicBlockRef instance.
  #
  # @method value_as_basic_block(val)
  # @param [OpaqueValue] val
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :value_as_basic_block, :LLVMValueAsBasicBlock, [OpaqueValue], OpaqueBasicBlock

  # Obtain the function to which a basic block belongs.
  #
  # @see llvm::BasicBlock::getParent()
  #
  # @method get_basic_block_parent(bb)
  # @param [OpaqueBasicBlock] bb
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_basic_block_parent, :LLVMGetBasicBlockParent, [OpaqueBasicBlock], OpaqueValue

  # Obtain the terminator instruction for a basic block.
  #
  # If the basic block does not have a terminator (it is not well-formed
  # if it doesn't), then NULL is returned.
  #
  # The returned LLVMValueRef corresponds to a llvm::TerminatorInst.
  #
  # @see llvm::BasicBlock::getTerminator()
  #
  # @method get_basic_block_terminator(bb)
  # @param [OpaqueBasicBlock] bb
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_basic_block_terminator, :LLVMGetBasicBlockTerminator, [OpaqueBasicBlock], OpaqueValue

  # Obtain the number of basic blocks in a function.
  #
  # @param Fn Function value to operate on.
  #
  # @method count_basic_blocks(fn)
  # @param [OpaqueValue] fn
  # @return [Integer]
  # @scope class
  attach_function :count_basic_blocks, :LLVMCountBasicBlocks, [OpaqueValue], :uint

  # Obtain all of the basic blocks in a function.
  #
  # This operates on a function value. The BasicBlocks parameter is a
  # pointer to a pre-allocated array of LLVMBasicBlockRef of at least
  # LLVMCountBasicBlocks() in length. This array is populated with
  # LLVMBasicBlockRef instances.
  #
  # @method get_basic_blocks(fn, basic_blocks)
  # @param [OpaqueValue] fn
  # @param [FFI::Pointer(*BasicBlockRef)] basic_blocks
  # @return [nil]
  # @scope class
  attach_function :get_basic_blocks, :LLVMGetBasicBlocks, [OpaqueValue, :pointer], :void

  # Obtain the first basic block in a function.
  #
  # The returned basic block can be used as an iterator. You will likely
  # eventually call into LLVMGetNextBasicBlock() with it.
  #
  # @see llvm::Function::begin()
  #
  # @method get_first_basic_block(fn)
  # @param [OpaqueValue] fn
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :get_first_basic_block, :LLVMGetFirstBasicBlock, [OpaqueValue], OpaqueBasicBlock

  # Obtain the last basic block in a function.
  #
  # @see llvm::Function::end()
  #
  # @method get_last_basic_block(fn)
  # @param [OpaqueValue] fn
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :get_last_basic_block, :LLVMGetLastBasicBlock, [OpaqueValue], OpaqueBasicBlock

  # Advance a basic block iterator.
  #
  # @method get_next_basic_block(bb)
  # @param [OpaqueBasicBlock] bb
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :get_next_basic_block, :LLVMGetNextBasicBlock, [OpaqueBasicBlock], OpaqueBasicBlock

  # Go backwards in a basic block iterator.
  #
  # @method get_previous_basic_block(bb)
  # @param [OpaqueBasicBlock] bb
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :get_previous_basic_block, :LLVMGetPreviousBasicBlock, [OpaqueBasicBlock], OpaqueBasicBlock

  # Obtain the basic block that corresponds to the entry point of a
  # function.
  #
  # @see llvm::Function::getEntryBlock()
  #
  # @method get_entry_basic_block(fn)
  # @param [OpaqueValue] fn
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :get_entry_basic_block, :LLVMGetEntryBasicBlock, [OpaqueValue], OpaqueBasicBlock

  # Append a basic block to the end of a function.
  #
  # @see llvm::BasicBlock::Create()
  #
  # @method append_basic_block_in_context(c, fn, name)
  # @param [OpaqueContext] c
  # @param [OpaqueValue] fn
  # @param [String] name
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :append_basic_block_in_context, :LLVMAppendBasicBlockInContext, [OpaqueContext, OpaqueValue, :string], OpaqueBasicBlock

  # Append a basic block to the end of a function using the global
  # context.
  #
  # @see llvm::BasicBlock::Create()
  #
  # @method append_basic_block(fn, name)
  # @param [OpaqueValue] fn
  # @param [String] name
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :append_basic_block, :LLVMAppendBasicBlock, [OpaqueValue, :string], OpaqueBasicBlock

  # Insert a basic block in a function before another basic block.
  #
  # The function to add to is determined by the function of the
  # passed basic block.
  #
  # @see llvm::BasicBlock::Create()
  #
  # @method insert_basic_block_in_context(c, bb, name)
  # @param [OpaqueContext] c
  # @param [OpaqueBasicBlock] bb
  # @param [String] name
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :insert_basic_block_in_context, :LLVMInsertBasicBlockInContext, [OpaqueContext, OpaqueBasicBlock, :string], OpaqueBasicBlock

  # Insert a basic block in a function using the global context.
  #
  # @see llvm::BasicBlock::Create()
  #
  # @method insert_basic_block(insert_before_bb, name)
  # @param [OpaqueBasicBlock] insert_before_bb
  # @param [String] name
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :insert_basic_block, :LLVMInsertBasicBlock, [OpaqueBasicBlock, :string], OpaqueBasicBlock

  # Remove a basic block from a function and delete it.
  #
  # This deletes the basic block from its containing function and deletes
  # the basic block itself.
  #
  # @see llvm::BasicBlock::eraseFromParent()
  #
  # @method delete_basic_block(bb)
  # @param [OpaqueBasicBlock] bb
  # @return [nil]
  # @scope class
  attach_function :delete_basic_block, :LLVMDeleteBasicBlock, [OpaqueBasicBlock], :void

  # Remove a basic block from a function.
  #
  # This deletes the basic block from its containing function but keep
  # the basic block alive.
  #
  # @see llvm::BasicBlock::removeFromParent()
  #
  # @method remove_basic_block_from_parent(bb)
  # @param [OpaqueBasicBlock] bb
  # @return [nil]
  # @scope class
  attach_function :remove_basic_block_from_parent, :LLVMRemoveBasicBlockFromParent, [OpaqueBasicBlock], :void

  # Move a basic block to before another one.
  #
  # @see llvm::BasicBlock::moveBefore()
  #
  # @method move_basic_block_before(bb, move_pos)
  # @param [OpaqueBasicBlock] bb
  # @param [OpaqueBasicBlock] move_pos
  # @return [nil]
  # @scope class
  attach_function :move_basic_block_before, :LLVMMoveBasicBlockBefore, [OpaqueBasicBlock, OpaqueBasicBlock], :void

  # Move a basic block to after another one.
  #
  # @see llvm::BasicBlock::moveAfter()
  #
  # @method move_basic_block_after(bb, move_pos)
  # @param [OpaqueBasicBlock] bb
  # @param [OpaqueBasicBlock] move_pos
  # @return [nil]
  # @scope class
  attach_function :move_basic_block_after, :LLVMMoveBasicBlockAfter, [OpaqueBasicBlock, OpaqueBasicBlock], :void

  # Obtain the first instruction in a basic block.
  #
  # The returned LLVMValueRef corresponds to a llvm::Instruction
  # instance.
  #
  # @method get_first_instruction(bb)
  # @param [OpaqueBasicBlock] bb
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_first_instruction, :LLVMGetFirstInstruction, [OpaqueBasicBlock], OpaqueValue

  # Obtain the last instruction in a basic block.
  #
  # The returned LLVMValueRef corresponds to an LLVM:Instruction.
  #
  # @method get_last_instruction(bb)
  # @param [OpaqueBasicBlock] bb
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_last_instruction, :LLVMGetLastInstruction, [OpaqueBasicBlock], OpaqueValue

  # Determine whether an instruction has any metadata attached.
  #
  # @method has_metadata(val)
  # @param [OpaqueValue] val
  # @return [Integer]
  # @scope class
  attach_function :has_metadata, :LLVMHasMetadata, [OpaqueValue], :int

  # Return metadata associated with an instruction value.
  #
  # @method get_metadata(val, kind_id)
  # @param [OpaqueValue] val
  # @param [Integer] kind_id
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_metadata, :LLVMGetMetadata, [OpaqueValue, :uint], OpaqueValue

  # Set metadata associated with an instruction value.
  #
  # @method set_metadata(val, kind_id, node)
  # @param [OpaqueValue] val
  # @param [Integer] kind_id
  # @param [OpaqueValue] node
  # @return [nil]
  # @scope class
  attach_function :set_metadata, :LLVMSetMetadata, [OpaqueValue, :uint, OpaqueValue], :void

  # Obtain the basic block to which an instruction belongs.
  #
  # @see llvm::Instruction::getParent()
  #
  # @method get_instruction_parent(inst)
  # @param [OpaqueValue] inst
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :get_instruction_parent, :LLVMGetInstructionParent, [OpaqueValue], OpaqueBasicBlock

  # Obtain the instruction that occurs after the one specified.
  #
  # The next instruction will be from the same basic block.
  #
  # If this is the last instruction in a basic block, NULL will be
  # returned.
  #
  # @method get_next_instruction(inst)
  # @param [OpaqueValue] inst
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_next_instruction, :LLVMGetNextInstruction, [OpaqueValue], OpaqueValue

  # Obtain the instruction that occurred before this one.
  #
  # If the instruction is the first instruction in a basic block, NULL
  # will be returned.
  #
  # @method get_previous_instruction(inst)
  # @param [OpaqueValue] inst
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_previous_instruction, :LLVMGetPreviousInstruction, [OpaqueValue], OpaqueValue

  # Remove and delete an instruction.
  #
  # The instruction specified is removed from its containing building
  # block and then deleted.
  #
  # @see llvm::Instruction::eraseFromParent()
  #
  # @method instruction_erase_from_parent(inst)
  # @param [OpaqueValue] inst
  # @return [nil]
  # @scope class
  attach_function :instruction_erase_from_parent, :LLVMInstructionEraseFromParent, [OpaqueValue], :void

  # Obtain the code opcode for an individual instruction.
  #
  # @see llvm::Instruction::getOpCode()
  #
  # @method get_instruction_opcode(inst)
  # @param [OpaqueValue] inst
  # @return [Symbol from _enum_opcode_]
  # @scope class
  attach_function :get_instruction_opcode, :LLVMGetInstructionOpcode, [OpaqueValue], :opcode

  # Obtain the predicate of an instruction.
  #
  # This is only valid for instructions that correspond to llvm::ICmpInst
  # or llvm::ConstantExpr whose opcode is llvm::Instruction::ICmp.
  #
  # @see llvm::ICmpInst::getPredicate()
  #
  # @method get_i_cmp_predicate(inst)
  # @param [OpaqueValue] inst
  # @return [Symbol from _enum_int_predicate_]
  # @scope class
  attach_function :get_i_cmp_predicate, :LLVMGetICmpPredicate, [OpaqueValue], :int_predicate

  # Set the calling convention for a call instruction.
  #
  # This expects an LLVMValueRef that corresponds to a llvm::CallInst or
  # llvm::InvokeInst.
  #
  # @see llvm::CallInst::setCallingConv()
  # @see llvm::InvokeInst::setCallingConv()
  #
  # @method set_instruction_call_conv(instr, cc)
  # @param [OpaqueValue] instr
  # @param [Integer] cc
  # @return [nil]
  # @scope class
  attach_function :set_instruction_call_conv, :LLVMSetInstructionCallConv, [OpaqueValue, :uint], :void

  # Obtain the calling convention for a call instruction.
  #
  # This is the opposite of LLVMSetInstructionCallConv(). Reads its
  # usage.
  #
  # @see LLVMSetInstructionCallConv()
  #
  # @method get_instruction_call_conv(instr)
  # @param [OpaqueValue] instr
  # @return [Integer]
  # @scope class
  attach_function :get_instruction_call_conv, :LLVMGetInstructionCallConv, [OpaqueValue], :uint

  # (Not documented)
  #
  # @method add_instr_attribute(instr, index, attribute)
  # @param [OpaqueValue] instr
  # @param [Integer] index
  # @param [Symbol from _enum_attribute_] attribute
  # @return [nil]
  # @scope class
  attach_function :add_instr_attribute, :LLVMAddInstrAttribute, [OpaqueValue, :uint, :attribute], :void

  # (Not documented)
  #
  # @method remove_instr_attribute(instr, index, attribute)
  # @param [OpaqueValue] instr
  # @param [Integer] index
  # @param [Symbol from _enum_attribute_] attribute
  # @return [nil]
  # @scope class
  attach_function :remove_instr_attribute, :LLVMRemoveInstrAttribute, [OpaqueValue, :uint, :attribute], :void

  # (Not documented)
  #
  # @method set_instr_param_alignment(instr, index, align)
  # @param [OpaqueValue] instr
  # @param [Integer] index
  # @param [Integer] align
  # @return [nil]
  # @scope class
  attach_function :set_instr_param_alignment, :LLVMSetInstrParamAlignment, [OpaqueValue, :uint, :uint], :void

  # Obtain whether a call instruction is a tail call.
  #
  # This only works on llvm::CallInst instructions.
  #
  # @see llvm::CallInst::isTailCall()
  #
  # @method is_tail_call(call_inst)
  # @param [OpaqueValue] call_inst
  # @return [Integer]
  # @scope class
  attach_function :is_tail_call, :LLVMIsTailCall, [OpaqueValue], :int

  # Set whether a call instruction is a tail call.
  #
  # This only works on llvm::CallInst instructions.
  #
  # @see llvm::CallInst::setTailCall()
  #
  # @method set_tail_call(call_inst, is_tail_call)
  # @param [OpaqueValue] call_inst
  # @param [Integer] is_tail_call
  # @return [nil]
  # @scope class
  attach_function :set_tail_call, :LLVMSetTailCall, [OpaqueValue, :int], :void

  # Obtain the default destination basic block of a switch instruction.
  #
  # This only works on llvm::SwitchInst instructions.
  #
  # @see llvm::SwitchInst::getDefaultDest()
  #
  # @method get_switch_default_dest(switch_instr)
  # @param [OpaqueValue] switch_instr
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :get_switch_default_dest, :LLVMGetSwitchDefaultDest, [OpaqueValue], OpaqueBasicBlock

  # Add an incoming value to the end of a PHI list.
  #
  # @method add_incoming(phi_node, incoming_values, incoming_blocks, count)
  # @param [OpaqueValue] phi_node
  # @param [FFI::Pointer(*ValueRef)] incoming_values
  # @param [FFI::Pointer(*BasicBlockRef)] incoming_blocks
  # @param [Integer] count
  # @return [nil]
  # @scope class
  attach_function :add_incoming, :LLVMAddIncoming, [OpaqueValue, :pointer, :pointer, :uint], :void

  # Obtain the number of incoming basic blocks to a PHI node.
  #
  # @method count_incoming(phi_node)
  # @param [OpaqueValue] phi_node
  # @return [Integer]
  # @scope class
  attach_function :count_incoming, :LLVMCountIncoming, [OpaqueValue], :uint

  # Obtain an incoming value to a PHI node as an LLVMValueRef.
  #
  # @method get_incoming_value(phi_node, index)
  # @param [OpaqueValue] phi_node
  # @param [Integer] index
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_incoming_value, :LLVMGetIncomingValue, [OpaqueValue, :uint], OpaqueValue

  # Obtain an incoming value to a PHI node as an LLVMBasicBlockRef.
  #
  # @method get_incoming_block(phi_node, index)
  # @param [OpaqueValue] phi_node
  # @param [Integer] index
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :get_incoming_block, :LLVMGetIncomingBlock, [OpaqueValue, :uint], OpaqueBasicBlock

  # @defgroup LLVMCCoreInstructionBuilder Instruction Builders
  #
  # An instruction builder represents a point within a basic block and is
  # the exclusive means of building instructions using the C interface.
  #
  # @{
  #
  # @method create_builder_in_context(c)
  # @param [OpaqueContext] c
  # @return [OpaqueBuilder]
  # @scope class
  attach_function :create_builder_in_context, :LLVMCreateBuilderInContext, [OpaqueContext], OpaqueBuilder

  # (Not documented)
  #
  # @method create_builder()
  # @return [OpaqueBuilder]
  # @scope class
  attach_function :create_builder, :LLVMCreateBuilder, [], OpaqueBuilder

  # (Not documented)
  #
  # @method position_builder(builder, block, instr)
  # @param [OpaqueBuilder] builder
  # @param [OpaqueBasicBlock] block
  # @param [OpaqueValue] instr
  # @return [nil]
  # @scope class
  attach_function :position_builder, :LLVMPositionBuilder, [OpaqueBuilder, OpaqueBasicBlock, OpaqueValue], :void

  # (Not documented)
  #
  # @method position_builder_before(builder, instr)
  # @param [OpaqueBuilder] builder
  # @param [OpaqueValue] instr
  # @return [nil]
  # @scope class
  attach_function :position_builder_before, :LLVMPositionBuilderBefore, [OpaqueBuilder, OpaqueValue], :void

  # (Not documented)
  #
  # @method position_builder_at_end(builder, block)
  # @param [OpaqueBuilder] builder
  # @param [OpaqueBasicBlock] block
  # @return [nil]
  # @scope class
  attach_function :position_builder_at_end, :LLVMPositionBuilderAtEnd, [OpaqueBuilder, OpaqueBasicBlock], :void

  # (Not documented)
  #
  # @method get_insert_block(builder)
  # @param [OpaqueBuilder] builder
  # @return [OpaqueBasicBlock]
  # @scope class
  attach_function :get_insert_block, :LLVMGetInsertBlock, [OpaqueBuilder], OpaqueBasicBlock

  # (Not documented)
  #
  # @method clear_insertion_position(builder)
  # @param [OpaqueBuilder] builder
  # @return [nil]
  # @scope class
  attach_function :clear_insertion_position, :LLVMClearInsertionPosition, [OpaqueBuilder], :void

  # (Not documented)
  #
  # @method insert_into_builder(builder, instr)
  # @param [OpaqueBuilder] builder
  # @param [OpaqueValue] instr
  # @return [nil]
  # @scope class
  attach_function :insert_into_builder, :LLVMInsertIntoBuilder, [OpaqueBuilder, OpaqueValue], :void

  # (Not documented)
  #
  # @method insert_into_builder_with_name(builder, instr, name)
  # @param [OpaqueBuilder] builder
  # @param [OpaqueValue] instr
  # @param [String] name
  # @return [nil]
  # @scope class
  attach_function :insert_into_builder_with_name, :LLVMInsertIntoBuilderWithName, [OpaqueBuilder, OpaqueValue, :string], :void

  # (Not documented)
  #
  # @method dispose_builder(builder)
  # @param [OpaqueBuilder] builder
  # @return [nil]
  # @scope class
  attach_function :dispose_builder, :LLVMDisposeBuilder, [OpaqueBuilder], :void

  # Metadata
  #
  # @method set_current_debug_location(builder, l)
  # @param [OpaqueBuilder] builder
  # @param [OpaqueValue] l
  # @return [nil]
  # @scope class
  attach_function :set_current_debug_location, :LLVMSetCurrentDebugLocation, [OpaqueBuilder, OpaqueValue], :void

  # (Not documented)
  #
  # @method get_current_debug_location(builder)
  # @param [OpaqueBuilder] builder
  # @return [OpaqueValue]
  # @scope class
  attach_function :get_current_debug_location, :LLVMGetCurrentDebugLocation, [OpaqueBuilder], OpaqueValue

  # (Not documented)
  #
  # @method set_inst_debug_location(builder, inst)
  # @param [OpaqueBuilder] builder
  # @param [OpaqueValue] inst
  # @return [nil]
  # @scope class
  attach_function :set_inst_debug_location, :LLVMSetInstDebugLocation, [OpaqueBuilder, OpaqueValue], :void

  # Terminators
  #
  # @method build_ret_void(opaque_builder)
  # @param [OpaqueBuilder] opaque_builder
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_ret_void, :LLVMBuildRetVoid, [OpaqueBuilder], OpaqueValue

  # (Not documented)
  #
  # @method build_ret(opaque_builder, v)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] v
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_ret, :LLVMBuildRet, [OpaqueBuilder, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method build_aggregate_ret(opaque_builder, ret_vals, n)
  # @param [OpaqueBuilder] opaque_builder
  # @param [FFI::Pointer(*ValueRef)] ret_vals
  # @param [Integer] n
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_aggregate_ret, :LLVMBuildAggregateRet, [OpaqueBuilder, :pointer, :uint], OpaqueValue

  # (Not documented)
  #
  # @method build_br(opaque_builder, dest)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueBasicBlock] dest
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_br, :LLVMBuildBr, [OpaqueBuilder, OpaqueBasicBlock], OpaqueValue

  # (Not documented)
  #
  # @method build_cond_br(opaque_builder, if_, then_, else_)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] if_
  # @param [OpaqueBasicBlock] then_
  # @param [OpaqueBasicBlock] else_
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_cond_br, :LLVMBuildCondBr, [OpaqueBuilder, OpaqueValue, OpaqueBasicBlock, OpaqueBasicBlock], OpaqueValue

  # (Not documented)
  #
  # @method build_switch(opaque_builder, v, else_, num_cases)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] v
  # @param [OpaqueBasicBlock] else_
  # @param [Integer] num_cases
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_switch, :LLVMBuildSwitch, [OpaqueBuilder, OpaqueValue, OpaqueBasicBlock, :uint], OpaqueValue

  # (Not documented)
  #
  # @method build_indirect_br(b, addr, num_dests)
  # @param [OpaqueBuilder] b
  # @param [OpaqueValue] addr
  # @param [Integer] num_dests
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_indirect_br, :LLVMBuildIndirectBr, [OpaqueBuilder, OpaqueValue, :uint], OpaqueValue

  # (Not documented)
  #
  # @method build_invoke(opaque_builder, fn, args, num_args, then_, catch, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] fn
  # @param [FFI::Pointer(*ValueRef)] args
  # @param [Integer] num_args
  # @param [OpaqueBasicBlock] then_
  # @param [OpaqueBasicBlock] catch
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_invoke, :LLVMBuildInvoke, [OpaqueBuilder, OpaqueValue, :pointer, :uint, OpaqueBasicBlock, OpaqueBasicBlock, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_landing_pad(b, ty, pers_fn, num_clauses, name)
  # @param [OpaqueBuilder] b
  # @param [OpaqueType] ty
  # @param [OpaqueValue] pers_fn
  # @param [Integer] num_clauses
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_landing_pad, :LLVMBuildLandingPad, [OpaqueBuilder, OpaqueType, OpaqueValue, :uint, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_resume(b, exn)
  # @param [OpaqueBuilder] b
  # @param [OpaqueValue] exn
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_resume, :LLVMBuildResume, [OpaqueBuilder, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method build_unreachable(opaque_builder)
  # @param [OpaqueBuilder] opaque_builder
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_unreachable, :LLVMBuildUnreachable, [OpaqueBuilder], OpaqueValue

  # Add a case to the switch instruction
  #
  # @method add_case(switch, on_val, dest)
  # @param [OpaqueValue] switch
  # @param [OpaqueValue] on_val
  # @param [OpaqueBasicBlock] dest
  # @return [nil]
  # @scope class
  attach_function :add_case, :LLVMAddCase, [OpaqueValue, OpaqueValue, OpaqueBasicBlock], :void

  # Add a destination to the indirectbr instruction
  #
  # @method add_destination(indirect_br, dest)
  # @param [OpaqueValue] indirect_br
  # @param [OpaqueBasicBlock] dest
  # @return [nil]
  # @scope class
  attach_function :add_destination, :LLVMAddDestination, [OpaqueValue, OpaqueBasicBlock], :void

  # Add a catch or filter clause to the landingpad instruction
  #
  # @method add_clause(landing_pad, clause_val)
  # @param [OpaqueValue] landing_pad
  # @param [OpaqueValue] clause_val
  # @return [nil]
  # @scope class
  attach_function :add_clause, :LLVMAddClause, [OpaqueValue, OpaqueValue], :void

  # Set the 'cleanup' flag in the landingpad instruction
  #
  # @method set_cleanup(landing_pad, val)
  # @param [OpaqueValue] landing_pad
  # @param [Integer] val
  # @return [nil]
  # @scope class
  attach_function :set_cleanup, :LLVMSetCleanup, [OpaqueValue, :int], :void

  # Arithmetic
  #
  # @method build_add(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_add, :LLVMBuildAdd, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_nsw_add(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_nsw_add, :LLVMBuildNSWAdd, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_nuw_add(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_nuw_add, :LLVMBuildNUWAdd, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_f_add(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_f_add, :LLVMBuildFAdd, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_sub(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_sub, :LLVMBuildSub, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_nsw_sub(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_nsw_sub, :LLVMBuildNSWSub, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_nuw_sub(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_nuw_sub, :LLVMBuildNUWSub, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_f_sub(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_f_sub, :LLVMBuildFSub, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_mul(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_mul, :LLVMBuildMul, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_nsw_mul(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_nsw_mul, :LLVMBuildNSWMul, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_nuw_mul(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_nuw_mul, :LLVMBuildNUWMul, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_f_mul(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_f_mul, :LLVMBuildFMul, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_u_div(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_u_div, :LLVMBuildUDiv, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_s_div(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_s_div, :LLVMBuildSDiv, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_exact_s_div(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_exact_s_div, :LLVMBuildExactSDiv, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_f_div(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_f_div, :LLVMBuildFDiv, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_u_rem(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_u_rem, :LLVMBuildURem, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_s_rem(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_s_rem, :LLVMBuildSRem, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_f_rem(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_f_rem, :LLVMBuildFRem, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_shl(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_shl, :LLVMBuildShl, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_l_shr(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_l_shr, :LLVMBuildLShr, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_a_shr(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_a_shr, :LLVMBuildAShr, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_and(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_and, :LLVMBuildAnd, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_or(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_or, :LLVMBuildOr, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_xor(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_xor, :LLVMBuildXor, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_bin_op(b, op, lhs, rhs, name)
  # @param [OpaqueBuilder] b
  # @param [Symbol from _enum_opcode_] op
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_bin_op, :LLVMBuildBinOp, [OpaqueBuilder, :opcode, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_neg(opaque_builder, v, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] v
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_neg, :LLVMBuildNeg, [OpaqueBuilder, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_nsw_neg(b, v, name)
  # @param [OpaqueBuilder] b
  # @param [OpaqueValue] v
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_nsw_neg, :LLVMBuildNSWNeg, [OpaqueBuilder, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_nuw_neg(b, v, name)
  # @param [OpaqueBuilder] b
  # @param [OpaqueValue] v
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_nuw_neg, :LLVMBuildNUWNeg, [OpaqueBuilder, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_f_neg(opaque_builder, v, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] v
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_f_neg, :LLVMBuildFNeg, [OpaqueBuilder, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_not(opaque_builder, v, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] v
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_not, :LLVMBuildNot, [OpaqueBuilder, OpaqueValue, :string], OpaqueValue

  # Memory
  #
  # @method build_malloc(opaque_builder, ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueType] ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_malloc, :LLVMBuildMalloc, [OpaqueBuilder, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_array_malloc(opaque_builder, ty, val, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueType] ty
  # @param [OpaqueValue] val
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_array_malloc, :LLVMBuildArrayMalloc, [OpaqueBuilder, OpaqueType, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_alloca(opaque_builder, ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueType] ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_alloca, :LLVMBuildAlloca, [OpaqueBuilder, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_array_alloca(opaque_builder, ty, val, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueType] ty
  # @param [OpaqueValue] val
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_array_alloca, :LLVMBuildArrayAlloca, [OpaqueBuilder, OpaqueType, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_free(opaque_builder, pointer_val)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] pointer_val
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_free, :LLVMBuildFree, [OpaqueBuilder, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method build_load(opaque_builder, pointer_val, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] pointer_val
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_load, :LLVMBuildLoad, [OpaqueBuilder, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_store(opaque_builder, val, ptr)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueValue] ptr
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_store, :LLVMBuildStore, [OpaqueBuilder, OpaqueValue, OpaqueValue], OpaqueValue

  # (Not documented)
  #
  # @method build_gep(b, pointer, indices, num_indices, name)
  # @param [OpaqueBuilder] b
  # @param [OpaqueValue] pointer
  # @param [FFI::Pointer(*ValueRef)] indices
  # @param [Integer] num_indices
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_gep, :LLVMBuildGEP, [OpaqueBuilder, OpaqueValue, :pointer, :uint, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_in_bounds_gep(b, pointer, indices, num_indices, name)
  # @param [OpaqueBuilder] b
  # @param [OpaqueValue] pointer
  # @param [FFI::Pointer(*ValueRef)] indices
  # @param [Integer] num_indices
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_in_bounds_gep, :LLVMBuildInBoundsGEP, [OpaqueBuilder, OpaqueValue, :pointer, :uint, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_struct_gep(b, pointer, idx, name)
  # @param [OpaqueBuilder] b
  # @param [OpaqueValue] pointer
  # @param [Integer] idx
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_struct_gep, :LLVMBuildStructGEP, [OpaqueBuilder, OpaqueValue, :uint, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_global_string(b, str, name)
  # @param [OpaqueBuilder] b
  # @param [String] str
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_global_string, :LLVMBuildGlobalString, [OpaqueBuilder, :string, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_global_string_ptr(b, str, name)
  # @param [OpaqueBuilder] b
  # @param [String] str
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_global_string_ptr, :LLVMBuildGlobalStringPtr, [OpaqueBuilder, :string, :string], OpaqueValue

  # (Not documented)
  #
  # @method get_volatile(memory_access_inst)
  # @param [OpaqueValue] memory_access_inst
  # @return [Integer]
  # @scope class
  attach_function :get_volatile, :LLVMGetVolatile, [OpaqueValue], :int

  # (Not documented)
  #
  # @method set_volatile(memory_access_inst, is_volatile)
  # @param [OpaqueValue] memory_access_inst
  # @param [Integer] is_volatile
  # @return [nil]
  # @scope class
  attach_function :set_volatile, :LLVMSetVolatile, [OpaqueValue, :int], :void

  # Casts
  #
  # @method build_trunc(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_trunc, :LLVMBuildTrunc, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_z_ext(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_z_ext, :LLVMBuildZExt, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_s_ext(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_s_ext, :LLVMBuildSExt, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_fp_to_ui(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_fp_to_ui, :LLVMBuildFPToUI, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_fp_to_si(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_fp_to_si, :LLVMBuildFPToSI, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_ui_to_fp(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_ui_to_fp, :LLVMBuildUIToFP, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_si_to_fp(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_si_to_fp, :LLVMBuildSIToFP, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_fp_trunc(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_fp_trunc, :LLVMBuildFPTrunc, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_fp_ext(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_fp_ext, :LLVMBuildFPExt, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_ptr_to_int(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_ptr_to_int, :LLVMBuildPtrToInt, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_int_to_ptr(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_int_to_ptr, :LLVMBuildIntToPtr, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_bit_cast(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_bit_cast, :LLVMBuildBitCast, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_addr_space_cast(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_addr_space_cast, :LLVMBuildAddrSpaceCast, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_z_ext_or_bit_cast(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_z_ext_or_bit_cast, :LLVMBuildZExtOrBitCast, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_s_ext_or_bit_cast(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_s_ext_or_bit_cast, :LLVMBuildSExtOrBitCast, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_trunc_or_bit_cast(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_trunc_or_bit_cast, :LLVMBuildTruncOrBitCast, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_cast(b, op, val, dest_ty, name)
  # @param [OpaqueBuilder] b
  # @param [Symbol from _enum_opcode_] op
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_cast, :LLVMBuildCast, [OpaqueBuilder, :opcode, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_pointer_cast(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_pointer_cast, :LLVMBuildPointerCast, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_int_cast(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_int_cast, :LLVMBuildIntCast, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_fp_cast(opaque_builder, val, dest_ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [OpaqueType] dest_ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_fp_cast, :LLVMBuildFPCast, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # Comparisons
  #
  # @method build_i_cmp(opaque_builder, op, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [Symbol from _enum_int_predicate_] op
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_i_cmp, :LLVMBuildICmp, [OpaqueBuilder, :int_predicate, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_f_cmp(opaque_builder, op, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [Symbol from _enum_real_predicate_] op
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_f_cmp, :LLVMBuildFCmp, [OpaqueBuilder, :real_predicate, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # Miscellaneous instructions
  #
  # @method build_phi(opaque_builder, ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueType] ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_phi, :LLVMBuildPhi, [OpaqueBuilder, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_call(opaque_builder, fn, args, num_args, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] fn
  # @param [FFI::Pointer(*ValueRef)] args
  # @param [Integer] num_args
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_call, :LLVMBuildCall, [OpaqueBuilder, OpaqueValue, :pointer, :uint, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_select(opaque_builder, if_, then_, else_, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] if_
  # @param [OpaqueValue] then_
  # @param [OpaqueValue] else_
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_select, :LLVMBuildSelect, [OpaqueBuilder, OpaqueValue, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_va_arg(opaque_builder, list, ty, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] list
  # @param [OpaqueType] ty
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_va_arg, :LLVMBuildVAArg, [OpaqueBuilder, OpaqueValue, OpaqueType, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_extract_element(opaque_builder, vec_val, index, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] vec_val
  # @param [OpaqueValue] index
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_extract_element, :LLVMBuildExtractElement, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_insert_element(opaque_builder, vec_val, elt_val, index, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] vec_val
  # @param [OpaqueValue] elt_val
  # @param [OpaqueValue] index
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_insert_element, :LLVMBuildInsertElement, [OpaqueBuilder, OpaqueValue, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_shuffle_vector(opaque_builder, v1, v2, mask, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] v1
  # @param [OpaqueValue] v2
  # @param [OpaqueValue] mask
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_shuffle_vector, :LLVMBuildShuffleVector, [OpaqueBuilder, OpaqueValue, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_extract_value(opaque_builder, agg_val, index, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] agg_val
  # @param [Integer] index
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_extract_value, :LLVMBuildExtractValue, [OpaqueBuilder, OpaqueValue, :uint, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_insert_value(opaque_builder, agg_val, elt_val, index, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] agg_val
  # @param [OpaqueValue] elt_val
  # @param [Integer] index
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_insert_value, :LLVMBuildInsertValue, [OpaqueBuilder, OpaqueValue, OpaqueValue, :uint, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_is_null(opaque_builder, val, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_is_null, :LLVMBuildIsNull, [OpaqueBuilder, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_is_not_null(opaque_builder, val, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] val
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_is_not_null, :LLVMBuildIsNotNull, [OpaqueBuilder, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_ptr_diff(opaque_builder, lhs, rhs, name)
  # @param [OpaqueBuilder] opaque_builder
  # @param [OpaqueValue] lhs
  # @param [OpaqueValue] rhs
  # @param [String] name
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_ptr_diff, :LLVMBuildPtrDiff, [OpaqueBuilder, OpaqueValue, OpaqueValue, :string], OpaqueValue

  # (Not documented)
  #
  # @method build_atomic_rmw(b, op, ptr, val, ordering, single_thread)
  # @param [OpaqueBuilder] b
  # @param [Symbol from _enum_atomic_rmw_bin_op_] op
  # @param [OpaqueValue] ptr
  # @param [OpaqueValue] val
  # @param [Symbol from _enum_atomic_ordering_] ordering
  # @param [Integer] single_thread
  # @return [OpaqueValue]
  # @scope class
  attach_function :build_atomic_rmw, :LLVMBuildAtomicRMW, [OpaqueBuilder, :atomic_rmw_bin_op, OpaqueValue, OpaqueValue, :atomic_ordering, :int], OpaqueValue

  # Changes the type of M so it can be passed to FunctionPassManagers and the
  # JIT.  They take ModuleProviders for historical reasons.
  #
  # @method create_module_provider_for_existing_module(m)
  # @param [OpaqueModule] m
  # @return [OpaqueModuleProvider]
  # @scope class
  attach_function :create_module_provider_for_existing_module, :LLVMCreateModuleProviderForExistingModule, [OpaqueModule], OpaqueModuleProvider

  # Destroys the module M.
  #
  # @method dispose_module_provider(m)
  # @param [OpaqueModuleProvider] m
  # @return [nil]
  # @scope class
  attach_function :dispose_module_provider, :LLVMDisposeModuleProvider, [OpaqueModuleProvider], :void

  # @defgroup LLVMCCoreMemoryBuffers Memory Buffers
  #
  # @{
  #
  # @method create_memory_buffer_with_contents_of_file(path, out_mem_buf, out_message)
  # @param [String] path
  # @param [FFI::Pointer(*MemoryBufferRef)] out_mem_buf
  # @param [FFI::Pointer(**CharS)] out_message
  # @return [Integer]
  # @scope class
  attach_function :create_memory_buffer_with_contents_of_file, :LLVMCreateMemoryBufferWithContentsOfFile, [:string, :pointer, :pointer], :int

  # (Not documented)
  #
  # @method create_memory_buffer_with_stdin(out_mem_buf, out_message)
  # @param [FFI::Pointer(*MemoryBufferRef)] out_mem_buf
  # @param [FFI::Pointer(**CharS)] out_message
  # @return [Integer]
  # @scope class
  attach_function :create_memory_buffer_with_stdin, :LLVMCreateMemoryBufferWithSTDIN, [:pointer, :pointer], :int

  # (Not documented)
  #
  # @method create_memory_buffer_with_memory_range(input_data, input_data_length, buffer_name, requires_null_terminator)
  # @param [String] input_data
  # @param [Integer] input_data_length
  # @param [String] buffer_name
  # @param [Integer] requires_null_terminator
  # @return [OpaqueMemoryBuffer]
  # @scope class
  attach_function :create_memory_buffer_with_memory_range, :LLVMCreateMemoryBufferWithMemoryRange, [:string, :ulong, :string, :int], OpaqueMemoryBuffer

  # (Not documented)
  #
  # @method create_memory_buffer_with_memory_range_copy(input_data, input_data_length, buffer_name)
  # @param [String] input_data
  # @param [Integer] input_data_length
  # @param [String] buffer_name
  # @return [OpaqueMemoryBuffer]
  # @scope class
  attach_function :create_memory_buffer_with_memory_range_copy, :LLVMCreateMemoryBufferWithMemoryRangeCopy, [:string, :ulong, :string], OpaqueMemoryBuffer

  # (Not documented)
  #
  # @method get_buffer_start(mem_buf)
  # @param [OpaqueMemoryBuffer] mem_buf
  # @return [String]
  # @scope class
  attach_function :get_buffer_start, :LLVMGetBufferStart, [OpaqueMemoryBuffer], :string

  # (Not documented)
  #
  # @method get_buffer_size(mem_buf)
  # @param [OpaqueMemoryBuffer] mem_buf
  # @return [Integer]
  # @scope class
  attach_function :get_buffer_size, :LLVMGetBufferSize, [OpaqueMemoryBuffer], :ulong

  # (Not documented)
  #
  # @method dispose_memory_buffer(mem_buf)
  # @param [OpaqueMemoryBuffer] mem_buf
  # @return [nil]
  # @scope class
  attach_function :dispose_memory_buffer, :LLVMDisposeMemoryBuffer, [OpaqueMemoryBuffer], :void

  # Return the global pass registry, for use with initialization functions.
  #     @see llvm::PassRegistry::getPassRegistry
  #
  # @method get_global_pass_registry()
  # @return [OpaquePassRegistry]
  # @scope class
  attach_function :get_global_pass_registry, :LLVMGetGlobalPassRegistry, [], OpaquePassRegistry

  # Constructs a new whole-module pass pipeline. This type of pipeline is
  #     suitable for link-time optimization and whole-module transformations.
  #     @see llvm::PassManager::PassManager
  #
  # @method create_pass_manager()
  # @return [OpaquePassManager]
  # @scope class
  attach_function :create_pass_manager, :LLVMCreatePassManager, [], OpaquePassManager

  # Constructs a new function-by-function pass pipeline over the module
  #     provider. It does not take ownership of the module provider. This type of
  #     pipeline is suitable for code generation and JIT compilation tasks.
  #     @see llvm::FunctionPassManager::FunctionPassManager
  #
  # @method create_function_pass_manager_for_module(m)
  # @param [OpaqueModule] m
  # @return [OpaquePassManager]
  # @scope class
  attach_function :create_function_pass_manager_for_module, :LLVMCreateFunctionPassManagerForModule, [OpaqueModule], OpaquePassManager

  # Deprecated: Use LLVMCreateFunctionPassManagerForModule instead.
  #
  # @method create_function_pass_manager(mp)
  # @param [OpaqueModuleProvider] mp
  # @return [OpaquePassManager]
  # @scope class
  attach_function :create_function_pass_manager, :LLVMCreateFunctionPassManager, [OpaqueModuleProvider], OpaquePassManager

  # Initializes, executes on the provided module, and finalizes all of the
  #     passes scheduled in the pass manager. Returns 1 if any of the passes
  #     modified the module, 0 otherwise.
  #     @see llvm::PassManager::run(Module&)
  #
  # @method run_pass_manager(pm, m)
  # @param [OpaquePassManager] pm
  # @param [OpaqueModule] m
  # @return [Integer]
  # @scope class
  attach_function :run_pass_manager, :LLVMRunPassManager, [OpaquePassManager, OpaqueModule], :int

  # Initializes all of the function passes scheduled in the function pass
  #     manager. Returns 1 if any of the passes modified the module, 0 otherwise.
  #     @see llvm::FunctionPassManager::doInitialization
  #
  # @method initialize_function_pass_manager(fpm)
  # @param [OpaquePassManager] fpm
  # @return [Integer]
  # @scope class
  attach_function :initialize_function_pass_manager, :LLVMInitializeFunctionPassManager, [OpaquePassManager], :int

  # Executes all of the function passes scheduled in the function pass manager
  #     on the provided function. Returns 1 if any of the passes modified the
  #     function, false otherwise.
  #     @see llvm::FunctionPassManager::run(Function&)
  #
  # @method run_function_pass_manager(fpm, f)
  # @param [OpaquePassManager] fpm
  # @param [OpaqueValue] f
  # @return [Integer]
  # @scope class
  attach_function :run_function_pass_manager, :LLVMRunFunctionPassManager, [OpaquePassManager, OpaqueValue], :int

  # Finalizes all of the function passes scheduled in in the function pass
  #     manager. Returns 1 if any of the passes modified the module, 0 otherwise.
  #     @see llvm::FunctionPassManager::doFinalization
  #
  # @method finalize_function_pass_manager(fpm)
  # @param [OpaquePassManager] fpm
  # @return [Integer]
  # @scope class
  attach_function :finalize_function_pass_manager, :LLVMFinalizeFunctionPassManager, [OpaquePassManager], :int

  # Frees the memory of a pass pipeline. For function pipelines, does not free
  #     the module provider.
  #     @see llvm::PassManagerBase::~PassManagerBase.
  #
  # @method dispose_pass_manager(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :dispose_pass_manager, :LLVMDisposePassManager, [OpaquePassManager], :void

  # Allocate and initialize structures needed to make LLVM safe for
  #     multithreading. The return value indicates whether multithreaded
  #     initialization succeeded. Must be executed in isolation from all
  #     other LLVM api calls.
  #     @see llvm::llvm_start_multithreaded
  #
  # @method start_multithreaded()
  # @return [Integer]
  # @scope class
  attach_function :start_multithreaded, :LLVMStartMultithreaded, [], :int

  # Deallocate structures necessary to make LLVM safe for multithreading.
  #     Must be executed in isolation from all other LLVM api calls.
  #     @see llvm::llvm_stop_multithreaded
  #
  # @method stop_multithreaded()
  # @return [nil]
  # @scope class
  attach_function :stop_multithreaded, :LLVMStopMultithreaded, [], :void

  # Check whether LLVM is executing in thread-safe mode or not.
  #     @see llvm::llvm_is_multithreaded
  #
  # @method is_multithreaded()
  # @return [Integer]
  # @scope class
  attach_function :is_multithreaded, :LLVMIsMultithreaded, [], :int

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:verifier_failure_action).</em>
  #
  # === Options:
  # :abort_process ::
  #
  # :print_message ::
  #   verifier will print to stderr and abort()
  # :return_status ::
  #   verifier will print to stderr and return 1
  #
  # @method _enum_verifier_failure_action_
  # @return [Symbol]
  # @scope class
  enum :verifier_failure_action, [
    :abort_process, 0,
    :print_message, 1,
    :return_status, 2
  ]

  # Verifies that a module is valid, taking the specified action if not.
  #    Optionally returns a human-readable description of any invalid constructs.
  #    OutMessage must be disposed with LLVMDisposeMessage.
  #
  # @method verify_module(m, action, out_message)
  # @param [OpaqueModule] m
  # @param [Symbol from _enum_verifier_failure_action_] action
  # @param [FFI::Pointer(**CharS)] out_message
  # @return [Integer]
  # @scope class
  attach_function :verify_module, :LLVMVerifyModule, [OpaqueModule, :verifier_failure_action, :pointer], :int

  # Verifies that a single function is valid, taking the specified action. Useful
  #    for debugging.
  #
  # @method verify_function(fn, action)
  # @param [OpaqueValue] fn
  # @param [Symbol from _enum_verifier_failure_action_] action
  # @return [Integer]
  # @scope class
  attach_function :verify_function, :LLVMVerifyFunction, [OpaqueValue, :verifier_failure_action], :int

  # Open up a ghostview window that displays the CFG of the current function.
  #    Useful for debugging.
  #
  # @method view_function_cfg(fn)
  # @param [OpaqueValue] fn
  # @return [nil]
  # @scope class
  attach_function :view_function_cfg, :LLVMViewFunctionCFG, [OpaqueValue], :void

  # (Not documented)
  #
  # @method view_function_cfg_only(fn)
  # @param [OpaqueValue] fn
  # @return [nil]
  # @scope class
  attach_function :view_function_cfg_only, :LLVMViewFunctionCFGOnly, [OpaqueValue], :void

  # (Not documented)
  #
  # @method parse_bitcode(mem_buf, out_module, out_message)
  # @param [OpaqueMemoryBuffer] mem_buf
  # @param [FFI::Pointer(*ModuleRef)] out_module
  # @param [FFI::Pointer(**CharS)] out_message
  # @return [Integer]
  # @scope class
  attach_function :parse_bitcode, :LLVMParseBitcode, [OpaqueMemoryBuffer, :pointer, :pointer], :int

  # (Not documented)
  #
  # @method parse_bitcode_in_context(context_ref, mem_buf, out_module, out_message)
  # @param [OpaqueContext] context_ref
  # @param [OpaqueMemoryBuffer] mem_buf
  # @param [FFI::Pointer(*ModuleRef)] out_module
  # @param [FFI::Pointer(**CharS)] out_message
  # @return [Integer]
  # @scope class
  attach_function :parse_bitcode_in_context, :LLVMParseBitcodeInContext, [OpaqueContext, OpaqueMemoryBuffer, :pointer, :pointer], :int

  # Reads a module from the specified path, returning via the OutMP parameter
  #     a module provider which performs lazy deserialization. Returns 0 on success.
  #     Optionally returns a human-readable error message via OutMessage.
  #
  # @method get_bitcode_module_in_context(context_ref, mem_buf, out_m, out_message)
  # @param [OpaqueContext] context_ref
  # @param [OpaqueMemoryBuffer] mem_buf
  # @param [FFI::Pointer(*ModuleRef)] out_m
  # @param [FFI::Pointer(**CharS)] out_message
  # @return [Integer]
  # @scope class
  attach_function :get_bitcode_module_in_context, :LLVMGetBitcodeModuleInContext, [OpaqueContext, OpaqueMemoryBuffer, :pointer, :pointer], :int

  # (Not documented)
  #
  # @method get_bitcode_module(mem_buf, out_m, out_message)
  # @param [OpaqueMemoryBuffer] mem_buf
  # @param [FFI::Pointer(*ModuleRef)] out_m
  # @param [FFI::Pointer(**CharS)] out_message
  # @return [Integer]
  # @scope class
  attach_function :get_bitcode_module, :LLVMGetBitcodeModule, [OpaqueMemoryBuffer, :pointer, :pointer], :int

  # Deprecated: Use LLVMGetBitcodeModuleInContext instead.
  #
  # @method get_bitcode_module_provider_in_context(context_ref, mem_buf, out_mp, out_message)
  # @param [OpaqueContext] context_ref
  # @param [OpaqueMemoryBuffer] mem_buf
  # @param [FFI::Pointer(*ModuleProviderRef)] out_mp
  # @param [FFI::Pointer(**CharS)] out_message
  # @return [Integer]
  # @scope class
  attach_function :get_bitcode_module_provider_in_context, :LLVMGetBitcodeModuleProviderInContext, [OpaqueContext, OpaqueMemoryBuffer, :pointer, :pointer], :int

  # Deprecated: Use LLVMGetBitcodeModule instead.
  #
  # @method get_bitcode_module_provider(mem_buf, out_mp, out_message)
  # @param [OpaqueMemoryBuffer] mem_buf
  # @param [FFI::Pointer(*ModuleProviderRef)] out_mp
  # @param [FFI::Pointer(**CharS)] out_message
  # @return [Integer]
  # @scope class
  attach_function :get_bitcode_module_provider, :LLVMGetBitcodeModuleProvider, [OpaqueMemoryBuffer, :pointer, :pointer], :int

  # (Not documented)
  #
  # @method write_bitcode_to_file(m, path)
  # @param [OpaqueModule] m
  # @param [String] path
  # @return [Integer]
  # @scope class
  attach_function :write_bitcode_to_file, :LLVMWriteBitcodeToFile, [OpaqueModule, :string], :int

  # Writes a module to an open file descriptor. Returns 0 on success.
  #
  # @method write_bitcode_to_fd(m, fd, should_close, unbuffered)
  # @param [OpaqueModule] m
  # @param [Integer] fd
  # @param [Integer] should_close
  # @param [Integer] unbuffered
  # @return [Integer]
  # @scope class
  attach_function :write_bitcode_to_fd, :LLVMWriteBitcodeToFD, [OpaqueModule, :int, :int, :int], :int

  # Deprecated for LLVMWriteBitcodeToFD. Writes a module to an open file
  #     descriptor. Returns 0 on success. Closes the Handle.
  #
  # @method write_bitcode_to_file_handle(m, handle)
  # @param [OpaqueModule] m
  # @param [Integer] handle
  # @return [Integer]
  # @scope class
  attach_function :write_bitcode_to_file_handle, :LLVMWriteBitcodeToFileHandle, [OpaqueModule, :int], :int

  # The type for the operand information call back function.  This is called to
  # get the symbolic information for an operand of an instruction.  Typically
  # this is from the relocation information, symbol table, etc.  That block of
  # information is saved when the disassembler context is created and passed to
  # the call back in the DisInfo parameter.  The instruction containing operand
  # is at the PC parameter.  For some instruction sets, there can be more than
  # one operand with symbolic information.  To determine the symbolic operand
  # information for each operand, the bytes for the specific operand in the
  # instruction are specified by the Offset parameter and its byte widith is the
  # size parameter.  For instructions sets with fixed widths and one symbolic
  # operand per instruction, the Offset parameter will be zero and Size parameter
  # will be the instruction width.  The information is returned in TagBuf and is
  # Triple specific with its specific information defined by the value of
  # TagType for that Triple.  If symbolic information is returned the function
  # returns 1, otherwise it returns 0.
  #
  # <em>This entry is only for documentation and no real method.</em>
  #
  # @method _callback_op_info_callback_(pc, offset, size, tag_type, tag_buf)
  # @param [Integer] pc
  # @param [Integer] offset
  # @param [Integer] size
  # @param [Integer] tag_type
  # @param [FFI::Pointer(*Void)] tag_buf
  # @return [FFI::Pointer(*Void)]
  # @scope class
  callback :op_info_callback, [:ulong, :ulong, :ulong, :int, :pointer], :pointer

  # The initial support in LLVM MC for the most general form of a relocatable
  # expression is "AddSymbol - SubtractSymbol + Offset".  For some Darwin targets
  # this full form is encoded in the relocation information so that AddSymbol and
  # SubtractSymbol can be link edited independent of each other.  Many other
  # platforms only allow a relocatable expression of the form AddSymbol + Offset
  # to be encoded.
  #
  # The LLVMOpInfoCallback() for the TagType value of 1 uses the struct
  # LLVMOpInfo1.  The value of the relocatable expression for the operand,
  # including any PC adjustment, is passed in to the call back in the Value
  # field.  The symbolic information about the operand is returned using all
  # the fields of the structure with the Offset of the relocatable expression
  # returned in the Value field.  It is possible that some symbols in the
  # relocatable expression were assembly temporary symbols, for example
  # "Ldata - LpicBase + constant", and only the Values of the symbols without
  # symbol names are present in the relocation information.  The VariantKind
  # type is one of the Target specific #defines below and is used to print
  # operands like "_foo@GOT", ":lower16:_foo", etc.
  #
  # = Fields:
  # :present ::
  #   (Integer) 1 if this symbol is present
  # :name ::
  #   (String) symbol name if not NULL
  # :value ::
  #   (Integer) symbol value if name is NULL
  class OpInfoSymbol1 < FFI::Struct
    layout :present, :ulong,
           :name, :string,
           :value, :ulong
  end

  # symbol value if name is NULL
  #
  # = Fields:
  # :add_symbol ::
  #   (OpInfoSymbol1)
  # :subtract_symbol ::
  #   (OpInfoSymbol1)
  # :value ::
  #   (Integer)
  # :variant_kind ::
  #   (Integer)
  class OpInfo1 < FFI::Struct
    layout :add_symbol, OpInfoSymbol1.by_value,
           :subtract_symbol, OpInfoSymbol1.by_value,
           :value, :ulong,
           :variant_kind, :ulong
  end

  # The type for the symbol lookup function.  This may be called by the
  # disassembler for things like adding a comment for a PC plus a constant
  # offset load instruction to use a symbol name instead of a load address value.
  # It is passed the block information is saved when the disassembler context is
  # created and the ReferenceValue to look up as a symbol.  If no symbol is found
  # for the ReferenceValue NULL is returned.  The ReferenceType of the
  # instruction is passed indirectly as is the PC of the instruction in
  # ReferencePC.  If the output reference can be determined its type is returned
  # indirectly in ReferenceType along with ReferenceName if any, or that is set
  # to NULL.
  #
  # <em>This entry is only for documentation and no real method.</em>
  #
  # @method _callback_symbol_lookup_callback_(reference_value, reference_type, reference_pc, reference_name)
  # @param [Integer] reference_value
  # @param [FFI::Pointer(*Uint64T)] reference_type
  # @param [Integer] reference_pc
  # @param [FFI::Pointer(**CharS)] reference_name
  # @return [FFI::Pointer(*Void)]
  # @scope class
  callback :symbol_lookup_callback, [:ulong, :pointer, :ulong, :pointer], :pointer

  # Create a disassembler for the TripleName.  Symbolic disassembly is supported
  # by passing a block of information in the DisInfo parameter and specifying the
  # TagType and callback functions as described above.  These can all be passed
  # as NULL.  If successful, this returns a disassembler context.  If not, it
  # returns NULL. This function is equivalent to calling LLVMCreateDisasmCPU()
  # with an empty CPU name.
  #
  # @method create_disasm(triple_name, dis_info, tag_type, get_op_info, symbol_look_up)
  # @param [String] triple_name
  # @param [FFI::Pointer(*Void)] dis_info
  # @param [Integer] tag_type
  # @param [Proc(_callback_op_info_callback_)] get_op_info
  # @param [Proc(_callback_symbol_lookup_callback_)] symbol_look_up
  # @return [FFI::Pointer(DisasmContextRef)]
  # @scope class
  attach_function :create_disasm, :LLVMCreateDisasm, [:string, :pointer, :int, :op_info_callback, :symbol_lookup_callback], :pointer

  # Create a disassembler for the TripleName and a specific CPU.  Symbolic
  # disassembly is supported by passing a block of information in the DisInfo
  # parameter and specifying the TagType and callback functions as described
  # above.  These can all be passed * as NULL.  If successful, this returns a
  # disassembler context.  If not, it returns NULL.
  #
  # @method create_disasm_cpu(triple, cpu, dis_info, tag_type, get_op_info, symbol_look_up)
  # @param [String] triple
  # @param [String] cpu
  # @param [FFI::Pointer(*Void)] dis_info
  # @param [Integer] tag_type
  # @param [Proc(_callback_op_info_callback_)] get_op_info
  # @param [Proc(_callback_symbol_lookup_callback_)] symbol_look_up
  # @return [FFI::Pointer(DisasmContextRef)]
  # @scope class
  attach_function :create_disasm_cpu, :LLVMCreateDisasmCPU, [:string, :string, :pointer, :int, :op_info_callback, :symbol_lookup_callback], :pointer

  # Set the disassembler's options.  Returns 1 if it can set the Options and 0
  # otherwise.
  #
  # @method set_disasm_options(dc, options)
  # @param [FFI::Pointer(DisasmContextRef)] dc
  # @param [Integer] options
  # @return [Integer]
  # @scope class
  attach_function :set_disasm_options, :LLVMSetDisasmOptions, [:pointer, :ulong], :int

  # Dispose of a disassembler context.
  #
  # @method disasm_dispose(dc)
  # @param [FFI::Pointer(DisasmContextRef)] dc
  # @return [nil]
  # @scope class
  attach_function :disasm_dispose, :LLVMDisasmDispose, [:pointer], :void

  # Disassemble a single instruction using the disassembler context specified in
  # the parameter DC.  The bytes of the instruction are specified in the
  # parameter Bytes, and contains at least BytesSize number of bytes.  The
  # instruction is at the address specified by the PC parameter.  If a valid
  # instruction can be disassembled, its string is returned indirectly in
  # OutString whose size is specified in the parameter OutStringSize.  This
  # function returns the number of bytes in the instruction or zero if there was
  # no valid instruction.
  #
  # @method disasm_instruction(dc, bytes, bytes_size, pc, out_string, out_string_size)
  # @param [FFI::Pointer(DisasmContextRef)] dc
  # @param [FFI::Pointer(*Uint8T)] bytes
  # @param [Integer] bytes_size
  # @param [Integer] pc
  # @param [String] out_string
  # @param [Integer] out_string_size
  # @return [Integer]
  # @scope class
  attach_function :disasm_instruction, :LLVMDisasmInstruction, [:pointer, :pointer, :ulong, :ulong, :string, :ulong], :ulong

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:byte_ordering).</em>
  #
  # === Options:
  # :big_endian ::
  #
  # :little_endian ::
  #
  #
  # @method _enum_byte_ordering_
  # @return [Symbol]
  # @scope class
  enum :byte_ordering, [
    :big_endian, 0,
    :little_endian, 1
  ]

  # (Not documented)
  class OpaqueTargetData < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  class OpaqueTargetLibraryInfotData < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # @method initialize_all_target_infos()
  # @return [nil]
  # @scope class
  attach_function :initialize_all_target_infos, :LLVMInitializeAllTargetInfos, [], :void

  # LLVMInitializeAllTargets - The main program should call this function if it
  #     wants to link in all available targets that LLVM is configured to
  #     support.
  #
  # @method initialize_all_targets()
  # @return [nil]
  # @scope class
  attach_function :initialize_all_targets, :LLVMInitializeAllTargets, [], :void

  # LLVMInitializeAllTargetMCs - The main program should call this function if
  #     it wants access to all available target MC that LLVM is configured to
  #     support.
  #
  # @method initialize_all_target_m_cs()
  # @return [nil]
  # @scope class
  attach_function :initialize_all_target_mcs, :LLVMInitializeAllTargetMCs, [], :void

  # LLVMInitializeAllAsmPrinters - The main program should call this function if
  #     it wants all asm printers that LLVM is configured to support, to make them
  #     available via the TargetRegistry.
  #
  # @method initialize_all_asm_printers()
  # @return [nil]
  # @scope class
  attach_function :initialize_all_asm_printers, :LLVMInitializeAllAsmPrinters, [], :void

  # LLVMInitializeAllAsmParsers - The main program should call this function if
  #     it wants all asm parsers that LLVM is configured to support, to make them
  #     available via the TargetRegistry.
  #
  # @method initialize_all_asm_parsers()
  # @return [nil]
  # @scope class
  attach_function :initialize_all_asm_parsers, :LLVMInitializeAllAsmParsers, [], :void

  # LLVMInitializeAllDisassemblers - The main program should call this function
  #     if it wants all disassemblers that LLVM is configured to support, to make
  #     them available via the TargetRegistry.
  #
  # @method initialize_all_disassemblers()
  # @return [nil]
  # @scope class
  attach_function :initialize_all_disassemblers, :LLVMInitializeAllDisassemblers, [], :void

  # LLVMInitializeNativeTarget - The main program should call this function to
  #     initialize the native target corresponding to the host.  This is useful
  #     for JIT applications to ensure that the target gets linked in correctly.
  #
  # @method initialize_native_target()
  # @return [Integer]
  # @scope class
  attach_function :initialize_native_target, :LLVMInitializeNativeTarget, [], :int

  # LLVMInitializeNativeTargetAsmParser - The main program should call this
  #     function to initialize the parser for the native target corresponding to the
  #     host.
  #
  # @method initialize_native_asm_parser()
  # @return [Integer]
  # @scope class
  attach_function :initialize_native_asm_parser, :LLVMInitializeNativeAsmParser, [], :int

  # LLVMInitializeNativeTargetAsmPrinter - The main program should call this
  #     function to initialize the printer for the native target corresponding to
  #     the host.
  #
  # @method initialize_native_asm_printer()
  # @return [Integer]
  # @scope class
  attach_function :initialize_native_asm_printer, :LLVMInitializeNativeAsmPrinter, [], :int

  # LLVMInitializeNativeTargetDisassembler - The main program should call this
  #     function to initialize the disassembler for the native target corresponding
  #     to the host.
  #
  # @method initialize_native_disassembler()
  # @return [Integer]
  # @scope class
  attach_function :initialize_native_disassembler, :LLVMInitializeNativeDisassembler, [], :int

  # Creates target data from a target layout string.
  #     See the constructor llvm::DataLayout::DataLayout.
  #
  # @method create_target_data(string_rep)
  # @param [String] string_rep
  # @return [OpaqueTargetData]
  # @scope class
  attach_function :create_target_data, :LLVMCreateTargetData, [:string], OpaqueTargetData

  # Adds target data information to a pass manager. This does not take ownership
  #     of the target data.
  #     See the method llvm::PassManagerBase::add.
  #
  # @method add_target_data(td, pm)
  # @param [OpaqueTargetData] td
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_target_data, :LLVMAddTargetData, [OpaqueTargetData, OpaquePassManager], :void

  # Adds target library information to a pass manager. This does not take
  #     ownership of the target library info.
  #     See the method llvm::PassManagerBase::add.
  #
  # @method add_target_library_info(tli, pm)
  # @param [OpaqueTargetLibraryInfotData] tli
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_target_library_info, :LLVMAddTargetLibraryInfo, [OpaqueTargetLibraryInfotData, OpaquePassManager], :void

  # Converts target data to a target layout string. The string must be disposed
  #     with LLVMDisposeMessage.
  #     See the constructor llvm::DataLayout::DataLayout.
  #
  # @method copy_string_rep_of_target_data(td)
  # @param [OpaqueTargetData] td
  # @return [String]
  # @scope class
  attach_function :copy_string_rep_of_target_data, :LLVMCopyStringRepOfTargetData, [OpaqueTargetData], :string

  # Returns the byte order of a target, either LLVMBigEndian or
  #     LLVMLittleEndian.
  #     See the method llvm::DataLayout::isLittleEndian.
  #
  # @method byte_order(td)
  # @param [OpaqueTargetData] td
  # @return [Symbol from _enum_byte_ordering_]
  # @scope class
  attach_function :byte_order, :LLVMByteOrder, [OpaqueTargetData], :byte_ordering

  # Returns the pointer size in bytes for a target.
  #     See the method llvm::DataLayout::getPointerSize.
  #
  # @method pointer_size(td)
  # @param [OpaqueTargetData] td
  # @return [Integer]
  # @scope class
  attach_function :pointer_size, :LLVMPointerSize, [OpaqueTargetData], :uint

  # Returns the pointer size in bytes for a target for a specified
  #     address space.
  #     See the method llvm::DataLayout::getPointerSize.
  #
  # @method pointer_size_for_as(td, as)
  # @param [OpaqueTargetData] td
  # @param [Integer] as
  # @return [Integer]
  # @scope class
  attach_function :pointer_size_for_as, :LLVMPointerSizeForAS, [OpaqueTargetData, :uint], :uint

  # Returns the integer type that is the same size as a pointer on a target.
  #     See the method llvm::DataLayout::getIntPtrType.
  #
  # @method int_ptr_type(td)
  # @param [OpaqueTargetData] td
  # @return [OpaqueType]
  # @scope class
  attach_function :int_ptr_type, :LLVMIntPtrType, [OpaqueTargetData], OpaqueType

  # Returns the integer type that is the same size as a pointer on a target.
  #     This version allows the address space to be specified.
  #     See the method llvm::DataLayout::getIntPtrType.
  #
  # @method int_ptr_type_for_as(td, as)
  # @param [OpaqueTargetData] td
  # @param [Integer] as
  # @return [OpaqueType]
  # @scope class
  attach_function :int_ptr_type_for_as, :LLVMIntPtrTypeForAS, [OpaqueTargetData, :uint], OpaqueType

  # Returns the integer type that is the same size as a pointer on a target.
  #     See the method llvm::DataLayout::getIntPtrType.
  #
  # @method int_ptr_type_in_context(c, td)
  # @param [OpaqueContext] c
  # @param [OpaqueTargetData] td
  # @return [OpaqueType]
  # @scope class
  attach_function :int_ptr_type_in_context, :LLVMIntPtrTypeInContext, [OpaqueContext, OpaqueTargetData], OpaqueType

  # Returns the integer type that is the same size as a pointer on a target.
  #     This version allows the address space to be specified.
  #     See the method llvm::DataLayout::getIntPtrType.
  #
  # @method int_ptr_type_for_as_in_context(c, td, as)
  # @param [OpaqueContext] c
  # @param [OpaqueTargetData] td
  # @param [Integer] as
  # @return [OpaqueType]
  # @scope class
  attach_function :int_ptr_type_for_as_in_context, :LLVMIntPtrTypeForASInContext, [OpaqueContext, OpaqueTargetData, :uint], OpaqueType

  # Computes the size of a type in bytes for a target.
  #     See the method llvm::DataLayout::getTypeSizeInBits.
  #
  # @method size_of_type_in_bits(td, ty)
  # @param [OpaqueTargetData] td
  # @param [OpaqueType] ty
  # @return [Integer]
  # @scope class
  attach_function :size_of_type_in_bits, :LLVMSizeOfTypeInBits, [OpaqueTargetData, OpaqueType], :ulong_long

  # Computes the storage size of a type in bytes for a target.
  #     See the method llvm::DataLayout::getTypeStoreSize.
  #
  # @method store_size_of_type(td, ty)
  # @param [OpaqueTargetData] td
  # @param [OpaqueType] ty
  # @return [Integer]
  # @scope class
  attach_function :store_size_of_type, :LLVMStoreSizeOfType, [OpaqueTargetData, OpaqueType], :ulong_long

  # Computes the ABI size of a type in bytes for a target.
  #     See the method llvm::DataLayout::getTypeAllocSize.
  #
  # @method abi_size_of_type(td, ty)
  # @param [OpaqueTargetData] td
  # @param [OpaqueType] ty
  # @return [Integer]
  # @scope class
  attach_function :abi_size_of_type, :LLVMABISizeOfType, [OpaqueTargetData, OpaqueType], :ulong_long

  # Computes the ABI alignment of a type in bytes for a target.
  #     See the method llvm::DataLayout::getTypeABISize.
  #
  # @method abi_alignment_of_type(td, ty)
  # @param [OpaqueTargetData] td
  # @param [OpaqueType] ty
  # @return [Integer]
  # @scope class
  attach_function :abi_alignment_of_type, :LLVMABIAlignmentOfType, [OpaqueTargetData, OpaqueType], :uint

  # Computes the call frame alignment of a type in bytes for a target.
  #     See the method llvm::DataLayout::getTypeABISize.
  #
  # @method call_frame_alignment_of_type(td, ty)
  # @param [OpaqueTargetData] td
  # @param [OpaqueType] ty
  # @return [Integer]
  # @scope class
  attach_function :call_frame_alignment_of_type, :LLVMCallFrameAlignmentOfType, [OpaqueTargetData, OpaqueType], :uint

  # Computes the preferred alignment of a type in bytes for a target.
  #     See the method llvm::DataLayout::getTypeABISize.
  #
  # @method preferred_alignment_of_type(td, ty)
  # @param [OpaqueTargetData] td
  # @param [OpaqueType] ty
  # @return [Integer]
  # @scope class
  attach_function :preferred_alignment_of_type, :LLVMPreferredAlignmentOfType, [OpaqueTargetData, OpaqueType], :uint

  # Computes the preferred alignment of a global variable in bytes for a target.
  #     See the method llvm::DataLayout::getPreferredAlignment.
  #
  # @method preferred_alignment_of_global(td, global_var)
  # @param [OpaqueTargetData] td
  # @param [OpaqueValue] global_var
  # @return [Integer]
  # @scope class
  attach_function :preferred_alignment_of_global, :LLVMPreferredAlignmentOfGlobal, [OpaqueTargetData, OpaqueValue], :uint

  # Computes the structure element that contains the byte offset for a target.
  #     See the method llvm::StructLayout::getElementContainingOffset.
  #
  # @method element_at_offset(td, struct_ty, offset)
  # @param [OpaqueTargetData] td
  # @param [OpaqueType] struct_ty
  # @param [Integer] offset
  # @return [Integer]
  # @scope class
  attach_function :element_at_offset, :LLVMElementAtOffset, [OpaqueTargetData, OpaqueType, :ulong_long], :uint

  # Computes the byte offset of the indexed struct element for a target.
  #     See the method llvm::StructLayout::getElementContainingOffset.
  #
  # @method offset_of_element(td, struct_ty, element)
  # @param [OpaqueTargetData] td
  # @param [OpaqueType] struct_ty
  # @param [Integer] element
  # @return [Integer]
  # @scope class
  attach_function :offset_of_element, :LLVMOffsetOfElement, [OpaqueTargetData, OpaqueType, :uint], :ulong_long

  # Deallocates a TargetData.
  #     See the destructor llvm::DataLayout::~DataLayout.
  #
  # @method dispose_target_data(td)
  # @param [OpaqueTargetData] td
  # @return [nil]
  # @scope class
  attach_function :dispose_target_data, :LLVMDisposeTargetData, [OpaqueTargetData], :void

  # (Not documented)
  class OpaqueTargetMachine < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  module TargetWrappers
    def has_jit()
      RLTK::CG::Bindings.target_has_jit(self)
    end

    def has_target_machine()
      RLTK::CG::Bindings.target_has_target_machine(self)
    end

    def has_asm_backend()
      RLTK::CG::Bindings.target_has_asm_backend(self)
    end
  end

  class Target < FFI::Struct
    include TargetWrappers
    layout :dummy, :char
  end

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:code_gen_opt_level).</em>
  #
  # === Options:
  # :none ::
  #
  # :less ::
  #
  # :default ::
  #
  # :aggressive ::
  #
  #
  # @method _enum_code_gen_opt_level_
  # @return [Symbol]
  # @scope class
  enum :code_gen_opt_level, [
    :none, 0,
    :less, 1,
    :default, 2,
    :aggressive, 3
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:reloc_mode).</em>
  #
  # === Options:
  # :default ::
  #
  # :static ::
  #
  # :pic ::
  #
  # :dynamic_no_pic ::
  #
  #
  # @method _enum_reloc_mode_
  # @return [Symbol]
  # @scope class
  enum :reloc_mode, [
    :default, 0,
    :static, 1,
    :pic, 2,
    :dynamic_no_pic, 3
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:code_model).</em>
  #
  # === Options:
  # :default ::
  #
  # :jit_default ::
  #
  # :small ::
  #
  # :kernel ::
  #
  # :medium ::
  #
  # :large ::
  #
  #
  # @method _enum_code_model_
  # @return [Symbol]
  # @scope class
  enum :code_model, [
    :default, 0,
    :jit_default, 1,
    :small, 2,
    :kernel, 3,
    :medium, 4,
    :large, 5
  ]

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:code_gen_file_type).</em>
  #
  # === Options:
  # :assembly ::
  #
  # :object ::
  #
  #
  # @method _enum_code_gen_file_type_
  # @return [Symbol]
  # @scope class
  enum :code_gen_file_type, [
    :assembly, 0,
    :object, 1
  ]

  # Returns the first llvm::Target in the registered targets list.
  #
  # @method get_first_target()
  # @return [Target]
  # @scope class
  attach_function :get_first_target, :LLVMGetFirstTarget, [], Target

  # Returns the next llvm::Target given a previous one (or null if there's none)
  #
  # @method get_next_target(t)
  # @param [Target] t
  # @return [Target]
  # @scope class
  attach_function :get_next_target, :LLVMGetNextTarget, [Target], Target

  # Finds the target corresponding to the given name and stores it in \p T.
  #   Returns 0 on success.
  #
  # @method get_target_from_name(name)
  # @param [String] name
  # @return [Target]
  # @scope class
  attach_function :get_target_from_name, :LLVMGetTargetFromName, [:string], Target

  # Finds the target corresponding to the given triple and stores it in \p T.
  #   Returns 0 on success. Optionally returns any error in ErrorMessage.
  #   Use LLVMDisposeMessage to dispose the message.
  #
  # @method get_target_from_triple(triple, t, error_message)
  # @param [String] triple
  # @param [FFI::Pointer(*TargetRef)] t
  # @param [FFI::Pointer(**CharS)] error_message
  # @return [Integer]
  # @scope class
  attach_function :get_target_from_triple, :LLVMGetTargetFromTriple, [:string, :pointer, :pointer], :int

  # Returns the name of a target. See llvm::Target::getName
  #
  # @method get_target_name(t)
  # @param [Target] t
  # @return [String]
  # @scope class
  attach_function :get_target_name, :LLVMGetTargetName, [Target], :string

  # Returns the description  of a target. See llvm::Target::getDescription
  #
  # @method get_target_description(t)
  # @param [Target] t
  # @return [String]
  # @scope class
  attach_function :get_target_description, :LLVMGetTargetDescription, [Target], :string

  # Returns if the target has a JIT
  #
  # @method target_has_jit(t)
  # @param [Target] t
  # @return [Integer]
  # @scope class
  attach_function :target_has_jit, :LLVMTargetHasJIT, [Target], :int

  # Returns if the target has a TargetMachine associated
  #
  # @method target_has_target_machine(t)
  # @param [Target] t
  # @return [Integer]
  # @scope class
  attach_function :target_has_target_machine, :LLVMTargetHasTargetMachine, [Target], :int

  # Returns if the target as an ASM backend (required for emitting output)
  #
  # @method target_has_asm_backend(t)
  # @param [Target] t
  # @return [Integer]
  # @scope class
  attach_function :target_has_asm_backend, :LLVMTargetHasAsmBackend, [Target], :int

  # Creates a new llvm::TargetMachine. See llvm::Target::createTargetMachine
  #
  # @method create_target_machine(t, triple, cpu, features, level, reloc, code_model)
  # @param [Target] t
  # @param [String] triple
  # @param [String] cpu
  # @param [String] features
  # @param [Symbol from _enum_code_gen_opt_level_] level
  # @param [Symbol from _enum_reloc_mode_] reloc
  # @param [Symbol from _enum_code_model_] code_model
  # @return [OpaqueTargetMachine]
  # @scope class
  attach_function :create_target_machine, :LLVMCreateTargetMachine, [Target, :string, :string, :string, :code_gen_opt_level, :reloc_mode, :code_model], OpaqueTargetMachine

  # Dispose the LLVMTargetMachineRef instance generated by
  #   LLVMCreateTargetMachine.
  #
  # @method dispose_target_machine(t)
  # @param [OpaqueTargetMachine] t
  # @return [nil]
  # @scope class
  attach_function :dispose_target_machine, :LLVMDisposeTargetMachine, [OpaqueTargetMachine], :void

  # Returns the Target used in a TargetMachine
  #
  # @method get_target_machine_target(t)
  # @param [OpaqueTargetMachine] t
  # @return [Target]
  # @scope class
  attach_function :get_target_machine_target, :LLVMGetTargetMachineTarget, [OpaqueTargetMachine], Target

  # Returns the triple used creating this target machine. See
  #   llvm::TargetMachine::getTriple. The result needs to be disposed with
  #   LLVMDisposeMessage.
  #
  # @method get_target_machine_triple(t)
  # @param [OpaqueTargetMachine] t
  # @return [String]
  # @scope class
  attach_function :get_target_machine_triple, :LLVMGetTargetMachineTriple, [OpaqueTargetMachine], :string

  # Returns the cpu used creating this target machine. See
  #   llvm::TargetMachine::getCPU. The result needs to be disposed with
  #   LLVMDisposeMessage.
  #
  # @method get_target_machine_cpu(t)
  # @param [OpaqueTargetMachine] t
  # @return [String]
  # @scope class
  attach_function :get_target_machine_cpu, :LLVMGetTargetMachineCPU, [OpaqueTargetMachine], :string

  # Returns the feature string used creating this target machine. See
  #   llvm::TargetMachine::getFeatureString. The result needs to be disposed with
  #   LLVMDisposeMessage.
  #
  # @method get_target_machine_feature_string(t)
  # @param [OpaqueTargetMachine] t
  # @return [String]
  # @scope class
  attach_function :get_target_machine_feature_string, :LLVMGetTargetMachineFeatureString, [OpaqueTargetMachine], :string

  # Returns the llvm::DataLayout used for this llvm:TargetMachine.
  #
  # @method get_target_machine_data(t)
  # @param [OpaqueTargetMachine] t
  # @return [OpaqueTargetData]
  # @scope class
  attach_function :get_target_machine_data, :LLVMGetTargetMachineData, [OpaqueTargetMachine], OpaqueTargetData

  # Set the target machine's ASM verbosity.
  #
  # @method set_target_machine_asm_verbosity(t, verbose_asm)
  # @param [OpaqueTargetMachine] t
  # @param [Integer] verbose_asm
  # @return [nil]
  # @scope class
  attach_function :set_target_machine_asm_verbosity, :LLVMSetTargetMachineAsmVerbosity, [OpaqueTargetMachine, :int], :void

  # Emits an asm or object file for the given module to the filename. This
  #   wraps several c++ only classes (among them a file stream). Returns any
  #   error in ErrorMessage. Use LLVMDisposeMessage to dispose the message.
  #
  # @method target_machine_emit_to_file(t, m, filename, codegen, error_message)
  # @param [OpaqueTargetMachine] t
  # @param [OpaqueModule] m
  # @param [String] filename
  # @param [Symbol from _enum_code_gen_file_type_] codegen
  # @param [FFI::Pointer(**CharS)] error_message
  # @return [Integer]
  # @scope class
  attach_function :target_machine_emit_to_file, :LLVMTargetMachineEmitToFile, [OpaqueTargetMachine, OpaqueModule, :string, :code_gen_file_type, :pointer], :int

  # Compile the LLVM IR stored in \p M and store the result in \p OutMemBuf.
  #
  # @method target_machine_emit_to_memory_buffer(t, m, codegen, error_message, out_mem_buf)
  # @param [OpaqueTargetMachine] t
  # @param [OpaqueModule] m
  # @param [Symbol from _enum_code_gen_file_type_] codegen
  # @param [FFI::Pointer(**CharS)] error_message
  # @param [FFI::Pointer(*MemoryBufferRef)] out_mem_buf
  # @return [Integer]
  # @scope class
  attach_function :target_machine_emit_to_memory_buffer, :LLVMTargetMachineEmitToMemoryBuffer, [OpaqueTargetMachine, OpaqueModule, :code_gen_file_type, :pointer, :pointer], :int

  # Get a triple for the host machine as a string. The result needs to be
  #   disposed with LLVMDisposeMessage.
  #
  # @method get_default_target_triple()
  # @return [String]
  # @scope class
  attach_function :get_default_target_triple, :LLVMGetDefaultTargetTriple, [], :string

  # (Not documented)
  #
  # @method link_in_jit()
  # @return [nil]
  # @scope class
  attach_function :link_in_jit, :LLVMLinkInJIT, [], :void

  # (Not documented)
  #
  # @method link_in_mcjit()
  # @return [nil]
  # @scope class
  attach_function :link_in_mcjit, :LLVMLinkInMCJIT, [], :void

  # (Not documented)
  #
  # @method link_in_interpreter()
  # @return [nil]
  # @scope class
  attach_function :link_in_interpreter, :LLVMLinkInInterpreter, [], :void

  # (Not documented)
  class OpaqueGenericValue < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  class OpaqueExecutionEngine < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  class OpaqueMCJITMemoryManager < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  #
  # = Fields:
  # :opt_level ::
  #   (Integer)
  # :code_model ::
  #   (Symbol from _enum_code_model_)
  # :no_frame_pointer_elim ::
  #   (Integer)
  # :enable_fast_i_sel ::
  #   (Integer)
  # :mcjmm ::
  #   (OpaqueMCJITMemoryManager)
  class MCJITCompilerOptions < FFI::Struct
    layout :opt_level, :uint,
           :code_model, :code_model,
           :no_frame_pointer_elim, :int,
           :enable_fast_i_sel, :int,
           :mcjmm, OpaqueMCJITMemoryManager
  end

  # ===-- Operations on generic values --------------------------------------===
  #
  # @method create_generic_value_of_int(ty, n, is_signed)
  # @param [OpaqueType] ty
  # @param [Integer] n
  # @param [Integer] is_signed
  # @return [OpaqueGenericValue]
  # @scope class
  attach_function :create_generic_value_of_int, :LLVMCreateGenericValueOfInt, [OpaqueType, :ulong_long, :int], OpaqueGenericValue

  # (Not documented)
  #
  # @method create_generic_value_of_pointer(p)
  # @param [FFI::Pointer(*Void)] p
  # @return [OpaqueGenericValue]
  # @scope class
  attach_function :create_generic_value_of_pointer, :LLVMCreateGenericValueOfPointer, [:pointer], OpaqueGenericValue

  # (Not documented)
  #
  # @method create_generic_value_of_float(ty, n)
  # @param [OpaqueType] ty
  # @param [Float] n
  # @return [OpaqueGenericValue]
  # @scope class
  attach_function :create_generic_value_of_float, :LLVMCreateGenericValueOfFloat, [OpaqueType, :double], OpaqueGenericValue

  # (Not documented)
  #
  # @method generic_value_int_width(gen_val_ref)
  # @param [OpaqueGenericValue] gen_val_ref
  # @return [Integer]
  # @scope class
  attach_function :generic_value_int_width, :LLVMGenericValueIntWidth, [OpaqueGenericValue], :uint

  # (Not documented)
  #
  # @method generic_value_to_int(gen_val, is_signed)
  # @param [OpaqueGenericValue] gen_val
  # @param [Integer] is_signed
  # @return [Integer]
  # @scope class
  attach_function :generic_value_to_int, :LLVMGenericValueToInt, [OpaqueGenericValue, :int], :ulong_long

  # (Not documented)
  #
  # @method generic_value_to_pointer(gen_val)
  # @param [OpaqueGenericValue] gen_val
  # @return [FFI::Pointer(*Void)]
  # @scope class
  attach_function :generic_value_to_pointer, :LLVMGenericValueToPointer, [OpaqueGenericValue], :pointer

  # (Not documented)
  #
  # @method generic_value_to_float(ty_ref, gen_val)
  # @param [OpaqueType] ty_ref
  # @param [OpaqueGenericValue] gen_val
  # @return [Float]
  # @scope class
  attach_function :generic_value_to_float, :LLVMGenericValueToFloat, [OpaqueType, OpaqueGenericValue], :double

  # (Not documented)
  #
  # @method dispose_generic_value(gen_val)
  # @param [OpaqueGenericValue] gen_val
  # @return [nil]
  # @scope class
  attach_function :dispose_generic_value, :LLVMDisposeGenericValue, [OpaqueGenericValue], :void

  # ===-- Operations on execution engines -----------------------------------===
  #
  # @method create_execution_engine_for_module(out_ee, m, out_error)
  # @param [FFI::Pointer(*ExecutionEngineRef)] out_ee
  # @param [OpaqueModule] m
  # @param [FFI::Pointer(**CharS)] out_error
  # @return [Integer]
  # @scope class
  attach_function :create_execution_engine_for_module, :LLVMCreateExecutionEngineForModule, [:pointer, OpaqueModule, :pointer], :int

  # (Not documented)
  #
  # @method create_interpreter_for_module(out_interp, m, out_error)
  # @param [FFI::Pointer(*ExecutionEngineRef)] out_interp
  # @param [OpaqueModule] m
  # @param [FFI::Pointer(**CharS)] out_error
  # @return [Integer]
  # @scope class
  attach_function :create_interpreter_for_module, :LLVMCreateInterpreterForModule, [:pointer, OpaqueModule, :pointer], :int

  # (Not documented)
  #
  # @method create_jit_compiler_for_module(out_jit, m, opt_level, out_error)
  # @param [FFI::Pointer(*ExecutionEngineRef)] out_jit
  # @param [OpaqueModule] m
  # @param [Integer] opt_level
  # @param [FFI::Pointer(**CharS)] out_error
  # @return [Integer]
  # @scope class
  attach_function :create_jit_compiler_for_module, :LLVMCreateJITCompilerForModule, [:pointer, OpaqueModule, :uint, :pointer], :int

  # (Not documented)
  #
  # @method initialize_mcjit_compiler_options(options, size_of_options)
  # @param [MCJITCompilerOptions] options
  # @param [Integer] size_of_options
  # @return [nil]
  # @scope class
  attach_function :initialize_mcjit_compiler_options, :LLVMInitializeMCJITCompilerOptions, [MCJITCompilerOptions, :ulong], :void

  # Create an MCJIT execution engine for a module, with the given options. It is
  # the responsibility of the caller to ensure that all fields in Options up to
  # the given SizeOfOptions are initialized. It is correct to pass a smaller
  # value of SizeOfOptions that omits some fields. The canonical way of using
  # this is:
  #
  # LLVMMCJITCompilerOptions options;
  # LLVMInitializeMCJITCompilerOptions(&options, sizeof(options));
  # ... fill in those options you care about
  # LLVMCreateMCJITCompilerForModule(&jit, mod, &options, sizeof(options),
  #                                  &error);
  #
  # Note that this is also correct, though possibly suboptimal:
  #
  # LLVMCreateMCJITCompilerForModule(&jit, mod, 0, 0, &error);
  #
  # @method create_mcjit_compiler_for_module(out_jit, m, options, size_of_options, out_error)
  # @param [FFI::Pointer(*ExecutionEngineRef)] out_jit
  # @param [OpaqueModule] m
  # @param [MCJITCompilerOptions] options
  # @param [Integer] size_of_options
  # @param [FFI::Pointer(**CharS)] out_error
  # @return [Integer]
  # @scope class
  attach_function :create_mcjit_compiler_for_module, :LLVMCreateMCJITCompilerForModule, [:pointer, OpaqueModule, MCJITCompilerOptions, :ulong, :pointer], :int

  # Deprecated: Use LLVMCreateExecutionEngineForModule instead.
  #
  # @method create_execution_engine(out_ee, mp, out_error)
  # @param [FFI::Pointer(*ExecutionEngineRef)] out_ee
  # @param [OpaqueModuleProvider] mp
  # @param [FFI::Pointer(**CharS)] out_error
  # @return [Integer]
  # @scope class
  attach_function :create_execution_engine, :LLVMCreateExecutionEngine, [:pointer, OpaqueModuleProvider, :pointer], :int

  # Deprecated: Use LLVMCreateInterpreterForModule instead.
  #
  # @method create_interpreter(out_interp, mp, out_error)
  # @param [FFI::Pointer(*ExecutionEngineRef)] out_interp
  # @param [OpaqueModuleProvider] mp
  # @param [FFI::Pointer(**CharS)] out_error
  # @return [Integer]
  # @scope class
  attach_function :create_interpreter, :LLVMCreateInterpreter, [:pointer, OpaqueModuleProvider, :pointer], :int

  # Deprecated: Use LLVMCreateJITCompilerForModule instead.
  #
  # @method create_jit_compiler(out_jit, mp, opt_level, out_error)
  # @param [FFI::Pointer(*ExecutionEngineRef)] out_jit
  # @param [OpaqueModuleProvider] mp
  # @param [Integer] opt_level
  # @param [FFI::Pointer(**CharS)] out_error
  # @return [Integer]
  # @scope class
  attach_function :create_jit_compiler, :LLVMCreateJITCompiler, [:pointer, OpaqueModuleProvider, :uint, :pointer], :int

  # (Not documented)
  #
  # @method dispose_execution_engine(ee)
  # @param [OpaqueExecutionEngine] ee
  # @return [nil]
  # @scope class
  attach_function :dispose_execution_engine, :LLVMDisposeExecutionEngine, [OpaqueExecutionEngine], :void

  # (Not documented)
  #
  # @method run_static_constructors(ee)
  # @param [OpaqueExecutionEngine] ee
  # @return [nil]
  # @scope class
  attach_function :run_static_constructors, :LLVMRunStaticConstructors, [OpaqueExecutionEngine], :void

  # (Not documented)
  #
  # @method run_static_destructors(ee)
  # @param [OpaqueExecutionEngine] ee
  # @return [nil]
  # @scope class
  attach_function :run_static_destructors, :LLVMRunStaticDestructors, [OpaqueExecutionEngine], :void

  # (Not documented)
  #
  # @method run_function_as_main(ee, f, arg_c, arg_v, env_p)
  # @param [OpaqueExecutionEngine] ee
  # @param [OpaqueValue] f
  # @param [Integer] arg_c
  # @param [FFI::Pointer(**CharS)] arg_v
  # @param [FFI::Pointer(**CharS)] env_p
  # @return [Integer]
  # @scope class
  attach_function :run_function_as_main, :LLVMRunFunctionAsMain, [OpaqueExecutionEngine, OpaqueValue, :uint, :pointer, :pointer], :int

  # (Not documented)
  #
  # @method run_function(ee, f, num_args, args)
  # @param [OpaqueExecutionEngine] ee
  # @param [OpaqueValue] f
  # @param [Integer] num_args
  # @param [FFI::Pointer(*GenericValueRef)] args
  # @return [OpaqueGenericValue]
  # @scope class
  attach_function :run_function, :LLVMRunFunction, [OpaqueExecutionEngine, OpaqueValue, :uint, :pointer], OpaqueGenericValue

  # (Not documented)
  #
  # @method free_machine_code_for_function(ee, f)
  # @param [OpaqueExecutionEngine] ee
  # @param [OpaqueValue] f
  # @return [nil]
  # @scope class
  attach_function :free_machine_code_for_function, :LLVMFreeMachineCodeForFunction, [OpaqueExecutionEngine, OpaqueValue], :void

  # (Not documented)
  #
  # @method add_module(ee, m)
  # @param [OpaqueExecutionEngine] ee
  # @param [OpaqueModule] m
  # @return [nil]
  # @scope class
  attach_function :add_module, :LLVMAddModule, [OpaqueExecutionEngine, OpaqueModule], :void

  # Deprecated: Use LLVMAddModule instead.
  #
  # @method add_module_provider(ee, mp)
  # @param [OpaqueExecutionEngine] ee
  # @param [OpaqueModuleProvider] mp
  # @return [nil]
  # @scope class
  attach_function :add_module_provider, :LLVMAddModuleProvider, [OpaqueExecutionEngine, OpaqueModuleProvider], :void

  # (Not documented)
  #
  # @method remove_module(ee, m, out_mod, out_error)
  # @param [OpaqueExecutionEngine] ee
  # @param [OpaqueModule] m
  # @param [FFI::Pointer(*ModuleRef)] out_mod
  # @param [FFI::Pointer(**CharS)] out_error
  # @return [Integer]
  # @scope class
  attach_function :remove_module, :LLVMRemoveModule, [OpaqueExecutionEngine, OpaqueModule, :pointer, :pointer], :int

  # Deprecated: Use LLVMRemoveModule instead.
  #
  # @method remove_module_provider(ee, mp, out_mod, out_error)
  # @param [OpaqueExecutionEngine] ee
  # @param [OpaqueModuleProvider] mp
  # @param [FFI::Pointer(*ModuleRef)] out_mod
  # @param [FFI::Pointer(**CharS)] out_error
  # @return [Integer]
  # @scope class
  attach_function :remove_module_provider, :LLVMRemoveModuleProvider, [OpaqueExecutionEngine, OpaqueModuleProvider, :pointer, :pointer], :int

  # (Not documented)
  #
  # @method find_function(ee, name, out_fn)
  # @param [OpaqueExecutionEngine] ee
  # @param [String] name
  # @param [FFI::Pointer(*ValueRef)] out_fn
  # @return [Integer]
  # @scope class
  attach_function :find_function, :LLVMFindFunction, [OpaqueExecutionEngine, :string, :pointer], :int

  # (Not documented)
  #
  # @method recompile_and_relink_function(ee, fn)
  # @param [OpaqueExecutionEngine] ee
  # @param [OpaqueValue] fn
  # @return [FFI::Pointer(*Void)]
  # @scope class
  attach_function :recompile_and_relink_function, :LLVMRecompileAndRelinkFunction, [OpaqueExecutionEngine, OpaqueValue], :pointer

  # (Not documented)
  #
  # @method get_execution_engine_target_data(ee)
  # @param [OpaqueExecutionEngine] ee
  # @return [OpaqueTargetData]
  # @scope class
  attach_function :get_execution_engine_target_data, :LLVMGetExecutionEngineTargetData, [OpaqueExecutionEngine], OpaqueTargetData

  # (Not documented)
  #
  # @method add_global_mapping(ee, global, addr)
  # @param [OpaqueExecutionEngine] ee
  # @param [OpaqueValue] global
  # @param [FFI::Pointer(*Void)] addr
  # @return [nil]
  # @scope class
  attach_function :add_global_mapping, :LLVMAddGlobalMapping, [OpaqueExecutionEngine, OpaqueValue, :pointer], :void

  # (Not documented)
  #
  # @method get_pointer_to_global(ee, global)
  # @param [OpaqueExecutionEngine] ee
  # @param [OpaqueValue] global
  # @return [FFI::Pointer(*Void)]
  # @scope class
  attach_function :get_pointer_to_global, :LLVMGetPointerToGlobal, [OpaqueExecutionEngine, OpaqueValue], :pointer

  # ===-- Operations on memory managers -------------------------------------===
  #
  # <em>This entry is only for documentation and no real method.</em>
  #
  # @method _callback_memory_manager_allocate_code_section_callback_(opaque, size, alignment, section_id, section_name)
  # @param [FFI::Pointer(*Void)] opaque
  # @param [Integer] size
  # @param [Integer] alignment
  # @param [Integer] section_id
  # @param [String] section_name
  # @return [Integer]
  # @scope class
  callback :memory_manager_allocate_code_section_callback, [:pointer, :ulong, :uint, :uint, :string], :uchar

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method.</em>
  #
  # @method _callback_memory_manager_allocate_data_section_callback_(opaque, size, alignment, section_id, section_name, is_read_only)
  # @param [FFI::Pointer(*Void)] opaque
  # @param [Integer] size
  # @param [Integer] alignment
  # @param [Integer] section_id
  # @param [String] section_name
  # @param [Integer] is_read_only
  # @return [Integer]
  # @scope class
  callback :memory_manager_allocate_data_section_callback, [:pointer, :ulong, :uint, :uint, :string, :int], :uchar

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method.</em>
  #
  # @method _callback_memory_manager_finalize_memory_callback_(opaque, err_msg)
  # @param [FFI::Pointer(*Void)] opaque
  # @param [FFI::Pointer(**CharS)] err_msg
  # @return [Integer]
  # @scope class
  callback :memory_manager_finalize_memory_callback, [:pointer, :pointer], :int

  # Create a simple custom MCJIT memory manager. This memory manager can
  # intercept allocations in a module-oblivious way. This will return NULL
  # if any of the passed functions are NULL.
  #
  # @param Opaque An opaque client object to pass back to the callbacks.
  # @param AllocateCodeSection Allocate a block of memory for executable code.
  # @param AllocateDataSection Allocate a block of memory for data.
  # @param FinalizeMemory Set page permissions and flush cache. Return 0 on
  #   success, 1 on error.
  #
  # @method create_simple_mcjit_memory_manager(opaque, allocate_code_section, allocate_data_section, finalize_memory, destroy)
  # @param [FFI::Pointer(*Void)] opaque
  # @param [Proc(_callback_memory_manager_allocate_code_section_callback_)] allocate_code_section
  # @param [Proc(_callback_memory_manager_allocate_data_section_callback_)] allocate_data_section
  # @param [Proc(_callback_memory_manager_finalize_memory_callback_)] finalize_memory
  # @param [FFI::Pointer(MemoryManagerDestroyCallback)] destroy
  # @return [OpaqueMCJITMemoryManager]
  # @scope class
  attach_function :create_simple_mcjit_memory_manager, :LLVMCreateSimpleMCJITMemoryManager, [:pointer, :memory_manager_allocate_code_section_callback, :memory_manager_allocate_data_section_callback, :memory_manager_finalize_memory_callback, :pointer], OpaqueMCJITMemoryManager

  # (Not documented)
  #
  # @method dispose_mcjit_memory_manager(mm)
  # @param [OpaqueMCJITMemoryManager] mm
  # @return [nil]
  # @scope class
  attach_function :dispose_mcjit_memory_manager, :LLVMDisposeMCJITMemoryManager, [OpaqueMCJITMemoryManager], :void

  # (Not documented)
  #
  # @method initialize_core(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_core, :LLVMInitializeCore, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method initialize_transform_utils(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_transform_utils, :LLVMInitializeTransformUtils, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method initialize_scalar_opts(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_scalar_opts, :LLVMInitializeScalarOpts, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method initialize_obj_carc_opts(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_objc_arc_opts, :LLVMInitializeObjCARCOpts, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method initialize_vectorization(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_vectorization, :LLVMInitializeVectorization, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method initialize_inst_combine(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_inst_combine, :LLVMInitializeInstCombine, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method initialize_ipo(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_ipo, :LLVMInitializeIPO, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method initialize_instrumentation(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_instrumentation, :LLVMInitializeInstrumentation, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method initialize_analysis(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_analysis, :LLVMInitializeAnalysis, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method initialize_ipa(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_ipa, :LLVMInitializeIPA, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method initialize_code_gen(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_code_gen, :LLVMInitializeCodeGen, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method initialize_target(r)
  # @param [OpaquePassRegistry] r
  # @return [nil]
  # @scope class
  attach_function :initialize_target, :LLVMInitializeTarget, [OpaquePassRegistry], :void

  # (Not documented)
  #
  # @method parse_ir_in_context(context_ref, mem_buf, out_m, out_message)
  # @param [OpaqueContext] context_ref
  # @param [OpaqueMemoryBuffer] mem_buf
  # @param [FFI::Pointer(*ModuleRef)] out_m
  # @param [FFI::Pointer(**CharS)] out_message
  # @return [Integer]
  # @scope class
  attach_function :parse_ir_in_context, :LLVMParseIRInContext, [OpaqueContext, OpaqueMemoryBuffer, :pointer, :pointer], :int

  # (Not documented)
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:linker_mode).</em>
  #
  # === Options:
  # :linker_destroy_source ::
  #
  #
  # @method _enum_linker_mode_
  # @return [Symbol]
  # @scope class
  enum :linker_mode, [
    :linker_destroy_source, 0
  ]

  # Links the source module into the destination module, taking ownership
  # of the source module away from the caller. Optionally returns a
  # human-readable description of any errors that occurred in linking.
  # OutMessage must be disposed with LLVMDisposeMessage. The return value
  # is true if an error occurred, false otherwise.
  #
  # @method link_modules(dest, src, mode, out_message)
  # @param [OpaqueModule] dest
  # @param [OpaqueModule] src
  # @param [Symbol from _enum_linker_mode_] mode
  # @param [FFI::Pointer(**CharS)] out_message
  # @return [Integer]
  # @scope class
  attach_function :link_modules, :LLVMLinkModules, [OpaqueModule, OpaqueModule, :linker_mode, :pointer], :int

  # /// This should map exactly onto the C++ enumerator LTOStatus.
  #
  # <em>This entry is only for documentation and no real method. The FFI::Enum can be accessed via #enum_type(:llvm_lto_status).</em>
  #
  # === Options:
  # :unknown ::
  #
  # :opt_success ::
  #
  # :read_success ::
  #
  # :read_failure ::
  #
  # :write_failure ::
  #
  # :no_target ::
  #
  # :no_work ::
  #
  # :module_merge_failure ::
  #
  # :asm_failure ::
  #
  # :null_object ::
  #   //  Added C-specific error codes
  #
  # @method _enum_llvm_lto_status_
  # @return [Symbol]
  # @scope class
  enum :llvm_lto_status, [
    :unknown, 0,
    :opt_success, 1,
    :read_success, 2,
    :read_failure, 3,
    :write_failure, 4,
    :no_target, 5,
    :no_work, 6,
    :module_merge_failure, 7,
    :asm_failure, 8,
    :null_object, 9
  ]

  # /// extern "C" helps, because dlopen() interface uses name to find the symbol.
  #
  # @method llvm_create_optimizer()
  # @return [FFI::Pointer(LlvmLtoT)]
  # @scope class
  attach_function :llvm_create_optimizer, :llvm_create_optimizer, [], :pointer

  # (Not documented)
  #
  # @method llvm_destroy_optimizer(lto)
  # @param [FFI::Pointer(LlvmLtoT)] lto
  # @return [nil]
  # @scope class
  attach_function :llvm_destroy_optimizer, :llvm_destroy_optimizer, [:pointer], :void

  # (Not documented)
  #
  # @method llvm_read_object_file(lto, input_filename)
  # @param [FFI::Pointer(LlvmLtoT)] lto
  # @param [String] input_filename
  # @return [Symbol from _enum_llvm_lto_status_]
  # @scope class
  attach_function :llvm_read_object_file, :llvm_read_object_file, [:pointer, :string], :llvm_lto_status

  # (Not documented)
  #
  # @method llvm_optimize_modules(lto, output_filename)
  # @param [FFI::Pointer(LlvmLtoT)] lto
  # @param [String] output_filename
  # @return [Symbol from _enum_llvm_lto_status_]
  # @scope class
  attach_function :llvm_optimize_modules, :llvm_optimize_modules, [:pointer, :string], :llvm_lto_status

  # (Not documented)
  class OpaqueObjectFile < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  class OpaqueSectionIterator < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  class OpaqueSymbolIterator < FFI::Struct
    layout :dummy, :char
  end

  # (Not documented)
  class OpaqueRelocationIterator < FFI::Struct
    layout :dummy, :char
  end

  # // ObjectFile creation
  #
  # @method create_object_file(mem_buf)
  # @param [OpaqueMemoryBuffer] mem_buf
  # @return [OpaqueObjectFile]
  # @scope class
  attach_function :create_object_file, :LLVMCreateObjectFile, [OpaqueMemoryBuffer], OpaqueObjectFile

  # (Not documented)
  #
  # @method dispose_object_file(object_file)
  # @param [OpaqueObjectFile] object_file
  # @return [nil]
  # @scope class
  attach_function :dispose_object_file, :LLVMDisposeObjectFile, [OpaqueObjectFile], :void

  # // ObjectFile Section iterators
  #
  # @method get_sections(object_file)
  # @param [OpaqueObjectFile] object_file
  # @return [OpaqueSectionIterator]
  # @scope class
  attach_function :get_sections, :LLVMGetSections, [OpaqueObjectFile], OpaqueSectionIterator

  # (Not documented)
  #
  # @method dispose_section_iterator(si)
  # @param [OpaqueSectionIterator] si
  # @return [nil]
  # @scope class
  attach_function :dispose_section_iterator, :LLVMDisposeSectionIterator, [OpaqueSectionIterator], :void

  # (Not documented)
  #
  # @method is_section_iterator_at_end(object_file, si)
  # @param [OpaqueObjectFile] object_file
  # @param [OpaqueSectionIterator] si
  # @return [Integer]
  # @scope class
  attach_function :is_section_iterator_at_end, :LLVMIsSectionIteratorAtEnd, [OpaqueObjectFile, OpaqueSectionIterator], :int

  # (Not documented)
  #
  # @method move_to_next_section(si)
  # @param [OpaqueSectionIterator] si
  # @return [nil]
  # @scope class
  attach_function :move_to_next_section, :LLVMMoveToNextSection, [OpaqueSectionIterator], :void

  # (Not documented)
  #
  # @method move_to_containing_section(sect, sym)
  # @param [OpaqueSectionIterator] sect
  # @param [OpaqueSymbolIterator] sym
  # @return [nil]
  # @scope class
  attach_function :move_to_containing_section, :LLVMMoveToContainingSection, [OpaqueSectionIterator, OpaqueSymbolIterator], :void

  # // ObjectFile Symbol iterators
  #
  # @method get_symbols(object_file)
  # @param [OpaqueObjectFile] object_file
  # @return [OpaqueSymbolIterator]
  # @scope class
  attach_function :get_symbols, :LLVMGetSymbols, [OpaqueObjectFile], OpaqueSymbolIterator

  # (Not documented)
  #
  # @method dispose_symbol_iterator(si)
  # @param [OpaqueSymbolIterator] si
  # @return [nil]
  # @scope class
  attach_function :dispose_symbol_iterator, :LLVMDisposeSymbolIterator, [OpaqueSymbolIterator], :void

  # (Not documented)
  #
  # @method is_symbol_iterator_at_end(object_file, si)
  # @param [OpaqueObjectFile] object_file
  # @param [OpaqueSymbolIterator] si
  # @return [Integer]
  # @scope class
  attach_function :is_symbol_iterator_at_end, :LLVMIsSymbolIteratorAtEnd, [OpaqueObjectFile, OpaqueSymbolIterator], :int

  # (Not documented)
  #
  # @method move_to_next_symbol(si)
  # @param [OpaqueSymbolIterator] si
  # @return [nil]
  # @scope class
  attach_function :move_to_next_symbol, :LLVMMoveToNextSymbol, [OpaqueSymbolIterator], :void

  # // SectionRef accessors
  #
  # @method get_section_name(si)
  # @param [OpaqueSectionIterator] si
  # @return [String]
  # @scope class
  attach_function :get_section_name, :LLVMGetSectionName, [OpaqueSectionIterator], :string

  # (Not documented)
  #
  # @method get_section_size(si)
  # @param [OpaqueSectionIterator] si
  # @return [Integer]
  # @scope class
  attach_function :get_section_size, :LLVMGetSectionSize, [OpaqueSectionIterator], :ulong

  # (Not documented)
  #
  # @method get_section_contents(si)
  # @param [OpaqueSectionIterator] si
  # @return [String]
  # @scope class
  attach_function :get_section_contents, :LLVMGetSectionContents, [OpaqueSectionIterator], :string

  # (Not documented)
  #
  # @method get_section_address(si)
  # @param [OpaqueSectionIterator] si
  # @return [Integer]
  # @scope class
  attach_function :get_section_address, :LLVMGetSectionAddress, [OpaqueSectionIterator], :ulong

  # (Not documented)
  #
  # @method get_section_contains_symbol(si, sym)
  # @param [OpaqueSectionIterator] si
  # @param [OpaqueSymbolIterator] sym
  # @return [Integer]
  # @scope class
  attach_function :get_section_contains_symbol, :LLVMGetSectionContainsSymbol, [OpaqueSectionIterator, OpaqueSymbolIterator], :int

  # // Section Relocation iterators
  #
  # @method get_relocations(section)
  # @param [OpaqueSectionIterator] section
  # @return [OpaqueRelocationIterator]
  # @scope class
  attach_function :get_relocations, :LLVMGetRelocations, [OpaqueSectionIterator], OpaqueRelocationIterator

  # (Not documented)
  #
  # @method dispose_relocation_iterator(ri)
  # @param [OpaqueRelocationIterator] ri
  # @return [nil]
  # @scope class
  attach_function :dispose_relocation_iterator, :LLVMDisposeRelocationIterator, [OpaqueRelocationIterator], :void

  # (Not documented)
  #
  # @method is_relocation_iterator_at_end(section, ri)
  # @param [OpaqueSectionIterator] section
  # @param [OpaqueRelocationIterator] ri
  # @return [Integer]
  # @scope class
  attach_function :is_relocation_iterator_at_end, :LLVMIsRelocationIteratorAtEnd, [OpaqueSectionIterator, OpaqueRelocationIterator], :int

  # (Not documented)
  #
  # @method move_to_next_relocation(ri)
  # @param [OpaqueRelocationIterator] ri
  # @return [nil]
  # @scope class
  attach_function :move_to_next_relocation, :LLVMMoveToNextRelocation, [OpaqueRelocationIterator], :void

  # // SymbolRef accessors
  #
  # @method get_symbol_name(si)
  # @param [OpaqueSymbolIterator] si
  # @return [String]
  # @scope class
  attach_function :get_symbol_name, :LLVMGetSymbolName, [OpaqueSymbolIterator], :string

  # (Not documented)
  #
  # @method get_symbol_address(si)
  # @param [OpaqueSymbolIterator] si
  # @return [Integer]
  # @scope class
  attach_function :get_symbol_address, :LLVMGetSymbolAddress, [OpaqueSymbolIterator], :ulong

  # (Not documented)
  #
  # @method get_symbol_file_offset(si)
  # @param [OpaqueSymbolIterator] si
  # @return [Integer]
  # @scope class
  attach_function :get_symbol_file_offset, :LLVMGetSymbolFileOffset, [OpaqueSymbolIterator], :ulong

  # (Not documented)
  #
  # @method get_symbol_size(si)
  # @param [OpaqueSymbolIterator] si
  # @return [Integer]
  # @scope class
  attach_function :get_symbol_size, :LLVMGetSymbolSize, [OpaqueSymbolIterator], :ulong

  # // RelocationRef accessors
  #
  # @method get_relocation_address(ri)
  # @param [OpaqueRelocationIterator] ri
  # @return [Integer]
  # @scope class
  attach_function :get_relocation_address, :LLVMGetRelocationAddress, [OpaqueRelocationIterator], :ulong

  # (Not documented)
  #
  # @method get_relocation_offset(ri)
  # @param [OpaqueRelocationIterator] ri
  # @return [Integer]
  # @scope class
  attach_function :get_relocation_offset, :LLVMGetRelocationOffset, [OpaqueRelocationIterator], :ulong

  # (Not documented)
  #
  # @method get_relocation_symbol(ri)
  # @param [OpaqueRelocationIterator] ri
  # @return [OpaqueSymbolIterator]
  # @scope class
  attach_function :get_relocation_symbol, :LLVMGetRelocationSymbol, [OpaqueRelocationIterator], OpaqueSymbolIterator

  # (Not documented)
  #
  # @method get_relocation_type(ri)
  # @param [OpaqueRelocationIterator] ri
  # @return [Integer]
  # @scope class
  attach_function :get_relocation_type, :LLVMGetRelocationType, [OpaqueRelocationIterator], :ulong

  # // following functions.
  #
  # @method get_relocation_type_name(ri)
  # @param [OpaqueRelocationIterator] ri
  # @return [String]
  # @scope class
  attach_function :get_relocation_type_name, :LLVMGetRelocationTypeName, [OpaqueRelocationIterator], :string

  # (Not documented)
  #
  # @method get_relocation_value_string(ri)
  # @param [OpaqueRelocationIterator] ri
  # @return [String]
  # @scope class
  attach_function :get_relocation_value_string, :LLVMGetRelocationValueString, [OpaqueRelocationIterator], :string

  # (Not documented)
  #
  # @method load_library_permanently(filename)
  # @param [String] filename
  # @return [Integer]
  # @scope class
  attach_function :load_library_permanently, :LLVMLoadLibraryPermanently, [:string], :int

  # (Not documented)
  #
  # @method add_argument_promotion_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_argument_promotion_pass, :LLVMAddArgumentPromotionPass, [OpaquePassManager], :void

  # See llvm::createConstantMergePass function.
  #
  # @method add_constant_merge_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_constant_merge_pass, :LLVMAddConstantMergePass, [OpaquePassManager], :void

  # See llvm::createDeadArgEliminationPass function.
  #
  # @method add_dead_arg_elimination_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_dead_arg_elimination_pass, :LLVMAddDeadArgEliminationPass, [OpaquePassManager], :void

  # See llvm::createFunctionAttrsPass function.
  #
  # @method add_function_attrs_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_function_attrs_pass, :LLVMAddFunctionAttrsPass, [OpaquePassManager], :void

  # See llvm::createFunctionInliningPass function.
  #
  # @method add_function_inlining_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_function_inlining_pass, :LLVMAddFunctionInliningPass, [OpaquePassManager], :void

  # See llvm::createAlwaysInlinerPass function.
  #
  # @method add_always_inliner_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_always_inliner_pass, :LLVMAddAlwaysInlinerPass, [OpaquePassManager], :void

  # See llvm::createGlobalDCEPass function.
  #
  # @method add_global_dce_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_global_dce_pass, :LLVMAddGlobalDCEPass, [OpaquePassManager], :void

  # See llvm::createGlobalOptimizerPass function.
  #
  # @method add_global_optimizer_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_global_optimizer_pass, :LLVMAddGlobalOptimizerPass, [OpaquePassManager], :void

  # See llvm::createIPConstantPropagationPass function.
  #
  # @method add_ip_constant_propagation_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_ip_constant_propagation_pass, :LLVMAddIPConstantPropagationPass, [OpaquePassManager], :void

  # See llvm::createPruneEHPass function.
  #
  # @method add_prune_eh_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_prune_eh_pass, :LLVMAddPruneEHPass, [OpaquePassManager], :void

  # See llvm::createIPSCCPPass function.
  #
  # @method add_ipsccp_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_ipsccp_pass, :LLVMAddIPSCCPPass, [OpaquePassManager], :void

  # See llvm::createInternalizePass function.
  #
  # @method add_internalize_pass(opaque_pass_manager, all_but_main)
  # @param [OpaquePassManager] opaque_pass_manager
  # @param [Integer] all_but_main
  # @return [nil]
  # @scope class
  attach_function :add_internalize_pass, :LLVMAddInternalizePass, [OpaquePassManager, :uint], :void

  # See llvm::createStripDeadPrototypesPass function.
  #
  # @method add_strip_dead_prototypes_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_strip_dead_prototypes_pass, :LLVMAddStripDeadPrototypesPass, [OpaquePassManager], :void

  # See llvm::createStripSymbolsPass function.
  #
  # @method add_strip_symbols_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_strip_symbols_pass, :LLVMAddStripSymbolsPass, [OpaquePassManager], :void

  # (Not documented)
  class OpaquePassManagerBuilder < FFI::Struct
    layout :dummy, :char
  end

  # See llvm::PassManagerBuilder.
  #
  # @method pass_manager_builder_create()
  # @return [OpaquePassManagerBuilder]
  # @scope class
  attach_function :pass_manager_builder_create, :LLVMPassManagerBuilderCreate, [], OpaquePassManagerBuilder

  # (Not documented)
  #
  # @method pass_manager_builder_dispose(pmb)
  # @param [OpaquePassManagerBuilder] pmb
  # @return [nil]
  # @scope class
  attach_function :pass_manager_builder_dispose, :LLVMPassManagerBuilderDispose, [OpaquePassManagerBuilder], :void

  # See llvm::PassManagerBuilder::OptLevel.
  #
  # @method pass_manager_builder_set_opt_level(pmb, opt_level)
  # @param [OpaquePassManagerBuilder] pmb
  # @param [Integer] opt_level
  # @return [nil]
  # @scope class
  attach_function :pass_manager_builder_set_opt_level, :LLVMPassManagerBuilderSetOptLevel, [OpaquePassManagerBuilder, :uint], :void

  # See llvm::PassManagerBuilder::SizeLevel.
  #
  # @method pass_manager_builder_set_size_level(pmb, size_level)
  # @param [OpaquePassManagerBuilder] pmb
  # @param [Integer] size_level
  # @return [nil]
  # @scope class
  attach_function :pass_manager_builder_set_size_level, :LLVMPassManagerBuilderSetSizeLevel, [OpaquePassManagerBuilder, :uint], :void

  # See llvm::PassManagerBuilder::DisableUnitAtATime.
  #
  # @method pass_manager_builder_set_disable_unit_at_a_time(pmb, value)
  # @param [OpaquePassManagerBuilder] pmb
  # @param [Integer] value
  # @return [nil]
  # @scope class
  attach_function :pass_manager_builder_set_disable_unit_at_a_time, :LLVMPassManagerBuilderSetDisableUnitAtATime, [OpaquePassManagerBuilder, :int], :void

  # See llvm::PassManagerBuilder::DisableUnrollLoops.
  #
  # @method pass_manager_builder_set_disable_unroll_loops(pmb, value)
  # @param [OpaquePassManagerBuilder] pmb
  # @param [Integer] value
  # @return [nil]
  # @scope class
  attach_function :pass_manager_builder_set_disable_unroll_loops, :LLVMPassManagerBuilderSetDisableUnrollLoops, [OpaquePassManagerBuilder, :int], :void

  # See llvm::PassManagerBuilder::DisableSimplifyLibCalls
  #
  # @method pass_manager_builder_set_disable_simplify_lib_calls(pmb, value)
  # @param [OpaquePassManagerBuilder] pmb
  # @param [Integer] value
  # @return [nil]
  # @scope class
  attach_function :pass_manager_builder_set_disable_simplify_lib_calls, :LLVMPassManagerBuilderSetDisableSimplifyLibCalls, [OpaquePassManagerBuilder, :int], :void

  # See llvm::PassManagerBuilder::Inliner.
  #
  # @method pass_manager_builder_use_inliner_with_threshold(pmb, threshold)
  # @param [OpaquePassManagerBuilder] pmb
  # @param [Integer] threshold
  # @return [nil]
  # @scope class
  attach_function :pass_manager_builder_use_inliner_with_threshold, :LLVMPassManagerBuilderUseInlinerWithThreshold, [OpaquePassManagerBuilder, :uint], :void

  # See llvm::PassManagerBuilder::populateFunctionPassManager.
  #
  # @method pass_manager_builder_populate_function_pass_manager(pmb, pm)
  # @param [OpaquePassManagerBuilder] pmb
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :pass_manager_builder_populate_function_pass_manager, :LLVMPassManagerBuilderPopulateFunctionPassManager, [OpaquePassManagerBuilder, OpaquePassManager], :void

  # See llvm::PassManagerBuilder::populateModulePassManager.
  #
  # @method pass_manager_builder_populate_module_pass_manager(pmb, pm)
  # @param [OpaquePassManagerBuilder] pmb
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :pass_manager_builder_populate_module_pass_manager, :LLVMPassManagerBuilderPopulateModulePassManager, [OpaquePassManagerBuilder, OpaquePassManager], :void

  # See llvm::PassManagerBuilder::populateLTOPassManager.
  #
  # @method pass_manager_builder_populate_lto_pass_manager(pmb, pm, internalize, run_inliner)
  # @param [OpaquePassManagerBuilder] pmb
  # @param [OpaquePassManager] pm
  # @param [Integer] internalize
  # @param [Integer] run_inliner
  # @return [nil]
  # @scope class
  attach_function :pass_manager_builder_populate_lto_pass_manager, :LLVMPassManagerBuilderPopulateLTOPassManager, [OpaquePassManagerBuilder, OpaquePassManager, :int, :int], :void

  # (Not documented)
  #
  # @method add_aggressive_dce_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_aggressive_dce_pass, :LLVMAddAggressiveDCEPass, [OpaquePassManager], :void

  # See llvm::createCFGSimplificationPass function.
  #
  # @method add_cfg_simplification_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_cfg_simplification_pass, :LLVMAddCFGSimplificationPass, [OpaquePassManager], :void

  # See llvm::createDeadStoreEliminationPass function.
  #
  # @method add_dead_store_elimination_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_dead_store_elimination_pass, :LLVMAddDeadStoreEliminationPass, [OpaquePassManager], :void

  # See llvm::createGVNPass function.
  #
  # @method add_gvn_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_gvn_pass, :LLVMAddGVNPass, [OpaquePassManager], :void

  # See llvm::createIndVarSimplifyPass function.
  #
  # @method add_ind_var_simplify_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_ind_var_simplify_pass, :LLVMAddIndVarSimplifyPass, [OpaquePassManager], :void

  # See llvm::createInstructionCombiningPass function.
  #
  # @method add_instruction_combining_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_instruction_combining_pass, :LLVMAddInstructionCombiningPass, [OpaquePassManager], :void

  # See llvm::createJumpThreadingPass function.
  #
  # @method add_jump_threading_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_jump_threading_pass, :LLVMAddJumpThreadingPass, [OpaquePassManager], :void

  # See llvm::createLICMPass function.
  #
  # @method add_licm_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_licm_pass, :LLVMAddLICMPass, [OpaquePassManager], :void

  # See llvm::createLoopDeletionPass function.
  #
  # @method add_loop_deletion_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_loop_deletion_pass, :LLVMAddLoopDeletionPass, [OpaquePassManager], :void

  # See llvm::createLoopIdiomPass function
  #
  # @method add_loop_idiom_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_loop_idiom_pass, :LLVMAddLoopIdiomPass, [OpaquePassManager], :void

  # See llvm::createLoopRotatePass function.
  #
  # @method add_loop_rotate_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_loop_rotate_pass, :LLVMAddLoopRotatePass, [OpaquePassManager], :void

  # See llvm::createLoopRerollPass function.
  #
  # @method add_loop_reroll_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_loop_reroll_pass, :LLVMAddLoopRerollPass, [OpaquePassManager], :void

  # See llvm::createLoopUnrollPass function.
  #
  # @method add_loop_unroll_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_loop_unroll_pass, :LLVMAddLoopUnrollPass, [OpaquePassManager], :void

  # See llvm::createLoopUnswitchPass function.
  #
  # @method add_loop_unswitch_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_loop_unswitch_pass, :LLVMAddLoopUnswitchPass, [OpaquePassManager], :void

  # See llvm::createMemCpyOptPass function.
  #
  # @method add_mem_cpy_opt_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_mem_cpy_opt_pass, :LLVMAddMemCpyOptPass, [OpaquePassManager], :void

  # See llvm::createPartiallyInlineLibCallsPass function.
  #
  # @method add_partially_inline_lib_calls_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_partially_inline_lib_calls_pass, :LLVMAddPartiallyInlineLibCallsPass, [OpaquePassManager], :void

  # See llvm::createPromoteMemoryToRegisterPass function.
  #
  # @method add_promote_memory_to_register_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_promote_memory_to_register_pass, :LLVMAddPromoteMemoryToRegisterPass, [OpaquePassManager], :void

  # See llvm::createReassociatePass function.
  #
  # @method add_reassociate_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_reassociate_pass, :LLVMAddReassociatePass, [OpaquePassManager], :void

  # See llvm::createSCCPPass function.
  #
  # @method add_sccp_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_sccp_pass, :LLVMAddSCCPPass, [OpaquePassManager], :void

  # See llvm::createScalarReplAggregatesPass function.
  #
  # @method add_scalar_repl_aggregates_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_scalar_repl_aggregates_pass, :LLVMAddScalarReplAggregatesPass, [OpaquePassManager], :void

  # See llvm::createScalarReplAggregatesPass function.
  #
  # @method add_scalar_repl_aggregates_pass_ssa(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_scalar_repl_aggregates_pass_ssa, :LLVMAddScalarReplAggregatesPassSSA, [OpaquePassManager], :void

  # See llvm::createScalarReplAggregatesPass function.
  #
  # @method add_scalar_repl_aggregates_pass_with_threshold(pm, threshold)
  # @param [OpaquePassManager] pm
  # @param [Integer] threshold
  # @return [nil]
  # @scope class
  attach_function :add_scalar_repl_aggregates_pass_with_threshold, :LLVMAddScalarReplAggregatesPassWithThreshold, [OpaquePassManager, :int], :void

  # See llvm::createSimplifyLibCallsPass function.
  #
  # @method add_simplify_lib_calls_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_simplify_lib_calls_pass, :LLVMAddSimplifyLibCallsPass, [OpaquePassManager], :void

  # See llvm::createTailCallEliminationPass function.
  #
  # @method add_tail_call_elimination_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_tail_call_elimination_pass, :LLVMAddTailCallEliminationPass, [OpaquePassManager], :void

  # See llvm::createConstantPropagationPass function.
  #
  # @method add_constant_propagation_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_constant_propagation_pass, :LLVMAddConstantPropagationPass, [OpaquePassManager], :void

  # See llvm::demotePromoteMemoryToRegisterPass function.
  #
  # @method add_demote_memory_to_register_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_demote_memory_to_register_pass, :LLVMAddDemoteMemoryToRegisterPass, [OpaquePassManager], :void

  # See llvm::createVerifierPass function.
  #
  # @method add_verifier_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_verifier_pass, :LLVMAddVerifierPass, [OpaquePassManager], :void

  # See llvm::createCorrelatedValuePropagationPass function
  #
  # @method add_correlated_value_propagation_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_correlated_value_propagation_pass, :LLVMAddCorrelatedValuePropagationPass, [OpaquePassManager], :void

  # See llvm::createEarlyCSEPass function
  #
  # @method add_early_cse_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_early_cse_pass, :LLVMAddEarlyCSEPass, [OpaquePassManager], :void

  # See llvm::createLowerExpectIntrinsicPass function
  #
  # @method add_lower_expect_intrinsic_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_lower_expect_intrinsic_pass, :LLVMAddLowerExpectIntrinsicPass, [OpaquePassManager], :void

  # See llvm::createTypeBasedAliasAnalysisPass function
  #
  # @method add_type_based_alias_analysis_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_type_based_alias_analysis_pass, :LLVMAddTypeBasedAliasAnalysisPass, [OpaquePassManager], :void

  # See llvm::createBasicAliasAnalysisPass function
  #
  # @method add_basic_alias_analysis_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_basic_alias_analysis_pass, :LLVMAddBasicAliasAnalysisPass, [OpaquePassManager], :void

  # (Not documented)
  #
  # @method add_bb_vectorize_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_bb_vectorize_pass, :LLVMAddBBVectorizePass, [OpaquePassManager], :void

  # See llvm::createLoopVectorizePass function.
  #
  # @method add_loop_vectorize_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_loop_vectorize_pass, :LLVMAddLoopVectorizePass, [OpaquePassManager], :void

  # See llvm::createSLPVectorizerPass function.
  #
  # @method add_slp_vectorize_pass(pm)
  # @param [OpaquePassManager] pm
  # @return [nil]
  # @scope class
  attach_function :add_slp_vectorize_pass, :LLVMAddSLPVectorizePass, [OpaquePassManager], :void

end
