/*
 * Decompiled with CFR 0.152.
 */
package dotty.tools.xsbt;

import dotty.tools.dotc.reporting.CodeAction;
import dotty.tools.dotc.rewrites.Rewrites;
import dotty.tools.dotc.util.SourceFile;
import dotty.tools.dotc.util.SourcePosition;
import dotty.tools.xsbt.Action;
import dotty.tools.xsbt.DiagnosticCode;
import dotty.tools.xsbt.PositionBridge;
import dotty.tools.xsbt.TextEdit;
import dotty.tools.xsbt.WorkspaceEdit;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import scala.Option;
import scala.collection.Seq;
import scala.jdk.javaapi.CollectionConverters;
import scala.jdk.javaapi.OptionConverters;
import xsbti.Position;
import xsbti.Severity;

public final class Problem
implements xsbti.Problem {
    private final Position _position;
    private final String _message;
    private final Severity _severity;
    private final Optional<String> _rendered;
    private final String _diagnosticCode;
    private final List<CodeAction> _actions;
    private final Function<SourceFile, String> _lookupVirtualFileId;

    public Problem(Position position, String string, Severity severity, String string2, String string3, List<CodeAction> list, Function<SourceFile, String> function) {
        this._position = position;
        this._message = string;
        this._severity = severity;
        this._rendered = Optional.of(string2);
        this._diagnosticCode = string3;
        this._actions = list;
        this._lookupVirtualFileId = function;
    }

    public String category() {
        return "";
    }

    public Position position() {
        return this._position;
    }

    public String message() {
        return this._message;
    }

    public Severity severity() {
        return this._severity;
    }

    public Optional<String> rendered() {
        return this._rendered;
    }

    public Optional<xsbti.DiagnosticCode> diagnosticCode() {
        if (this._diagnosticCode == "-1") {
            return Optional.empty();
        }
        return Optional.of(new DiagnosticCode(this._diagnosticCode, Optional.empty()));
    }

    public List<xsbti.Action> actions() {
        if (this._actions.isEmpty()) {
            return Collections.emptyList();
        }
        return this._actions.stream().map(codeAction -> new Action(codeAction.title(), OptionConverters.toJava((Option)codeAction.description()), Problem.toWorkspaceEdit(CollectionConverters.asJava((Seq)codeAction.patches()), this._lookupVirtualFileId))).collect(Collectors.toList());
    }

    private static WorkspaceEdit toWorkspaceEdit(List<Rewrites.ActionPatch> list, Function<SourceFile, String> function) {
        return new WorkspaceEdit(list.stream().map(actionPatch -> new TextEdit(Problem.positionOf(actionPatch.srcPos(), function), actionPatch.replacement())).collect(Collectors.toList()));
    }

    private static Position positionOf(SourcePosition sourcePosition, Function<SourceFile, String> function) {
        if (sourcePosition.exists()) {
            return new PositionBridge(sourcePosition, function.apply(sourcePosition.source()));
        }
        return PositionBridge.noPosition;
    }

    public String toString() {
        return "Problem(" + this._position + ", " + this._message + ", " + this._severity + ", " + this._rendered + ", " + this._diagnosticCode + ")";
    }
}

