/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.annotation.ActionInput;
import org.openhab.core.automation.handler.BaseActionModuleHandler;
import org.openhab.core.automation.type.ActionType;
import org.openhab.core.automation.type.Input;
import org.openhab.core.automation.type.Output;
import org.openhab.core.automation.util.ActionInputsHelper;
import org.openhab.core.library.types.QuantityType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class AnnotationActionHandler
extends BaseActionModuleHandler {
    public static final String MODULE_RESULT = "result";
    private final Logger logger = LoggerFactory.getLogger(AnnotationActionHandler.class);
    private final Method method;
    private final ActionType moduleType;
    private final Object actionProvider;
    private final ActionInputsHelper actionInputsHelper;

    public AnnotationActionHandler(Action module, ActionType mt, Method method, Object actionProvider, ActionInputsHelper actionInputsHelper) {
        super(module);
        this.method = method;
        this.moduleType = mt;
        this.actionProvider = actionProvider;
        this.actionInputsHelper = actionInputsHelper;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public @Nullable Map<String, Object> execute(Map<String, Object> context) {
        Object value;
        HashMap<String, Object> output = new HashMap<String, Object>();
        Annotation[][] annotations = this.method.getParameterAnnotations();
        ArrayList<@Nullable Object> args = new ArrayList<Object>();
        int i = 0;
        while (i < annotations.length) {
            block28: {
                block27: {
                    Annotation[] annotationsOnParam = annotations[i];
                    if (annotationsOnParam == null || annotationsOnParam.length != 1) break block27;
                    Annotation annotation = annotationsOnParam[0];
                    if (annotation instanceof ActionInput) {
                        Object configValue;
                        ActionInput inputAnnotation = (ActionInput)annotation;
                        if (!this.hasInput(this.moduleType, inputAnnotation.name())) {
                            this.logger.error("Annotated method defines input '{}' but the module type '{}' does not specify an input with this name.", (Object)inputAnnotation.name(), (Object)this.moduleType);
                            return output;
                        }
                        value = context.get(inputAnnotation.name());
                        if (value == null && (configValue = ((Action)this.module).getConfiguration().get(inputAnnotation.name())) != null) {
                            try {
                                value = this.actionInputsHelper.mapSerializedInputToActionInput(this.moduleType.getInputs().get(i), configValue);
                            }
                            catch (IllegalArgumentException e) {
                                this.logger.debug("{} Input parameter is ignored.", (Object)e.getMessage());
                            }
                        }
                        args.add(i, value);
                    }
                    break block28;
                }
                args.add(i, context.get("p" + i));
            }
            ++i;
        }
        Object result = null;
        Object @Nullable [] arguments = args.toArray();
        if (arguments.length > 0 && this.logger.isDebugEnabled()) {
            this.logger.debug("Calling action method {} with the following arguments:", (Object)this.method.getName());
            int i2 = 0;
            while (i2 < arguments.length) {
                if (arguments[i2] == null) {
                    this.logger.debug("  - Argument {}: null", (Object)i2);
                } else {
                    this.logger.debug("  - Argument {}: type {} value {}", new Object[]{i2, arguments[i2].getClass().getCanonicalName(), arguments[i2]});
                }
                ++i2;
            }
        }
        try {
            result = this.method.invoke(this.actionProvider, arguments);
        }
        catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            this.logger.error("Could not call method '{}' from module type '{}'.", new Object[]{this.method, this.moduleType.getUID(), e});
        }
        if (result == null) return output;
        if (result instanceof Map) {
            try {
                Map resultMap = (Map)result;
                value = resultMap.entrySet().iterator();
                while (true) {
                    if (!value.hasNext()) {
                        return output;
                    }
                    Map.Entry entry = (Map.Entry)value.next();
                    if (!this.hasOutput(this.moduleType, (String)entry.getKey())) continue;
                    output.put((String)entry.getKey(), entry.getValue());
                }
            }
            catch (ClassCastException ex) {
                this.logger.error("The return type of action method '{}' from module type '{}' should be Map<String, Object>, because {}", new Object[]{this.method, this.moduleType.getUID(), ex.getMessage()});
                return output;
            }
        }
        if (result instanceof Boolean) {
            Boolean booleanValue = (Boolean)result;
            output.put(MODULE_RESULT, booleanValue);
            return output;
        }
        if (result instanceof String) {
            String string = (String)result;
            output.put(MODULE_RESULT, string);
            return output;
        }
        if (result instanceof Byte) {
            Byte byteValue = (Byte)result;
            output.put(MODULE_RESULT, byteValue);
            return output;
        }
        if (result instanceof Short) {
            Short shortValue = (Short)result;
            output.put(MODULE_RESULT, shortValue);
            return output;
        }
        if (result instanceof Integer) {
            Integer integerValue = (Integer)result;
            output.put(MODULE_RESULT, integerValue);
            return output;
        }
        if (result instanceof Long) {
            Long longValue = (Long)result;
            output.put(MODULE_RESULT, longValue);
            return output;
        }
        if (result instanceof Double) {
            Double doubleValue = (Double)result;
            output.put(MODULE_RESULT, doubleValue);
            return output;
        }
        if (result instanceof Float) {
            Float floatValue = (Float)result;
            output.put(MODULE_RESULT, floatValue);
            return output;
        }
        if (result instanceof BigDecimal) {
            BigDecimal bigDecimalValue = (BigDecimal)result;
            output.put(MODULE_RESULT, bigDecimalValue.doubleValue());
            return output;
        }
        if (!(result instanceof QuantityType || result instanceof LocalDate || result instanceof LocalTime || result instanceof LocalDateTime || result instanceof ZonedDateTime || result instanceof Instant || result instanceof Duration)) {
            this.logger.warn("Non compatible return type '{}' on action method.", result.getClass());
            return output;
        }
        output.put(MODULE_RESULT, result.toString());
        return output;
    }

    private boolean hasInput(ActionType moduleType, String in) {
        for (Input i : moduleType.getInputs()) {
            if (!i.getName().equals(in)) continue;
            return true;
        }
        return false;
    }

    private boolean hasOutput(ActionType moduleType, String out) {
        for (Output o : moduleType.getOutputs()) {
            if (!o.getName().equals(out)) continue;
            return true;
        }
        return false;
    }
}

