/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.client.registration.cli.commands;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.keycloak.client.cli.config.ConfigData;
import org.keycloak.client.cli.util.ConfigUtil;
import org.keycloak.client.cli.util.HttpUtil;
import org.keycloak.client.cli.util.IoUtil;
import org.keycloak.client.cli.util.OsUtil;
import org.keycloak.client.registration.cli.KcRegMain;
import org.keycloak.client.registration.cli.commands.AbstractAuthOptionsCmd;
import picocli.CommandLine;

@CommandLine.Command(name="delete", description={"CLIENT [GLOBAL_OPTIONS]"})
public class DeleteCmd
extends AbstractAuthOptionsCmd {
    @CommandLine.Parameters(arity="0..1")
    String clientId;

    @Override
    protected void process() {
        if (this.clientId == null) {
            throw new IllegalArgumentException("CLIENT not specified");
        }
        if (this.clientId.startsWith("-")) {
            IoUtil.warnfErr("You're using what looks like an OPTION as CLIENT: %s", this.clientId);
        }
        String regType = "default";
        ConfigData config = ConfigUtil.loadConfig();
        config = this.copyWithServerInfo(config);
        if (this.externalToken == null) {
            this.externalToken = ConfigUtil.getRegistrationToken(config.sessionRealmConfigData(), this.clientId);
        }
        this.setupTruststore(config);
        Object auth = this.externalToken;
        if (auth == null) {
            config = this.ensureAuthInfo(config);
            if (ConfigUtil.credentialsAvailable(config = this.copyWithServerInfo(config))) {
                auth = this.ensureToken(config);
            }
        }
        auth = auth != null ? "Bearer " + (String)auth : null;
        String server = config.getServerUrl();
        String realm = config.getRealm();
        HttpUtil.doDelete(server + "/realms/" + realm + "/clients-registrations/" + regType + "/" + HttpUtil.urlencode(this.clientId), (String)auth);
        ConfigUtil.saveMergeConfig(cfg -> cfg.ensureRealmConfigData(server, realm).getClients().remove(this.clientId));
    }

    @Override
    protected boolean nothingToDo() {
        return super.nothingToDo() && this.clientId == null;
    }

    @Override
    protected String help() {
        StringWriter sb = new StringWriter();
        PrintWriter out = new PrintWriter(sb);
        out.println("Usage: " + KcRegMain.CMD + " delete CLIENT [ARGUMENTS]");
        out.println();
        out.println("Command to delete a specific client configuration. If registration access token is specified or is available in ");
        out.println("configuration file, then it is used. Otherwise, current active session is used.");
        this.globalOptions(out);
        out.println("    CLIENT                ClientId of the client to delete");
        out.println("    -t, --token TOKEN     Use the specified Registration Access Token for authorization");
        out.println();
        out.println("Examples:");
        out.println();
        out.println("Delete a client:");
        out.println("  " + OsUtil.PROMPT + " " + KcRegMain.CMD + " delete my_client");
        out.println();
        out.println();
        out.println("Use '" + KcRegMain.CMD + " help' for general information and a list of commands");
        return sb.toString();
    }
}

