/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import org.infinispan.commons.util.concurrent.AggregateCompletionStage;
import org.infinispan.util.function.TriConsumer;
import org.jboss.logging.Logger;
import org.keycloak.models.AuthenticatedClientSessionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.ModelIllegalStateException;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.delegate.ClientModelLazyDelegate;
import org.keycloak.models.session.PersistentAuthenticatedClientSessionAdapter;
import org.keycloak.models.session.PersistentUserSessionAdapter;
import org.keycloak.models.session.UserSessionPersisterProvider;
import org.keycloak.models.sessions.infinispan.changes.MergedUpdate;
import org.keycloak.models.sessions.infinispan.changes.PersistentUpdate;
import org.keycloak.models.sessions.infinispan.changes.SessionEntityWrapper;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdateTask;
import org.keycloak.models.sessions.infinispan.changes.SessionUpdatesList;
import org.keycloak.models.sessions.infinispan.entities.AuthenticatedClientSessionEntity;
import org.keycloak.models.sessions.infinispan.entities.SessionEntity;
import org.keycloak.models.sessions.infinispan.entities.UserSessionEntity;
import org.keycloak.models.utils.RealmModelDelegate;
import org.keycloak.models.utils.UserModelDelegate;
import org.keycloak.models.utils.UserSessionModelDelegate;

public class JpaChangesPerformer<K, V extends SessionEntity> {
    private static final Logger LOG = Logger.getLogger(JpaChangesPerformer.class);
    private final List<PersistentUpdate> changes;
    private final TriConsumer<KeycloakSession, Map.Entry<K, SessionUpdatesList<V>>, MergedUpdate<V>> processor;
    private final ArrayBlockingQueue<PersistentUpdate> batchingQueue;
    private boolean warningShown = false;

    public JpaChangesPerformer(String cacheName, ArrayBlockingQueue<PersistentUpdate> batchingQueue) {
        this.changes = batchingQueue == null ? new ArrayList(2) : List.of();
        this.batchingQueue = batchingQueue;
        this.processor = this.processor(cacheName);
    }

    public boolean isNonBlocking() {
        return this.batchingQueue != null;
    }

    public void asyncWrite(AggregateCompletionStage<Void> stage, Map.Entry<K, SessionUpdatesList<V>> entry, MergedUpdate<V> merged) {
        PersistentUpdate update = this.newUpdate(entry, merged);
        this.offer(update);
        stage.dependsOn(update.future());
    }

    public void registerChange(Map.Entry<K, SessionUpdatesList<V>> entry, MergedUpdate<V> merged) {
        this.changes.add(this.newUpdate(entry, merged));
    }

    public void write(KeycloakSession session) {
        this.changes.forEach(persistentUpdate -> persistentUpdate.perform(session));
    }

    public void clear() {
        this.changes.clear();
    }

    private PersistentUpdate newUpdate(Map.Entry<K, SessionUpdatesList<V>> entry, MergedUpdate<V> merged) {
        return new PersistentUpdate(innerSession -> this.processor.accept(innerSession, (Object)entry, (Object)merged));
    }

    private TriConsumer<KeycloakSession, Map.Entry<K, SessionUpdatesList<V>>, MergedUpdate<V>> processor(String cacheName) {
        return switch (cacheName) {
            case "sessions", "offlineSessions" -> JpaChangesPerformer::processUserSessionUpdate;
            case "clientSessions", "offlineClientSessions" -> JpaChangesPerformer::processClientSessionUpdate;
            default -> throw new IllegalStateException("Unexpected value: " + cacheName);
        };
    }

    private void offer(PersistentUpdate update) {
        if (!this.batchingQueue.offer(update)) {
            if (!this.warningShown) {
                this.warningShown = true;
                LOG.warn((Object)"Queue is full, will block");
            }
            try {
                this.batchingQueue.put(update);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
    }

    private static <K, V extends SessionEntity> void processClientSessionUpdate(KeycloakSession session, Map.Entry<K, SessionUpdatesList<V>> entry, MergedUpdate<V> merged) {
        SessionUpdatesList<V> sessionUpdates = entry.getValue();
        SessionEntityWrapper<V> sessionWrapper = sessionUpdates.getEntityWrapper();
        RealmModel realm = sessionUpdates.getRealm();
        UserSessionPersisterProvider userSessionPersister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
        switch (merged.getOperation()) {
            case REMOVE: {
                AuthenticatedClientSessionEntity entity = (AuthenticatedClientSessionEntity)sessionWrapper.getEntity();
                userSessionPersister.removeClientSession(entity.getUserSessionId(), entity.getClientId(), entity.isOffline());
                break;
            }
            case ADD: 
            case ADD_IF_ABSENT: {
                JpaChangesPerformer.createClientSession(session, sessionWrapper, userSessionPersister);
                break;
            }
            case REPLACE: {
                JpaChangesPerformer.mergeClientSession(sessionWrapper, userSessionPersister, realm, sessionUpdates);
            }
        }
    }

    private static <K, V extends SessionEntity> void mergeClientSession(SessionEntityWrapper<V> sessionWrapper, UserSessionPersisterProvider userSessionPersister, RealmModel realm, SessionUpdatesList<V> sessionUpdates) {
        UserSessionModelDelegate userSession;
        final AuthenticatedClientSessionEntity entity = (AuthenticatedClientSessionEntity)sessionWrapper.getEntity();
        ClientModelLazyDelegate client = new ClientModelLazyDelegate(null){

            public String getId() {
                return Objects.requireNonNull(entity.getClientId());
            }
        };
        final PersistentAuthenticatedClientSessionAdapter clientSessionModel = (PersistentAuthenticatedClientSessionAdapter)userSessionPersister.loadClientSession(realm, (ClientModel)client, (UserSessionModel)(userSession = new UserSessionModelDelegate(null){

            public String getId() {
                return Objects.requireNonNull(entity.getUserSessionId());
            }
        }), entity.isOffline());
        if (clientSessionModel != null) {
            AuthenticatedClientSessionEntity authenticatedClientSessionEntity = new AuthenticatedClientSessionEntity(){

                @Override
                public Map<String, String> getNotes() {
                    return new HashMap<String, String>(){

                        @Override
                        public String get(Object key) {
                            return (String)clientSessionModel.getNotes().get(key);
                        }

                        @Override
                        public String put(String key, String value) {
                            String oldValue = (String)clientSessionModel.getNotes().get(key);
                            clientSessionModel.setNote(key, value);
                            return oldValue;
                        }
                    };
                }

                @Override
                public void setRedirectUri(String redirectUri) {
                    clientSessionModel.setRedirectUri(redirectUri);
                }

                @Override
                public void setTimestamp(int timestamp) {
                    clientSessionModel.setTimestamp(timestamp);
                }

                @Override
                public void setAction(String action) {
                    clientSessionModel.setAction(action);
                }

                @Override
                public void setAuthMethod(String authMethod) {
                    clientSessionModel.setProtocol(authMethod);
                }

                @Override
                public String getAuthMethod() {
                    throw new IllegalStateException("not implemented");
                }

                @Override
                public String getRedirectUri() {
                    return clientSessionModel.getRedirectUri();
                }

                @Override
                public int getTimestamp() {
                    return clientSessionModel.getTimestamp();
                }

                @Override
                public int getUserSessionStarted() {
                    return clientSessionModel.getUserSessionStarted();
                }

                @Override
                public int getStarted() {
                    return clientSessionModel.getStarted();
                }

                @Override
                public boolean isUserSessionRememberMe() {
                    return clientSessionModel.isUserSessionRememberMe();
                }

                @Override
                public String getClientId() {
                    return clientSessionModel.getClient().getClientId();
                }

                @Override
                public void setClientId(String clientId) {
                    throw new IllegalStateException("not implemented");
                }

                @Override
                public String getAction() {
                    return clientSessionModel.getAction();
                }

                @Override
                public void setNotes(Map<String, String> notes) {
                    clientSessionModel.getNotes().keySet().forEach(arg_0 -> ((PersistentAuthenticatedClientSessionAdapter)clientSessionModel).removeNote(arg_0));
                    notes.forEach((arg_0, arg_1) -> ((PersistentAuthenticatedClientSessionAdapter)clientSessionModel).setNote(arg_0, arg_1));
                }

                @Override
                public SessionEntityWrapper mergeRemoteEntityWithLocalEntity(SessionEntityWrapper localEntityWrapper) {
                    throw new IllegalStateException("not implemented");
                }

                @Override
                public String getUserSessionId() {
                    return clientSessionModel.getUserSession().getId();
                }

                @Override
                public void setUserSessionId(String userSessionId) {
                    throw new IllegalStateException("not implemented");
                }
            };
            sessionUpdates.getUpdateTasks().forEach(vSessionUpdateTask -> {
                vSessionUpdateTask.runUpdate(authenticatedClientSessionEntity);
                if (vSessionUpdateTask.getOperation() == SessionUpdateTask.CacheOperation.REMOVE) {
                    userSessionPersister.removeClientSession(entity.getUserSessionId(), entity.getClientId(), entity.isOffline());
                }
            });
            clientSessionModel.getUpdatedModel();
        } else {
            LOG.debugf("No client session found for %s/%s", (Object)entity.getUserSessionId(), (Object)entity.getClientId());
        }
    }

    private static <V extends SessionEntity> void createClientSession(final KeycloakSession session, SessionEntityWrapper<V> sessionWrapper, UserSessionPersisterProvider userSessionPersister) {
        final AuthenticatedClientSessionEntity entity = (AuthenticatedClientSessionEntity)sessionWrapper.getEntity();
        userSessionPersister.createClientSession(new AuthenticatedClientSessionModel(){

            public int getStarted() {
                return entity.getStarted();
            }

            public int getUserSessionStarted() {
                return entity.getUserSessionStarted();
            }

            public boolean isUserSessionRememberMe() {
                return entity.isUserSessionRememberMe();
            }

            public String getId() {
                throw new UnsupportedOperationException();
            }

            public int getTimestamp() {
                return entity.getTimestamp();
            }

            public void setTimestamp(int timestamp) {
                throw new IllegalStateException("not implemented");
            }

            public void detachFromUserSession() {
                throw new IllegalStateException("not implemented");
            }

            public UserSessionModel getUserSession() {
                return new UserSessionModelDelegate(null){

                    public String getId() {
                        return entity.getUserSessionId();
                    }
                };
            }

            public String getNote(String name) {
                return entity.getNotes().get(name);
            }

            public void setNote(String name, String value) {
                throw new IllegalStateException("not implemented");
            }

            public void removeNote(String name) {
                throw new IllegalStateException("not implemented");
            }

            public Map<String, String> getNotes() {
                return entity.getNotes();
            }

            public String getRedirectUri() {
                return entity.getRedirectUri();
            }

            public void setRedirectUri(String uri) {
                throw new IllegalStateException("not implemented");
            }

            public RealmModel getRealm() {
                return session.realms().getRealm(entity.getRealmId());
            }

            public ClientModel getClient() {
                return new ClientModelLazyDelegate(() -> null){

                    public String getId() {
                        return entity.getClientId();
                    }
                };
            }

            public String getAction() {
                return entity.getAction();
            }

            public void setAction(String action) {
                throw new IllegalStateException("not implemented");
            }

            public String getProtocol() {
                return entity.getAuthMethod();
            }

            public void setProtocol(String method) {
                throw new IllegalStateException("not implemented");
            }
        }, entity.isOffline());
    }

    private static <K, V extends SessionEntity> void processUserSessionUpdate(KeycloakSession session, Map.Entry<K, SessionUpdatesList<V>> entry, MergedUpdate<V> merged) {
        SessionUpdatesList<V> sessionUpdates = entry.getValue();
        SessionEntityWrapper<V> sessionWrapper = sessionUpdates.getEntityWrapper();
        RealmModel realm = sessionUpdates.getRealm();
        UserSessionPersisterProvider userSessionPersister = (UserSessionPersisterProvider)session.getProvider(UserSessionPersisterProvider.class);
        UserSessionEntity entity = (UserSessionEntity)sessionWrapper.getEntity();
        switch (merged.getOperation()) {
            case REMOVE: {
                userSessionPersister.removeUserSession(entry.getKey().toString(), entity.isOffline());
                break;
            }
            case ADD: {
                throw new ModelIllegalStateException("Operation ADD is not implemented to overwrite an existing user session");
            }
            case ADD_IF_ABSENT: {
                PersistentUserSessionAdapter userSessionModel = (PersistentUserSessionAdapter)userSessionPersister.loadUserSession(realm, entry.getKey().toString(), entity.isOffline());
                if (userSessionModel != null) {
                    if (!Objects.equals(userSessionModel.getUserId(), entity.getUser())) {
                        throw new ModelIllegalStateException("User ID of the session does not match, the user ID should not change");
                    }
                    if (Math.abs(userSessionModel.getStarted() - entity.getStarted()) > 10) {
                        throw new ModelIllegalStateException("Session has already aged, concurrent requests to create it should not happen");
                    }
                    JpaChangesPerformer.mergeUserSession(session, entry, userSessionModel, realm, sessionUpdates, userSessionPersister, entity);
                    break;
                }
                JpaChangesPerformer.createUserSession(userSessionPersister, entity);
                break;
            }
            case REPLACE: {
                PersistentUserSessionAdapter userSessionModel = (PersistentUserSessionAdapter)userSessionPersister.loadUserSession(realm, entry.getKey().toString(), entity.isOffline());
                if (userSessionModel != null) {
                    JpaChangesPerformer.mergeUserSession(session, entry, userSessionModel, realm, sessionUpdates, userSessionPersister, entity);
                    break;
                }
                LOG.debugf("No user session found for %s", entry.getKey());
            }
        }
    }

    private static void createUserSession(UserSessionPersisterProvider userSessionPersister, final UserSessionEntity entity) {
        userSessionPersister.createUserSession(new UserSessionModel(){

            public String getId() {
                return entity.getId();
            }

            public RealmModel getRealm() {
                return new RealmModelDelegate(null){

                    public String getId() {
                        return entity.getRealmId();
                    }
                };
            }

            public String getBrokerSessionId() {
                return entity.getBrokerSessionId();
            }

            public String getBrokerUserId() {
                return entity.getBrokerUserId();
            }

            public UserModel getUser() {
                return new UserModelDelegate(null){

                    public String getId() {
                        return entity.getUser();
                    }
                };
            }

            public String getLoginUsername() {
                return entity.getLoginUsername();
            }

            public String getIpAddress() {
                return entity.getIpAddress();
            }

            public String getAuthMethod() {
                return entity.getAuthMethod();
            }

            public boolean isRememberMe() {
                return entity.isRememberMe();
            }

            public int getStarted() {
                return entity.getStarted();
            }

            public int getLastSessionRefresh() {
                return entity.getLastSessionRefresh();
            }

            public void setLastSessionRefresh(int seconds) {
                throw new IllegalStateException("not implemented");
            }

            public boolean isOffline() {
                return entity.isOffline();
            }

            public Map<String, AuthenticatedClientSessionModel> getAuthenticatedClientSessions() {
                return Collections.emptyMap();
            }

            public void removeAuthenticatedClientSessions(Collection<String> removedClientUUIDS) {
                throw new IllegalStateException("not implemented");
            }

            public String getNote(String name) {
                return entity.getNotes().get(name);
            }

            public void setNote(String name, String value) {
                throw new IllegalStateException("not implemented");
            }

            public void removeNote(String name) {
                throw new IllegalStateException("not implemented");
            }

            public Map<String, String> getNotes() {
                return entity.getNotes();
            }

            public UserSessionModel.State getState() {
                return entity.getState();
            }

            public void setState(UserSessionModel.State state) {
                throw new IllegalStateException("not implemented");
            }

            public void restartSession(RealmModel realm, UserModel user, String loginUsername, String ipAddress, String authMethod, boolean rememberMe, String brokerSessionId, String brokerUserId) {
                throw new IllegalStateException("not implemented");
            }
        }, entity.isOffline());
    }

    private static <K, V extends SessionEntity> void mergeUserSession(final KeycloakSession innerSession, Map.Entry<K, SessionUpdatesList<V>> entry, final PersistentUserSessionAdapter userSessionModel, final RealmModel realm, SessionUpdatesList<V> sessionUpdates, UserSessionPersisterProvider userSessionPersister, UserSessionEntity entity) {
        UserSessionEntity userSessionEntity = new UserSessionEntity(userSessionModel.getId()){

            @Override
            public Map<String, String> getNotes() {
                return new HashMap<String, String>(){

                    @Override
                    public String get(Object key) {
                        return (String)userSessionModel.getNotes().get(key);
                    }

                    @Override
                    public String put(String key, String value) {
                        String oldValue = (String)userSessionModel.getNotes().get(key);
                        userSessionModel.setNote(key, value);
                        return oldValue;
                    }

                    @Override
                    public String remove(Object key) {
                        String oldValue = (String)userSessionModel.getNotes().get(key);
                        userSessionModel.removeNote(key.toString());
                        return oldValue;
                    }

                    @Override
                    public void clear() {
                        userSessionModel.getNotes().clear();
                    }
                };
            }

            @Override
            public void setLastSessionRefresh(int lastSessionRefresh) {
                userSessionModel.setLastSessionRefresh(lastSessionRefresh);
            }

            @Override
            public void setState(UserSessionModel.State state) {
                userSessionModel.setState(state);
            }

            @Override
            public String getRealmId() {
                return userSessionModel.getRealm().getId();
            }

            @Override
            public void setRealmId(String realmId) {
                userSessionModel.setRealm(innerSession.realms().getRealm(realmId));
            }

            @Override
            public String getUser() {
                return userSessionModel.getUser().getId();
            }

            @Override
            public void setUser(String userId) {
                userSessionModel.setUser(innerSession.users().getUserById(realm, userId));
            }

            @Override
            public String getLoginUsername() {
                return userSessionModel.getLoginUsername();
            }

            @Override
            public void setLoginUsername(String loginUsername) {
                userSessionModel.setLoginUsername(loginUsername);
            }

            @Override
            public String getIpAddress() {
                return userSessionModel.getIpAddress();
            }

            @Override
            public void setIpAddress(String ipAddress) {
                userSessionModel.setIpAddress(ipAddress);
            }

            @Override
            public String getAuthMethod() {
                return userSessionModel.getAuthMethod();
            }

            @Override
            public void setAuthMethod(String authMethod) {
                userSessionModel.setAuthMethod(authMethod);
            }

            @Override
            public boolean isRememberMe() {
                return userSessionModel.isRememberMe();
            }

            @Override
            public void setRememberMe(boolean rememberMe) {
                userSessionModel.setRememberMe(rememberMe);
            }

            @Override
            public int getStarted() {
                return userSessionModel.getStarted();
            }

            @Override
            public void setStarted(int started) {
                userSessionModel.setStarted(started);
            }

            @Override
            public int getLastSessionRefresh() {
                return userSessionModel.getLastSessionRefresh();
            }

            @Override
            public void setNotes(Map<String, String> notes) {
                userSessionModel.getNotes().keySet().forEach(arg_0 -> ((PersistentUserSessionAdapter)userSessionModel).removeNote(arg_0));
                notes.forEach((arg_0, arg_1) -> ((PersistentUserSessionAdapter)userSessionModel).setNote(arg_0, arg_1));
            }

            @Override
            public UserSessionModel.State getState() {
                return userSessionModel.getState();
            }

            @Override
            public String getBrokerSessionId() {
                return userSessionModel.getBrokerSessionId();
            }

            @Override
            public void setBrokerSessionId(String brokerSessionId) {
                userSessionModel.setBrokerSessionId(brokerSessionId);
            }

            @Override
            public String getBrokerUserId() {
                return userSessionModel.getBrokerUserId();
            }

            @Override
            public void setBrokerUserId(String brokerUserId) {
                userSessionModel.setBrokerUserId(brokerUserId);
            }

            @Override
            public SessionEntityWrapper mergeRemoteEntityWithLocalEntity(SessionEntityWrapper localEntityWrapper) {
                throw new IllegalStateException("not supported");
            }
        };
        sessionUpdates.getUpdateTasks().forEach(vSessionUpdateTask -> {
            vSessionUpdateTask.runUpdate(userSessionEntity);
            if (vSessionUpdateTask.getOperation() == SessionUpdateTask.CacheOperation.REMOVE) {
                userSessionPersister.removeUserSession(entry.getKey().toString(), entity.isOffline());
            }
        });
        userSessionModel.getUpdatedModel();
    }
}

