/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.gax.rpc.mtls;

import com.google.api.core.InternalApi;
import com.google.api.gax.rpc.internal.EnvironmentProvider;

@InternalApi
public class CertificateBasedAccess {
    private final EnvironmentProvider envProvider;

    public CertificateBasedAccess(EnvironmentProvider envProvider) {
        this.envProvider = envProvider;
    }

    public static CertificateBasedAccess createWithSystemEnv() {
        return new CertificateBasedAccess(System::getenv);
    }

    public boolean useMtlsClientCertificate() {
        String useClientCertificate = this.envProvider.getenv("GOOGLE_API_USE_CLIENT_CERTIFICATE");
        return "true".equals(useClientCertificate);
    }

    public MtlsEndpointUsagePolicy getMtlsEndpointUsagePolicy() {
        String mtlsEndpointUsagePolicy = this.envProvider.getenv("GOOGLE_API_USE_MTLS_ENDPOINT");
        if ("never".equals(mtlsEndpointUsagePolicy)) {
            return MtlsEndpointUsagePolicy.NEVER;
        }
        if ("always".equals(mtlsEndpointUsagePolicy)) {
            return MtlsEndpointUsagePolicy.ALWAYS;
        }
        return MtlsEndpointUsagePolicy.AUTO;
    }

    public static enum MtlsEndpointUsagePolicy {
        NEVER,
        AUTO,
        ALWAYS;

    }
}

