/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.metamodel.model.domain;

import java.io.Serializable;
import java.util.Objects;
import org.hibernate.Incubating;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.spi.DotIdentifierSequence;

@Incubating
public final class NavigableRole
implements DotIdentifierSequence,
Serializable {
    public static final String IDENTIFIER_MAPPER_PROPERTY = "_identifierMapper";
    private final NavigableRole parent;
    private final String localName;
    private final String fullPath;

    public NavigableRole(NavigableRole parent, String localName) {
        this(parent, localName, '.');
    }

    public NavigableRole(NavigableRole parent, String localName, char separator) {
        this.parent = parent;
        this.localName = localName;
        this.fullPath = this.fullPath(parent, localName, separator);
    }

    private String fullPath(NavigableRole parent, String localName, char separator) {
        String resolvedParent;
        if (IDENTIFIER_MAPPER_PROPERTY.equals(localName)) {
            return parent == null ? "" : parent.getFullPath();
        }
        Object prefix = parent != null ? (StringHelper.isEmpty(resolvedParent = parent.getFullPath()) ? "" : resolvedParent + separator) : "";
        return (String)prefix + localName;
    }

    public NavigableRole(String localName) {
        this(null, localName);
    }

    public NavigableRole() {
        this("");
    }

    @Override
    public NavigableRole append(String name) {
        return new NavigableRole(this, name);
    }

    public NavigableRole appendContainer(String name) {
        return new NavigableRole(this, name, '#');
    }

    @Override
    public NavigableRole getParent() {
        return this.parent;
    }

    @Override
    public String getLocalName() {
        return this.localName;
    }

    public String getNavigableName() {
        return this.getLocalName();
    }

    @Override
    public String getFullPath() {
        return this.fullPath;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.fullPath + "]";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof NavigableRole)) {
            return false;
        }
        NavigableRole that = (NavigableRole)object;
        return Objects.equals(this.fullPath, that.fullPath);
    }

    public int hashCode() {
        return this.fullPath.hashCode();
    }
}

