/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.galleon.cli.cmd.state;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.aesh.command.CommandDefinition;
import org.aesh.command.option.Argument;
import org.aesh.readline.AeshContext;
import org.jboss.galleon.ProvisioningException;
import org.jboss.galleon.cli.CommandExecutionException;
import org.jboss.galleon.cli.PmCommandInvocation;
import org.jboss.galleon.cli.PmSession;
import org.jboss.galleon.cli.PmSessionCommand;
import org.jboss.galleon.util.PathsUtils;

@CommandDefinition(name="edit", description="Load an installation or a provisioning xml file in order to create a provisioning state")
public class StateEditCommand
extends PmSessionCommand {
    @Argument(required=false, description="Installation directory or provisionng file")
    protected File dir;

    @Override
    protected void runCommand(PmCommandInvocation invoc) throws CommandExecutionException {
        throw new CommandExecutionException("Shouldn't have been called");
    }

    @Override
    public String getCommandClassName(PmSession session) throws ProvisioningException {
        return "org.jboss.galleon.cli.cmd.state.core.CoreStateEditCommand";
    }

    public Path getInstallationHome(AeshContext context) {
        return this.dir == null ? PmSession.getWorkDir(context) : this.dir.toPath();
    }

    @Override
    public String getCoreVersion(PmSession session) throws ProvisioningException {
        Path toEdit;
        Path provisioning = toEdit = this.getInstallationHome(session.getAeshContext());
        if (Files.isDirectory(toEdit, new LinkOption[0])) {
            provisioning = PathsUtils.getProvisioningXml(toEdit);
        }
        return session.getGalleonBuilder().getCoreVersion(provisioning);
    }
}

