/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.client;

import org.eclipse.jetty.client.HttpRequestException;
import org.eclipse.jetty.client.ProtocolHandler;
import org.eclipse.jetty.client.Request;
import org.eclipse.jetty.client.Response;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.RetainingResponseListener;
import org.eclipse.jetty.client.internal.HttpContentResponse;
import org.eclipse.jetty.client.transport.HttpConversation;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpRequest;
import org.eclipse.jetty.client.transport.ResponseListeners;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;

public class ContinueProtocolHandler
implements ProtocolHandler {
    public static final String NAME = "continue";
    private static final String ATTRIBUTE = ContinueProtocolHandler.class.getName() + ".100continue";

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        boolean is100;
        boolean handled100 = request.getAttributes().containsKey(ATTRIBUTE);
        if (handled100) {
            return false;
        }
        boolean bl = is100 = response.getStatus() == 100;
        if (is100) {
            return true;
        }
        return request.getHeaders().contains(HttpHeader.EXPECT, HttpHeaderValue.CONTINUE.asString());
    }

    @Override
    public Response.Listener getResponseListener() {
        return new ContinueListener();
    }

    protected Runnable onContinue(Request request) {
        return null;
    }

    protected class ContinueListener
    extends RetainingResponseListener {
        protected ContinueListener() {
        }

        @Override
        public void onSuccess(Response response) {
            super.onSuccess(response);
            Request request = response.getRequest();
            HttpConversation conversation = ((HttpRequest)request).getConversation();
            request.attribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange != null);
            if (response.getStatus() == 100) {
                exchange.resetResponse();
                Runnable proceedAction = ContinueProtocolHandler.this.onContinue(request);
                exchange.proceed(proceedAction, null);
            } else {
                ResponseListeners listeners = exchange.getResponseListeners();
                HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
                listeners.emitSuccess(contentResponse);
                exchange.proceed(null, new HttpRequestException("Expectation failed", request));
            }
        }

        @Override
        public void onFailure(Response response, Throwable failure) {
            super.onFailure(response, failure);
            HttpConversation conversation = ((HttpRequest)response.getRequest()).getConversation();
            conversation.setAttribute(ATTRIBUTE, Boolean.TRUE);
            conversation.updateResponseListeners(null);
            HttpExchange exchange = conversation.getExchanges().peekLast();
            assert (exchange.getResponse() == response);
            ResponseListeners listeners = exchange.getResponseListeners();
            HttpContentResponse contentResponse = new HttpContentResponse(response, this.getContent(), this.getMediaType(), this.getEncoding());
            listeners.emitFailureComplete(new Result(exchange.getRequest(), exchange.getRequestFailure(), contentResponse, failure));
        }

        @Override
        public void onComplete(Result result) {
        }
    }
}

