/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.parser.extension;

import de.rub.nds.tlsattacker.core.protocol.message.extension.SRPExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.ExtensionParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SRPExtensionParser
extends ExtensionParser<SRPExtensionMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public SRPExtensionParser(int startposition, byte[] array) {
        super(startposition, array);
    }

    @Override
    public void parseExtensionMessageContent(SRPExtensionMessage msg) {
        msg.setSrpIdentifierLength(this.parseIntField(1));
        if ((Integer)msg.getSrpIdentifierLength().getValue() > 32) {
            LOGGER.warn("The SRP Identifier should not exceed 32 bytes.");
        }
        msg.setSrpIdentifier(this.parseByteArrayField((Integer)msg.getSrpIdentifierLength().getValue()));
    }

    @Override
    protected SRPExtensionMessage createExtensionMessage() {
        return new SRPExtensionMessage();
    }
}

