/* [config]
 * expect_result: pass
 * glsl_version: 4.00
 * require_extensions: GL_ARB_gpu_shader_int64
 * [end config]
 *
 * Check that the following test vectors are constant folded correctly:
 * (i64vec2(-10l, -12l) << u64vec2(13ul, 63ul)) => i64vec2(-81920l, 0l)
 * (i64vec2(-10l, -12l) << u64vec2(52ul, 50ul)) => i64vec2(-45035996273704960l, -13510798882111488l)
 * (i64vec2(-10l, -12l) << u64vec2(24ul, 61ul)) => i64vec2(-167772160l, -9223372036854775808l)
 * (i64vec2(-42l, 48l) << u64vec2(13ul, 63ul)) => i64vec2(-344064l, 0l)
 * (i64vec2(-42l, 48l) << u64vec2(52ul, 50ul)) => i64vec2(-189151184349560832l, 54043195528445952l)
 * (i64vec2(-42l, 48l) << u64vec2(24ul, 61ul)) => i64vec2(-704643072l, 0l)
 */
#version 400
#extension GL_ARB_gpu_shader_int64 : require

void main()
{
  float[all(equal((i64vec2(-10l, -12l) << u64vec2(13ul, 63ul)), i64vec2(-81920l, 0l))) ? 1 : -1] array0;
  float[all(equal((i64vec2(-10l, -12l) << u64vec2(52ul, 50ul)), i64vec2(-45035996273704960l, -13510798882111488l))) ? 1 : -1] array1;
  float[all(equal((i64vec2(-10l, -12l) << u64vec2(24ul, 61ul)), i64vec2(-167772160l, -9223372036854775808l))) ? 1 : -1] array2;
  float[all(equal((i64vec2(-42l, 48l) << u64vec2(13ul, 63ul)), i64vec2(-344064l, 0l))) ? 1 : -1] array3;
  float[all(equal((i64vec2(-42l, 48l) << u64vec2(52ul, 50ul)), i64vec2(-189151184349560832l, 54043195528445952l))) ? 1 : -1] array4;
  float[all(equal((i64vec2(-42l, 48l) << u64vec2(24ul, 61ul)), i64vec2(-704643072l, 0l))) ? 1 : -1] array5;
  gl_Position = vec4(array0.length() + array1.length() + array2.length() + array3.length() + array4.length() + array5.length());
}
