/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.util;

import io.undertow.util.HttpString;
import io.undertow.util.UndertowConnectorMessages;

public class HttpTokens {
    private static final boolean[] ALLOWED_TOKEN_CHARACTERS = new boolean[256];

    public static void verifyToken(HttpString header) {
        int length = header.length();
        for (int i = 0; i < length; ++i) {
            byte c = header.byteAt(i);
            if (ALLOWED_TOKEN_CHARACTERS[c]) continue;
            throw UndertowConnectorMessages.MESSAGES.invalidToken(c);
        }
    }

    public static boolean isValidTokenCharacter(byte c) {
        return ALLOWED_TOKEN_CHARACTERS[c];
    }

    static {
        block3: for (int i = 0; i < ALLOWED_TOKEN_CHARACTERS.length; ++i) {
            if (i >= 48 && i <= 57 || i >= 97 && i <= 122 || i >= 65 && i <= 90) {
                HttpTokens.ALLOWED_TOKEN_CHARACTERS[i] = true;
                continue;
            }
            switch (i) {
                case 33: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 42: 
                case 43: 
                case 45: 
                case 46: 
                case 94: 
                case 95: 
                case 96: 
                case 124: 
                case 126: {
                    HttpTokens.ALLOWED_TOKEN_CHARACTERS[i] = true;
                    continue block3;
                }
                default: {
                    HttpTokens.ALLOWED_TOKEN_CHARACTERS[i] = false;
                }
            }
        }
    }
}

