/*
 * Decompiled with CFR 0.152.
 */
package net.sf.mpxj.primavera.p3;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.LinkedList;
import java.util.List;
import net.sf.mpxj.MPXJException;
import net.sf.mpxj.ProjectFile;
import net.sf.mpxj.common.FileHelper;
import net.sf.mpxj.common.FixedLengthInputStream;
import net.sf.mpxj.common.StreamHelper;
import net.sf.mpxj.listener.ProjectListener;
import net.sf.mpxj.primavera.common.Blast;
import net.sf.mpxj.primavera.p3.P3DatabaseReader;
import net.sf.mpxj.reader.AbstractProjectReader;

public final class P3PRXFileReader
extends AbstractProjectReader {
    private List<ProjectListener> m_projectListeners;

    @Override
    public void addProjectListener(ProjectListener projectListener) {
        if (this.m_projectListeners == null) {
            this.m_projectListeners = new LinkedList<ProjectListener>();
        }
        this.m_projectListeners.add(projectListener);
    }

    @Override
    public ProjectFile read(InputStream inputStream) throws MPXJException {
        ProjectFile projectFile;
        File file = null;
        try {
            StreamHelper.skip(inputStream, 27000L);
            file = FileHelper.createTempDir();
            while (inputStream.available() > 0) {
                this.extractFile(inputStream, file);
            }
            projectFile = P3DatabaseReader.setProjectNameAndRead(file);
        }
        catch (IOException iOException) {
            try {
                throw new MPXJException("Failed to parse file", iOException);
            }
            catch (Throwable throwable) {
                FileHelper.deleteQuietly(file);
                throw throwable;
            }
        }
        FileHelper.deleteQuietly(file);
        return projectFile;
    }

    private void extractFile(InputStream inputStream, File file) throws IOException {
        byte[] byArray = new byte[8];
        byte[] byArray2 = new byte[13];
        byte[] byArray3 = new byte[4];
        inputStream.read(byArray);
        inputStream.read(byArray2);
        inputStream.read(byArray3);
        int n = this.getInt(byArray3, 0);
        String string = this.getString(byArray2, 0);
        File file2 = new File(file, string);
        if (n == 0) {
            FileHelper.createNewFile(file2);
        } else {
            FileOutputStream fileOutputStream = new FileOutputStream(file2);
            FixedLengthInputStream fixedLengthInputStream = new FixedLengthInputStream(inputStream, n);
            Blast blast = new Blast();
            blast.blast(fixedLengthInputStream, fileOutputStream);
            ((OutputStream)fileOutputStream).close();
        }
    }

    private int getInt(byte[] byArray, int n) {
        int n2 = 0;
        int n3 = n;
        for (int i = 0; i < 32; i += 8) {
            n2 |= (byArray[n3] & 0xFF) << i;
            ++n3;
        }
        return n2;
    }

    private String getString(byte[] byArray, int n) {
        char c;
        StringBuilder stringBuilder = new StringBuilder();
        int n2 = 0;
        while (n + n2 < byArray.length && (c = (char)byArray[n + n2]) != '\u0000') {
            stringBuilder.append(c);
            ++n2;
        }
        return stringBuilder.toString();
    }
}

