/*
 * Decompiled with CFR 0.152.
 */
package com.opensymphony.module.sitemesh.parser;

import com.opensymphony.module.sitemesh.Page;
import com.opensymphony.module.sitemesh.PageParser;
import com.opensymphony.module.sitemesh.html.HTMLProcessor;
import com.opensymphony.module.sitemesh.html.State;
import com.opensymphony.module.sitemesh.html.StateTransitionRule;
import com.opensymphony.module.sitemesh.html.rules.BodyTagRule;
import com.opensymphony.module.sitemesh.html.rules.ContentBlockExtractingRule;
import com.opensymphony.module.sitemesh.html.rules.FramesetRule;
import com.opensymphony.module.sitemesh.html.rules.HeadExtractingRule;
import com.opensymphony.module.sitemesh.html.rules.HtmlAttributesRule;
import com.opensymphony.module.sitemesh.html.rules.MSOfficeDocumentPropertiesRule;
import com.opensymphony.module.sitemesh.html.rules.MetaTagRule;
import com.opensymphony.module.sitemesh.html.rules.PageBuilder;
import com.opensymphony.module.sitemesh.html.rules.ParameterExtractingRule;
import com.opensymphony.module.sitemesh.html.rules.TitleExtractingRule;
import com.opensymphony.module.sitemesh.html.util.CharArray;
import com.opensymphony.module.sitemesh.parser.TokenizedHTMLPage;
import java.io.IOException;

public class HTMLPageParser
implements PageParser {
    public Page parse(char[] data) throws IOException {
        CharArray head = new CharArray(64);
        CharArray body = new CharArray(4096);
        TokenizedHTMLPage page = new TokenizedHTMLPage(data, body, head);
        HTMLProcessor processor = new HTMLProcessor(data, body);
        State html = processor.defaultState();
        html.addRule(new HeadExtractingRule(head));
        html.addRule(new BodyTagRule(page, body));
        html.addRule(new TitleExtractingRule(page));
        html.addRule(new FramesetRule(page));
        this.addUserDefinedRules(html, page);
        processor.process();
        return page;
    }

    protected void addUserDefinedRules(State html, PageBuilder page) {
        State xml = new State();
        html.addRule(new StateTransitionRule("xml", xml));
        html.addRule(new HtmlAttributesRule(page));
        html.addRule(new MetaTagRule(page));
        html.addRule(new ParameterExtractingRule(page));
        html.addRule(new ContentBlockExtractingRule(page));
        xml.addRule(new MSOfficeDocumentPropertiesRule(page));
    }
}

