/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CollectionUtil {
    public static <T> Set<Set<T>> powerSet(Collection<T> originalSet) {
        HashSet<Set<T>> sets = new HashSet<Set<T>>();
        if (originalSet.isEmpty()) {
            sets.add(new HashSet());
            return sets;
        }
        ArrayList<T> list = new ArrayList<T>(originalSet);
        Object head = list.get(0);
        List rest = list.subList(1, list.size());
        for (Set set : CollectionUtil.powerSet(rest)) {
            HashSet newSet = new HashSet();
            newSet.add(head);
            newSet.addAll(set);
            sets.add(newSet);
            sets.add(set);
        }
        return sets;
    }

    public static <T> List<Map<String, T>> permutations(Map<String, List<T>> parameterValues) {
        ArrayList<Map<String, T>> list = new ArrayList<Map<String, T>>();
        if (parameterValues == null || parameterValues.size() == 0) {
            return list;
        }
        CollectionUtil.permute(new HashMap(), new ArrayList<String>(parameterValues.keySet()), parameterValues, list);
        return list;
    }

    private static <T> void permute(Map<String, T> basePermutation, List<String> remainingKeys, Map<String, List<T>> parameterValues, List<Map<String, T>> returnList) {
        String thisKey = remainingKeys.get(0);
        remainingKeys = remainingKeys.subList(1, remainingKeys.size());
        for (T value : parameterValues.get(thisKey)) {
            HashMap<String, T> permutation = new HashMap<String, T>(basePermutation);
            permutation.put(thisKey, value);
            if (remainingKeys.size() == 0) {
                returnList.add(permutation);
                continue;
            }
            CollectionUtil.permute(permutation, remainingKeys, parameterValues, returnList);
        }
    }
}

