/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Map;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.property.access.internal.PropertyAccessStrategyMapImpl;
import org.hibernate.property.access.spi.Getter;
import org.hibernate.property.access.spi.PropertyAccess;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.Setter;

public class PropertyAccessMapImpl
implements PropertyAccess {
    private final @UnknownKeyFor @NonNull @Initialized Getter getter;
    private final @UnknownKeyFor @NonNull @Initialized Setter setter;
    private final @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategyMapImpl strategy;

    public PropertyAccessMapImpl(@UnknownKeyFor @NonNull @Initialized PropertyAccessStrategyMapImpl strategy, @UnknownKeyFor @NonNull @Initialized String propertyName) {
        this.strategy = strategy;
        this.getter = new GetterImpl(propertyName);
        this.setter = new SetterImpl(propertyName);
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy getPropertyAccessStrategy() {
        return this.strategy;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Getter getGetter() {
        return this.getter;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized Setter getSetter() {
        return this.setter;
    }

    public static class SetterImpl
    implements Setter {
        private final @UnknownKeyFor @NonNull @Initialized String propertyName;

        public SetterImpl(@UnknownKeyFor @NonNull @Initialized String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public void set(@UnknownKeyFor @NonNull @Initialized Object target, @Nullable @UnknownKeyFor @Initialized Object value) {
            ((Map)target).put(this.propertyName, value);
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String getMethodName() {
            return null;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Method getMethod() {
            return null;
        }
    }

    public static class GetterImpl
    implements Getter {
        private final @UnknownKeyFor @NonNull @Initialized String propertyName;

        public GetterImpl(@UnknownKeyFor @NonNull @Initialized String propertyName) {
            this.propertyName = propertyName;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Object get(@UnknownKeyFor @NonNull @Initialized Object owner) {
            return ((Map)owner).get(this.propertyName);
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Object getForInsert(@UnknownKeyFor @NonNull @Initialized Object owner, @UnknownKeyFor @NonNull @Initialized Map mergeMap, @UnknownKeyFor @NonNull @Initialized SharedSessionContractImplementor session) {
            return this.get(owner);
        }

        @Override
        public /*
         * Issues handling annotations - annotations may be inaccurate
         */
        @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> getReturnTypeClass() {
            return Object.class;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Type getReturnType() {
            return Object.class;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Member getMember() {
            return null;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized String getMethodName() {
            return null;
        }

        @Override
        public @Nullable @UnknownKeyFor @Initialized Method getMethod() {
            return null;
        }
    }
}

