/*
 * Decompiled with CFR 0.152.
 */
package org.jitsi.nlj.rtp.codec.vp8;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jitsi.nlj.MediaSourceDesc;
import org.jitsi.nlj.PacketInfo;
import org.jitsi.nlj.RtpEncodingDesc;
import org.jitsi.nlj.RtpLayerDesc;
import org.jitsi.nlj.rtp.codec.VideoCodecParser;
import org.jitsi.nlj.rtp.codec.vp8.Vp8Packet;
import org.jitsi.nlj.util.StateChangeLogger;
import org.jitsi.rtp.extensions.ByteArrayBufferKt;
import org.jitsi.utils.logging2.Logger;
import org.jitsi.utils.logging2.LoggerExtensionsKt;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jitsi/nlj/rtp/codec/vp8/Vp8Parser;", "Lorg/jitsi/nlj/rtp/codec/VideoCodecParser;", "source", "Lorg/jitsi/nlj/MediaSourceDesc;", "parentLogger", "Lorg/jitsi/utils/logging2/Logger;", "<init>", "(Lorg/jitsi/nlj/MediaSourceDesc;Lorg/jitsi/utils/logging2/Logger;)V", "logger", "pictureIdState", "Lorg/jitsi/nlj/util/StateChangeLogger;", "extendedPictureIdState", "tidWithoutTl0PicIdxState", "parse", "", "packetInfo", "Lorg/jitsi/nlj/PacketInfo;", "jitsi-media-transform"})
@SourceDebugExtension(value={"SMAP\nVp8Parser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Vp8Parser.kt\norg/jitsi/nlj/rtp/codec/vp8/Vp8Parser\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,68:1\n11102#2:69\n11437#2,3:70\n37#3,2:73\n*S KotlinDebug\n*F\n+ 1 Vp8Parser.kt\norg/jitsi/nlj/rtp/codec/vp8/Vp8Parser\n*L\n49#1:69\n49#1:70,3\n50#1:73,2\n*E\n"})
public final class Vp8Parser
extends VideoCodecParser {
    @NotNull
    private final Logger logger;
    @NotNull
    private final StateChangeLogger pictureIdState;
    @NotNull
    private final StateChangeLogger extendedPictureIdState;
    @NotNull
    private final StateChangeLogger tidWithoutTl0PicIdxState;

    public Vp8Parser(@NotNull MediaSourceDesc source, @NotNull Logger parentLogger) {
        Intrinsics.checkNotNullParameter(source, "source");
        Intrinsics.checkNotNullParameter(parentLogger, "parentLogger");
        super(source);
        this.logger = LoggerExtensionsKt.createChildLogger$default(this, parentLogger, null, 2, null);
        this.pictureIdState = new StateChangeLogger("missing picture id", this.logger);
        this.extendedPictureIdState = new StateChangeLogger("missing extended picture ID", this.logger);
        this.tidWithoutTl0PicIdxState = new StateChangeLogger("TID with missing TL0PICIDX", this.logger);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void parse(@NotNull PacketInfo packetInfo) {
        Intrinsics.checkNotNullParameter(packetInfo, "packetInfo");
        Vp8Packet vp8Packet = (Vp8Packet)packetInfo.packetAs();
        if (vp8Packet.getHeight() > -1) {
            RtpEncodingDesc rtpEncodingDesc = this.findRtpEncodingDesc(vp8Packet);
            if (rtpEncodingDesc != null) {
                void $this$mapTo$iv$iv;
                RtpEncodingDesc enc = rtpEncodingDesc;
                boolean bl = false;
                RtpLayerDesc[] $this$map$iv = enc.getLayers$jitsi_media_transform();
                boolean $i$f$map = false;
                RtpLayerDesc[] rtpLayerDescArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void layer;
                    void item$iv$iv;
                    void var13_13 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(RtpLayerDesc.copy$default((RtpLayerDesc)layer, vp8Packet.getHeight(), 0, false, 6, null));
                }
                List newLayers = (List)destination$iv$iv;
                Collection $this$toTypedArray$iv = newLayers;
                boolean $i$f$toTypedArray = false;
                Collection thisCollection$iv = $this$toTypedArray$iv;
                enc.setLayers$jitsi_media_transform(thisCollection$iv.toArray(new RtpLayerDesc[0]));
            }
        }
        this.pictureIdState.setState(vp8Packet.getHasPictureId(), vp8Packet, () -> Vp8Parser.parse$lambda$2(vp8Packet));
        this.extendedPictureIdState.setState(vp8Packet.getHasExtendedPictureId(), vp8Packet, () -> Vp8Parser.parse$lambda$3(vp8Packet));
        this.tidWithoutTl0PicIdxState.setState(vp8Packet.getHasTL0PICIDX() || !vp8Packet.getHasTemporalLayerIndex(), vp8Packet, () -> Vp8Parser.parse$lambda$4(vp8Packet));
    }

    private static final String parse$lambda$2(Vp8Packet $vp8Packet) {
        Intrinsics.checkNotNullParameter($vp8Packet, "$vp8Packet");
        return "Packet Data: " + ByteArrayBufferKt.toHex($vp8Packet, 80);
    }

    private static final String parse$lambda$3(Vp8Packet $vp8Packet) {
        Intrinsics.checkNotNullParameter($vp8Packet, "$vp8Packet");
        return "Packet Data: " + ByteArrayBufferKt.toHex($vp8Packet, 80);
    }

    private static final String parse$lambda$4(Vp8Packet $vp8Packet) {
        Intrinsics.checkNotNullParameter($vp8Packet, "$vp8Packet");
        return "Packet Data: " + ByteArrayBufferKt.toHex($vp8Packet, 80);
    }
}

