/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.client.gui.panel;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.JPanel;
import javax.swing.Timer;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.client.gui.ImageLibrary;
import net.sf.freecol.client.gui.panel.FreeColPanel;
import net.sf.freecol.common.resources.FAFile;
import net.sf.freecol.common.resources.ResourceManager;
import net.sf.freecol.common.util.StringUtils;

public final class DeclarationPanel
extends FreeColPanel {
    private static final Logger logger = Logger.getLogger(DeclarationPanel.class.getName());
    private final int SIGNATURE_Y = 450;
    private final String ANIMATION_STOPPED = "AnimationStopped";
    private final int START_DELAY = 2000;
    private final int ANIMATION_DELAY = 50;
    private final int FINISH_DELAY = 5000;
    private final Runnable afterClosing;
    private boolean closed = false;

    public DeclarationPanel(FreeColClient freeColClient, Runnable afterClosing) {
        super(freeColClient);
        this.afterClosing = afterClosing;
        this.setLayout(null);
        BufferedImage image = ImageLibrary.getUnscaledImage("image.flavor.Declaration");
        this.setSize(((Image)image).getWidth(null), ((Image)image).getHeight(null));
        this.setOpaque(false);
        this.setBorder(null);
        this.addKeyListener(new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent k) {
                DeclarationPanel.this.closePanel();
            }
        });
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                DeclarationPanel.this.closePanel();
            }
        });
        SignaturePanel signaturePanel = new SignaturePanel();
        signaturePanel.initialize(this.getMyPlayer().getName());
        signaturePanel.setLocation((this.getWidth() - signaturePanel.getWidth()) / 2, (this.getHeight() + 450 - signaturePanel.getHeight()) / 2 - 15);
        signaturePanel.addActionListener(this);
        this.add(signaturePanel);
        Timer t = new Timer(2000, ae -> signaturePanel.startAnimation());
        t.setRepeats(false);
        t.start();
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if ("AnimationStopped".equals(command)) {
            Timer t = new Timer(5000, x -> this.closePanel());
            t.setRepeats(false);
            t.start();
        } else {
            super.actionPerformed(ae);
        }
    }

    private void closePanel() {
        boolean oldClosed = this.closed;
        this.closed = true;
        if (!oldClosed) {
            this.getGUI().removeComponent(this);
            this.afterClosing.run();
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        BufferedImage image = ImageLibrary.getUnscaledImage("image.flavor.Declaration");
        g.drawImage(image, 0, 0, null);
    }

    private class SignaturePanel
    extends JPanel {
        private final FAFile faFile;
        private final ArrayList<ActionListener> actionListeners = new ArrayList();
        private Point[] points = null;
        private int counter = 0;

        SignaturePanel() {
            this.faFile = ResourceManager.getFAFile("animatedfont.signature");
            this.setOpaque(false);
        }

        private String getAbbreviatedName(String name) {
            if (!this.isTooLarge(name)) {
                return name;
            }
            String[] partNames = name.split(" ");
            for (int i = 1; i < partNames.length - 1 && this.isTooLarge(StringUtils.join(" ", partNames)); ++i) {
                partNames[i] = partNames[i].charAt(0) + ".";
            }
            while (partNames.length > 2 && this.isTooLarge(StringUtils.join(" ", partNames))) {
                String[] newPartNames = new String[partNames.length - 1];
                newPartNames[0] = partNames[0];
                for (int i = 1; i < newPartNames.length; ++i) {
                    newPartNames[i] = partNames[i + 1];
                }
                partNames = newPartNames;
            }
            String first = partNames[0];
            String second = partNames[1];
            Object s = StringUtils.join(" ", partNames);
            if (!this.isTooLarge((String)s)) {
                return s;
            }
            s = first.charAt(0) + ". " + second;
            if (!this.isTooLarge((String)s)) {
                return s;
            }
            s = first + " " + second.charAt(0) + ".";
            if (!this.isTooLarge((String)s)) {
                return s;
            }
            return first.charAt(0) + ". " + second.charAt(0) + ".";
        }

        private boolean isTooLarge(String name) {
            Dimension d = this.faFile.getDimension(name);
            return d.width > DeclarationPanel.this.getWidth() - 10;
        }

        public void initialize(String name) {
            name = this.getAbbreviatedName(name);
            this.points = this.faFile.getPoints(name);
            this.counter = 0;
            this.setSize(this.faFile.getDimension(name));
        }

        public void addActionListener(ActionListener al) {
            if (!this.actionListeners.contains(al)) {
                this.actionListeners.add(al);
            }
        }

        private void notifyStopped() {
            for (ActionListener actionListener : this.actionListeners) {
                actionListener.actionPerformed(new ActionEvent(this, 1001, "AnimationStopped"));
            }
        }

        public void startAnimation() {
            ActionListener taskPerformer = ae -> {
                if (this.counter < this.points.length - 1) {
                    this.counter += 20;
                    if (this.counter > this.points.length) {
                        this.counter = this.points.length - 1;
                        ((Timer)ae.getSource()).stop();
                        this.notifyStopped();
                    }
                    this.validate();
                    this.repaint();
                } else {
                    ((Timer)ae.getSource()).stop();
                    this.notifyStopped();
                }
            };
            new Timer(50, taskPerformer).start();
        }

        @Override
        public void paintComponent(Graphics g) {
            if (this.points == null || this.points.length == 0) {
                return;
            }
            if (this.isOpaque()) {
                super.paintComponent(g);
            }
            g.setColor(Color.BLACK);
            ((Graphics2D)g).setComposite(AlphaComposite.getInstance(3, 0.75f));
            for (int i = 0; i < this.counter - 1; ++i) {
                Point p1 = this.points[i];
                Point p2 = this.points[i + 1];
                g.drawLine((int)p1.getX(), (int)p1.getY(), (int)p2.getX(), (int)p2.getY());
            }
        }
    }
}

