/*
 * Decompiled with CFR 0.152.
 */
package net.wimpi.modbus.util;

import java.util.Arrays;
import net.wimpi.modbus.Modbus;

public class SerialParameterValidator {
    public static final Integer[] COMMON_BAUD_RATES = new Integer[]{75, 110, 300, 1200, 2400, 4800, 9600, 19200, 38400, 57600, 115200};
    public static final Double[] VALID_STOP_BITS = new Double[]{1.0, 1.5, 2.0};
    public static final Integer[] VALID_PARITYS = new Integer[]{0, 2, 1};
    public static final String[] VALID_FLOWCONTROL_STRINGS = new String[]{"none", "xon/xoff out", "xon/xoff in", "rts/cts in", "rts/cts out"};
    public static final Integer[] VALID_FLOWCONTROL_INT = new Integer[]{0, 1, 2, 4, 8};

    public static boolean isBaudRateValid(int baudRate) {
        return Arrays.asList(COMMON_BAUD_RATES).contains(baudRate);
    }

    public static boolean isDataBitsValid(int databits) {
        return databits >= 5 && databits <= 8;
    }

    public static boolean isStopbitsValid(double stopbits) {
        return Arrays.asList(VALID_STOP_BITS).contains(stopbits);
    }

    public static boolean isParityValid(int parity) {
        return Arrays.asList(VALID_PARITYS).contains(parity);
    }

    public static boolean isEncodingValid(String enc) {
        return Arrays.asList(Modbus.validSerialEncodings).contains(enc);
    }

    public static boolean isReceiveTimeoutValid(int receiveTimeout) {
        return receiveTimeout > 0;
    }

    public static boolean isFlowControlValid(String flowcontrol) {
        return Arrays.asList(VALID_FLOWCONTROL_STRINGS).contains(flowcontrol);
    }

    public static boolean isFlowControlValid(int flowcontrol) {
        return Arrays.asList(VALID_FLOWCONTROL_INT).contains(flowcontrol);
    }
}

