/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.Database;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableBase;
import org.hsqldb.error.Error;
import org.hsqldb.lib.DoubleIntIndex;
import org.hsqldb.lib.DoubleLongIndex;
import org.hsqldb.lib.HsqlArrayList;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.lib.StopWatch;
import org.hsqldb.lib.StringUtil;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.RowStoreAVLDisk;

final class DataFileDefrag {
    DataFileCache dataFileOut;
    StopWatch stopw = new StopWatch();
    String dataFileName;
    long[][] rootsList;
    Database database;
    DataFileCache dataCache;
    LongLookup pointerLookup;

    DataFileDefrag(Database database, DataFileCache dataFileCache) {
        this.database = database;
        this.dataCache = dataFileCache;
        this.dataFileName = dataFileCache.getFileName();
    }

    void process(Session session) {
        Object object;
        Throwable throwable = null;
        this.database.logger.logDetailEvent("Defrag process begins");
        HsqlArrayList hsqlArrayList = this.database.schemaManager.getAllTables(true);
        this.rootsList = new long[hsqlArrayList.size()][];
        long l = 0L;
        int n = hsqlArrayList.size();
        for (int i = 0; i < n; ++i) {
            long l2;
            Table table = (Table)hsqlArrayList.get(i);
            if (table.getTableType() != 5 || (l2 = (object = this.database.persistentStoreCollection.getStore(table)).elementCount()) <= l) continue;
            l = l2;
        }
        if (l > Integer.MAX_VALUE) {
            throw Error.error(3426);
        }
        try {
            String string = this.database.getCanonicalPath();
            this.dataFileOut = new DataFileCache(this.database, string, true);
            this.pointerLookup = this.dataCache.fileFreePosition < Integer.MAX_VALUE * (long)this.dataCache.dataFileScale ? new DoubleIntIndex((int)l) : new DoubleLongIndex((int)l);
            int n2 = hsqlArrayList.size();
            for (n = 0; n < n2; ++n) {
                object = (Table)hsqlArrayList.get(n);
                if (((TableBase)object).getTableType() == 5) {
                    long[] lArray = this.writeTableToDataFile((Table)object);
                    this.rootsList[n] = lArray;
                } else {
                    this.rootsList[n] = null;
                }
                this.database.logger.logDetailEvent("table complete " + ((Table)object).getName().name);
            }
            this.dataFileOut.close();
            this.dataFileOut = null;
            n2 = this.rootsList.length;
            for (n = 0; n < n2; ++n) {
                object = this.rootsList[n];
                if (object == null) continue;
                this.database.logger.logDetailEvent("roots: " + StringUtil.getList((long[])object, ",", ""));
            }
        }
        catch (OutOfMemoryError outOfMemoryError) {
            throwable = outOfMemoryError;
            throw Error.error(460, outOfMemoryError);
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw Error.error(458, throwable2);
        }
        finally {
            try {
                if (this.dataFileOut != null) {
                    this.dataFileOut.release();
                }
            }
            catch (Throwable throwable3) {}
            if (throwable instanceof OutOfMemoryError) {
                this.database.logger.logInfoEvent("defrag failed - out of memory - required: " + l * 8L);
            }
            if (throwable == null) {
                this.database.logger.logDetailEvent("Defrag transfer complete: " + this.stopw.elapsedTime());
            } else {
                this.database.logger.logSevereEvent("defrag failed ", throwable);
                DataFileCache.deleteFile(this.database, this.dataFileName + ".new");
            }
        }
    }

    long[] writeTableToDataFile(Table table) {
        RowStoreAVLDisk rowStoreAVLDisk = (RowStoreAVLDisk)table.database.persistentStoreCollection.getStore(table);
        long[] lArray = table.getIndexRootsArray();
        this.pointerLookup.clear();
        this.database.logger.logDetailEvent("lookup begins " + table.getName().name + " " + this.stopw.elapsedTime());
        rowStoreAVLDisk.moveDataToSpace(this.dataFileOut, this.pointerLookup);
        for (int i = 0; i < table.getIndexCount(); ++i) {
            if (lArray[i] == -1L) continue;
            long l = this.pointerLookup.lookup(lArray[i], -1L);
            if (l == -1L) {
                throw Error.error(466);
            }
            lArray[i] = l;
        }
        long l = rowStoreAVLDisk.elementCount();
        if (l != (long)this.pointerLookup.size()) {
            this.database.logger.logSevereEvent("discrepency in row count " + table.getName().name + " " + l + " " + this.pointerLookup.size(), null);
        }
        this.database.logger.logDetailEvent("table written " + table.getName().name);
        return lArray;
    }

    public long[][] getIndexRoots() {
        return this.rootsList;
    }
}

