// -*- C++ -*-
//===----------------------------------------------------------------------===//
//
// Part of the LLVM Project, under the Apache License v2.0 with LLVM Exceptions.
// See https://llvm.org/LICENSE.txt for license information.
// SPDX-License-Identifier: Apache-2.0 WITH LLVM-exception
//
//===----------------------------------------------------------------------===//

#ifndef _LIBCPP___CXX03_COMPLEX_H
#define _LIBCPP___CXX03_COMPLEX_H

/*
    complex.h synopsis

#include <__cxx03/ccomplex>

*/

#include <__cxx03/__config>

#if !defined(_LIBCPP_HAS_NO_PRAGMA_SYSTEM_HEADER)
#  pragma GCC system_header
#endif

#ifdef __cplusplus
#  include <__cxx03/ccomplex>
#elif __has_include_next(<complex.h>)
#  include_next <complex.h>
#endif

#endif // _LIBCPP___CXX03_COMPLEX_H
