/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.dbtree;

import ca.sqlpower.object.AbstractSPObject;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.object.SPObject;
import ca.sqlpower.object.SPObjectSnapshot;
import ca.sqlpower.object.annotation.NonProperty;
import ca.sqlpower.sqlobject.SQLColumn;
import ca.sqlpower.sqlobject.SQLDatabase;
import ca.sqlpower.sqlobject.SQLIndex;
import ca.sqlpower.sqlobject.SQLObject;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRoot;
import ca.sqlpower.sqlobject.SQLRelationship;
import ca.sqlpower.sqlobject.SQLTable;
import ca.sqlpower.swingui.FolderNode;
import ca.sqlpower.util.SQLPowerUtils;
import ca.sqlpower.util.TransactionEvent;
import java.beans.PropertyChangeEvent;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.apache.log4j.Logger;

public class DBTreeModel
implements TreeModel,
Serializable {
    private static Logger logger = Logger.getLogger(DBTreeModel.class);
    private final DBTreeSPListener treeListener = new DBTreeSPListener();
    private boolean refireOnAnyThread = false;
    protected SQLObject root;
    protected final Map<SQLTable, List<ArchitectFolder>> foldersInTables = new HashMap<SQLTable, List<ArchitectFolder>>();
    private TreeWillExpandListener treeWillExpandListener = new TreeWillExpandListener(){

        @Override
        public void treeWillCollapse(TreeExpansionEvent event) {
        }

        @Override
        public void treeWillExpand(TreeExpansionEvent event) {
            if (DBTreeModel.this.isColumnsFolder(event.getPath().getLastPathComponent())) {
                try {
                    ((SQLTable)event.getPath().getPathComponent(event.getPath().getPathCount() - 2)).getIndices();
                }
                catch (SQLObjectException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    };
    private final boolean showPlayPenDatabase;
    private final boolean showColumns;
    private final boolean showRelationships;
    private final boolean showImportedKeys;
    private final boolean showIndices;
    private final SPObject snapshotContainer;
    protected LinkedList<TreeModelListener> treeModelListeners;

    public DBTreeModel(SQLObjectRoot root, JTree tree) {
        this(root, tree, true, true, true, true, true);
    }

    public DBTreeModel(SQLObjectRoot root, JTree tree, SPObject snapshotContainer) {
        this(root, tree, snapshotContainer, true, true, true, true, true);
    }

    public DBTreeModel(SQLObjectRoot root, JTree tree, boolean showPlayPenDatabase, boolean showColumns, boolean showRelationships, boolean showImportedKeys, boolean showIndices) {
        this(root, tree, null, showPlayPenDatabase, showColumns, showRelationships, showImportedKeys, showIndices);
    }

    public DBTreeModel(SQLObjectRoot root, JTree tree, SPObject snapshotContainer, boolean showPlayPenDatabase, boolean showColumns, boolean showRelationships, boolean showImportedKeys, boolean showIndices) {
        this.root = root;
        this.snapshotContainer = snapshotContainer;
        this.showPlayPenDatabase = showPlayPenDatabase;
        this.showColumns = showColumns;
        this.showRelationships = showRelationships;
        this.showImportedKeys = showImportedKeys;
        this.showIndices = showIndices;
        this.treeModelListeners = new LinkedList();
        tree.addTreeWillExpandListener(this.treeWillExpandListener);
        SQLPowerUtils.listenToHierarchy((SPObject)root, (SPListener)this.treeListener);
        for (SPObject ancestor : SQLPowerUtils.getAncestorList((SPObject)root)) {
            if (ancestor == snapshotContainer) continue;
            ancestor.addSPListener((SPListener)this.treeListener);
        }
        if (snapshotContainer != null) {
            snapshotContainer.addSPListener((SPListener)this.treeListener);
            for (SPObjectSnapshot snapshot : snapshotContainer.getChildren(SPObjectSnapshot.class)) {
                SQLPowerUtils.listenToHierarchy((SPObject)snapshot, (SPListener)this.treeListener);
            }
        }
        this.setupTreeForNode((SPObject)root);
    }

    private void setupTreeForNode(SPObject node) {
        if (node instanceof SQLTable) {
            this.createFolders((SQLTable)node);
        }
        if (node instanceof SQLObject) {
            for (SQLObject child : ((SQLObject)node).getChildrenWithoutPopulating()) {
                this.setupTreeForNode((SPObject)child);
            }
        } else {
            for (SPObject child : node.getChildren()) {
                this.setupTreeForNode(child);
            }
        }
    }

    @Override
    public Object getRoot() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DBTreeModel.getRoot: returning " + this.root));
        }
        return this.root;
    }

    @Override
    public Object getChild(Object parent, int index) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DBTreeModel.getChild(" + parent + "," + index + ")"));
        }
        if (parent instanceof ArchitectFolder) {
            return ((ArchitectFolder)((Object)parent)).getChildren().get(index);
        }
        if (parent instanceof SQLTable) {
            return this.foldersInTables.get((SQLTable)parent).get(index);
        }
        if (!this.showPlayPenDatabase && parent instanceof SQLObjectRoot) {
            SQLObjectRoot root = (SQLObjectRoot)parent;
            List children = root.getChildren();
            int treeIndex = 0;
            for (int childIndex = 0; childIndex < children.size(); ++childIndex) {
                SQLObject child = (SQLObject)children.get(childIndex);
                if (child instanceof SQLDatabase && ((SQLDatabase)child).isPlayPenDatabase()) continue;
                if (treeIndex == index) {
                    return child;
                }
                ++treeIndex;
            }
            if (index == treeIndex && this.getSnapshotContainer() != null) {
                return this.getSnapshotContainer();
            }
        } else {
            if (parent instanceof SQLObjectRoot && index == ((SQLObjectRoot)parent).getChildren().size()) {
                return this.getSnapshotContainer();
            }
            if (parent == this.getSnapshotContainer()) {
                SPObjectSnapshot snapshot = (SPObjectSnapshot)this.getSnapshotContainer().getChildren(SPObjectSnapshot.class).get(index);
                return snapshot;
            }
        }
        SQLObject sqlParent = (SQLObject)parent;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("returning " + sqlParent.getChild(index)));
            }
            return sqlParent.getChild(index);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public int getChildCount(Object parent) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DBTreeModel.getChildCount(" + parent + ")"));
        }
        if (parent instanceof ArchitectFolder) {
            return ((ArchitectFolder)((Object)parent)).getChildren().size();
        }
        if (parent instanceof SQLTable) {
            return this.foldersInTables.get((SQLTable)parent).size();
        }
        if (parent instanceof SQLColumn) {
            return 0;
        }
        if (!this.showPlayPenDatabase && parent instanceof SQLObjectRoot) {
            SQLObjectRoot root = (SQLObjectRoot)parent;
            int size = root.getChildren().size();
            for (SQLDatabase db : ((SQLObjectRoot)parent).getChildren(SQLDatabase.class)) {
                if (!db.isPlayPenDatabase()) continue;
                --size;
            }
            if (this.getSnapshotContainer() != null) {
                ++size;
            }
            return size;
        }
        if (parent instanceof SQLObjectRoot) {
            SQLObjectRoot root = (SQLObjectRoot)parent;
            int size = root.getChildren().size();
            if (this.getSnapshotContainer() != null) {
                ++size;
            }
            return size;
        }
        if (parent == this.getSnapshotContainer()) {
            int size = ((SPObject)parent).getChildren(SPObjectSnapshot.class).size();
            return size;
        }
        SPObject sqlParent = (SPObject)parent;
        try {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("returning " + sqlParent.getChildren().size()));
            }
            return sqlParent.getChildren().size();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean isLeaf(Object parent) {
        if (logger.isDebugEnabled()) {
            if (parent instanceof AbstractSPObject) {
                logger.debug((Object)("DBTreeModel.isLeaf(" + parent + "): returning " + !((AbstractSPObject)parent).allowsChildren()));
            } else {
                logger.debug((Object)("DBTreeModel.isLeaf(" + parent + "): returning " + !((SQLObject)parent).allowsChildren()));
            }
        }
        if (parent instanceof ArchitectFolder) {
            return false;
        }
        if (parent instanceof SQLColumn) {
            return true;
        }
        return !((SPObject)parent).allowsChildren();
    }

    public boolean isColumnsFolder(Object parent) {
        return parent instanceof ArchitectFolder && ((ArchitectFolder)((Object)parent)).allowsChildType(SQLColumn.class);
    }

    @Override
    public void valueForPathChanged(TreePath path, Object newValue) {
        throw new UnsupportedOperationException("model doesn't support editing yet");
    }

    @Override
    public int getIndexOfChild(Object parent, Object child) {
        SPObject spChild = (SPObject)child;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("DBTreeModel.getIndexOfChild(" + parent + "," + child + "): returning " + ((SQLObject)parent).getChildren(spChild.getClass()).indexOf(child)));
        }
        if (parent instanceof ArchitectFolder) {
            if (((ArchitectFolder)((Object)parent)).isPopulated() || spChild.getParent().equals(parent)) {
                return ((ArchitectFolder)((Object)parent)).getChildren(spChild.getClass()).indexOf(child);
            }
            return -1;
        }
        if (parent instanceof SQLTable) {
            if (this.foldersInTables.get((SQLTable)parent) == null) {
                return -1;
            }
            return this.foldersInTables.get((SQLTable)parent).indexOf(child);
        }
        int index = ((SPObject)parent).getChildren(spChild.getClass()).indexOf(child);
        if (!this.showPlayPenDatabase && parent instanceof SQLObjectRoot) {
            if (child instanceof SQLDatabase && ((SQLDatabase)child).isPlayPenDatabase()) {
                index = -1;
            } else {
                SQLObjectRoot root = (SQLObjectRoot)parent;
                List children = root.getChildren();
                int playPenDatabaseCount = 0;
                for (int i = 0; i < index; ++i) {
                    SQLObject childOfRoot = (SQLObject)children.get(i);
                    if (!(childOfRoot instanceof SQLDatabase) || !((SQLDatabase)childOfRoot).isPlayPenDatabase()) continue;
                    ++playPenDatabaseCount;
                }
                index -= playPenDatabaseCount;
            }
            if (child == this.getSnapshotContainer()) {
                ++index;
            }
        }
        return index;
    }

    @Override
    public void addTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.add(l);
    }

    @Override
    public void removeTreeModelListener(TreeModelListener l) {
        this.treeModelListeners.remove(l);
    }

    protected void fireTreeNodesInserted(TreeModelEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Firing treeNodesInserted event: " + e));
        }
        final TreeModelEvent ev = e;
        Runnable notifier = new Runnable(){

            @Override
            public void run() {
                Iterator it = DBTreeModel.this.treeModelListeners.iterator();
                while (it.hasNext()) {
                    ((TreeModelListener)it.next()).treeNodesInserted(ev);
                }
            }
        };
        notifier.run();
    }

    protected void fireTreeNodesRemoved(TreeModelEvent e) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Firing treeNodesRemoved event " + e));
        }
        final TreeModelEvent ev = e;
        Runnable notifier = new Runnable(){

            @Override
            public void run() {
                Iterator it = DBTreeModel.this.treeModelListeners.iterator();
                while (it.hasNext()) {
                    ((TreeModelListener)it.next()).treeNodesRemoved(ev);
                }
            }
        };
        notifier.run();
    }

    protected void fireTreeNodesChanged(TreeModelEvent e) {
        final TreeModelEvent ev = e;
        Runnable notifier = new Runnable(){

            @Override
            public void run() {
                Iterator it = DBTreeModel.this.treeModelListeners.iterator();
                while (it.hasNext()) {
                    ((TreeModelListener)it.next()).treeNodesChanged(ev);
                }
            }
        };
        notifier.run();
    }

    protected void fireTreeStructureChanged(TreeModelEvent e) {
        logger.debug((Object)("firing TreeStructuredChanged. source=" + e.getSource()));
        final TreeModelEvent ev = e;
        Runnable notifier = new Runnable(){

            @Override
            public void run() {
                Iterator it = DBTreeModel.this.treeModelListeners.iterator();
                while (it.hasNext()) {
                    ((TreeModelListener)it.next()).treeStructureChanged(ev);
                }
            }
        };
        notifier.run();
    }

    public void refreshTreeStructure() {
        this.fireTreeStructureChanged(new TreeModelEvent((Object)this.root, new Object[]{this.root}));
    }

    public SPObject[] getPathToNode(SPObject node) {
        LinkedList<ArchitectFolder> path = new LinkedList<ArchitectFolder>();
        while (node != null && node != this.root) {
            if (path.size() > 0 && node instanceof SQLTable) {
                for (ArchitectFolder folder : this.foldersInTables.get(node)) {
                    if (!folder.getContainingChildType().isAssignableFrom(((SPObject)path.get(0)).getClass())) continue;
                    path.add(0, folder);
                    break;
                }
            }
            path.add(0, (ArchitectFolder)node);
            if (node == this.getSnapshotContainer()) break;
            node = node.getParent();
        }
        path.add(0, (ArchitectFolder)this.root);
        return path.toArray(new SPObject[path.size()]);
    }

    public List<SPObject[]> getPathsToNode(SQLObject node) {
        ArrayList<SPObject[]> nodePaths = new ArrayList<SPObject[]>();
        nodePaths.add(this.getPathToNode((SPObject)node));
        return nodePaths;
    }

    public void setRefireEventsOnAnyThread(boolean v) {
        this.refireOnAnyThread = v;
    }

    private void createFolders(final SQLTable table) {
        if (this.foldersInTables.get(table) == null) {
            ArrayList<ArchitectFolder> folderList = new ArrayList<ArchitectFolder>();
            this.foldersInTables.put(table, folderList);
            if (this.showColumns) {
                ArchitectFolder SQLColumnFolder = new ArchitectFolder((SPObject)table, SQLColumn.class, new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return table.isColumnsPopulated();
                    }
                });
                folderList.add(SQLColumnFolder);
            }
            if (this.showRelationships) {
                ArchitectFolder SQLRelationshipFolder = new ArchitectFolder((SPObject)table, SQLRelationship.class, new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return table.isExportedKeysPopulated();
                    }
                });
                folderList.add(SQLRelationshipFolder);
            }
            if (this.showImportedKeys) {
                ArchitectFolder SQLImportedKeys = new ArchitectFolder((SPObject)table, SQLRelationship.SQLImportedKey.class, new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return table.isImportedKeysPopulated();
                    }
                });
                folderList.add(SQLImportedKeys);
            }
            if (this.showIndices) {
                ArchitectFolder SQLIndexFolder = new ArchitectFolder((SPObject)table, SQLIndex.class, new Callable<Boolean>(){

                    @Override
                    public Boolean call() throws Exception {
                        return table.isIndicesPopulated();
                    }
                });
                folderList.add(SQLIndexFolder);
            }
        }
    }

    public SPObject getSnapshotContainer() {
        return this.snapshotContainer;
    }

    private class DBTreeSPListener
    implements SPListener {
        private DBTreeSPListener() {
        }

        public void childAdded(SPChildEvent e) {
            if (!this.isSPObjectRelevant(e.getSource())) {
                return;
            }
            if (!this.isSPObjectRelevant(e.getChild())) {
                return;
            }
            if (!DBTreeModel.this.root.getRunnableDispatcher().isForegroundThread()) {
                throw new IllegalStateException("Adding a child " + e.getChild() + " to " + e.getSource() + " not on the foreground thread.");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dbChildrenInserted. source=" + e.getSource() + " index: " + e.getIndex() + " child: " + e.getChild()));
                logger.debug((Object)("dbChildrenInserted SQLObjectEvent: " + e + "; tree path=" + Arrays.asList(DBTreeModel.this.getPathToNode(e.getSource()))));
            }
            SQLPowerUtils.listenToHierarchy((SPObject)e.getChild(), (SPListener)this);
            Set<TreeModelEvent> events = this.createTreeEvents(e);
            for (TreeModelEvent evt : events) {
                DBTreeModel.this.fireTreeNodesInserted(evt);
            }
            if (e.getChild() instanceof SQLTable && DBTreeModel.this.foldersInTables.get(e.getChild()) == null) {
                SQLTable table = (SQLTable)e.getChild();
                DBTreeModel.this.createFolders(table);
                List<ArchitectFolder> folderList = DBTreeModel.this.foldersInTables.get(table);
                int[] positions = new int[folderList.size()];
                for (int i = 0; i < folderList.size(); ++i) {
                    positions[i] = i;
                }
                TreeModelEvent evt = new TreeModelEvent((Object)table, DBTreeModel.this.getPathToNode((SPObject)table), positions, folderList.toArray());
                DBTreeModel.this.fireTreeNodesInserted(evt);
            } else {
                DBTreeModel.this.setupTreeForNode(e.getChild());
            }
        }

        public void childRemoved(SPChildEvent e) {
            if (!this.isSPObjectRelevant(e.getSource())) {
                return;
            }
            if (!this.isSPObjectRelevant(e.getChild())) {
                return;
            }
            if (!DBTreeModel.this.root.getRunnableDispatcher().isForegroundThread()) {
                throw new IllegalStateException("Removing a child " + e.getChild() + " to " + e.getSource() + " not on the foreground thread.");
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dbchildrenremoved. source=" + e.getSource() + " index: " + e.getIndex() + " child: " + e.getChild()));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dbChildrenRemoved SQLObjectEvent: " + e));
            }
            SQLPowerUtils.unlistenToHierarchy((SPObject)e.getChild(), (SPListener)this);
            if (e.getChild() instanceof SQLTable) {
                DBTreeModel.this.foldersInTables.remove(e.getChild());
            }
            Set<TreeModelEvent> events = this.createTreeEvents(e);
            for (TreeModelEvent evt : events) {
                DBTreeModel.this.fireTreeNodesRemoved(evt);
            }
        }

        public void transactionEnded(TransactionEvent e) {
            if (!DBTreeModel.this.root.getRunnableDispatcher().isForegroundThread()) {
                throw new IllegalStateException("Transaction ended for " + e.getSource() + " while not on the foreground thread.");
            }
        }

        public void transactionRollback(TransactionEvent e) {
            if (!DBTreeModel.this.root.getRunnableDispatcher().isForegroundThread()) {
                throw new IllegalStateException("Transaction rolled back for " + e.getSource() + " while not on the foreground thread.");
            }
        }

        public void transactionStarted(TransactionEvent e) {
            if (!DBTreeModel.this.root.getRunnableDispatcher().isForegroundThread()) {
                throw new IllegalStateException("Transaction started for " + e.getSource() + " while not on the foreground thread.");
            }
        }

        public void propertyChanged(PropertyChangeEvent e) {
            if (!this.isSPObjectRelevant((SPObject)e.getSource())) {
                return;
            }
            if (!DBTreeModel.this.root.getRunnableDispatcher().isForegroundThread()) {
                throw new IllegalStateException("Changing the property" + e.getPropertyName() + " on " + e.getSource() + " not on the foreground thread.");
            }
            logger.debug((Object)("dbObjectChanged. source=" + e.getSource()));
            if (!SwingUtilities.isEventDispatchThread() && !DBTreeModel.this.refireOnAnyThread) {
                logger.warn((Object)"Not refiring because this is not the EDT. You will need to call refreshTreeStructure() at some point in the future.");
                return;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("dbObjectChanged SQLObjectEvent: " + e));
            }
            this.processSQLObjectChanged(e);
        }

        private Set<TreeModelEvent> createTreeEvents(SPChildEvent change) {
            HashSet<TreeModelEvent> events = new HashSet<TreeModelEvent>();
            Object parent = change.getSource();
            SPObject child = change.getChild();
            if (parent instanceof SQLTable) {
                for (ArchitectFolder folder : DBTreeModel.this.foldersInTables.get(parent)) {
                    if (!folder.getContainingChildType().isAssignableFrom(child.getClass())) continue;
                    parent = folder;
                    break;
                }
            }
            events.add(new TreeModelEvent((Object)DBTreeModel.this, DBTreeModel.this.getPathToNode((SPObject)parent), new int[]{change.getIndex()}, new Object[]{child}));
            return events;
        }

        private void processSQLObjectChanged(PropertyChangeEvent e) {
            if (e.getSource() != null && e.getNewValue() != null && e.getPropertyName().equals("name") && !e.getNewValue().equals(((SPObject)e.getSource()).getName())) {
                logger.error((Object)("Name change event has wrong new value. new=" + e.getNewValue() + "; real=" + ((SPObject)e.getSource()).getName()));
            }
            SPObject source = (SPObject)e.getSource();
            if (e.getPropertyName().equals("UUID")) {
                DBTreeModel.this.refreshTreeStructure();
                logger.info((Object)"Changing a UUID. This should only be done during load.");
            } else {
                TreeModelEvent evt = new TreeModelEvent((Object)this, DBTreeModel.this.getPathToNode(source));
                DBTreeModel.this.fireTreeNodesChanged(evt);
            }
        }

        private boolean isSPObjectRelevant(SPObject spObject) {
            if (spObject == DBTreeModel.this.getSnapshotContainer()) {
                return true;
            }
            if (spObject instanceof SPObjectSnapshot && spObject.getParent() == DBTreeModel.this.getSnapshotContainer()) {
                return true;
            }
            if (!SQLPowerUtils.getAncestorList((SPObject)spObject).contains(DBTreeModel.this.root) && !spObject.equals(DBTreeModel.this.root)) {
                return false;
            }
            if (!DBTreeModel.this.showColumns && spObject instanceof SQLColumn) {
                return false;
            }
            if (!DBTreeModel.this.showRelationships && spObject instanceof SQLRelationship) {
                return false;
            }
            if (!DBTreeModel.this.showImportedKeys && spObject instanceof SQLRelationship.SQLImportedKey) {
                return false;
            }
            if (!DBTreeModel.this.showIndices && spObject instanceof SQLIndex) {
                return false;
            }
            if (!DBTreeModel.this.showPlayPenDatabase && spObject instanceof SQLDatabase) {
                return ((SQLDatabase)spObject).isPlayPenDatabase();
            }
            if (!DBTreeModel.this.showPlayPenDatabase) {
                SQLDatabase db = (SQLDatabase)SQLPowerUtils.getAncestor((SPObject)spObject, SQLDatabase.class);
                return db == null || !db.isPlayPenDatabase();
            }
            return true;
        }
    }

    private static class ArchitectFolder
    extends FolderNode {
        private final Class<? extends SQLObject> containingSQLObjectChildType;
        protected final Callable<Boolean> isPopulatedRunnable;

        public ArchitectFolder(SPObject parentTable, Class<? extends SQLObject> containingChildType, Callable<Boolean> isPopulatedRunnable) {
            super(parentTable, containingChildType);
            this.containingSQLObjectChildType = containingChildType;
            this.isPopulatedRunnable = isPopulatedRunnable;
        }

        public Throwable getChildrenInaccessibleReason(Class<? extends SQLObject> childType) {
            if (childType == this.containingChildType || childType == SQLObject.class) {
                return ((SQLTable)this.parentTable).getChildrenInaccessibleReason(this.containingSQLObjectChildType);
            }
            return null;
        }

        public String getShortDisplayName() {
            if (this.containingChildType.isAssignableFrom(SQLColumn.class)) {
                return "Columns folder for " + this.parentTable.getName();
            }
            if (this.containingChildType.isAssignableFrom(SQLIndex.class)) {
                return "Indices folder for " + this.parentTable.getName();
            }
            if (this.containingChildType.isAssignableFrom(SQLRelationship.class)) {
                return "Exported keys folder for " + this.parentTable.getName();
            }
            if (this.containingChildType.isAssignableFrom(SQLRelationship.SQLImportedKey.class)) {
                return "Imported keys folder for " + this.parentTable.getName();
            }
            return this.containingChildType.getSimpleName() + "s folder for " + this.parentTable.getName();
        }

        public boolean isPopulated() {
            try {
                return this.isPopulatedRunnable.call();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @NonProperty
        public List<? extends SPObject> getChildrenWithoutPopulating() {
            if (this.parentTable instanceof SQLTable) {
                return ((SQLTable)this.parentTable).getChildrenWithoutPopulating(this.containingChildType);
            }
            return this.getChildren();
        }
    }
}

