/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript.optimizer;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.List;
import org.mozilla.classfile.ClassFileWriter;
import org.mozilla.javascript.CompilerEnvirons;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Evaluator;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.FunctionNode;
import org.mozilla.javascript.GeneratedClassLoader;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.NativeFunction;
import org.mozilla.javascript.ObjArray;
import org.mozilla.javascript.ObjToIntMap;
import org.mozilla.javascript.RhinoException;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.ScriptOrFnNode;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.SecurityController;
import org.mozilla.javascript.optimizer.BodyCodegen;
import org.mozilla.javascript.optimizer.OptFunctionNode;
import org.mozilla.javascript.optimizer.OptTransformer;
import org.mozilla.javascript.optimizer.Optimizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Codegen
implements Evaluator {
    static final String DEFAULT_MAIN_METHOD_CLASS = "org.mozilla.javascript.optimizer.OptRuntime";
    private static final String SUPER_CLASS_NAME = "org.mozilla.javascript.NativeFunction";
    static final String DIRECT_CALL_PARENT_FIELD = "_dcp";
    private static final String ID_FIELD_NAME = "_id";
    private static final String REGEXP_INIT_METHOD_NAME = "_reInit";
    private static final String REGEXP_INIT_METHOD_SIGNATURE = "(Lorg/mozilla/javascript/RegExpProxy;Lorg/mozilla/javascript/Context;)V";
    static final String REGEXP_ARRAY_FIELD_NAME = "_re";
    static final String REGEXP_ARRAY_FIELD_TYPE = "[Ljava/lang/Object;";
    static final String FUNCTION_INIT_SIGNATURE = "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)V";
    static final String FUNCTION_CONSTRUCTOR_SIGNATURE = "(Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Context;I)V";
    private static final Object globalLock = new Object();
    private static int globalSerialClassCounter;
    private CompilerEnvirons compilerEnv;
    private ObjArray directCallTargets;
    ScriptOrFnNode[] scriptOrFnNodes;
    private ObjToIntMap scriptOrFnIndexes;
    private String mainMethodClass = "org.mozilla.javascript.optimizer.OptRuntime";
    String mainClassName;
    String mainClassSignature;
    private double[] itsConstantList;
    private int itsConstantListSize;

    @Override
    public void captureStackInfo(RhinoException rhinoException) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getSourcePositionFromStack(Context context, int[] nArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPatchedStack(RhinoException rhinoException, String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<String> getScriptStack(RhinoException rhinoException) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setEvalScriptFlag(Script script) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object compile(CompilerEnvirons compilerEnvirons, ScriptOrFnNode scriptOrFnNode, String string, boolean bl) {
        int n;
        Object object = globalLock;
        synchronized (object) {
            n = ++globalSerialClassCounter;
        }
        object = "org.mozilla.javascript.gen.c" + n;
        byte[] byArray = this.compileToClassFile(compilerEnvirons, (String)object, scriptOrFnNode, string, bl);
        return new Object[]{object, byArray};
    }

    @Override
    public Script createScriptObject(Object object, Object object2) {
        Script script;
        Class<?> clazz = this.defineClass(object, object2);
        try {
            script = (Script)clazz.newInstance();
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to instantiate compiled class:" + exception.toString());
        }
        return script;
    }

    @Override
    public Function createFunctionObject(Context context, Scriptable scriptable, Object object, Object object2) {
        NativeFunction nativeFunction;
        Class<?> clazz = this.defineClass(object, object2);
        try {
            Constructor<?> constructor = clazz.getConstructors()[0];
            Object[] objectArray = new Object[]{scriptable, context, new Integer(0)};
            nativeFunction = (NativeFunction)constructor.newInstance(objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Unable to instantiate compiled class:" + exception.toString());
        }
        return nativeFunction;
    }

    private Class<?> defineClass(Object object, Object object2) {
        RuntimeException runtimeException;
        Object[] objectArray = (Object[])object;
        String string = (String)objectArray[0];
        byte[] byArray = (byte[])objectArray[1];
        ClassLoader classLoader = this.getClass().getClassLoader();
        GeneratedClassLoader generatedClassLoader = SecurityController.createLoader(classLoader, object2);
        try {
            Class<?> clazz = generatedClassLoader.defineClass(string, byArray);
            generatedClassLoader.linkClass(clazz);
            return clazz;
        }
        catch (SecurityException securityException) {
            runtimeException = securityException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            runtimeException = illegalArgumentException;
        }
        throw new RuntimeException("Malformed optimizer package " + runtimeException);
    }

    byte[] compileToClassFile(CompilerEnvirons compilerEnvirons, String string, ScriptOrFnNode scriptOrFnNode, String string2, boolean bl) {
        this.compilerEnv = compilerEnvirons;
        this.transform(scriptOrFnNode);
        if (bl) {
            scriptOrFnNode = scriptOrFnNode.getFunctionNode(0);
        }
        this.initScriptOrFnNodesData(scriptOrFnNode);
        this.mainClassName = string;
        this.mainClassSignature = ClassFileWriter.classNameToSignature(string);
        try {
            return this.generateCode(string2);
        }
        catch (ClassFileWriter.ClassFileFormatException classFileFormatException) {
            throw this.reportClassFileFormatException(scriptOrFnNode, classFileFormatException.getMessage());
        }
    }

    private RuntimeException reportClassFileFormatException(ScriptOrFnNode scriptOrFnNode, String string) {
        String string2 = scriptOrFnNode instanceof FunctionNode ? ScriptRuntime.getMessage2("msg.while.compiling.fn", ((FunctionNode)scriptOrFnNode).getFunctionName(), string) : ScriptRuntime.getMessage1("msg.while.compiling.script", string);
        return Context.reportRuntimeError(string2, scriptOrFnNode.getSourceName(), scriptOrFnNode.getLineno(), null, 0);
    }

    private void transform(ScriptOrFnNode scriptOrFnNode) {
        Codegen.initOptFunctions_r(scriptOrFnNode);
        int n = this.compilerEnv.getOptimizationLevel();
        HashMap<String, OptFunctionNode> hashMap = null;
        if (n > 0 && scriptOrFnNode.getType() == 135) {
            int n2 = scriptOrFnNode.getFunctionCount();
            int n3 = 0;
            while (n3 != n2) {
                String string;
                OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptOrFnNode, n3);
                if (optFunctionNode.fnode.getFunctionType() == 1 && (string = optFunctionNode.fnode.getFunctionName()).length() != 0) {
                    if (hashMap == null) {
                        hashMap = new HashMap<String, OptFunctionNode>();
                    }
                    hashMap.put(string, optFunctionNode);
                }
                ++n3;
            }
        }
        if (hashMap != null) {
            this.directCallTargets = new ObjArray();
        }
        OptTransformer optTransformer = new OptTransformer(hashMap, this.directCallTargets);
        optTransformer.transform(scriptOrFnNode);
        if (n > 0) {
            new Optimizer().optimize(scriptOrFnNode);
        }
    }

    private static void initOptFunctions_r(ScriptOrFnNode scriptOrFnNode) {
        int n = 0;
        int n2 = scriptOrFnNode.getFunctionCount();
        while (n != n2) {
            FunctionNode functionNode = scriptOrFnNode.getFunctionNode(n);
            new OptFunctionNode(functionNode);
            Codegen.initOptFunctions_r(functionNode);
            ++n;
        }
    }

    private void initScriptOrFnNodesData(ScriptOrFnNode scriptOrFnNode) {
        ObjArray objArray = new ObjArray();
        Codegen.collectScriptOrFnNodes_r(scriptOrFnNode, objArray);
        int n = objArray.size();
        this.scriptOrFnNodes = new ScriptOrFnNode[n];
        objArray.toArray(this.scriptOrFnNodes);
        this.scriptOrFnIndexes = new ObjToIntMap(n);
        int n2 = 0;
        while (n2 != n) {
            this.scriptOrFnIndexes.put(this.scriptOrFnNodes[n2], n2);
            ++n2;
        }
    }

    private static void collectScriptOrFnNodes_r(ScriptOrFnNode scriptOrFnNode, ObjArray objArray) {
        objArray.add(scriptOrFnNode);
        int n = scriptOrFnNode.getFunctionCount();
        int n2 = 0;
        while (n2 != n) {
            Codegen.collectScriptOrFnNodes_r(scriptOrFnNode.getFunctionNode(n2), objArray);
            ++n2;
        }
    }

    private byte[] generateCode(String string) {
        boolean bl = this.scriptOrFnNodes[0].getType() == 135;
        boolean bl2 = this.scriptOrFnNodes.length > 1 || !bl;
        String string2 = null;
        if (this.compilerEnv.isGenerateDebugInfo()) {
            string2 = this.scriptOrFnNodes[0].getSourceName();
        }
        ClassFileWriter classFileWriter = new ClassFileWriter(this.mainClassName, SUPER_CLASS_NAME, string2);
        classFileWriter.addField(ID_FIELD_NAME, "I", (short)2);
        classFileWriter.addField(DIRECT_CALL_PARENT_FIELD, this.mainClassSignature, (short)2);
        classFileWriter.addField(REGEXP_ARRAY_FIELD_NAME, REGEXP_ARRAY_FIELD_TYPE, (short)2);
        if (bl2) {
            this.generateFunctionConstructor(classFileWriter);
        }
        if (bl) {
            classFileWriter.addInterface("org/mozilla/javascript/Script");
            this.generateScriptCtor(classFileWriter);
            this.generateMain(classFileWriter);
            this.generateExecute(classFileWriter);
        }
        this.generateCallMethod(classFileWriter);
        this.generateResumeGenerator(classFileWriter);
        this.generateNativeFunctionOverrides(classFileWriter, string);
        int n = this.scriptOrFnNodes.length;
        int n2 = 0;
        while (n2 != n) {
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[n2];
            BodyCodegen bodyCodegen = new BodyCodegen();
            bodyCodegen.cfw = classFileWriter;
            bodyCodegen.codegen = this;
            bodyCodegen.compilerEnv = this.compilerEnv;
            bodyCodegen.scriptOrFn = scriptOrFnNode;
            bodyCodegen.scriptOrFnIndex = n2;
            try {
                bodyCodegen.generateBodyCode();
            }
            catch (ClassFileWriter.ClassFileFormatException classFileFormatException) {
                throw this.reportClassFileFormatException(scriptOrFnNode, classFileFormatException.getMessage());
            }
            if (scriptOrFnNode.getType() == 108) {
                OptFunctionNode optFunctionNode = OptFunctionNode.get(scriptOrFnNode);
                this.generateFunctionInit(classFileWriter, optFunctionNode);
                if (optFunctionNode.isTargetOfDirectCall()) {
                    this.emitDirectConstructor(classFileWriter, optFunctionNode);
                }
            }
            ++n2;
        }
        if (this.directCallTargets != null) {
            n2 = this.directCallTargets.size();
            int n3 = 0;
            while (n3 != n2) {
                classFileWriter.addField(Codegen.getDirectTargetFieldName(n3), this.mainClassSignature, (short)2);
                ++n3;
            }
        }
        this.emitRegExpInit(classFileWriter);
        this.emitConstantDudeInitializers(classFileWriter);
        return classFileWriter.toByteArray();
    }

    private void emitDirectConstructor(ClassFileWriter classFileWriter, OptFunctionNode optFunctionNode) {
        classFileWriter.startMethod(this.getDirectCtorName(optFunctionNode.fnode), this.getBodyMethodSignature(optFunctionNode.fnode), (short)10);
        int n = optFunctionNode.fnode.getParamCount();
        int n2 = 4 + n * 3 + 1;
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addInvoke(182, "org/mozilla/javascript/BaseFunction", "createObject", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Lorg/mozilla/javascript/Scriptable;");
        classFileWriter.addAStore(n2);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(n2);
        int n3 = 0;
        while (n3 < n) {
            classFileWriter.addALoad(4 + n3 * 3);
            classFileWriter.addDLoad(5 + n3 * 3);
            ++n3;
        }
        classFileWriter.addALoad(4 + n * 3);
        classFileWriter.addInvoke(184, this.mainClassName, this.getBodyMethodName(optFunctionNode.fnode), this.getBodyMethodSignature(optFunctionNode.fnode));
        n3 = classFileWriter.acquireLabel();
        classFileWriter.add(89);
        classFileWriter.add(193, "org/mozilla/javascript/Scriptable");
        classFileWriter.add(153, n3);
        classFileWriter.add(192, "org/mozilla/javascript/Scriptable");
        classFileWriter.add(176);
        classFileWriter.markLabel(n3);
        classFileWriter.addALoad(n2);
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)(n2 + 1));
    }

    static boolean isGenerator(ScriptOrFnNode scriptOrFnNode) {
        return scriptOrFnNode.getType() == 108 && ((FunctionNode)scriptOrFnNode).isGenerator();
    }

    private void generateResumeGenerator(ClassFileWriter classFileWriter) {
        boolean bl = false;
        int n = 0;
        while (n < this.scriptOrFnNodes.length) {
            if (Codegen.isGenerator(this.scriptOrFnNodes[n])) {
                bl = true;
            }
            ++n;
        }
        if (!bl) {
            return;
        }
        classFileWriter.startMethod("resumeGenerator", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;ILjava/lang/Object;Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(4);
        classFileWriter.addALoad(5);
        classFileWriter.addILoad(3);
        classFileWriter.addLoadThis();
        classFileWriter.add(180, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        n = classFileWriter.addTableSwitch(0, this.scriptOrFnNodes.length - 1);
        classFileWriter.markTableSwitchDefault(n);
        int n2 = classFileWriter.acquireLabel();
        int n3 = 0;
        while (n3 < this.scriptOrFnNodes.length) {
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[n3];
            classFileWriter.markTableSwitchCase(n, n3, 6);
            if (Codegen.isGenerator(scriptOrFnNode)) {
                String string = "(" + this.mainClassSignature + "Lorg/mozilla/javascript/Context;" + "Lorg/mozilla/javascript/Scriptable;" + "Ljava/lang/Object;" + "Ljava/lang/Object;I)Ljava/lang/Object;";
                classFileWriter.addInvoke(184, this.mainClassName, String.valueOf(this.getBodyMethodName(scriptOrFnNode)) + "_gen", string);
                classFileWriter.add(176);
            } else {
                classFileWriter.add(167, n2);
            }
            ++n3;
        }
        classFileWriter.markLabel(n2);
        Codegen.pushUndefined(classFileWriter);
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)6);
    }

    private void generateCallMethod(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;", (short)17);
        int n = classFileWriter.acquireLabel();
        classFileWriter.addALoad(1);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "hasTopCall", "(Lorg/mozilla/javascript/Context;)Z");
        classFileWriter.add(154, n);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(3);
        classFileWriter.addALoad(4);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "doTopCall", "(Lorg/mozilla/javascript/Callable;Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        classFileWriter.add(176);
        classFileWriter.markLabel(n);
        classFileWriter.addALoad(0);
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(3);
        classFileWriter.addALoad(4);
        int n2 = this.scriptOrFnNodes.length;
        boolean bl = 2 <= n2;
        int n3 = 0;
        short s = 0;
        if (bl) {
            classFileWriter.addLoadThis();
            classFileWriter.add(180, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
            n3 = classFileWriter.addTableSwitch(1, n2 - 1);
        }
        int n4 = 0;
        while (n4 != n2) {
            int n5;
            OptFunctionNode optFunctionNode;
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[n4];
            if (bl) {
                if (n4 == 0) {
                    classFileWriter.markTableSwitchDefault(n3);
                    s = classFileWriter.getStackTop();
                } else {
                    classFileWriter.markTableSwitchCase(n3, n4 - 1, s);
                }
            }
            if (scriptOrFnNode.getType() == 108 && (optFunctionNode = OptFunctionNode.get(scriptOrFnNode)).isTargetOfDirectCall() && (n5 = optFunctionNode.fnode.getParamCount()) != 0) {
                int n6 = 0;
                while (n6 != n5) {
                    classFileWriter.add(190);
                    classFileWriter.addPush(n6);
                    int n7 = classFileWriter.acquireLabel();
                    int n8 = classFileWriter.acquireLabel();
                    classFileWriter.add(164, n7);
                    classFileWriter.addALoad(4);
                    classFileWriter.addPush(n6);
                    classFileWriter.add(50);
                    classFileWriter.add(167, n8);
                    classFileWriter.markLabel(n7);
                    Codegen.pushUndefined(classFileWriter);
                    classFileWriter.markLabel(n8);
                    classFileWriter.adjustStackTop(-1);
                    classFileWriter.addPush(0.0);
                    classFileWriter.addALoad(4);
                    ++n6;
                }
            }
            classFileWriter.addInvoke(184, this.mainClassName, this.getBodyMethodName(scriptOrFnNode), this.getBodyMethodSignature(scriptOrFnNode));
            classFileWriter.add(176);
            ++n4;
        }
        classFileWriter.stopMethod((short)5);
    }

    private void generateMain(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("main", "([Ljava/lang/String;)V", (short)9);
        classFileWriter.add(187, classFileWriter.getClassName());
        classFileWriter.add(89);
        classFileWriter.addInvoke(183, classFileWriter.getClassName(), "<init>", "()V");
        classFileWriter.add(42);
        classFileWriter.addInvoke(184, this.mainMethodClass, "main", "(Lorg/mozilla/javascript/Script;[Ljava/lang/String;)V");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)1);
    }

    private void generateExecute(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("exec", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;)Ljava/lang/Object;", (short)17);
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.add(89);
        classFileWriter.add(1);
        classFileWriter.addInvoke(182, classFileWriter.getClassName(), "call", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;[Ljava/lang/Object;)Ljava/lang/Object;");
        classFileWriter.add(176);
        classFileWriter.stopMethod((short)3);
    }

    private void generateScriptCtor(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("<init>", "()V", (short)1);
        classFileWriter.addLoadThis();
        classFileWriter.addInvoke(183, SUPER_CLASS_NAME, "<init>", "()V");
        classFileWriter.addLoadThis();
        classFileWriter.addPush(0);
        classFileWriter.add(181, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)1);
    }

    private void generateFunctionConstructor(ClassFileWriter classFileWriter) {
        classFileWriter.startMethod("<init>", FUNCTION_CONSTRUCTOR_SIGNATURE, (short)1);
        classFileWriter.addALoad(0);
        classFileWriter.addInvoke(183, SUPER_CLASS_NAME, "<init>", "()V");
        classFileWriter.addLoadThis();
        classFileWriter.addILoad(3);
        classFileWriter.add(181, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(2);
        classFileWriter.addALoad(1);
        int n = this.scriptOrFnNodes[0].getType() == 135 ? 1 : 0;
        int n2 = this.scriptOrFnNodes.length;
        if (n == n2) {
            throw Codegen.badTree();
        }
        boolean bl = 2 <= n2 - n;
        int n3 = 0;
        short s = 0;
        if (bl) {
            classFileWriter.addILoad(3);
            n3 = classFileWriter.addTableSwitch(n + 1, n2 - 1);
        }
        int n4 = n;
        while (n4 != n2) {
            if (bl) {
                if (n4 == n) {
                    classFileWriter.markTableSwitchDefault(n3);
                    s = classFileWriter.getStackTop();
                } else {
                    classFileWriter.markTableSwitchCase(n3, n4 - 1 - n, s);
                }
            }
            OptFunctionNode optFunctionNode = OptFunctionNode.get(this.scriptOrFnNodes[n4]);
            classFileWriter.addInvoke(182, this.mainClassName, this.getFunctionInitMethodName(optFunctionNode), FUNCTION_INIT_SIGNATURE);
            classFileWriter.add(177);
            ++n4;
        }
        classFileWriter.stopMethod((short)4);
    }

    private void generateFunctionInit(ClassFileWriter classFileWriter, OptFunctionNode optFunctionNode) {
        classFileWriter.startMethod(this.getFunctionInitMethodName(optFunctionNode), FUNCTION_INIT_SIGNATURE, (short)18);
        classFileWriter.addLoadThis();
        classFileWriter.addALoad(1);
        classFileWriter.addALoad(2);
        classFileWriter.addInvoke(182, "org/mozilla/javascript/NativeFunction", "initScriptFunction", FUNCTION_INIT_SIGNATURE);
        int n = optFunctionNode.fnode.getRegexpCount();
        if (n != 0) {
            classFileWriter.addLoadThis();
            this.pushRegExpArray(classFileWriter, optFunctionNode.fnode, 1, 2);
            classFileWriter.add(181, this.mainClassName, REGEXP_ARRAY_FIELD_NAME, REGEXP_ARRAY_FIELD_TYPE);
        }
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)3);
    }

    private void generateNativeFunctionOverrides(ClassFileWriter classFileWriter, String string) {
        classFileWriter.startMethod("getLanguageVersion", "()I", (short)1);
        classFileWriter.addPush(this.compilerEnv.getLanguageVersion());
        classFileWriter.add(172);
        classFileWriter.stopMethod((short)1);
        int n = 0;
        while (n != 6) {
            if (n != 4 || string != null) {
                short s;
                switch (n) {
                    case 0: {
                        s = 1;
                        classFileWriter.startMethod("getFunctionName", "()Ljava/lang/String;", (short)1);
                        break;
                    }
                    case 1: {
                        s = 1;
                        classFileWriter.startMethod("getParamCount", "()I", (short)1);
                        break;
                    }
                    case 2: {
                        s = 1;
                        classFileWriter.startMethod("getParamAndVarCount", "()I", (short)1);
                        break;
                    }
                    case 3: {
                        s = 2;
                        classFileWriter.startMethod("getParamOrVarName", "(I)Ljava/lang/String;", (short)1);
                        break;
                    }
                    case 5: {
                        s = 3;
                        classFileWriter.startMethod("getParamOrVarConst", "(I)Z", (short)1);
                        break;
                    }
                    case 4: {
                        s = 1;
                        classFileWriter.startMethod("getEncodedSource", "()Ljava/lang/String;", (short)1);
                        classFileWriter.addPush(string);
                        break;
                    }
                    default: {
                        throw Kit.codeBug();
                    }
                }
                int n2 = this.scriptOrFnNodes.length;
                int n3 = 0;
                int n4 = 0;
                if (n2 > 1) {
                    classFileWriter.addLoadThis();
                    classFileWriter.add(180, classFileWriter.getClassName(), ID_FIELD_NAME, "I");
                    n3 = classFileWriter.addTableSwitch(1, n2 - 1);
                }
                int n5 = 0;
                while (n5 != n2) {
                    ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[n5];
                    if (n5 == 0) {
                        if (n2 > 1) {
                            classFileWriter.markTableSwitchDefault(n3);
                            n4 = classFileWriter.getStackTop();
                        }
                    } else {
                        classFileWriter.markTableSwitchCase(n3, n5 - 1, n4);
                    }
                    switch (n) {
                        case 0: {
                            if (scriptOrFnNode.getType() == 135) {
                                classFileWriter.addPush("");
                            } else {
                                String string2 = ((FunctionNode)scriptOrFnNode).getFunctionName();
                                classFileWriter.addPush(string2);
                            }
                            classFileWriter.add(176);
                            break;
                        }
                        case 1: {
                            classFileWriter.addPush(scriptOrFnNode.getParamCount());
                            classFileWriter.add(172);
                            break;
                        }
                        case 2: {
                            classFileWriter.addPush(scriptOrFnNode.getParamAndVarCount());
                            classFileWriter.add(172);
                            break;
                        }
                        case 3: {
                            int n6 = scriptOrFnNode.getParamAndVarCount();
                            if (n6 == 0) {
                                classFileWriter.add(1);
                                classFileWriter.add(176);
                                break;
                            }
                            if (n6 == 1) {
                                classFileWriter.addPush(scriptOrFnNode.getParamOrVarName(0));
                                classFileWriter.add(176);
                                break;
                            }
                            classFileWriter.addILoad(1);
                            int n7 = classFileWriter.addTableSwitch(1, n6 - 1);
                            int n8 = 0;
                            while (n8 != n6) {
                                if (classFileWriter.getStackTop() != 0) {
                                    Kit.codeBug();
                                }
                                String string3 = scriptOrFnNode.getParamOrVarName(n8);
                                if (n8 == 0) {
                                    classFileWriter.markTableSwitchDefault(n7);
                                } else {
                                    classFileWriter.markTableSwitchCase(n7, n8 - 1, 0);
                                }
                                classFileWriter.addPush(string3);
                                classFileWriter.add(176);
                                ++n8;
                            }
                            break;
                        }
                        case 5: {
                            int n9 = scriptOrFnNode.getParamAndVarCount();
                            boolean[] blArray = scriptOrFnNode.getParamAndVarConst();
                            if (n9 == 0) {
                                classFileWriter.add(3);
                                classFileWriter.add(172);
                                break;
                            }
                            if (n9 == 1) {
                                classFileWriter.addPush(blArray[0]);
                                classFileWriter.add(172);
                                break;
                            }
                            classFileWriter.addILoad(1);
                            int n8 = classFileWriter.addTableSwitch(1, n9 - 1);
                            int n10 = 0;
                            while (n10 != n9) {
                                if (classFileWriter.getStackTop() != 0) {
                                    Kit.codeBug();
                                }
                                if (n10 == 0) {
                                    classFileWriter.markTableSwitchDefault(n8);
                                } else {
                                    classFileWriter.markTableSwitchCase(n8, n10 - 1, 0);
                                }
                                classFileWriter.addPush(blArray[n10]);
                                classFileWriter.add(172);
                                ++n10;
                            }
                            break;
                        }
                        case 4: {
                            classFileWriter.addPush(scriptOrFnNode.getEncodedSourceStart());
                            classFileWriter.addPush(scriptOrFnNode.getEncodedSourceEnd());
                            classFileWriter.addInvoke(182, "java/lang/String", "substring", "(II)Ljava/lang/String;");
                            classFileWriter.add(176);
                            break;
                        }
                        default: {
                            throw Kit.codeBug();
                        }
                    }
                    ++n5;
                }
                classFileWriter.stopMethod(s);
            }
            ++n;
        }
    }

    private void emitRegExpInit(ClassFileWriter classFileWriter) {
        int n = 0;
        int n2 = 0;
        while (n2 != this.scriptOrFnNodes.length) {
            n += this.scriptOrFnNodes[n2].getRegexpCount();
            ++n2;
        }
        if (n == 0) {
            return;
        }
        classFileWriter.startMethod(REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE, (short)42);
        classFileWriter.addField("_reInitDone", "Z", (short)10);
        classFileWriter.add(178, this.mainClassName, "_reInitDone", "Z");
        n2 = classFileWriter.acquireLabel();
        classFileWriter.add(153, n2);
        classFileWriter.add(177);
        classFileWriter.markLabel(n2);
        int n3 = 0;
        while (n3 != this.scriptOrFnNodes.length) {
            ScriptOrFnNode scriptOrFnNode = this.scriptOrFnNodes[n3];
            int n4 = scriptOrFnNode.getRegexpCount();
            int n5 = 0;
            while (n5 != n4) {
                String string = this.getCompiledRegexpName(scriptOrFnNode, n5);
                String string2 = "Ljava/lang/Object;";
                String string3 = scriptOrFnNode.getRegexpString(n5);
                String string4 = scriptOrFnNode.getRegexpFlags(n5);
                classFileWriter.addField(string, string2, (short)10);
                classFileWriter.addALoad(0);
                classFileWriter.addALoad(1);
                classFileWriter.addPush(string3);
                if (string4 == null) {
                    classFileWriter.add(1);
                } else {
                    classFileWriter.addPush(string4);
                }
                classFileWriter.addInvoke(185, "org/mozilla/javascript/RegExpProxy", "compileRegExp", "(Lorg/mozilla/javascript/Context;Ljava/lang/String;Ljava/lang/String;)Ljava/lang/Object;");
                classFileWriter.add(179, this.mainClassName, string, string2);
                ++n5;
            }
            ++n3;
        }
        classFileWriter.addPush(1);
        classFileWriter.add(179, this.mainClassName, "_reInitDone", "Z");
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)2);
    }

    private void emitConstantDudeInitializers(ClassFileWriter classFileWriter) {
        int n = this.itsConstantListSize;
        if (n == 0) {
            return;
        }
        classFileWriter.startMethod("<clinit>", "()V", (short)24);
        double[] dArray = this.itsConstantList;
        int n2 = 0;
        while (n2 != n) {
            double d = dArray[n2];
            String string = "_k" + n2;
            String string2 = Codegen.getStaticConstantWrapperType(d);
            classFileWriter.addField(string, string2, (short)10);
            int n3 = (int)d;
            if ((double)n3 == d) {
                classFileWriter.add(187, "java/lang/Integer");
                classFileWriter.add(89);
                classFileWriter.addPush(n3);
                classFileWriter.addInvoke(183, "java/lang/Integer", "<init>", "(I)V");
            } else {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            }
            classFileWriter.add(179, this.mainClassName, string, string2);
            ++n2;
        }
        classFileWriter.add(177);
        classFileWriter.stopMethod((short)0);
    }

    void pushRegExpArray(ClassFileWriter classFileWriter, ScriptOrFnNode scriptOrFnNode, int n, int n2) {
        int n3 = scriptOrFnNode.getRegexpCount();
        if (n3 == 0) {
            throw Codegen.badTree();
        }
        classFileWriter.addPush(n3);
        classFileWriter.add(189, "java/lang/Object");
        classFileWriter.addALoad(n);
        classFileWriter.addInvoke(184, "org/mozilla/javascript/ScriptRuntime", "checkRegExpProxy", "(Lorg/mozilla/javascript/Context;)Lorg/mozilla/javascript/RegExpProxy;");
        classFileWriter.add(89);
        classFileWriter.addALoad(n);
        classFileWriter.addInvoke(184, this.mainClassName, REGEXP_INIT_METHOD_NAME, REGEXP_INIT_METHOD_SIGNATURE);
        int n4 = 0;
        while (n4 != n3) {
            classFileWriter.add(92);
            classFileWriter.addALoad(n);
            classFileWriter.addALoad(n2);
            classFileWriter.add(178, this.mainClassName, this.getCompiledRegexpName(scriptOrFnNode, n4), "Ljava/lang/Object;");
            classFileWriter.addInvoke(185, "org/mozilla/javascript/RegExpProxy", "wrapRegExp", "(Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Ljava/lang/Object;)Lorg/mozilla/javascript/Scriptable;");
            classFileWriter.addPush(n4);
            classFileWriter.add(95);
            classFileWriter.add(83);
            ++n4;
        }
        classFileWriter.add(87);
    }

    void pushNumberAsObject(ClassFileWriter classFileWriter, double d) {
        if (d == 0.0) {
            if (1.0 / d > 0.0) {
                classFileWriter.add(178, "org/mozilla/javascript/optimizer/OptRuntime", "zeroObj", "Ljava/lang/Double;");
            } else {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            }
        } else {
            if (d == 1.0) {
                classFileWriter.add(178, "org/mozilla/javascript/optimizer/OptRuntime", "oneObj", "Ljava/lang/Double;");
                return;
            }
            if (d == -1.0) {
                classFileWriter.add(178, "org/mozilla/javascript/optimizer/OptRuntime", "minusOneObj", "Ljava/lang/Double;");
            } else if (d != d) {
                classFileWriter.add(178, "org/mozilla/javascript/ScriptRuntime", "NaNobj", "Ljava/lang/Double;");
            } else if (this.itsConstantListSize >= 2000) {
                classFileWriter.addPush(d);
                Codegen.addDoubleWrap(classFileWriter);
            } else {
                Object object;
                int n = this.itsConstantListSize;
                int n2 = 0;
                if (n == 0) {
                    this.itsConstantList = new double[64];
                } else {
                    object = this.itsConstantList;
                    while (n2 != n && object[n2] != d) {
                        ++n2;
                    }
                    if (n == ((double[])object).length) {
                        object = new double[n * 2];
                        System.arraycopy(this.itsConstantList, 0, object, 0, n);
                        this.itsConstantList = object;
                    }
                }
                if (n2 == n) {
                    this.itsConstantList[n] = d;
                    this.itsConstantListSize = n + 1;
                }
                object = "_k" + n2;
                String string = Codegen.getStaticConstantWrapperType(d);
                classFileWriter.add(178, this.mainClassName, (String)object, string);
            }
        }
    }

    private static void addDoubleWrap(ClassFileWriter classFileWriter) {
        classFileWriter.addInvoke(184, "org/mozilla/javascript/optimizer/OptRuntime", "wrapDouble", "(D)Ljava/lang/Double;");
    }

    private static String getStaticConstantWrapperType(double d) {
        int n = (int)d;
        if ((double)n == d) {
            return "Ljava/lang/Integer;";
        }
        return "Ljava/lang/Double;";
    }

    static void pushUndefined(ClassFileWriter classFileWriter) {
        classFileWriter.add(178, "org/mozilla/javascript/Undefined", "instance", "Ljava/lang/Object;");
    }

    int getIndex(ScriptOrFnNode scriptOrFnNode) {
        return this.scriptOrFnIndexes.getExisting(scriptOrFnNode);
    }

    static String getDirectTargetFieldName(int n) {
        return "_dt" + n;
    }

    String getDirectCtorName(ScriptOrFnNode scriptOrFnNode) {
        return "_n" + this.getIndex(scriptOrFnNode);
    }

    String getBodyMethodName(ScriptOrFnNode scriptOrFnNode) {
        return "_c" + this.getIndex(scriptOrFnNode);
    }

    String getBodyMethodSignature(ScriptOrFnNode scriptOrFnNode) {
        OptFunctionNode optFunctionNode;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        stringBuffer.append(this.mainClassSignature);
        stringBuffer.append("Lorg/mozilla/javascript/Context;Lorg/mozilla/javascript/Scriptable;Lorg/mozilla/javascript/Scriptable;");
        if (scriptOrFnNode.getType() == 108 && (optFunctionNode = OptFunctionNode.get(scriptOrFnNode)).isTargetOfDirectCall()) {
            int n = optFunctionNode.fnode.getParamCount();
            int n2 = 0;
            while (n2 != n) {
                stringBuffer.append("Ljava/lang/Object;D");
                ++n2;
            }
        }
        stringBuffer.append("[Ljava/lang/Object;)Ljava/lang/Object;");
        return stringBuffer.toString();
    }

    String getFunctionInitMethodName(OptFunctionNode optFunctionNode) {
        return "_i" + this.getIndex(optFunctionNode.fnode);
    }

    String getCompiledRegexpName(ScriptOrFnNode scriptOrFnNode, int n) {
        return REGEXP_ARRAY_FIELD_NAME + this.getIndex(scriptOrFnNode) + "_" + n;
    }

    static RuntimeException badTree() {
        throw new RuntimeException("Bad tree in codegen");
    }

    void setMainMethodClass(String string) {
        this.mainMethodClass = string;
    }
}

