/*
 * Decompiled with CFR 0.152.
 */
package org.scilab.forge.jlatexmath;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.BitSet;
import java.util.Map;
import org.scilab.forge.jlatexmath.Box;
import org.scilab.forge.jlatexmath.Char;
import org.scilab.forge.jlatexmath.CharBox;
import org.scilab.forge.jlatexmath.CharFont;
import org.scilab.forge.jlatexmath.CharSymbol;
import org.scilab.forge.jlatexmath.HorizontalBox;
import org.scilab.forge.jlatexmath.InvalidSymbolTypeException;
import org.scilab.forge.jlatexmath.ResourceParseException;
import org.scilab.forge.jlatexmath.ScaleBox;
import org.scilab.forge.jlatexmath.StrutBox;
import org.scilab.forge.jlatexmath.SymbolMappingNotFoundException;
import org.scilab.forge.jlatexmath.SymbolNotFoundException;
import org.scilab.forge.jlatexmath.TeXEnvironment;
import org.scilab.forge.jlatexmath.TeXFont;
import org.scilab.forge.jlatexmath.TeXFormula;
import org.scilab.forge.jlatexmath.TeXSymbolParser;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public class SymbolAtom
extends CharSymbol {
    private final boolean a;
    private final String a;
    public static Map a = new TeXSymbolParser().readSymbols();
    private static BitSet a = new BitSet(16);
    private char a;

    public SymbolAtom(SymbolAtom symbolAtom, int n) {
        if (!a.get(n)) {
            throw new InvalidSymbolTypeException("The symbol type was not valid! Use one of the symbol type constants from the class 'TeXConstants'.");
        }
        this.a = symbolAtom.a;
        this.a = n;
        if (n == 1) {
            this.b = 0;
        }
        this.a = symbolAtom.a;
    }

    public SymbolAtom(String string, int n, boolean bl) {
        this.a = string;
        this.a = n;
        if (n == 1) {
            this.b = 0;
        }
        this.a = bl;
    }

    public SymbolAtom setUnicode(char c2) {
        this.a = c2;
        return this;
    }

    public char getUnicode() {
        return this.a;
    }

    public static void addSymbolAtom(String string) {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ResourceParseException(string, fileNotFoundException);
        }
        SymbolAtom.addSymbolAtom(fileInputStream, string);
    }

    public static void addSymbolAtom(InputStream inputStream, String string) {
        TeXSymbolParser teXSymbolParser = new TeXSymbolParser(inputStream, string);
        a.putAll(teXSymbolParser.readSymbols());
    }

    public static void addSymbolAtom(SymbolAtom symbolAtom) {
        a.put(symbolAtom.a, symbolAtom);
    }

    public static SymbolAtom get(String string) {
        Object v = a.get(string);
        if (v == null) {
            throw new SymbolNotFoundException(string);
        }
        return (SymbolAtom)v;
    }

    public boolean isDelimiter() {
        return this.a;
    }

    public String getName() {
        return this.a;
    }

    public Box createBox(TeXEnvironment teXEnvironment) {
        TeXFont teXFont = teXEnvironment.getTeXFont();
        int n = teXEnvironment.getStyle();
        Char char_ = teXFont.getChar(this.a, n);
        Box box = new CharBox(char_);
        if (teXEnvironment.getSmallCap() && this.a != '\u0000' && Character.isLowerCase(this.a)) {
            try {
                box = new ScaleBox(new CharBox(teXFont.getChar(TeXFormula.b[Character.toUpperCase(this.a)], n)), 0.8, 0.8);
            }
            catch (SymbolMappingNotFoundException symbolMappingNotFoundException) {
                // empty catch block
            }
        }
        if (this.a) {
            if (n < 2 && teXFont.hasNextLarger(char_)) {
                char_ = teXFont.getNextLarger(char_, n);
            }
            box = new CharBox(char_);
            box.setShift(-(box.getHeight() + box.getDepth()) / 2.0f - teXEnvironment.getTeXFont().getAxisHeight(teXEnvironment.getStyle()));
            float f = char_.getItalic();
            HorizontalBox horizontalBox = new HorizontalBox(box);
            if (f > 1.0E-7f) {
                horizontalBox.add(new StrutBox(f, 0.0f, 0.0f, 0.0f));
            }
            return horizontalBox;
        }
        return box;
    }

    public CharFont getCharFont(TeXFont teXFont) {
        return teXFont.getChar(this.a, 0).getCharFont();
    }

    static {
        a.set(0);
        a.set(1);
        a.set(2);
        a.set(3);
        a.set(4);
        a.set(5);
        a.set(6);
        a.set(10);
    }
}

