/*
 * Decompiled with CFR 0.152.
 */
package org.jf.dexlib2.writer.pool;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jf.dexlib2.builder.MutableMethodImplementation;
import org.jf.dexlib2.iface.Annotation;
import org.jf.dexlib2.iface.ClassDef;
import org.jf.dexlib2.iface.ExceptionHandler;
import org.jf.dexlib2.iface.Field;
import org.jf.dexlib2.iface.Method;
import org.jf.dexlib2.iface.MethodImplementation;
import org.jf.dexlib2.iface.MethodParameter;
import org.jf.dexlib2.iface.TryBlock;
import org.jf.dexlib2.iface.debug.DebugItem;
import org.jf.dexlib2.iface.debug.EndLocal;
import org.jf.dexlib2.iface.debug.LineNumber;
import org.jf.dexlib2.iface.debug.RestartLocal;
import org.jf.dexlib2.iface.debug.SetSourceFile;
import org.jf.dexlib2.iface.debug.StartLocal;
import org.jf.dexlib2.iface.instruction.Instruction;
import org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import org.jf.dexlib2.iface.reference.CallSiteReference;
import org.jf.dexlib2.iface.reference.FieldReference;
import org.jf.dexlib2.iface.reference.MethodReference;
import org.jf.dexlib2.iface.reference.Reference;
import org.jf.dexlib2.iface.reference.StringReference;
import org.jf.dexlib2.iface.reference.TypeReference;
import org.jf.dexlib2.iface.value.ArrayEncodedValue;
import org.jf.dexlib2.iface.value.EncodedValue;
import org.jf.dexlib2.util.ReferenceUtil;
import org.jf.dexlib2.writer.ClassSection;
import org.jf.dexlib2.writer.DebugWriter;
import org.jf.dexlib2.writer.pool.AnnotationSetPool;
import org.jf.dexlib2.writer.pool.BasePool;
import org.jf.dexlib2.writer.pool.CallSitePool;
import org.jf.dexlib2.writer.pool.DexPool;
import org.jf.dexlib2.writer.pool.EncodedArrayPool;
import org.jf.dexlib2.writer.pool.FieldPool;
import org.jf.dexlib2.writer.pool.MethodPool;
import org.jf.dexlib2.writer.pool.PoolClassDef;
import org.jf.dexlib2.writer.pool.PoolMethod;
import org.jf.dexlib2.writer.pool.StringPool;
import org.jf.dexlib2.writer.pool.TypeListPool;
import org.jf.dexlib2.writer.pool.TypePool;
import org.jf.dexlib2.writer.util.StaticInitializerUtil;
import org.jf.util.AbstractForwardSequentialList;
import org.jf.util.ExceptionWithContext;

public class ClassPool
extends BasePool<String, PoolClassDef>
implements ClassSection<CharSequence, CharSequence, TypeListPool.Key<? extends Collection<? extends CharSequence>>, PoolClassDef, Field, PoolMethod, Set<? extends Annotation>, ArrayEncodedValue> {
    private ImmutableList<PoolClassDef> sortedClasses = null;
    private static final Predicate<MethodParameter> HAS_PARAMETER_ANNOTATIONS = new Predicate<MethodParameter>(){

        public boolean apply(MethodParameter input) {
            return input.getAnnotations().size() > 0;
        }
    };
    private static final Function<MethodParameter, Set<? extends Annotation>> PARAMETER_ANNOTATIONS = new Function<MethodParameter, Set<? extends Annotation>>(){

        public Set<? extends Annotation> apply(MethodParameter input) {
            return input.getAnnotations();
        }
    };

    public ClassPool(@Nonnull DexPool dexPool) {
        super(dexPool);
    }

    public void intern(@Nonnull ClassDef classDef) {
        PoolClassDef poolClassDef = new PoolClassDef(classDef);
        PoolClassDef prev = this.internedItems.put(poolClassDef.getType(), poolClassDef);
        if (prev != null) {
            throw new ExceptionWithContext("Class %s has already been interned", poolClassDef.getType());
        }
        ((TypePool)this.dexPool.typeSection).intern(poolClassDef.getType());
        ((TypePool)this.dexPool.typeSection).internNullable(poolClassDef.getSuperclass());
        ((TypeListPool)this.dexPool.typeListSection).intern(poolClassDef.getInterfaces());
        ((StringPool)this.dexPool.stringSection).internNullable(poolClassDef.getSourceFile());
        HashSet<String> fields = new HashSet<String>();
        for (Field field : poolClassDef.getFields()) {
            String fieldDescriptor = ReferenceUtil.getShortFieldDescriptor(field);
            if (!fields.add(fieldDescriptor)) {
                throw new ExceptionWithContext("Multiple definitions for field %s->%s", poolClassDef.getType(), fieldDescriptor);
            }
            ((FieldPool)this.dexPool.fieldSection).intern(field);
            EncodedValue initialValue = field.getInitialValue();
            if (initialValue != null) {
                this.dexPool.internEncodedValue(initialValue);
            }
            ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(field.getAnnotations());
            ArrayEncodedValue staticInitializers = this.getStaticInitializers(poolClassDef);
            if (staticInitializers == null) continue;
            ((EncodedArrayPool)this.dexPool.encodedArraySection).intern(staticInitializers);
        }
        HashSet<String> methods = new HashSet<String>();
        for (PoolMethod method : poolClassDef.getMethods()) {
            String methodDescriptor = ReferenceUtil.getMethodDescriptor(method, true);
            if (!methods.add(methodDescriptor)) {
                throw new ExceptionWithContext("Multiple definitions for method %s->%s", poolClassDef.getType(), methodDescriptor);
            }
            ((MethodPool)this.dexPool.methodSection).intern(method);
            this.internCode(method);
            this.internDebug(method);
            ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(method.getAnnotations());
            for (MethodParameter methodParameter : method.getParameters()) {
                ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(methodParameter.getAnnotations());
            }
        }
        ((AnnotationSetPool)this.dexPool.annotationSetSection).intern(poolClassDef.getAnnotations());
    }

    private void internCode(@Nonnull Method method) {
        boolean hasInstruction = false;
        MethodImplementation methodImpl = method.getImplementation();
        if (methodImpl != null) {
            block7: for (Instruction instruction : methodImpl.getInstructions()) {
                hasInstruction = true;
                if (!(instruction instanceof ReferenceInstruction)) continue;
                Reference reference = ((ReferenceInstruction)instruction).getReference();
                switch (instruction.getOpcode().referenceType) {
                    case 0: {
                        ((StringPool)this.dexPool.stringSection).intern((StringReference)reference);
                        continue block7;
                    }
                    case 1: {
                        ((TypePool)this.dexPool.typeSection).intern((TypeReference)reference);
                        continue block7;
                    }
                    case 2: {
                        ((FieldPool)this.dexPool.fieldSection).intern((FieldReference)reference);
                        continue block7;
                    }
                    case 3: {
                        ((MethodPool)this.dexPool.methodSection).intern((MethodReference)reference);
                        continue block7;
                    }
                    case 5: {
                        ((CallSitePool)this.dexPool.callSiteSection).intern((CallSiteReference)reference);
                        continue block7;
                    }
                }
                throw new ExceptionWithContext("Unrecognized reference type: %d", instruction.getOpcode().referenceType);
            }
            List<? extends TryBlock<? extends ExceptionHandler>> tryBlocks = methodImpl.getTryBlocks();
            if (!hasInstruction && tryBlocks.size() > 0) {
                throw new ExceptionWithContext("Method %s has no instructions, but has try blocks.", ReferenceUtil.getMethodDescriptor(method));
            }
            for (TryBlock<? extends ExceptionHandler> tryBlock : methodImpl.getTryBlocks()) {
                for (ExceptionHandler exceptionHandler : tryBlock.getExceptionHandlers()) {
                    ((TypePool)this.dexPool.typeSection).internNullable(exceptionHandler.getExceptionType());
                }
            }
        }
    }

    private void internDebug(@Nonnull Method method) {
        for (MethodParameter methodParameter : method.getParameters()) {
            String string = methodParameter.getName();
            if (string == null) continue;
            ((StringPool)this.dexPool.stringSection).intern(string);
        }
        MethodImplementation methodImpl = method.getImplementation();
        if (methodImpl != null) {
            for (DebugItem debugItem : methodImpl.getDebugItems()) {
                switch (debugItem.getDebugItemType()) {
                    case 3: {
                        StartLocal startLocal = (StartLocal)debugItem;
                        ((StringPool)this.dexPool.stringSection).internNullable(startLocal.getName());
                        ((TypePool)this.dexPool.typeSection).internNullable(startLocal.getType());
                        ((StringPool)this.dexPool.stringSection).internNullable(startLocal.getSignature());
                        break;
                    }
                    case 9: {
                        ((StringPool)this.dexPool.stringSection).internNullable(((SetSourceFile)debugItem).getSourceFile());
                    }
                }
            }
        }
    }

    @Override
    @Nonnull
    public Collection<? extends PoolClassDef> getSortedClasses() {
        if (this.sortedClasses == null) {
            this.sortedClasses = Ordering.natural().immutableSortedCopy(this.internedItems.values());
        }
        return this.sortedClasses;
    }

    @Override
    @Nullable
    public Map.Entry<? extends PoolClassDef, Integer> getClassEntryByType(@Nullable CharSequence name) {
        if (name == null) {
            return null;
        }
        final PoolClassDef classDef = (PoolClassDef)this.internedItems.get(name.toString());
        if (classDef == null) {
            return null;
        }
        return new Map.Entry<PoolClassDef, Integer>(){

            @Override
            public PoolClassDef getKey() {
                return classDef;
            }

            @Override
            public Integer getValue() {
                return classDef.classDefIndex;
            }

            @Override
            public Integer setValue(Integer value) {
                classDef.classDefIndex = value;
                return classDef.classDefIndex;
            }
        };
    }

    @Override
    @Nonnull
    public CharSequence getType(@Nonnull PoolClassDef classDef) {
        return classDef.getType();
    }

    @Override
    public int getAccessFlags(@Nonnull PoolClassDef classDef) {
        return classDef.getAccessFlags();
    }

    @Override
    @Nullable
    public CharSequence getSuperclass(@Nonnull PoolClassDef classDef) {
        return classDef.getSuperclass();
    }

    @Override
    @Nullable
    public TypeListPool.Key<List<String>> getInterfaces(@Nonnull PoolClassDef classDef) {
        return classDef.interfaces;
    }

    @Override
    @Nullable
    public CharSequence getSourceFile(@Nonnull PoolClassDef classDef) {
        return classDef.getSourceFile();
    }

    @Override
    @Nullable
    public ArrayEncodedValue getStaticInitializers(@Nonnull PoolClassDef classDef) {
        return StaticInitializerUtil.getStaticInitializers((SortedSet<? extends Field>)classDef.getStaticFields());
    }

    @Override
    @Nonnull
    public Collection<? extends Field> getSortedStaticFields(@Nonnull PoolClassDef classDef) {
        return classDef.getStaticFields();
    }

    @Override
    @Nonnull
    public Collection<? extends Field> getSortedInstanceFields(@Nonnull PoolClassDef classDef) {
        return classDef.getInstanceFields();
    }

    @Override
    @Nonnull
    public Collection<? extends Field> getSortedFields(@Nonnull PoolClassDef classDef) {
        return classDef.getFields();
    }

    @Override
    @Nonnull
    public Collection<PoolMethod> getSortedDirectMethods(@Nonnull PoolClassDef classDef) {
        return classDef.getDirectMethods();
    }

    @Override
    @Nonnull
    public Collection<PoolMethod> getSortedVirtualMethods(@Nonnull PoolClassDef classDef) {
        return classDef.getVirtualMethods();
    }

    @Override
    @Nonnull
    public Collection<? extends PoolMethod> getSortedMethods(@Nonnull PoolClassDef classDef) {
        return classDef.getMethods();
    }

    @Override
    public int getFieldAccessFlags(@Nonnull Field field) {
        return field.getAccessFlags();
    }

    @Override
    public int getMethodAccessFlags(@Nonnull PoolMethod method) {
        return method.getAccessFlags();
    }

    @Override
    @Nullable
    public Set<? extends Annotation> getClassAnnotations(@Nonnull PoolClassDef classDef) {
        Set<? extends Annotation> annotations = classDef.getAnnotations();
        if (annotations.size() == 0) {
            return null;
        }
        return annotations;
    }

    @Override
    @Nullable
    public Set<? extends Annotation> getFieldAnnotations(@Nonnull Field field) {
        Set<? extends Annotation> annotations = field.getAnnotations();
        if (annotations.size() == 0) {
            return null;
        }
        return annotations;
    }

    @Override
    @Nullable
    public Set<? extends Annotation> getMethodAnnotations(@Nonnull PoolMethod method) {
        Set<? extends Annotation> annotations = method.getAnnotations();
        if (annotations.size() == 0) {
            return null;
        }
        return annotations;
    }

    @Override
    @Nullable
    public List<? extends Set<? extends Annotation>> getParameterAnnotations(@Nonnull PoolMethod method) {
        final List<? extends MethodParameter> parameters = method.getParameters();
        boolean hasParameterAnnotations = Iterables.any(parameters, HAS_PARAMETER_ANNOTATIONS);
        if (hasParameterAnnotations) {
            return new AbstractForwardSequentialList<Set<? extends Annotation>>(){

                @Override
                @Nonnull
                public Iterator<Set<? extends Annotation>> iterator() {
                    return FluentIterable.from((Iterable)parameters).transform(PARAMETER_ANNOTATIONS).iterator();
                }

                @Override
                public int size() {
                    return parameters.size();
                }
            };
        }
        return null;
    }

    @Override
    @Nullable
    public Iterable<? extends DebugItem> getDebugItems(@Nonnull PoolMethod method) {
        MethodImplementation impl = method.getImplementation();
        if (impl != null) {
            return impl.getDebugItems();
        }
        return null;
    }

    @Override
    @Nullable
    public Iterable<CharSequence> getParameterNames(@Nonnull PoolMethod method) {
        return Iterables.transform(method.getParameters(), (Function)new Function<MethodParameter, CharSequence>(){

            @Nullable
            public CharSequence apply(MethodParameter input) {
                return input.getName();
            }
        });
    }

    @Override
    public int getRegisterCount(@Nonnull PoolMethod method) {
        MethodImplementation impl = method.getImplementation();
        if (impl != null) {
            return impl.getRegisterCount();
        }
        return 0;
    }

    @Override
    @Nullable
    public Iterable<? extends Instruction> getInstructions(@Nonnull PoolMethod method) {
        MethodImplementation impl = method.getImplementation();
        if (impl != null) {
            return impl.getInstructions();
        }
        return null;
    }

    @Override
    @Nonnull
    public List<? extends TryBlock<? extends ExceptionHandler>> getTryBlocks(@Nonnull PoolMethod method) {
        MethodImplementation impl = method.getImplementation();
        if (impl != null) {
            return impl.getTryBlocks();
        }
        return ImmutableList.of();
    }

    @Override
    @Nullable
    public CharSequence getExceptionType(@Nonnull ExceptionHandler handler) {
        return handler.getExceptionType();
    }

    @Override
    @Nonnull
    public MutableMethodImplementation makeMutableMethodImplementation(@Nonnull PoolMethod poolMethod) {
        return new MutableMethodImplementation(poolMethod.getImplementation());
    }

    @Override
    public void setAnnotationDirectoryOffset(@Nonnull PoolClassDef classDef, int offset) {
        classDef.annotationDirectoryOffset = offset;
    }

    @Override
    public int getAnnotationDirectoryOffset(@Nonnull PoolClassDef classDef) {
        return classDef.annotationDirectoryOffset;
    }

    @Override
    public void setAnnotationSetRefListOffset(@Nonnull PoolMethod method, int offset) {
        method.annotationSetRefListOffset = offset;
    }

    @Override
    public int getAnnotationSetRefListOffset(@Nonnull PoolMethod method) {
        return method.annotationSetRefListOffset;
    }

    @Override
    public void setCodeItemOffset(@Nonnull PoolMethod method, int offset) {
        method.codeItemOffset = offset;
    }

    @Override
    public int getCodeItemOffset(@Nonnull PoolMethod method) {
        return method.codeItemOffset;
    }

    @Override
    public void writeDebugItem(@Nonnull DebugWriter<CharSequence, CharSequence> writer, DebugItem debugItem) throws IOException {
        switch (debugItem.getDebugItemType()) {
            case 3: {
                StartLocal startLocal = (StartLocal)debugItem;
                writer.writeStartLocal(startLocal.getCodeAddress(), startLocal.getRegister(), startLocal.getName(), startLocal.getType(), startLocal.getSignature());
                break;
            }
            case 5: {
                EndLocal endLocal = (EndLocal)debugItem;
                writer.writeEndLocal(endLocal.getCodeAddress(), endLocal.getRegister());
                break;
            }
            case 6: {
                RestartLocal restartLocal = (RestartLocal)debugItem;
                writer.writeRestartLocal(restartLocal.getCodeAddress(), restartLocal.getRegister());
                break;
            }
            case 7: {
                writer.writePrologueEnd(debugItem.getCodeAddress());
                break;
            }
            case 8: {
                writer.writeEpilogueBegin(debugItem.getCodeAddress());
                break;
            }
            case 10: {
                LineNumber lineNumber = (LineNumber)debugItem;
                writer.writeLineNumber(lineNumber.getCodeAddress(), lineNumber.getLineNumber());
                break;
            }
            case 9: {
                SetSourceFile setSourceFile = (SetSourceFile)debugItem;
                writer.writeSetSourceFile(setSourceFile.getCodeAddress(), setSourceFile.getSourceFile());
            }
            default: {
                throw new ExceptionWithContext("Unexpected debug item type: %d", debugItem.getDebugItemType());
            }
        }
    }

    @Override
    public int getItemIndex(@Nonnull PoolClassDef classDef) {
        return classDef.classDefIndex;
    }

    @Override
    @Nonnull
    public Collection<? extends Map.Entry<PoolClassDef, Integer>> getItems() {
        return new AbstractCollection<Map.Entry<PoolClassDef, Integer>>(){

            @Override
            @Nonnull
            public Iterator<Map.Entry<PoolClassDef, Integer>> iterator() {
                return new Iterator<Map.Entry<PoolClassDef, Integer>>(){
                    Iterator<PoolClassDef> iter;
                    {
                        this.iter = ClassPool.this.internedItems.values().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.iter.hasNext();
                    }

                    @Override
                    public Map.Entry<PoolClassDef, Integer> next() {
                        class MapEntry
                        implements Map.Entry<PoolClassDef, Integer> {
                            @Nonnull
                            private final PoolClassDef classDef;

                            public MapEntry(PoolClassDef classDef) {
                                this.classDef = classDef;
                            }

                            @Override
                            public PoolClassDef getKey() {
                                return this.classDef;
                            }

                            @Override
                            public Integer getValue() {
                                return this.classDef.classDefIndex;
                            }

                            @Override
                            public Integer setValue(Integer value) {
                                int prev = this.classDef.classDefIndex;
                                this.classDef.classDefIndex = value;
                                return prev;
                            }
                        }
                        return new MapEntry(this.iter.next());
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return ClassPool.this.internedItems.size();
            }
        };
    }
}

