/*
 * Decompiled with CFR 0.152.
 */
package jadx.gui.ui;

import jadx.gui.treemodel.JClass;
import jadx.gui.treemodel.JNode;
import jadx.gui.ui.ContentPanel;
import jadx.gui.ui.TabbedPane;
import jadx.gui.utils.NLS;
import jadx.gui.utils.UiUtils;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import javax.swing.plaf.basic.BasicButtonUI;

public class TabComponent
extends JPanel {
    private static final long serialVersionUID = -8147035487543610321L;
    private static final ImageIcon ICON_CLOSE = UiUtils.openIcon("cross");
    private static final ImageIcon ICON_CLOSE_INACTIVE = UiUtils.openIcon("cross_grayed");
    private final TabbedPane tabbedPane;
    private final ContentPanel contentPanel;
    private JLabel label;

    public TabComponent(TabbedPane tabbedPane, ContentPanel contentPanel) {
        this.tabbedPane = tabbedPane;
        this.contentPanel = contentPanel;
        this.init();
    }

    public void loadSettings() {
        this.label.setFont(this.getLabelFont());
    }

    private Font getLabelFont() {
        return this.tabbedPane.getMainWindow().getSettings().getFont().deriveFont(1);
    }

    private void init() {
        TabComponent panel = this;
        panel.setLayout(new FlowLayout(1, 3, 0));
        panel.setOpaque(false);
        JNode node = this.contentPanel.getNode();
        this.label = new JLabel(node.makeLongString());
        this.label.setFont(this.getLabelFont());
        String toolTip = this.contentPanel.getTabTooltip();
        if (toolTip != null) {
            this.label.setToolTipText(toolTip);
        }
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 10));
        this.label.setIcon(node.getIcon());
        JButton closeBtn = new JButton();
        closeBtn.setIcon(ICON_CLOSE_INACTIVE);
        closeBtn.setRolloverIcon(ICON_CLOSE);
        closeBtn.setRolloverEnabled(true);
        closeBtn.setOpaque(false);
        closeBtn.setUI(new BasicButtonUI());
        closeBtn.setContentAreaFilled(false);
        closeBtn.setFocusable(false);
        closeBtn.setBorder(null);
        closeBtn.setBorderPainted(false);
        closeBtn.addActionListener(e -> this.tabbedPane.closeCodePanel(this.contentPanel));
        MouseAdapter clickAdapter = new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isMiddleMouseButton(e)) {
                    TabComponent.this.tabbedPane.closeCodePanel(TabComponent.this.contentPanel);
                } else if (SwingUtilities.isRightMouseButton(e)) {
                    JPopupMenu menu = TabComponent.this.createTabPopupMenu(TabComponent.this.contentPanel);
                    menu.show(e.getComponent(), e.getX(), e.getY());
                } else if (SwingUtilities.isLeftMouseButton(e) && TabComponent.this.tabbedPane.getSelectedComponent() != TabComponent.this.contentPanel) {
                    TabComponent.this.tabbedPane.setSelectedComponent(TabComponent.this.contentPanel);
                }
            }
        };
        panel.addMouseListener(clickAdapter);
        this.label.addMouseListener(clickAdapter);
        closeBtn.addMouseListener(clickAdapter);
        panel.add(this.label);
        panel.add(closeBtn);
        panel.setBorder(BorderFactory.createEmptyBorder(4, 0, 0, 0));
    }

    private JPopupMenu createTabPopupMenu(ContentPanel contentPanel) {
        JPopupMenu menu = new JPopupMenu();
        String nodeFullName = this.getNodeFullName(contentPanel);
        if (nodeFullName != null) {
            JMenuItem copyRootClassName = new JMenuItem(NLS.str("tabs.copy_class_name", new Object[0]));
            copyRootClassName.addActionListener(actionEvent -> UiUtils.setClipboardString(nodeFullName));
            menu.add(copyRootClassName);
            menu.addSeparator();
        }
        JMenuItem closeTab = new JMenuItem(NLS.str("tabs.close", new Object[0]));
        closeTab.addActionListener(e -> this.tabbedPane.closeCodePanel(contentPanel));
        menu.add(closeTab);
        Map<JNode, ContentPanel> openTabs = this.tabbedPane.getOpenTabs();
        if (openTabs.size() > 1) {
            JMenuItem closeOther = new JMenuItem(NLS.str("tabs.closeOthers", new Object[0]));
            closeOther.addActionListener(e -> {
                ArrayList contentPanels = new ArrayList(openTabs.values());
                for (ContentPanel panel : contentPanels) {
                    if (panel == contentPanel) continue;
                    this.tabbedPane.closeCodePanel(panel);
                }
            });
            menu.add(closeOther);
            JMenuItem closeAll = new JMenuItem(NLS.str("tabs.closeAll", new Object[0]));
            closeAll.addActionListener(e -> this.tabbedPane.closeAllTabs());
            menu.add(closeAll);
            menu.addSeparator();
            ContentPanel selectedContentPanel = this.tabbedPane.getSelectedCodePanel();
            for (Map.Entry<JNode, ContentPanel> entry : openTabs.entrySet()) {
                ContentPanel cp = entry.getValue();
                if (cp == selectedContentPanel) continue;
                JNode node = entry.getKey();
                String clsName = node.makeLongString();
                JMenuItem item = new JMenuItem(clsName);
                item.addActionListener(e -> this.tabbedPane.setSelectedComponent(cp));
                item.setIcon(node.getIcon());
                menu.add(item);
            }
        }
        return menu;
    }

    private String getNodeFullName(ContentPanel contentPanel) {
        JNode node = contentPanel.getNode();
        JClass jClass = node.getRootClass();
        if (jClass != null) {
            return jClass.getFullName();
        }
        return node.getName();
    }
}

