/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.xmlgen;

import jadx.core.codegen.CodeWriter;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.RootNode;
import jadx.core.xmlgen.CommonBinaryParser;
import jadx.core.xmlgen.ParserStream;
import jadx.core.xmlgen.ResContainer;
import jadx.core.xmlgen.ResXmlGen;
import jadx.core.xmlgen.ResourceStorage;
import jadx.core.xmlgen.entry.EntryConfig;
import jadx.core.xmlgen.entry.RawNamedValue;
import jadx.core.xmlgen.entry.RawValue;
import jadx.core.xmlgen.entry.ResourceEntry;
import jadx.core.xmlgen.entry.ValuesParser;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResTableParser
extends CommonBinaryParser {
    private static final Logger LOG = LoggerFactory.getLogger(ResTableParser.class);
    private final RootNode root;
    private final ResourceStorage resStorage = new ResourceStorage();
    private String[] strings;

    public ResTableParser(RootNode root) {
        this.root = root;
    }

    public void decode(InputStream inputStream) throws IOException {
        this.is = new ParserStream(inputStream);
        this.decodeTableChunk();
        this.resStorage.finish();
    }

    public ResContainer decodeFiles(InputStream inputStream) throws IOException {
        this.decode(inputStream);
        ValuesParser vp = new ValuesParser(this.root, this.strings, this.resStorage.getResourcesNames());
        ResXmlGen resGen = new ResXmlGen(this.resStorage, vp);
        CodeWriter content = this.makeXmlDump();
        List<ResContainer> xmlFiles = resGen.makeResourcesXml();
        return ResContainer.resourceTable("res", xmlFiles, content);
    }

    public CodeWriter makeXmlDump() {
        CodeWriter writer = new CodeWriter();
        writer.startLine("<?xml version=\"1.0\" encoding=\"utf-8\"?>");
        writer.startLine("<resources>");
        writer.incIndent();
        HashSet<String> addedValues = new HashSet<String>();
        for (ResourceEntry ri : this.resStorage.getResources()) {
            if (!addedValues.add(ri.getTypeName() + '.' + ri.getKeyName())) continue;
            String format = String.format("<public type=\"%s\" name=\"%s\" id=\"%s\" />", ri.getTypeName(), ri.getKeyName(), ri.getId());
            writer.startLine(format);
        }
        writer.decIndent();
        writer.startLine("</resources>");
        writer.finish();
        return writer;
    }

    public ResourceStorage getResStorage() {
        return this.resStorage;
    }

    public String[] getStrings() {
        return this.strings;
    }

    void decodeTableChunk() throws IOException {
        this.is.checkInt16(2, "Not a table chunk");
        this.is.checkInt16(12, "Unexpected table header size");
        this.is.readInt32();
        int pkgCount = this.is.readInt32();
        this.strings = this.parseStringPool();
        for (int i = 0; i < pkgCount; ++i) {
            this.parsePackage();
        }
    }

    private PackageChunk parsePackage() throws IOException {
        long start = this.is.getPos();
        this.is.checkInt16(512, "Not a table chunk");
        int headerSize = this.is.readInt16();
        if (headerSize != 284 && headerSize != 288) {
            this.die("Unexpected package header size");
        }
        long size = this.is.readUInt32();
        long endPos = start + size;
        int id = this.is.readInt32();
        String name = this.is.readString16Fixed(128);
        long typeStringsOffset = start + (long)this.is.readInt32();
        this.is.readInt32();
        long keyStringsOffset = start + (long)this.is.readInt32();
        this.is.readInt32();
        if (headerSize == 288) {
            this.is.readInt32();
        }
        String[] typeStrings = null;
        if (typeStringsOffset != 0L) {
            this.is.skipToPos(typeStringsOffset, "Expected typeStrings string pool");
            typeStrings = this.parseStringPool();
        }
        String[] keyStrings = null;
        if (keyStringsOffset != 0L) {
            this.is.skipToPos(keyStringsOffset, "Expected keyStrings string pool");
            keyStrings = this.parseStringPool();
        }
        PackageChunk pkg = new PackageChunk(id, name, typeStrings, keyStrings);
        this.resStorage.setAppPackage(name);
        while (this.is.getPos() < endPos) {
            long chunkStart = this.is.getPos();
            int type = this.is.readInt16();
            if (type == 0) continue;
            if (type == 514) {
                this.parseTypeSpecChunk();
                continue;
            }
            if (type != 513) continue;
            this.parseTypeChunk(chunkStart, pkg);
        }
        return pkg;
    }

    private void parseTypeSpecChunk() throws IOException {
        this.is.checkInt16(16, "Unexpected type spec header size");
        this.is.readInt32();
        int id = this.is.readInt8();
        this.is.skip(3L);
        int entryCount = this.is.readInt32();
        for (int i = 0; i < entryCount; ++i) {
            int n = this.is.readInt32();
        }
    }

    private void parseTypeChunk(long start, PackageChunk pkg) throws IOException {
        int i;
        this.is.readInt16();
        this.is.readInt32();
        int id = this.is.readInt8();
        this.is.checkInt8(0, "type chunk, res0");
        this.is.checkInt16(0, "type chunk, res1");
        int entryCount = this.is.readInt32();
        long entriesStart = start + (long)this.is.readInt32();
        EntryConfig config = this.parseConfig();
        if (config.isInvalid) {
            String typeName = pkg.getTypeStrings()[id - 1];
            LOG.warn("Invalid config flags detected: {}{}", (Object)typeName, (Object)config.getQualifiers());
        }
        int[] entryIndexes = new int[entryCount];
        for (i = 0; i < entryCount; ++i) {
            entryIndexes[i] = this.is.readInt32();
        }
        this.is.checkPos(entriesStart, "Expected entry start");
        for (i = 0; i < entryCount; ++i) {
            if (entryIndexes[i] == -1) continue;
            this.parseEntry(pkg, id, i, config);
        }
    }

    private void parseEntry(PackageChunk pkg, int typeId, int entryId, EntryConfig config) throws IOException {
        int size = this.is.readInt16();
        int flags = this.is.readInt16();
        int key = this.is.readInt32();
        if (key == -1) {
            return;
        }
        int resRef = pkg.getId() << 24 | typeId << 16 | entryId;
        String typeName = pkg.getTypeStrings()[typeId - 1];
        String keyName = pkg.getKeyStrings()[key];
        if (keyName.isEmpty()) {
            FieldNode constField = this.root.getConstValues().getGlobalConstFields().get(resRef);
            if (constField != null) {
                keyName = constField.getName();
                constField.add(AFlag.DONT_RENAME);
            } else {
                keyName = "RES_" + resRef;
            }
        }
        ResourceEntry ri = new ResourceEntry(resRef, pkg.getName(), typeName, keyName);
        ri.setConfig(config);
        if ((flags & 1) != 0 || size == 16) {
            int parentRef = this.is.readInt32();
            int count = this.is.readInt32();
            ri.setParentRef(parentRef);
            ArrayList<RawNamedValue> values = new ArrayList<RawNamedValue>(count);
            for (int i = 0; i < count; ++i) {
                values.add(this.parseValueMap());
            }
            ri.setNamedValues(values);
        } else {
            ri.setSimpleValue(this.parseValue());
        }
        this.resStorage.add(ri);
    }

    private RawNamedValue parseValueMap() throws IOException {
        int nameRef = this.is.readInt32();
        return new RawNamedValue(nameRef, this.parseValue());
    }

    private RawValue parseValue() throws IOException {
        this.is.checkInt16(8, "value size");
        this.is.checkInt8(0, "value res0 not 0");
        int dataType = this.is.readInt8();
        int data = this.is.readInt32();
        return new RawValue(dataType, data);
    }

    private EntryConfig parseConfig() throws IOException {
        long start = this.is.getPos();
        int size = this.is.readInt32();
        if (size < 28) {
            throw new IOException("Config size < 28");
        }
        short mcc = (short)this.is.readInt16();
        short mnc = (short)this.is.readInt16();
        char[] language = this.unpackLocaleOrRegion((byte)this.is.readInt8(), (byte)this.is.readInt8(), 'a');
        char[] country = this.unpackLocaleOrRegion((byte)this.is.readInt8(), (byte)this.is.readInt8(), '0');
        byte orientation = (byte)this.is.readInt8();
        byte touchscreen = (byte)this.is.readInt8();
        int density = this.is.readInt16();
        byte keyboard = (byte)this.is.readInt8();
        byte navigation = (byte)this.is.readInt8();
        byte inputFlags = (byte)this.is.readInt8();
        this.is.readInt8();
        short screenWidth = (short)this.is.readInt16();
        short screenHeight = (short)this.is.readInt16();
        short sdkVersion = (short)this.is.readInt16();
        this.is.readInt16();
        byte screenLayout = 0;
        byte uiMode = 0;
        short smallestScreenWidthDp = 0;
        if (size >= 32) {
            screenLayout = (byte)this.is.readInt8();
            uiMode = (byte)this.is.readInt8();
            smallestScreenWidthDp = (short)this.is.readInt16();
        }
        short screenWidthDp = 0;
        short screenHeightDp = 0;
        if (size >= 36) {
            screenWidthDp = (short)this.is.readInt16();
            screenHeightDp = (short)this.is.readInt16();
        }
        char[] localeScript = null;
        char[] localeVariant = null;
        if (size >= 48) {
            localeScript = this.readScriptOrVariantChar(4).toCharArray();
            localeVariant = this.readScriptOrVariantChar(8).toCharArray();
        }
        byte screenLayout2 = 0;
        byte colorMode = 0;
        if (size >= 52) {
            screenLayout2 = (byte)this.is.readInt8();
            colorMode = (byte)this.is.readInt8();
            this.is.readInt16();
        }
        this.is.skipToPos(start + (long)size, "Config skip trailing bytes");
        return new EntryConfig(mcc, mnc, language, country, orientation, touchscreen, density, keyboard, navigation, inputFlags, screenWidth, screenHeight, sdkVersion, screenLayout, uiMode, smallestScreenWidthDp, screenWidthDp, screenHeightDp, localeScript, localeVariant, screenLayout2, colorMode, false, size);
    }

    private char[] unpackLocaleOrRegion(byte in0, byte in1, char base) {
        if ((in0 >> 7 & 1) == 1) {
            int first = in1 & 0x1F;
            int second = ((in1 & 0xE0) >> 5) + ((in0 & 3) << 3);
            int third = (in0 & 0x7C) >> 2;
            return new char[]{(char)(first + base), (char)(second + base), (char)(third + base)};
        }
        return new char[]{(char)in0, (char)in1};
    }

    private String readScriptOrVariantChar(int length) throws IOException {
        short ch;
        long start = this.is.getPos();
        StringBuilder sb = new StringBuilder(16);
        for (int i = 0; i < length && (ch = (short)this.is.readInt8()) != 0; ++i) {
            sb.append((char)ch);
        }
        this.is.skipToPos(start + (long)length, "readScriptOrVariantChar");
        return sb.toString();
    }

    private static final class PackageChunk {
        private final int id;
        private final String name;
        private final String[] typeStrings;
        private final String[] keyStrings;

        private PackageChunk(int id, String name, String[] typeStrings, String[] keyStrings) {
            this.id = id;
            this.name = name;
            this.typeStrings = typeStrings;
            this.keyStrings = keyStrings;
        }

        public int getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String[] getTypeStrings() {
            return this.typeStrings;
        }

        public String[] getKeyStrings() {
            return this.keyStrings;
        }
    }
}

