/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors.regions.variables;

import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.nodes.IBlock;
import jadx.core.dex.nodes.IRegion;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.regions.loops.ForLoop;
import jadx.core.dex.regions.loops.LoopRegion;
import jadx.core.dex.regions.loops.LoopType;
import jadx.core.dex.visitors.regions.TracedRegionVisitor;
import jadx.core.dex.visitors.regions.variables.UsePlace;
import jadx.core.dex.visitors.regions.variables.VarUsage;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class CollectUsageRegionVisitor
extends TracedRegionVisitor {
    private final List<RegisterArg> args = new ArrayList<RegisterArg>();
    private final Map<SSAVar, VarUsage> usageMap = new LinkedHashMap<SSAVar, VarUsage>();

    CollectUsageRegionVisitor() {
    }

    public Map<SSAVar, VarUsage> getUsageMap() {
        return this.usageMap;
    }

    @Override
    public void processBlockTraced(MethodNode mth, IBlock block, IRegion curRegion) {
        UsePlace usePlace = new UsePlace(curRegion, block);
        this.regionProcess(usePlace);
        int len = block.getInstructions().size();
        for (int i = 0; i < len; ++i) {
            InsnNode insn = block.getInstructions().get(i);
            this.processInsn(insn, usePlace);
        }
    }

    private void regionProcess(UsePlace usePlace) {
        LoopRegion loopRegion;
        LoopType loopType;
        IRegion region = usePlace.getRegion();
        if (region instanceof LoopRegion && (loopType = (loopRegion = (LoopRegion)region).getType()) instanceof ForLoop) {
            ForLoop forLoop = (ForLoop)loopType;
            this.processInsn(forLoop.getInitInsn(), usePlace);
            this.processInsn(forLoop.getIncrInsn(), usePlace);
        }
    }

    void processInsn(InsnNode insn, UsePlace usePlace) {
        if (insn == null) {
            return;
        }
        RegisterArg result = insn.getResult();
        if (result != null && result.isRegister() && !result.contains(AFlag.DONT_GENERATE)) {
            VarUsage usage = this.getUsage(result.getSVar());
            usage.getAssigns().add(usePlace);
        }
        this.args.clear();
        insn.getRegisterArgs(this.args);
        for (RegisterArg arg : this.args) {
            if (arg.contains(AFlag.DONT_GENERATE)) continue;
            VarUsage usage = this.getUsage(arg.getSVar());
            usage.getUses().add(usePlace);
        }
    }

    private VarUsage getUsage(SSAVar ssaVar) {
        return this.usageMap.computeIfAbsent(ssaVar, VarUsage::new);
    }
}

