/*
 * Decompiled with CFR 0.152.
 */
package jadx.api;

import jadx.api.ICodeCache;
import jadx.api.impl.InMemoryCodeCache;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;

public class JadxArgs {
    public static final int DEFAULT_THREADS_COUNT = Math.max(1, Runtime.getRuntime().availableProcessors() / 2);
    public static final String DEFAULT_OUT_DIR = "jadx-output";
    public static final String DEFAULT_SRC_DIR = "sources";
    public static final String DEFAULT_RES_DIR = "resources";
    private List<File> inputFiles = new ArrayList<File>(1);
    private File outDir;
    private File outDirSrc;
    private File outDirRes;
    private ICodeCache codeCache = new InMemoryCodeCache();
    private int threadsCount = DEFAULT_THREADS_COUNT;
    private boolean cfgOutput = false;
    private boolean rawCFGOutput = false;
    private boolean fallbackMode = false;
    private boolean showInconsistentCode = false;
    private boolean useImports = true;
    private boolean debugInfo = true;
    private boolean inlineAnonymousClasses = true;
    private boolean skipResources = false;
    private boolean skipSources = false;
    private Predicate<String> classFilter = null;
    private boolean deobfuscationOn = false;
    private boolean deobfuscationForceSave = false;
    private boolean useSourceNameAsClassAlias = false;
    private int deobfuscationMinLength = 0;
    private int deobfuscationMaxLength = Integer.MAX_VALUE;
    private boolean escapeUnicode = false;
    private boolean replaceConsts = true;
    private boolean respectBytecodeAccModifiers = false;
    private boolean exportAsGradleProject = false;
    private boolean fsCaseSensitive;
    private Set<RenameEnum> renameFlags = EnumSet.allOf(RenameEnum.class);
    private OutputFormatEnum outputFormat = OutputFormatEnum.JAVA;

    public void setRootDir(File rootDir) {
        this.setOutDir(rootDir);
        this.setOutDirSrc(new File(rootDir, DEFAULT_SRC_DIR));
        this.setOutDirRes(new File(rootDir, DEFAULT_RES_DIR));
    }

    public List<File> getInputFiles() {
        return this.inputFiles;
    }

    public void setInputFile(File inputFile) {
        this.inputFiles = Collections.singletonList(inputFile);
    }

    public void setInputFiles(List<File> inputFiles) {
        this.inputFiles = inputFiles;
    }

    public File getOutDir() {
        return this.outDir;
    }

    public void setOutDir(File outDir) {
        this.outDir = outDir;
    }

    public File getOutDirSrc() {
        return this.outDirSrc;
    }

    public void setOutDirSrc(File outDirSrc) {
        this.outDirSrc = outDirSrc;
    }

    public File getOutDirRes() {
        return this.outDirRes;
    }

    public void setOutDirRes(File outDirRes) {
        this.outDirRes = outDirRes;
    }

    public int getThreadsCount() {
        return this.threadsCount;
    }

    public void setThreadsCount(int threadsCount) {
        this.threadsCount = threadsCount;
    }

    public boolean isCfgOutput() {
        return this.cfgOutput;
    }

    public void setCfgOutput(boolean cfgOutput) {
        this.cfgOutput = cfgOutput;
    }

    public boolean isRawCFGOutput() {
        return this.rawCFGOutput;
    }

    public void setRawCFGOutput(boolean rawCFGOutput) {
        this.rawCFGOutput = rawCFGOutput;
    }

    public boolean isFallbackMode() {
        return this.fallbackMode;
    }

    public void setFallbackMode(boolean fallbackMode) {
        this.fallbackMode = fallbackMode;
    }

    public boolean isShowInconsistentCode() {
        return this.showInconsistentCode;
    }

    public void setShowInconsistentCode(boolean showInconsistentCode) {
        this.showInconsistentCode = showInconsistentCode;
    }

    public boolean isUseImports() {
        return this.useImports;
    }

    public void setUseImports(boolean useImports) {
        this.useImports = useImports;
    }

    public boolean isDebugInfo() {
        return this.debugInfo;
    }

    public void setDebugInfo(boolean debugInfo) {
        this.debugInfo = debugInfo;
    }

    public boolean isInlineAnonymousClasses() {
        return this.inlineAnonymousClasses;
    }

    public void setInlineAnonymousClasses(boolean inlineAnonymousClasses) {
        this.inlineAnonymousClasses = inlineAnonymousClasses;
    }

    public boolean isSkipResources() {
        return this.skipResources;
    }

    public void setSkipResources(boolean skipResources) {
        this.skipResources = skipResources;
    }

    public boolean isSkipSources() {
        return this.skipSources;
    }

    public void setSkipSources(boolean skipSources) {
        this.skipSources = skipSources;
    }

    public Predicate<String> getClassFilter() {
        return this.classFilter;
    }

    public void setClassFilter(Predicate<String> classFilter) {
        this.classFilter = classFilter;
    }

    public boolean isDeobfuscationOn() {
        return this.deobfuscationOn;
    }

    public void setDeobfuscationOn(boolean deobfuscationOn) {
        this.deobfuscationOn = deobfuscationOn;
    }

    public boolean isDeobfuscationForceSave() {
        return this.deobfuscationForceSave;
    }

    public void setDeobfuscationForceSave(boolean deobfuscationForceSave) {
        this.deobfuscationForceSave = deobfuscationForceSave;
    }

    public boolean isUseSourceNameAsClassAlias() {
        return this.useSourceNameAsClassAlias;
    }

    public void setUseSourceNameAsClassAlias(boolean useSourceNameAsClassAlias) {
        this.useSourceNameAsClassAlias = useSourceNameAsClassAlias;
    }

    public int getDeobfuscationMinLength() {
        return this.deobfuscationMinLength;
    }

    public void setDeobfuscationMinLength(int deobfuscationMinLength) {
        this.deobfuscationMinLength = deobfuscationMinLength;
    }

    public int getDeobfuscationMaxLength() {
        return this.deobfuscationMaxLength;
    }

    public void setDeobfuscationMaxLength(int deobfuscationMaxLength) {
        this.deobfuscationMaxLength = deobfuscationMaxLength;
    }

    public boolean isEscapeUnicode() {
        return this.escapeUnicode;
    }

    public void setEscapeUnicode(boolean escapeUnicode) {
        this.escapeUnicode = escapeUnicode;
    }

    public boolean isReplaceConsts() {
        return this.replaceConsts;
    }

    public void setReplaceConsts(boolean replaceConsts) {
        this.replaceConsts = replaceConsts;
    }

    public boolean isRespectBytecodeAccModifiers() {
        return this.respectBytecodeAccModifiers;
    }

    public void setRespectBytecodeAccModifiers(boolean respectBytecodeAccModifiers) {
        this.respectBytecodeAccModifiers = respectBytecodeAccModifiers;
    }

    public boolean isExportAsGradleProject() {
        return this.exportAsGradleProject;
    }

    public void setExportAsGradleProject(boolean exportAsGradleProject) {
        this.exportAsGradleProject = exportAsGradleProject;
    }

    public boolean isFsCaseSensitive() {
        return this.fsCaseSensitive;
    }

    public void setFsCaseSensitive(boolean fsCaseSensitive) {
        this.fsCaseSensitive = fsCaseSensitive;
    }

    public boolean isRenameCaseSensitive() {
        return this.renameFlags.contains((Object)RenameEnum.CASE);
    }

    public void setRenameCaseSensitive(boolean renameCaseSensitive) {
        this.updateRenameFlag(renameCaseSensitive, RenameEnum.CASE);
    }

    public boolean isRenameValid() {
        return this.renameFlags.contains((Object)RenameEnum.VALID);
    }

    public void setRenameValid(boolean renameValid) {
        this.updateRenameFlag(renameValid, RenameEnum.VALID);
    }

    public boolean isRenamePrintable() {
        return this.renameFlags.contains((Object)RenameEnum.PRINTABLE);
    }

    public void setRenamePrintable(boolean renamePrintable) {
        this.updateRenameFlag(renamePrintable, RenameEnum.PRINTABLE);
    }

    private void updateRenameFlag(boolean enabled, RenameEnum flag) {
        if (enabled) {
            this.renameFlags.add(flag);
        } else {
            this.renameFlags.remove((Object)flag);
        }
    }

    public OutputFormatEnum getOutputFormat() {
        return this.outputFormat;
    }

    public boolean isJsonOutput() {
        return this.outputFormat == OutputFormatEnum.JSON;
    }

    public void setOutputFormat(OutputFormatEnum outputFormat) {
        this.outputFormat = outputFormat;
    }

    public ICodeCache getCodeCache() {
        return this.codeCache;
    }

    public void setCodeCache(ICodeCache codeCache) {
        this.codeCache = codeCache;
    }

    public String toString() {
        return "JadxArgs{inputFiles=" + this.inputFiles + ", outDir=" + this.outDir + ", outDirSrc=" + this.outDirSrc + ", outDirRes=" + this.outDirRes + ", threadsCount=" + this.threadsCount + ", cfgOutput=" + this.cfgOutput + ", rawCFGOutput=" + this.rawCFGOutput + ", fallbackMode=" + this.fallbackMode + ", showInconsistentCode=" + this.showInconsistentCode + ", useImports=" + this.useImports + ", skipResources=" + this.skipResources + ", skipSources=" + this.skipSources + ", deobfuscationOn=" + this.deobfuscationOn + ", deobfuscationForceSave=" + this.deobfuscationForceSave + ", useSourceNameAsClassAlias=" + this.useSourceNameAsClassAlias + ", deobfuscationMinLength=" + this.deobfuscationMinLength + ", deobfuscationMaxLength=" + this.deobfuscationMaxLength + ", escapeUnicode=" + this.escapeUnicode + ", replaceConsts=" + this.replaceConsts + ", respectBytecodeAccModifiers=" + this.respectBytecodeAccModifiers + ", exportAsGradleProject=" + this.exportAsGradleProject + ", fsCaseSensitive=" + this.fsCaseSensitive + ", renameFlags=" + this.renameFlags + ", outputFormat=" + (Object)((Object)this.outputFormat) + ", codeCache=" + this.codeCache + '}';
    }

    public static enum OutputFormatEnum {
        JAVA,
        JSON;

    }

    public static enum RenameEnum {
        CASE,
        VALID,
        PRINTABLE;

    }
}

