/*
 * Decompiled with CFR 0.152.
 */
package org.jf.smali;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.List;
import javax.annotation.Nonnull;
import org.jf.util.ConsoleUtil;
import org.jf.util.jcommander.Command;
import org.jf.util.jcommander.ExtendedCommands;
import org.jf.util.jcommander.ExtendedParameter;
import org.jf.util.jcommander.ExtendedParameters;
import org.jf.util.jcommander.HelpFormatter;

@Parameters(commandDescription="Shows usage information")
@ExtendedParameters(commandName="help", commandAliases={"h"})
public class HelpCommand
extends Command {
    @Parameter(description="If specified, show the detailed usage information for the given commands")
    @ExtendedParameter(argumentNames={"commands"})
    private List<String> commands;

    public HelpCommand(@Nonnull List<JCommander> commandAncestors) {
        super(commandAncestors);
    }

    public void run() {
        JCommander parentJc = (JCommander)this.commandAncestors.get(this.commandAncestors.size() - 1);
        if (this.commands == null || this.commands.isEmpty()) {
            System.out.println(new HelpFormatter().width(ConsoleUtil.getConsoleWidth()).format(this.commandAncestors));
        } else {
            boolean printedHelp = false;
            for (String cmd : this.commands) {
                JCommander command = ExtendedCommands.getSubcommand((JCommander)parentJc, (String)cmd);
                if (command == null) {
                    System.err.println("No such command: " + cmd);
                    continue;
                }
                printedHelp = true;
                System.out.println(new HelpFormatter().width(ConsoleUtil.getConsoleWidth()).format(((Command)command.getObjects().get(0)).getCommandHierarchy()));
            }
            if (!printedHelp) {
                System.out.println(new HelpFormatter().width(ConsoleUtil.getConsoleWidth()).format(this.commandAncestors));
            }
        }
    }

    @Parameters(hidden=true)
    @ExtendedParameters(commandName="hlep")
    public static class HlepCommand
    extends HelpCommand {
        public HlepCommand(@Nonnull List<JCommander> commandAncestors) {
            super(commandAncestors);
        }
    }
}

