/*
 * Decompiled with CFR 0.152.
 */
package jadx.cli;

import ch.qos.logback.classic.Level;
import com.beust.jcommander.IStringConverter;
import jadx.api.JadxDecompiler;
import jadx.cli.JadxCLI;
import jadx.cli.JadxCLIArgs;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogHelper {
    private static final Logger LOG = LoggerFactory.getLogger(LogHelper.class);

    public static void setLogLevelFromArgs(JadxCLIArgs args) {
        if (LogHelper.isCustomLogConfig()) {
            return;
        }
        LogLevelEnum logLevel = args.logLevel;
        if (args.quiet) {
            logLevel = LogLevelEnum.QUIET;
        } else if (args.verbose) {
            logLevel = LogLevelEnum.DEBUG;
        }
        LogHelper.applyLogLevel(logLevel);
    }

    public static void applyLogLevel(LogLevelEnum logLevel) {
        ch.qos.logback.classic.Logger rootLogger = (ch.qos.logback.classic.Logger)LoggerFactory.getLogger((String)"ROOT");
        rootLogger.setLevel(logLevel.getLevel());
        if (logLevel != LogLevelEnum.QUIET) {
            LogHelper.setLevelForClass(JadxCLI.class, Level.INFO);
            LogHelper.setLevelForClass(JadxDecompiler.class, Level.INFO);
        }
    }

    private static void setLevelForClass(Class<?> cls, Level level) {
        ((ch.qos.logback.classic.Logger)LoggerFactory.getLogger(cls)).setLevel(level);
    }

    private static boolean isCustomLogConfig() {
        try {
            String logbackConfig = System.getProperty("logback.configurationFile");
            if (logbackConfig == null) {
                return false;
            }
            LOG.debug("Use custom log config: {}", (Object)logbackConfig);
            return true;
        }
        catch (Exception e) {
            LOG.error("Failed to detect custom log config", (Throwable)e);
            return false;
        }
    }

    public static class LogLevelConverter
    implements IStringConverter<LogLevelEnum> {
        public LogLevelEnum convert(String value) {
            try {
                return LogLevelEnum.valueOf(value.toUpperCase());
            }
            catch (Exception e) {
                throw new IllegalArgumentException('\'' + value + "' is unknown log level, possible values are " + JadxCLIArgs.enumValuesString(LogLevelEnum.values()));
            }
        }
    }

    public static enum LogLevelEnum {
        QUIET(Level.OFF),
        PROGRESS(Level.OFF),
        ERROR(Level.ERROR),
        WARN(Level.WARN),
        INFO(Level.INFO),
        DEBUG(Level.DEBUG);

        private final Level level;

        private LogLevelEnum(Level level) {
            this.level = level;
        }

        public Level getLevel() {
            return this.level;
        }
    }
}

