<?php

/**
 * ⚠️ Editing not allowed except for 'en' language.
 *
 * @see https://github.com/monicahq/monica/blob/main/docs/contribute/translate.md for translations.
 */

return [
    'sidebar_settings' => 'Accountinstellingen',
    'sidebar_personalization' => 'Personalisatie',
    'sidebar_settings_storage' => 'Opslag',
    'sidebar_settings_export' => 'Exporteer gegevens',
    'sidebar_settings_users' => 'Gebruikers',
    'sidebar_settings_subscriptions' => 'Abonnement',
    'sidebar_settings_import' => 'Importeer gegevens',
    'sidebar_settings_tags' => 'Labelbeheer',
    'sidebar_settings_api' => 'API',
    'sidebar_settings_dav' => 'DAV bronnen',
    'sidebar_settings_security' => 'Beveiliging',
    'sidebar_settings_auditlogs' => 'Auditlog',

    'title_general' => 'Algemene Informatie',
    'title_i18n' => 'Internationaliseringsinstellingen',
    'title_layout' => 'Lay-out',

    'me_title' => 'Ik als contact',
    'me_help' => 'Dit is het contact dat <em>jou</em> vertegenwoordigt in Monica',
    'me_select' => 'Selecteer een contactpersoon',
    'me_no_contact' => 'Nog geen contact geselecteerd.',
    'me_select_click' => 'Klik hier om een contact te selecteren.',
    'me_remove_contact' => 'Koppeling verwijderen',
    'me_choose' => 'Kies jezelf',
    'me_choose_placeholder' => 'Kies jezelf',

    'export_title' => 'Exporteer je accountgegevens',
    'export_be_patient' => 'Click the button to start the export. It might take several minutes to process the export – please be patient and do not spam the button.',
    'export_title_sql' => 'Export to SQL',
    'export_sql_explanation' => 'Exporting your data in SQL format allows you to take your data and import it to your own Monica instance. This is only valuable if you do have your own server.',
    'export_sql_cta' => 'Export to SQL',
    'export_sql_link_instructions' => 'Note: <a href=":url">read the instructions</a> to learn more about importing this file to your instance.',
    'export_title_json' => 'Export to Json',
    'export_submitted' => 'Your export has been submitted, it will be available in a few moment…',
    'export_json_explanation' => 'Exporting your data in Json format for backup.',
    'export_json_beta' => 'Json export is in preview mode. Tell us what you think about it:',
    'export_json_cta' => 'Export to Json',
    'export_header_type' => 'Type',
    'export_header_timestamp' => 'Creation date',
    'export_header_status' => 'Status',
    'export_header_actions' => 'Actions',
    'export_last_title' => 'Last exports',
    'export_empty_title' => 'No exports yet',
    'export_type_json' => 'Json export',
    'export_type_sql' => 'SQL export',
    'export_status_todo' => 'Submitted',
    'export_status_doing' => 'Doing',
    'export_status_done' => 'Done',
    'export_status_failed' => 'Failed',
    'export_not_done' => 'Download impossible, this export is not done yet.',

    'firstname' => 'Voornaam',
    'lastname' => 'Achternaam',
    'name_order' => 'Naamvolgorde',
    'name_order_firstname_lastname' => '<First name> <Last name> – Klaas Bakker',
    'name_order_lastname_firstname' => '<Last name> <First name> – Bakker Klaas',
    'name_order_firstname_lastname_nickname' => '<First name> <Last name> (<Nickname>) – Klaas Bakker (Broodje)',
    'name_order_firstname_nickname_lastname' => '<First name> (<Nickname>) <Last name> – Klaas (Broodje) Bakker',
    'name_order_lastname_firstname_nickname' => '<Last name> <First name> (<Nickname>) – Bakker Klaas (Broodje)',
    'name_order_lastname_nickname_firstname' => '<Last name> (<Nickname>) <First name> – Bakker (Broodje) Klaas',
    'name_order_nickname_firstname_lastname' => '<Nickname> (<First name> <Last name>) – Rambo (John Doe)',
    'name_order_nickname_lastname_firstname' => '<Nickname> (<Last name> <First name>) – Rambo (Doe John)',
    'name_order_nickname' => '<Nickname> – Rambo',
    'currency' => 'Valuta',
    'name' => 'Jouw naam: :name',
    'email' => 'E-mailadres',
    'email_placeholder' => 'E-mailadres invoeren',
    'email_help' => 'Dit is de e-mail die gebruikt wordt om in te loggen, en dit is waar naar toe Monica uw herinneringen zal sturen.',
    'timezone' => 'Tijdzone',
    'temperature_scale' => 'Temperatuurschaal',
    'temperature_scale_fahrenheit' => 'Fahrenheit (°F)',
    'temperature_scale_celsius' => 'Celsius (°C)',
    'layout' => 'Lay-out',
    'layout_small' => 'Maximaal 1200 pixels breed',
    'layout_big' => 'Volledige breedte van de browser',
    'save' => 'Voorkeuren bijwerken',
    'delete_title' => 'Verwijder je account',
    'delete_desc' => 'Wilt u uw account verwijderen? Verwijderen is permanent en al uw gegevens zullen permanent worden verwijderd. Als u een abonnement hebt, wordt het onmiddellijk geannuleerd.',
    'delete_other_desc' => 'Your data in the main database will be deleted immediately. As described in our privacy policy, we carry out securely encrypted backups of the database every day.  These backups are kept for 30 days after which they are completely deleted. We cannot delete specific data from the backups we hold any earlier than this.  All of your data will be completely deleted no later than 31 days after your account’s deletion.',
    'reset_desc' => 'Wil je jouw account resetten? Hiermee verwijder je alle contactpersonen en de gegevens die hieraan zijn gekoppeld. Je account zal niet worden verwijderd.',
    'reset_title' => 'Reset je account',
    'reset_cta' => 'Account resetten',
    'reset_notice' => 'Weet je zeker dat je je account wilt resetten? Dit is permanent en kan niet ongedaan worden gemaakt.',
    'reset_success' => 'Uw account is succesvol gereset.',
    'delete_notice' => 'Weet je zeker dat je je account wilt verwijderen? Dit is permanent en kan niet ongedaan worden gemaakt. Al uw gegevens zullen worden verwijderd en kunnen niet worden hersteld.',
    'delete_cta' => 'Account verwijderen',
    'settings_success' => 'Voorkeuren bijgewerkt!',
    'locale' => 'Taal',
    'locale_help' => 'Wil je helpen met het vertalen van Monica of een nieuwe taal toevoegen? <a href=":url" target="_blank" lang="en">Klik hier voor meer informatie.</a>',
    'locale_ar' => 'Arabisch',
    'locale_cs' => 'Tsjechisch',
    'locale_de' => 'Duits',
    'locale_el' => 'Greek',
    'locale_en' => 'Engels',
    'locale_en-GB' => 'Engels (Verenigd Koninkrijk)',
    'locale_es' => 'Spaans',
    'locale_fr' => 'Frans',
    'locale_he' => 'Hebreeuws',
    'locale_hr' => 'Kroatisch',
    'locale_id' => 'Indonesisch',
    'locale_it' => 'Italiaans',
    'locale_ja' => 'Japans',
    'locale_nl' => 'Nederlands',
    'locale_pt' => 'Portugees',
    'locale_pt-BR' => 'Portuguese, Brazil',
    'locale_ru' => 'Russisch',
    'locale_sv' => 'Zweeds',
    'locale_vi' => 'Vietnamese',
    'locale_zh' => 'Chinees (vereenvoudigd)',
    'locale_zh-TW' => 'Traditioneel Chinees',
    'locale_tr' => 'Turks',

    'security_title' => 'Beveiliging',
    'security_help' => 'Verander de beveiligingsinstellingen voor je account.',
    'password_change' => 'Verander je wachtwoord',
    'password_current' => 'Huidige wachtwoord',
    'password_current_placeholder' => 'Voer je huidige wachtwoord in',
    'password_new1' => 'Nieuw wachtwoord',
    'password_new1_placeholder' => 'Voer je nieuwe wachtwoord in',
    'password_new2' => 'Bevestig nieuw wachtwoord',
    'password_new2_placeholder' => 'Herhaal je nieuwe wachtwoord',
    'password_btn' => 'Wachtwoord wijzigen',
    '2fa_title' => 'Tweestapsverificatie',
    '2fa_otp_title' => 'Tweestapsverificatie mobiele applicatie',
    '2fa_enable_title' => 'Tweestapsverificatie inschakelen',
    '2fa_enable_description' => 'Schakel tweestapsverificatie in om de beveiliging van je account te verbeteren.',
    '2fa_enable_otp' => 'Open je tweestapsverificatie app en scan de volgende QR code:',
    '2fa_enable_otp_help' => 'Als je tweestapsverificatie app geen QR codes ondersteund, voer dan de volgende code in:',
    '2fa_enable_otp_validate' => 'Controleer of je app goed is ingesteld:',
    '2fa_enable_success' => 'Tweestapsverificatie geactiveerd',
    '2fa_enable_error' => 'Foutmelding tijdens het activeren van tweestapsverificatie',
    '2fa_enable_error_already_set' => 'Tweestapsverificatie is al geactiveerd',
    '2fa_disable_title' => 'Tweestapsverificatie uitschakelen',
    '2fa_disable_description' => 'Tweestapsverificatie uitschakelen voor je account. Wees voorzichtig, je account zal minder beveiligd zijn!',
    '2fa_disable_success' => 'Tweestapsverificatie uitgeschakeld',
    '2fa_disable_error' => 'Foutmelding tijdens het uitschakelen van tweestapsverificatie',

    'webauthn_title' => 'Beveiligingssleutel — WebAuthn protocol',
    'webauthn_enable_description' => 'Voeg een nieuwe beveiligingssleutel toe',
    'webauthn_key_name_help' => 'Kies een naam voor je sleutel.',
    'webauthn_key_name' => 'Sleutelnaam:',
    'webauthn_success' => 'Je sleutel is gedetecteerd en bevestigd.',
    'webauthn_last_use' => 'Laatst gebruikt: {timestamp}',
    'webauthn_delete_confirmation' => 'Weet je zeker dat je deze sleutel wilt verwijderen?',
    'webauthn_delete_success' => 'Sleutel verwijderd',
    'webauthn_insertKey' => 'Voer je beveiligingssleutel in.',
    'webauthn_buttonAdvise' => 'Druk op de knop van de beveiligingssleutel, als deze er een heeft.',
    'webauthn_noButtonAdvise' => 'Als dat niet zo is, verwijder de sleutel dan en verbind deze opnieuw.',
    'webauthn_not_supported' => 'Je browser ondersteunt op dit moment geen WebAuthn.',
    'webauthn_not_secured' => 'WebAuthn ondersteunt alleen beveiligde verbindingen. Laad deze pagina via https.',
    'webauthn_error_already_used' => 'Deze sleutel is al geregistreerd. Je hoeft deze niet opnieuw te registreren.',
    'webauthn_error_not_allowed' => 'De bewerking is niet toegestaan, of duurde te lang en is geannuleerd.',

    'recovery_title' => 'Herstelcodes',
    'recovery_show' => 'Herstelcodes opvragen',
    'recovery_copy_help' => 'Codes naar klembord kopiëren',
    'recovery_help_intro' => 'Dit zijn je herstelcodes:',
    'recovery_help_information' => 'Je kan elke herstelcode eenmalig gebruiken.',
    'recovery_clipboard' => 'Codes gekopieerd naar het klembord.',
    'recovery_generate' => 'Genereer nieuwe codes…',
    'recovery_generate_help' => 'Het genereren van nieuwe codes zal eerder gegenereerde codes ongeldig maken.',
    'recovery_already_used_help' => 'Deze code is al gebruikt.',

    'users_list_title' => 'Gebruikers met toegang tot je account',
    'users_list_add_user' => 'Nieuwe gebruiker uitnodigen',
    'users_list_you' => 'Dat ben jij',
    'users_list_invitations_title' => 'Openstaande uitnodigingen',
    'users_list_invitations_explanation' => 'Hieronder staan de mensen die je hebt uitgenodigd om mee samen te werken.',
    'users_list_invitations_invited_by' => 'uitgenodigd door :name',
    'users_list_invitations_sent_date' => 'verzonden op :date',
    'users_blank_title' => 'Jij bent de enige met toegang tot dit account.',
    'users_blank_add_title' => 'Wil je iemand anders uitnodigen?',
    'users_blank_description' => 'Deze persoon zal dezelfde toegang hebben als jij en zal contactinformatie kunnen toevoegen, bewerken of verwijderen.',
    'users_blank_cta' => 'Iemand uitnodigen',
    'users_add_title' => 'Nodig een nieuwe gebruiker uit voor je account via e-mail',
    'users_add_description' => 'Deze persoon heeft dezelfde toegang als jij, inclusief het uitnodigen of verwijderen van andere gebruikers, waaronder jij. Zorg ervoor dat je deze persoon vertrouwt voordat je hem toegang geeft.',
    'users_add_email_field' => 'Voer het e-mailadres in van de persoon die je wil uitnodigen',
    'users_add_confirmation' => 'Ik bevestig dat ik deze gebruiker wil uitnodigen voor mijn account. Ik begrijp dat deze persoon toegang zal hebben tot AL mijn gegevens en precies zal zien wat ik zie.',
    'users_add_cta' => 'Uitnodigen via e-mail',
    'users_accept_title' => 'Uitnodiging accepteren en nieuw account aanmaken',
    'users_error_please_confirm' => 'Bevestig alsjeblieft, dat je deze gebruiker wilt uitnodigen',
    'users_error_email_already_taken' => 'Dit e-mailadres is al in gebruik. Gebruik een andere',
    'users_error_already_invited' => 'Je hebt deze gebruiker al uitgenodigd. Kies alsjeblieft een ander e-mailadres.',
    'users_error_email_not_similar' => 'Dit is niet het e-mailadres van de persoon die jou heeft uitgenodigd.',
    'users_invitation_deleted_confirmation_message' => 'De uitnodiging is succesvol verwijderd',
    'users_invitations_delete_confirmation' => 'Weet je zeker dat je deze uitnodiging wilt verwijderen?',
    'users_list_delete_confirmation' => 'Weet je zeker dat je deze gebruiker uit je account wil verwijderen?',
    'users_invitation_need_subscription' => 'Het toevoegen van meer gebruikers vereist een abonnement.',

    'subscriptions_account_current_plan' => 'Je huidige abonnement',
    'subscriptions_account_current_legacy' => 'Current plan, not selectable anymore:',
    'subscriptions_account_current_paid_plan' => 'Jij gebruikt het :name abonnement. Bedankt voor het aanmelden.',

    'subscriptions_account_next_billing_title' => 'Next bill',
    'subscriptions_account_next_billing' => 'Je abonnement wordt automatisch verlengd op <strong>:date</strong>.',
    'subscriptions_account_bill_monthly' => 'We’ll bill you <strong>:price</strong> for another <strong>month</strong>.',
    'subscriptions_account_bill_annual' => 'We’ll bill you <strong>:price</strong> for another <strong>year</strong>.',
    'subscriptions_account_change' => 'Change plan',

    'subscriptions_account_cancel_title' => 'Cancel subscription',
    'subscriptions_account_cancel_action' => 'Cancel subscription',
    'subscriptions_account_cancel' => 'Je kunt je abonnement op elk moment <a href=":url">annuleren</a>.',
    'subscriptions_account_free_plan' => 'Je hebt het gratis abonnement.',
    'subscriptions_account_free_plan_upgrade' => 'Je kan je account upgraden naar het :name abonnement, dat $:price per maand kost. Hier zijn de voordelen:',
    'subscriptions_account_free_plan_benefits_users' => 'Onbeperkt aantal gebruikers',
    'subscriptions_account_free_plan_benefits_reminders' => 'E-mail herinneringen',
    'subscriptions_account_free_plan_benefits_import_data_vcard' => 'Importeer contacten via vCard',
    'subscriptions_account_free_plan_benefits_support' => 'Steun het project op de lange termijn, zodat we meer geweldige functies kunnen introduceren.',
    'subscriptions_account_upgrade' => 'Account upgraden',
    'subscriptions_account_upgrade_title' => 'Upgrade Monica vandaag en maak je persoonlijke relaties betekenisvoller.',
    'subscriptions_account_upgrade_choice' => 'Kies hieronder een abonnement en sluit je aan bij meer dan :customers personen die reeds de premium versie van Monica gebruiken.',
    'subscriptions_account_update_title' => 'Update Monica subscription',
    'subscriptions_account_update_description' => 'You can change your subscription’s frequency here.',
    'subscriptions_account_update_information' => 'You will be billed immediately for the new amount. Your subscription will extend to the new period, depending on your choice.',
    'subscriptions_account_invoices' => 'Facturen',
    'subscriptions_account_invoices_download' => 'Download',
    'subscriptions_account_invoices_subscription' => 'Abonnement van :startDate tot :endDate',
    'subscriptions_account_payment' => 'Welke betaalmethode past je het beste?',
    'subscriptions_account_confirm_payment' => 'Je betaling is nog niet helemaal afgerond, <a href=":url">bevestig je betaling</a> alsjeblieft.',
    'subscriptions_downgrade_title' => 'Account naar de gratis variant downgraden',
    'subscriptions_downgrade_limitations' => 'De gratis versie heeft beperkingen. Om te kunnen downgraden moet je voldoen aan de volgende voorwaarden:',
    'subscriptions_downgrade_rule_users' => 'Je mag slechts één gebruiker in je account hebben',
    'subscriptions_downgrade_rule_users_constraint' => 'Je hebt op dit moment <a href=":url">1 gebruiker</a> in jouw account.|Je hebt op dit moment <a href=":url">:count gebruikers</a> in jouw account.',
    'subscriptions_downgrade_rule_invitations' => 'Je mag geen openstaande uitnodigingen hebben',
    'subscriptions_downgrade_rule_invitations_constraint' => 'Op dit moment heb je <a href=":url">1 openstaande uitnodiging</a>. Op dit moment heb je <a href=":url">:count openstaande uitnodigingen</a>.',
    'subscriptions_downgrade_rule_contacts' => 'Je mag niet meer dan :number actieve contacten hebben',
    'subscriptions_downgrade_rule_contacts_constraint' => 'Op dit moment heb je <a href=":url">1 contact</a>.|Op dit moment heb je <a href=":url">:count contacten</a>.',
    'subscriptions_downgrade_rule_contacts_archive' => 'We can also <a href=":url">archive all your contacts for you</a> – that would clear this rule and let you proceed with your account’s downgrade process.',
    'subscriptions_downgrade_cta' => 'Downgraden',
    'subscriptions_downgrade_success' => 'Je hebt nu het gratis abonnement!',
    'subscriptions_downgrade_thanks' => 'Bedankt dat je het betaalde abonnement geprobeerd hebt. We zijn voortdurend bezig om nieuwe functionaliteiten toe voegen. Misschien wil je dit in de gaten houden en wie weet heb je in de toekomst weer interesse in een betaald abonnement.',
    'subscriptions_back' => 'Terug naar instellingen',
    'subscriptions_upgrade_title' => 'Account upgraden',
    'subscriptions_upgrade_choose' => 'Je hebt het :plan abonnement gekozen.',
    'subscriptions_upgrade_infos' => 'Wij zijn erg blij. Voer hieronder je betaalgegevens in.',
    'subscriptions_upgrade_name' => 'Naam op de kaart',
    'subscriptions_upgrade_zip' => 'Postcode',
    'subscriptions_upgrade_credit' => 'Creditcard',
    'subscriptions_upgrade_submit' => 'Betaal {amount}',
    'subscriptions_upgrade_charge' => 'We nemen nu :price in rekening. Het volgende afschrift is op :date. Als je ooit van gedachten verandert, kun je op elk moment annuleren, geen vragen.',
    'subscriptions_upgrade_charge_handled' => 'De betaling wordt afgehandeld via <a href=":url">Stripe</a>. Er worden geen creditcardgegevens bij ons opgeslagen.',
    'subscriptions_upgrade_success' => 'Dankjewel! Je hebt nu een abonnement.',
    'subscriptions_upgrade_thanks' => 'Welkom in de community van mensen die proberen om de wereld een betere plek te maken.',

    'subscriptions_payment_confirm_title' => 'Bevestig je betaling van :amount',
    'subscriptions_payment_confirm_information' => 'Er is een extra bevestiging nodig om je betaling te kunnen verwerken. Bevestig je betaling door hieronder je betalingsgegevens in te vullen.',
    'subscriptions_payment_succeeded_title' => 'Betaling succesvol',
    'subscriptions_payment_succeeded' => 'Deze betaling is al met succes bevestigd.',
    'subscriptions_payment_cancelled_title' => 'Betaling geannuleerd',
    'subscriptions_payment_cancelled' => 'De betaling is geannuleerd.',
    'subscriptions_payment_error_name' => 'Voer alsjeblieft je naam in.',
    'subscriptions_payment_success' => 'De betaling is voltooid.',

    'subscriptions_pdf_title' => 'Jouw :name maandelijkse abonnement',
    'subscriptions_plan_frequency_year' => ':amount / year',
    'subscriptions_plan_frequency_month' => ':amount / month',
    'subscriptions_plan_choose' => 'Kies een abonnement',
    'subscriptions_plan_year_title' => 'Jaarlijks betalen',
    'subscriptions_plan_year_bonus' => 'Gemoedsrust voor een heel jaar',
    'subscriptions_plan_month_title' => 'Maandelijks betalen',
    'subscriptions_plan_month_bonus' => 'Altijd opzegbaar',
    'subscriptions_plan_include1' => 'Bij je upgrade inbegrepen:',
    'subscriptions_plan_include2' => 'Onbeperkt aantal contacten • Onbeperkt aantal gebruikers • Herinneringen via e-mail • Importeren via vCard • Personaliseren van het contactoverzicht',
    'subscriptions_plan_include3' => '100% van de inkomsten gaan naar de ontwikkeling van dit fantastische open source project.',
    'subscriptions_help_title' => 'Extra details waar je wellicht interesse in hebt',
    'subscriptions_help_opensource_title' => 'Wat is een open source project?',
    'subscriptions_help_opensource_desc' => 'Monica is een open source project. Dat betekend dat het volledig wordt gebouwd door een welwillende groep mensen die slechts een geweldige applicatie willen maken voor het algemeen belang. Open source betekend dat de code vrij beschikbaar is op Github, iederheen het kan inspecteren, het kan aanpassen of het kan verbeteren. Al het geld dat wij binnenkrijgen is bedoeld om betere functionaliteiten te ontwikkelen, krachtigere servers in te kunnen zetten en het helpt om de rekeningen te betalen. Bedankt voor je hulp. We zouden het niet zonder jou kunnen doen - werkelijk.',
    'subscriptions_help_limits_title' => 'Is er een limiet aan het aantal contacten dat je kan hebben in het gratis abonnement?',
    'subscriptions_help_limits_plan' => 'Ja. Een gratis abonnement stelt je in staat om :number contacten te beheren.',
    'subscriptions_help_discounts_title' => 'Zijn er kortingen voor non-profitorganisaties en onderwijs?',
    'subscriptions_help_discounts_desc' => 'Jazeker! Monica is gratis voor studenten en goede doelen. Neem contact op met <a href=":support">support</a> met een passend bewijs (van inschrijving) en wij zullen deze speciale status aan je account toekennen.',
    'subscriptions_help_change_title' => 'Wat als ik van gedachten verander?',
    'subscriptions_help_change_desc' => 'Je kan op elk moment volledig zelfstandig opzeggen, zonder verdere voorwaarden. Er is geen noodzaak om contact te zoeken met support. Je lopende abonnementsperiode kan echter niet terugbetaald worden.',

    'stripe_error_card' => 'Je creditcard is geweigerd met de volgende mededeling: :message',
    'stripe_error_api_connection' => 'Netwerkcommunicatie met Stripe is mislukt. Probeer het later opnieuw.',
    'stripe_error_rate_limit' => 'Teveel verzoeken met Stripe op dit moment. Probeer het later opnieuw.',
    'stripe_error_invalid_request' => 'Ongeldige parameters. Probeer het later opnieuw.',
    'stripe_error_authentication' => 'Verkeerde authenticatie met Stripe',

    'import_title' => 'Contacten importeren in jouw account',
    'import_cta' => 'Contacten uploaden',
    'import_stat' => 'Je heb tot nu toe :number bestanden geïmporteerd.',
    'import_result_stat' => 'vCard met 1 contact geüpload(:total_imported geïmporteerd,:total_skipped overgeslagen)|vCard met :total_contacts contacten geüpload(:total_imported geïmporteerd,:total_skipped overgeslagen)',
    'import_view_report' => 'Importrapport bekijken',
    'import_in_progress' => 'Het importeren is bezig. Ververs de pagina over één minuut.',
    'import_upload_title' => 'Contacten uit een vCard bestand importeren',
    'import_upload_rules_desc' => 'Er zijn restricties:',
    'import_upload_rule_format' => 'Wij ondersteunen <code>.vcard</code> en <code>.vcf</code> bestanden.',
    'import_upload_rule_vcard' => 'Wij ondersteunen het vCard 3.0 formaat, wat het standaardformaat is voor macOS Contacts.app en Google Contacts.',
    'import_upload_rule_instructions' => 'Export instructions for <a href=":url1" target="_blank" rel="noopener noreferrer">macOS Contacts.app</a> and <a href=":url2" target="_blank" rel="noopener noreferrer">Google Contacts</a>.',
    'import_upload_rule_multiple' => 'If your contacts have multiple email addresses or phone numbers, only the first entry will be saved.',
    'import_upload_rule_limit' => 'Bestanden mogen niet groter dan 10MB zijn.',
    'import_upload_rule_time' => 'It might take up to a minute to upload the contacts and process them. Please be patient.',
    'import_upload_rule_cant_revert' => 'Please make sure data is accurate before uploading, as you can’t undo the upload.',
    'import_upload_form_file' => 'Jouw <code>.vcf</code> of <code>.vCard</code> bestand:',
    'import_upload_behaviour' => 'Importgedrag:',
    'import_upload_behaviour_add' => 'Nieuwe contacten toevoegen en bestaande overslaan',
    'import_upload_behaviour_replace' => 'Overschrijf bestaande contacten',
    'import_upload_behaviour_help' => 'Replacing will replace all data found in the vCard, but will keep existing contact fields.',
    'import_report_title' => 'Importrapport',
    'import_report_date' => 'Importdatum',
    'import_report_type' => 'Importtype',
    'import_report_number_contacts' => 'Aantal contacten in het bestand',
    'import_report_number_contacts_imported' => 'Aantal geïmporteerde contacten',
    'import_report_number_contacts_skipped' => 'Aantal overgeslagen contacten',
    'import_report_status_imported' => 'Geïmporteerd',
    'import_report_status_skipped' => 'Overgeslagen',
    'import_vcard_parse_error' => 'Fout tijdens het verwerken van de vCard',
    'import_vcard_contact_exist' => 'Contactpersoon bestaat al',
    'import_vcard_contact_no_firstname' => 'Geen voornaam (verplicht)',
    'import_vcard_file_not_found' => 'Bestand niet gevonden',
    'import_vcard_unknown_entry' => 'Onbekende contactpersoon',
    'import_vcard_file_no_entries' => 'Bestand bevat geen items',
    'import_blank_title' => 'Je hebt nog geen contacten geïmporteerd.',
    'import_blank_question' => 'Wil je nu contacten importeren?',
    'import_blank_description' => 'Wij kunnen vCard-bestanden importeren die je kan krijgen uit Google Contacts of je contactenmanager.',
    'import_blank_cta' => 'Importeer vCard',
    'import_need_subscription' => 'Gegevens importeren vereist een abonnement.',

    'tags_list_title' => 'Labels',
    'tags_list_description' => 'Je kan je contacten organiseren door labels toe te voegen. Labels werken als mappen maar je kan meer dan één label toevoegen aan een contact. Om een nieuw label toe te voegen moet je dat bij een contactpersoon zelf doen.',
    'tags_list_contact_number' => '1 contact|:count contacten',
    'tags_list_delete_success' => 'Het label is succesvol verwijderd',
    'tags_list_delete_confirmation' => 'Weet je zeker dat je het label wil verwijderen? Alleen het label zal worden verwijderd, contactpersonen blijven behouden.',
    'tags_blank_title' => 'Labels zijn een geweldige methode om je contacten te organiseren.',
    'tags_blank_description' => 'Tags work like folders, but you can add more than one tag to a contact. Go to a contact and tag a friend, right below the name. Once a contact is tagged, come back here to manage all the tags in your account.',

    'api_title' => 'API-toegang',
    'api_description' => 'De API kan worden gebruikt om de gegevens van Monica te gebruiken in een externe applicatie. Bijvoorbeeld een app op je mobiele telefoon.',
    'api_help' => 'Om de API te gebruiken, is een token noodzakelijk. Je kunt een persoonlijke token aanmaken (zgn. \'Bearer authentication\'), of een OAuth client toestaan om dit voor je te doen. Zie ook de <a href=":url">API documentatie</a>.',
    'api_endpoint' => 'De \'API endpoint\' voor deze Monica-server is:',

    'api_personal_access_tokens' => 'Persoonlijke toegangscodes',
    'api_pao_description' => 'Zorg dat je deze code alleen toevertrouwt aan een bron die je vertrouwd gezien deze code toegang geeft tot al jouw gegevens.',
    'api_token_title' => 'Persoonlijke Tokens',
    'api_token_create_new' => 'Nieuwe code aanmaken',
    'api_token_not_created' => 'Je hebt nog geen persoonlijke toegangscodes aangemaakt.',
    'api_token_name' => 'Naam token',
    'api_token_expire' => 'Verloopt op {date}',
    'api_token_delete' => 'Verwijderen',
    'api_token_create' => 'Code aanmaken',
    'api_token_scopes' => 'Bereik',
    'api_token_help' => 'Hier is je nieuwe persoonlijke toegangscode. Dit is de enige keer dat deze getoond wordt dus verlies deze niet! Je kan deze toegangscode nu gebruiken om API-aanvragen te maken.',

    'api_oauth_clients' => 'Jouw OAuth clients',
    'api_oauth_clients_desc' => 'Hier kun je jouw eigen OAuth clients registreren.',
    'api_oauth_clients_desc2' => 'Gebruik deze client-id om een nieuwe token aan te vragen en autorisatiecodes om te zetten naar tokens. Zie <a href="{url}">Laravel Passport documentatie</a> voor meer informatie.',
    'api_oauth_title' => 'OAuth Clients',
    'api_oauth_create_new' => 'Nieuwe client aanmaken',
    'api_oauth_edit' => 'Client bewerken',
    'api_oauth_not_created' => 'Je hebt nog geen OAuth-clients aangemaakt.',
    'api_oauth_clientid' => 'Client-ID',
    'api_oauth_name' => 'Naam',
    'api_oauth_name_help' => 'Iets dat jouw gebruikers herkennen en kunnen vertrouwen.',
    'api_oauth_secret' => 'Secret',
    'api_oauth_create' => 'Client aanmaken',
    'api_oauth_redirecturl' => 'Redirect-URL',
    'api_oauth_redirecturl_help' => 'De authorisatie-callback-url van jouw applicatie.',

    'api_authorized_clients' => 'Lijst van geautoriseerde clients',
    'api_authorized_clients_desc' => 'Deze lijst bevat alle Clients die je hebt gemachtigd om toegang te krijgen tot je applicatie. Je kan deze machtiging te allen tijde intrekken.',
    'api_authorized_clients_title' => 'Geautoriseerde applicaties',
    'api_authorized_clients_none' => 'Er zijn nog geen geautoriseerde clients.',
    'api_authorized_clients_name' => 'Naam',
    'api_authorized_clients_scopes' => 'Bereik',

    'personalization_tab_title' => 'Personaliseer je account',

    'personalization_title' => 'Here you will find different settings to configure your account. These features are intended for “power users” who want maximum control over Monica.',
    'personalization_contact_field_type_title' => 'Contactvelden',
    'personalization_contact_field_type_add' => 'Nieuw type contactveld toevoegen',
    'personalization_contact_field_type_description' => 'You can configure all the different types of contact fields that you can associate to all your contacts. For example, if a new social network appears in the future, you will be able to add this new way of communicating with your contacts right here.',
    'personalization_contact_field_type_table_name' => 'Naam',
    'personalization_contact_field_type_table_protocol' => 'Protocol',
    'personalization_contact_field_type_table_actions' => 'Acties',
    'personalization_contact_field_type_modal_title' => 'Nieuw soort contactveld toevoegen',
    'personalization_contact_field_type_modal_edit_title' => 'Een bestaand type contactveld bewerken',
    'personalization_contact_field_type_modal_delete_title' => 'Een bestaand type contactveld verwijderen',
    'personalization_contact_field_type_modal_delete_description' => 'Are you sure you want to delete this contact field type? Deleting this type of contact field will delete ALL the data with this type for all of your contacts.',
    'personalization_contact_field_type_modal_name' => 'Naam',
    'personalization_contact_field_type_modal_protocol' => 'Protocol (optioneel)',
    'personalization_contact_field_type_modal_protocol_help' => 'Als er een protocol voor een type contactveld is ingesteld wordt bij een muisklik op dat veld de actie uitgevoerd die bij dat protocol hoort.',
    'personalization_contact_field_type_modal_icon' => 'Pictogram (optioneel)',
    'personalization_contact_field_type_modal_icon_help' => 'Je kan een pictogram koppelen aan dit type contactveld. Het moet een referentie zijn naar een Font Awesome pictogram.',
    'personalization_contact_field_type_delete_success' => 'The contact field type has been successfully deleted.',
    'personalization_contact_field_type_add_success' => 'Het type contactveld is met succes toegevoegd.',
    'personalization_contact_field_type_edit_success' => 'Het type contactveld is met succes bijgewerkt.',

    'personalization_genders_title' => 'Genderidentiteiten',
    'personalization_genders_add' => 'Nieuwe genderidentiteit toevoegen',
    'personalization_genders_desc' => 'Je kan zoveel genderidentiteiten definiëren als je nodig acht. Je hebt ten minste één genderidentiteit nodig in je account.',
    'personalization_genders_modal_add' => 'Genderidentiteit toevoegen',
    'personalization_genders_modal_edit' => 'Genderidentiteit bewerken',
    'personalization_genders_modal_name' => 'Naam',
    'personalization_genders_modal_name_help' => 'De titel voor het aangeven van het geslacht op een contactpagina.',
    'personalization_genders_modal_sex' => 'Geslacht',
    'personalization_genders_modal_sex_help' => 'Wordt gebruikt voor het definiëren van relaties, o.a. tijdens het importeren en exporteren van VCards.',
    'personalization_genders_modal_default' => 'Selecteer het standaardgeslacht voor nieuwe contacten',
    'personalization_genders_modal_delete' => 'Genderidentiteit verwijderen',
    'personalization_genders_modal_delete_desc' => 'Weet u zeker dat je het geslacht "{name} " wilt verwijderen?',
    'personalization_genders_modal_delete_question' => 'You currently have {count} contact with this gender. If you delete this gender, what gender should this contact have?|You currently have {count} contacts with this gender. If you delete this gender, what gender should these contacts have?',
    'personalization_genders_modal_delete_question_default' => 'This gender is the default one. If you delete this gender, which one will be the new default?',
    'personalization_genders_modal_error' => 'Kies een geslacht uit de lijst.',
    'personalization_genders_list_contact_number' => '{count} contact|{count} contacten',
    'personalization_genders_table_name' => 'Titel',
    'personalization_genders_table_sex' => 'Geslacht',
    'personalization_genders_table_default' => 'Standaard',
    'personalization_genders_default' => 'Standaardgeslacht',
    'personalization_genders_make_default' => 'Standaardgeslacht wijzigen',
    'personalization_genders_select_default' => 'Selecteer standaardgeslacht',
    'personalization_genders_m' => 'Man',
    'personalization_genders_f' => 'Vrouw',
    'personalization_genders_o' => 'Anders',
    'personalization_genders_u' => 'Onbekend',
    'personalization_genders_n' => 'Geen of niet van toepassing',

    'personalization_reminder_rule_save' => 'De instellingen zijn opgeslagen',
    'personalization_reminder_rule_title' => 'Herinneringen',
    'personalization_reminder_rule_line' => '{count} dag ervoor|{count} dagen ervoor',
    'personalization_reminder_rule_desc' => 'For every reminder that you set, Monica can send you an email a number of days before the event happens.  You can adjust these notification settings here. These notifications only apply to monthly and yearly reminders.',

    'personalization_module_save' => 'De wijziging is opgeslagen',
    'personalization_module_title' => 'Functionaliteiten',
    'personalization_module_desc' => 'You may not need all of Monica’s features. Below you can toggle specific features that are used on a contact sheet. This change will affect ALL your contacts. Turning off a feature does not delete any data, it simply hides the feature.',

    'personalisation_paid_upgrade' => 'Dit is een betaalde functionaliteit en vereist dat je een betaald abonnement hebt. Upgrade je account door naar <a href=":url">Instellingen > Abonnement</a> te gaan.',
    'personalisation_paid_upgrade_vue' => 'Dit is een betaalde functionaliteit en vereist dat je een betaald abonnement hebt. Upgrade je account door naar <a href="{url}">Instellingen > Abonnement</a> te gaan.',

    'reminder_time_to_send' => 'Tijd van de dag herinneringen zullen worden verzonden',
    'reminder_time_to_send_help' => 'Uw volgende herinnering is gepland te worden verzonden op <span title="{dateTimeUtc}" class="reminder-info">{dateTime}</span>.',

    'personalization_activity_type_category_title' => 'Activiteit-categorieën',
    'personalization_activity_type_category_add' => 'Voeg een nieuwe categorie activiteiten toe',
    'personalization_activity_type_category_table_name' => 'Naam',
    'personalization_activity_type_category_description' => 'An activity with one of your contacts can have a type and a category type. Your account comes with a set of predefined category types by default, but you can customize these here.',
    'personalization_activity_type_category_table_actions' => 'Acties',
    'personalization_activity_type_category_modal_add' => 'Voeg een nieuwe categorie activiteiten toe',
    'personalization_activity_type_category_modal_edit' => 'Bewerk een categorie activiteiten',
    'personalization_activity_type_category_modal_question' => 'Hoe moeten we deze nieuwe categorie noemen?',
    'personalization_activity_type_add_button' => 'Nieuw type activiteit toevoegen',
    'personalization_activity_type_modal_add' => 'Nieuw type activiteit toevoegen',
    'personalization_activity_type_modal_question' => 'Hoe moeten we deze nieuwe type activiteit noemen?',
    'personalization_activity_type_modal_edit' => 'Bewerk type activiteit',
    'personalization_activity_type_category_modal_delete' => 'Verwijder een categorie activiteiten',
    'personalization_activity_type_category_modal_delete_desc' => 'Are you sure you want to delete this category? Deleting it will delete all associated activity types. Activities that belong to this category will not be affected by this deletion.',
    'personalization_activity_type_modal_delete' => 'Verwijder type activiteit',
    'personalization_activity_type_modal_delete_desc' => 'Weet je zeker dat je dit activiteitstype wil verwijderen? Activiteiten die behoren tot dit type worden niet beïnvloed door deze verwijdering.',
    'personalization_activity_type_modal_delete_error' => 'We kunnen dit type activiteit niet vinden.',
    'personalization_activity_type_category_modal_delete_error' => 'We kunnen deze categorie niet vinden.',

    'personalization_life_event_category_title' => 'Levensgebeurtenis categorieën',
    'personalization_live_event_category_table_name' => 'Naam',
    'personalization_life_event_category_description' => 'A life event can have a type and a category. Your account comes with a set of predefined categories and types by default, but you can customize life event types here.',
    'personalization_live_event_category_table_actions' => 'Acties',
    'personalization_life_event_type_add_button' => 'Een nieuw levensgebeurtenis type toevoegen',
    'personalization_life_event_type_modal_add' => 'Een nieuw levensgebeurtenis type toevoegen',
    'personalization_life_event_type_modal_question' => 'Hoe moeten we dit nieuwe levensevenement noemen?',
    'personalization_life_event_type_modal_edit' => 'Bewerk een levensgebeurtenis type',
    'personalization_life_event_type_modal_delete' => 'Verwijder levensgebeurtenis type',
    'personalization_life_event_type_modal_delete_desc' => 'Are you sure you want to delete this life event type? Life events that belong to this type will be deleted by performing this action.',
    'personalization_life_event_type_modal_delete_error' => 'We can’t find this life event type.',

    'personalization_life_event_category_work_education' => 'Werk & onderwijs',
    'personalization_life_event_category_family_relationships' => 'Familie & relaties',
    'personalization_life_event_category_home_living' => 'Huis & leven',
    'personalization_life_event_category_travel_experiences' => 'Reizen & ervaringen',
    'personalization_life_event_category_health_wellness' => 'Gezondheid & welzijn',

    'personalization_life_event_type_new_job' => 'Nieuwe baan',
    'personalization_life_event_type_retirement' => 'Pensioen',
    'personalization_life_event_type_new_school' => 'Nieuwe school',
    'personalization_life_event_type_study_abroad' => 'Studie in het buitenland',
    'personalization_life_event_type_volunteer_work' => 'Vrijwilligerswerk',
    'personalization_life_event_type_published_book_or_paper' => 'Publicatie van boek of artikel',
    'personalization_life_event_type_military_service' => 'Militaire dienst',
    'personalization_life_event_type_first_met' => 'Eerste ontmoeting',
    'personalization_life_event_type_new_relationship' => 'Nieuwe relatie',
    'personalization_life_event_type_engagement' => 'Verloving',
    'personalization_life_event_type_marriage' => 'Huwelijk',
    'personalization_life_event_type_anniversary' => 'Jubileum',
    'personalization_life_event_type_expecting_a_baby' => 'Verwacht een baby',
    'personalization_life_event_type_new_child' => 'Nieuw kind',
    'personalization_life_event_type_new_family_member' => 'Nieuw gezinslid',
    'personalization_life_event_type_new_pet' => 'Nieuw huisdier',
    'personalization_life_event_type_end_of_relationship' => 'Einde van relatie',
    'personalization_life_event_type_loss_of_a_loved_one' => 'Verlies van een dierbare',
    'personalization_life_event_type_moved' => 'Verhuisd',
    'personalization_life_event_type_bought_a_home' => 'Huis gekocht',
    'personalization_life_event_type_home_improvement' => 'Verbouwing',
    'personalization_life_event_type_holidays' => 'Vakantie',
    'personalization_life_event_type_new_vehicle' => 'Nieuw voertuig',
    'personalization_life_event_type_new_roommate' => 'Nieuwe kamergenoot',
    'personalization_life_event_type_overcame_an_illness' => 'Overwon een ziekte',
    'personalization_life_event_type_quit_a_habit' => 'Gestopt met gewoonte',
    'personalization_life_event_type_new_eating_habits' => 'Nieuw voedingspatroon',
    'personalization_life_event_type_weight_loss' => 'Gewichtsverlies',
    'personalization_life_event_type_wear_glass_or_contact' => 'Begonnen met dragen van bril of contactlenzen',
    'personalization_life_event_type_broken_bone' => 'Bot gebroken',
    'personalization_life_event_type_removed_braces' => 'Had braces removed',
    'personalization_life_event_type_surgery' => 'Operatie ondergaan',
    'personalization_life_event_type_dentist' => 'Had dental treatment',
    'personalization_life_event_type_new_sport' => 'Begonnen met het spelen van een nieuwe sport',
    'personalization_life_event_type_new_hobby' => 'Took up a new hobby',
    'personalization_life_event_type_new_instrument' => 'Begonnen met leren van een nieuw instrument',
    'personalization_life_event_type_new_language' => 'Begonnen met leren van een nieuwe taal',
    'personalization_life_event_type_tattoo_or_piercing' => 'Tatoeage of piercing',
    'personalization_life_event_type_new_license' => 'Nieuw diploma',
    'personalization_life_event_type_travel' => 'Reizen',
    'personalization_life_event_type_achievement_or_award' => 'Prestatie of prijs',
    'personalization_life_event_type_changed_beliefs' => 'Van overtuiging veranderd',
    'personalization_life_event_type_first_word' => 'Eerste woord',
    'personalization_life_event_type_first_kiss' => 'Eerste kus',

    'storage_title' => 'Opslag',
    'storage_account_info' => 'Je accountlimit is :accountlimit MB. Je huidige gebruik is :currentAccountSize MB (ongeveer :percentUsage%).',
    'storage_upgrade_notice' => 'Upgrade je account om documenten en foto\'s te kunnen uploaden.',
    'storage_description' => 'Hier kun je alle documenten en foto\'s zien die bij als bijlage bij je contacten zijn geüpload.',

    'dav_title' => 'WebDAV',
    'dav_description' => 'Hier kun je alle instellingen vinden om WebDAV te gebruiken voor CardDAV en CalDAV export.',
    'dav_copy_help' => 'Naar klembord kopiëren',
    'dav_clipboard_copied' => 'Waarde gekopieerd naar klembord',
    'dav_url_base' => 'Basis-url voor alle CardDAV en CalDAV bronnen:',
    'dav_connect_help' => 'Je kan jouw contactpersonen en/of kalenders verbinden met deze basis-url op je telefoon of computer.',
    'dav_connect_help2' => 'Use your login (email) and create an API token as the password to authenticate.',
    'dav_url_carddav' => 'CardDAV url voor Contacten:',
    'dav_url_caldav_birthdays' => 'CalDAV url voor verjaardagen:',
    'dav_url_caldav_tasks' => 'CalDAV url voor taken:',
    'dav_title_carddav' => 'CardDAV',
    'dav_title_caldav' => 'CalDAV',
    'dav_carddav_export' => 'Alle contacten exporteren in één bestand',
    'dav_caldav_birthdays_export' => 'Alle verjaardagen exporteren in één bestand',
    'dav_caldav_tasks_export' => 'Alle taken exporteren in één bestand',

    'archive_title' => 'Archiveer alle contacten in uw account',
    'archive_desc' => 'Dit zal alle contacten in uw account archiveren.',
    'archive_cta' => 'Archiveer al je contacten',

    'logs_title' => 'Alles wat met dit account is gebeurd',
    'logs_actor' => 'Actor',
    'logs_timestamp' => 'Timestamp',
    'logs_description' => 'Beschrijving',
    'logs_subject' => 'Onderwerp',
    'logs_size' => 'Grootte (kB)',
    'logs_object' => 'Object',
];
