/*
 * Decompiled with CFR 0.152.
 */
package org.w3c.css.properties.css3;

import java.util.ArrayList;
import org.w3c.css.properties.css.CssProperty;
import org.w3c.css.util.ApplContext;
import org.w3c.css.util.InvalidParamException;
import org.w3c.css.values.CssCheckableValue;
import org.w3c.css.values.CssExpression;
import org.w3c.css.values.CssFunction;
import org.w3c.css.values.CssIdent;
import org.w3c.css.values.CssLayerList;
import org.w3c.css.values.CssNumber;
import org.w3c.css.values.CssValue;

public class CssAnimationTimingFunction
extends org.w3c.css.properties.css.CssAnimationTimingFunction {
    public static final CssIdent[] allowed_values;
    public static final String steps_func = "steps";
    public static final String cubic_bezier_func = "cubic-bezier";
    public static final CssIdent start;
    public static final CssIdent end;

    public static CssIdent getAllowedIdent(CssIdent ident) {
        for (CssIdent id : allowed_values) {
            if (!id.equals(ident)) continue;
            return id;
        }
        return null;
    }

    public CssAnimationTimingFunction() {
        this.value = initial;
    }

    public CssAnimationTimingFunction(ApplContext ac, CssExpression expression, boolean check) throws InvalidParamException {
        this.setByUser();
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        boolean singleVal = false;
        Object sValue = null;
        while (!expression.end()) {
            CssValue val = expression.getValue();
            char op = expression.getOperator();
            switch (val.getType()) {
                case 11: {
                    CssAnimationTimingFunction.parseFunctionValues(ac, val, this);
                    values.add(val);
                    break;
                }
                case 0: {
                    if (inherit.equals(val)) {
                        singleVal = true;
                        sValue = inherit;
                        values.add(inherit);
                        break;
                    }
                    CssIdent id = CssAnimationTimingFunction.getAllowedIdent((CssIdent)val);
                    if (id != null) {
                        values.add(id);
                        break;
                    }
                }
                default: {
                    throw new InvalidParamException("value", val.toString(), this.getPropertyName(), ac);
                }
            }
            expression.next();
            if (expression.end() || op == ',') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        if (singleVal && values.size() > 1) {
            throw new InvalidParamException("value", sValue.toString(), this.getPropertyName(), ac);
        }
        this.value = values.size() == 1 ? (CssValue)values.get(0) : new CssLayerList(values);
    }

    public CssAnimationTimingFunction(ApplContext ac, CssExpression expression) throws InvalidParamException {
        this(ac, expression, false);
    }

    private static CssValue parseStepsFunction(ApplContext ac, CssExpression funcparam, CssProperty caller) throws InvalidParamException {
        if (funcparam.getCount() > 2) {
            throw new InvalidParamException("unrecognize", ac);
        }
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        CssValue val = funcparam.getValue();
        char op = funcparam.getOperator();
        if (val.getType() != 5) {
            throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
        }
        CssCheckableValue number = val.getCheckableValue();
        number.checkInteger(ac, caller);
        number.checkStrictPositiveness(ac, caller);
        values.add(val);
        funcparam.next();
        if (!funcparam.end()) {
            if (op != ',') {
                throw new InvalidParamException("operator", new Character(op).toString(), ac);
            }
            val = funcparam.getValue();
            if (val.getType() != 0) {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
            if (start.equals(val)) {
                values.add(start);
            } else if (end.equals(val)) {
                values.add(end);
            } else {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
            funcparam.next();
        }
        return values.size() == 1 ? (CssValue)values.get(0) : new CssLayerList(values);
    }

    private static CssValue parseCubicBezierFunction(ApplContext ac, CssExpression funcparam, CssProperty caller) throws InvalidParamException {
        if (funcparam.getCount() > 4) {
            throw new InvalidParamException("unrecognize", ac);
        }
        if (funcparam.getCount() < 4) {
            throw new InvalidParamException("few-value", caller.getPropertyName(), ac);
        }
        ArrayList<CssValue> values = new ArrayList<CssValue>();
        for (int i = 0; i < 4; ++i) {
            CssValue val = funcparam.getValue();
            char op = funcparam.getOperator();
            if (val.getType() != 5) {
                throw new InvalidParamException("value", val.toString(), caller.getPropertyName(), ac);
            }
            CssNumber number = val.getNumber();
            if ((i & 1) == 0) {
                number.checkPositiveness(ac, caller);
                number.checkLowerEqualThan(ac, 1.0, caller);
            }
            values.add(val);
            funcparam.next();
            if (funcparam.end() || op == ',') continue;
            throw new InvalidParamException("operator", new Character(op).toString(), ac);
        }
        return new CssLayerList(values);
    }

    protected static CssValue parseFunctionValues(ApplContext ac, CssValue func, CssProperty caller) throws InvalidParamException {
        CssFunction function = (CssFunction)func;
        String fname = function.getName().toLowerCase();
        if (steps_func.equals(fname)) {
            return CssAnimationTimingFunction.parseStepsFunction(ac, function.getParameters(), caller);
        }
        if (cubic_bezier_func.equals(fname)) {
            return CssAnimationTimingFunction.parseCubicBezierFunction(ac, function.getParameters(), caller);
        }
        throw new InvalidParamException("value", func.toString(), caller.getPropertyName(), ac);
    }

    static {
        String[] _allowed_values = new String[]{"ease", "linear", "ease-in", "ease-out", "ease-in-out", "step-start", "step-end"};
        allowed_values = new CssIdent[_allowed_values.length];
        int i = 0;
        for (String s : _allowed_values) {
            CssAnimationTimingFunction.allowed_values[i++] = CssIdent.getIdent(s);
        }
        start = CssIdent.getIdent("start");
        end = CssIdent.getIdent("end");
    }
}

